/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import inetsoft.report.Margin;
import inetsoft.report.ReportEnv;
import inetsoft.report.StyleSheet;
import inetsoft.report.internal.Encoder;
import inetsoft.report.internal.PixelConsumer;
import inetsoft.report.internal.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;

public class Win32Graphics
extends Graphics
implements Cloneable {
    public static final int CREATE_DEFAULT = 0;
    public static final int CREATE_NEW = 1;
    static final int CREATE_CLONE = 2;
    static final int JOIN_MITER = 0;
    static final int JOIN_ROUND = 1;
    static final int JOIN_BEVEL = 2;
    static final int CAP_BUTT = 0;
    static final int CAP_ROUND = 1;
    static final int CAP_SQUARE = 2;
    private int resolution = 72;
    private Dimension pageSize = new Dimension(610, 792);
    private int resolutionX0 = 72;
    private int resolutionY0 = 72;
    private Dimension pageSize0 = new Dimension(610, 792);
    private Point center = new Point(0, 0);
    private Color color = Color.black;
    private Font font = new Font("Dialog", 0, 10);
    private long handle = 0L;
    private boolean cloned = false;
    private int context = 0;
    private boolean closed = false;
    private Point origin = new Point(0, 0);
    private Point offset = new Point(0, 0);
    private boolean disposed = true;
    protected boolean error = false;
    private static Hashtable fontmap = new Hashtable();
    private static boolean ok = false;

    static {
        try {
            System.loadLibrary("Win32Printer");
            ok = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Custom driver not used!");
            System.err.println("Please make sure the directory containing Win32Printer.dll is on the PATH.");
        }
        fontmap.put("dialog", "Arial");
        fontmap.put("dialoginput", "Courier New");
        fontmap.put("serif", "Times New Roman");
        fontmap.put("sansserif", "Arial");
        fontmap.put("monospaced", "Courier New");
        fontmap.put("timesroman", "Times New Roman");
        fontmap.put("courier", "Courier New");
        fontmap.put("helvetica", "Arial");
        fontmap.put("zapfdingbats", "WingDings");
    }

    private static int approximate(int n) {
        return n > 128 ? 255 : 0;
    }

    public void clearRect(double d, double d2, double d3, double d4, Color color) {
        if (this.isError()) {
            return;
        }
        this.clearRect0(this.realX(d), this.realY(d2), this.realX(d + d3), this.realY(d2 + d4), Win32Graphics.getRGB(color));
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.clearRect(n, n2, n3, n4, Color.white);
    }

    private native void clearRect0(int var1, int var2, int var3, int var4, int var5);

    public void clipRect(double d, double d2, double d3, double d4) {
        if (this.isError()) {
            return;
        }
        this.clipRect0(this.realX(d), this.realY(d2), this.realX(d + d3), this.realY(d2 + d4));
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clipRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    private native void clipRect0(int var1, int var2, int var3, int var4);

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.close0(this.error);
        }
    }

    public native void close0(boolean var1);

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyArea(this.realX(n), this.realY(n2), this.realW(n3), this.realH(n4), this.realX(n5), this.realY(n6));
    }

    private native void copyArea0(int var1, int var2, int var3, int var4, int var5, int var6);

    public Graphics create() {
        try {
            Win32Graphics win32Graphics = (Win32Graphics)this.clone();
            win32Graphics.cloned = true;
            win32Graphics.center = new Point(this.center);
            win32Graphics.context = win32Graphics.save0();
            return win32Graphics;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public native int create0(int var1);

    public native int create1(String var1);

    public native int create2();

    public void dispose() {
        if (this.disposed || this.isError()) {
            return;
        }
        this.disposed = true;
        if (!this.cloned) {
            this.setError(this.dispose0() < 0);
        } else {
            this.restore0(this.context);
        }
    }

    public native int dispose0();

    protected boolean doImage(PixelConsumer pixelConsumer, int n, int n2, int n3, int n4, ImageObserver imageObserver, Color color) {
        byte[] byArray = this.getImageBytes(pixelConsumer, color);
        if (n3 == 0) {
            n3 = pixelConsumer.iwidth;
        }
        if (n4 == 0) {
            n4 = pixelConsumer.iheight;
        }
        this.drawImage0(byArray, pixelConsumer.width, pixelConsumer.height, this.realX(n), this.realY(n2), this.realW(n3), this.realH(n4), color == null ? 0xFFFFFF : Win32Graphics.getRGB(color) & 0xFFFFFF, this.isDither());
        return true;
    }

    protected boolean doImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver, Color color) {
        PixelConsumer pixelConsumer = new PixelConsumer(image, n5, n6, n7, n8);
        return this.doImage(pixelConsumer, n, n2, n3, n4, imageObserver, color);
    }

    protected boolean doImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver, Color color) {
        PixelConsumer pixelConsumer = new PixelConsumer(image);
        return this.doImage(pixelConsumer, n, n2, n3, n4, imageObserver, color);
    }

    public void drawArc(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.isError()) {
            return;
        }
        int n = (int)(d + d3 / 2.0 + 1000.0 * Math.cos(d5 / 180.0 * Math.PI));
        int n2 = (int)(d2 + d4 / 2.0 + 1000.0 * Math.sin(d5 / 180.0 * Math.PI));
        int n3 = (int)(d + d3 / 2.0 + 1000.0 * Math.cos((d5 + d6) / 180.0 * Math.PI));
        int n4 = (int)(d2 + d4 / 2.0 + 1000.0 * Math.sin((d5 + d6) / 180.0 * Math.PI));
        this.drawArc0(this.realX(d), this.realY(d2), this.realX(d + d3), this.realY(d2 + d4), n, n2, n3, n4);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawArc((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    private native void drawArc0(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, n3 - n + 1, n4 - n2 + 1, n5, n6, n7, n8, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, n3 - n + 1, n4 - n2 + 1, n5, n6, n7, n8, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, n3, n4, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, n3, n4, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, 0, 0, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, 0, 0, imageObserver, null);
    }

    public native void drawImage0(byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    public native void drawImage1(byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, boolean var10);

    public void drawLine(double d, double d2, double d3, double d4) {
        if (this.isError()) {
            return;
        }
        if (d == d3 && d2 == d4) {
            d3 += 0.5;
        }
        this.drawLine0(this.realX(d), this.realY(d2), this.realX(d3), this.realY(d4));
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        double d = 0.5;
        double d2 = n3 - n;
        double d3 = n4 - n2;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = d4 > 0.0 ? d * d3 / d4 : 0.0;
        double d6 = d4 > 0.0 ? d * d2 / d4 : 0.0;
        this.drawLine((double)n + d5, (double)n2 + d6, (double)n3 + d5, (double)n4 + d6);
    }

    private native void drawLine0(int var1, int var2, int var3, int var4);

    public void drawOval(double d, double d2, double d3, double d4) {
        if (this.isError()) {
            return;
        }
        this.drawOval0(this.realX(d), this.realY(d2), this.realX(d + d3), this.realY(d2 + d4));
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.drawOval((double)n, (double)n2, (double)n3, (double)n4);
    }

    private native void drawOval0(int var1, int var2, int var3, int var4);

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        if (this.isError()) {
            return;
        }
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray2.length];
        int n2 = 0;
        while (n2 < n) {
            nArray3[n2] = this.realX(nArray[n2]);
            nArray4[n2] = this.realY(nArray2[n2]);
            ++n2;
        }
        this.drawPolygon0(nArray3, nArray4, n);
    }

    private native void drawPolygon0(int[] var1, int[] var2, int var3);

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (this.isError()) {
            return;
        }
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray2.length];
        int n2 = 0;
        while (n2 < n) {
            nArray3[n2] = this.realX(nArray[n2]);
            nArray4[n2] = this.realY(nArray2[n2]);
            ++n2;
        }
        this.drawPolyline0(nArray3, nArray4, n);
    }

    private native void drawPolyline0(int[] var1, int[] var2, int var3);

    public void drawRect(double d, double d2, double d3, double d4) {
        if (d3 < 0.0 || d4 < 0.0 || this.isError()) {
            return;
        }
        if (d4 == 0.0 || d3 == 0.0) {
            this.drawLine(d, d2, d + d3, d2 + d4);
        } else {
            this.drawLine(d, d2, d + d3 - 1.0, d2);
            this.drawLine(d + d3, d2, d + d3, d2 + d4 - 1.0);
            this.drawLine(d + d3, d2 + d4, d + 1.0, d2 + d4);
            this.drawLine(d, d2 + d4, d, d2 + 1.0);
        }
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.drawRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void drawRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.isError()) {
            return;
        }
        this.drawRoundRect0(this.realX(d), this.realY(d2), this.realX(d + d3), this.realY(d2 + d4), this.realW(d5), this.realH(d6));
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawRoundRect((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    private native void drawRoundRect0(int var1, int var2, int var3, int var4, int var5, int var6);

    public void drawString(String string, double d, double d2) {
        if (this.isError()) {
            return;
        }
        this.drawString0(string, this.realX(d), this.realY(d2), this.realW(Common.stringWidth(string, this.getFont())));
    }

    public void drawString(String string, int n, int n2) {
        if (this.isError()) {
            return;
        }
        this.drawString0(string, this.realX(n), this.realY(n2), this.realW(Common.stringWidth(string, this.getFont())));
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }

    private native void drawString0(String var1, int var2, int var3, int var4);

    public void fillArc(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.isError()) {
            return;
        }
        int n = (int)(d + d3 / 2.0 + 1000.0 * Math.cos(d5 / 180.0 * Math.PI));
        int n2 = (int)(d2 + d4 / 2.0 + 1000.0 * Math.sin(d5 / 180.0 * Math.PI));
        int n3 = (int)(d + d3 / 2.0 + 1000.0 * Math.cos((d5 + d6) / 180.0 * Math.PI));
        int n4 = (int)(d2 + d4 / 2.0 + 1000.0 * Math.sin((d5 + d6) / 180.0 * Math.PI));
        this.fillArc0(this.realX(d), this.realY(d2), this.realX(d + d3), this.realY(d2 + d4), n, n2, n3, n4);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillArc((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    private native void fillArc0(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public void fillOval(double d, double d2, double d3, double d4) {
        if (this.isError()) {
            return;
        }
        this.fillOval0(this.realX(d), this.realY(d2), this.realX(d + d3), this.realY(d2 + d4));
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fillOval((double)n, (double)n2, (double)n3, (double)n4);
    }

    private native void fillOval0(int var1, int var2, int var3, int var4);

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        if (this.isError()) {
            return;
        }
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray2.length];
        int n2 = 0;
        while (n2 < n) {
            nArray3[n2] = this.realX(nArray[n2]);
            nArray4[n2] = this.realY(nArray2[n2]);
            ++n2;
        }
        this.fillPolygon0(nArray3, nArray4, n);
    }

    private native void fillPolygon0(int[] var1, int[] var2, int var3);

    public void fillRect(double d, double d2, double d3, double d4) {
        if (this.isError()) {
            return;
        }
        this.fillRect0(this.realX(d), this.realY(d2), this.realX(d + d3), this.realY(d2 + d4));
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.fillRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    private native void fillRect0(int var1, int var2, int var3, int var4);

    public void fillRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.isError()) {
            return;
        }
        this.fillRoundRect0(this.realX(d), this.realY(d2), this.realX(d + d3), this.realY(d2 + d4), this.realW(d5), this.realH(d6));
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillRoundRect((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    private native void fillRoundRect0(int var1, int var2, int var3, int var4, int var5, int var6);

    private native int getBitsPerPixel0();

    public Shape getClip() {
        return this.getClipBounds();
    }

    public Rectangle getClipBounds() {
        Rectangle rectangle = this.getClipBounds0();
        if (rectangle == null) {
            return new Rectangle(0, 0, this.pageSize.width, this.pageSize.height);
        }
        rectangle.x = this.virtualX(rectangle.x);
        rectangle.y = this.virtualY(rectangle.y);
        rectangle.width = this.virtualW(rectangle.width);
        rectangle.height = this.virtualH(rectangle.height);
        return rectangle;
    }

    private native Rectangle getClipBounds0();

    public Color getColor() {
        return this.color;
    }

    public native int getCopies0();

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public String getFontName(Font font) {
        int n;
        String string = Common.getFontName(font);
        String string2 = (String)fontmap.get(string.toLowerCase());
        if (string2 == null && (n = string.indexOf(46)) > 0) {
            string2 = (String)fontmap.get(string.substring(0, n).toLowerCase());
        }
        return string2 == null ? string : string2;
    }

    public native int getFromPage0();

    public byte[] getImageBytes(PixelConsumer pixelConsumer, Color color) {
        pixelConsumer.produce();
        if (this.isDither()) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = this.getResolutionX0() / this.getResolution();
            int n8 = this.getResolutionY0() / this.getResolution();
            int n9 = n7 * pixelConsumer.width;
            int n10 = n8 * pixelConsumer.height;
            short[][] sArray = new short[n9][n10];
            int n11 = 0;
            int n12 = 0;
            while (n11 < pixelConsumer.height) {
                n6 = 0;
                n5 = 0;
                while (n6 < pixelConsumer.width) {
                    n4 = pixelConsumer.pix[n6][n11];
                    if ((n4 & 0xFF000000) == 0) {
                        n4 = color == null ? 0xFFFFFF : color.getRGB();
                    }
                    n3 = Encoder.toGray((n4 & 0xFF0000) >> 16, (n4 & 0xFF00) >> 8, n4 & 0xFF);
                    n2 = 0;
                    while (n2 < n8) {
                        n = 0;
                        while (n < n7) {
                            sArray[n5 + n][n12 + n2] = (short)n3;
                            ++n;
                        }
                        ++n2;
                    }
                    ++n6;
                    n5 += n7;
                }
                ++n11;
                n12 += n8;
            }
            pixelConsumer.pix = null;
            n6 = 0;
            while (n6 < n10) {
                n5 = 0;
                while (n5 < n9) {
                    n4 = Win32Graphics.approximate(sArray[n5][n6]);
                    n3 = sArray[n5][n6] - n4;
                    sArray[n5][n6] = (short)n4;
                    if (n5 < n9 - 1) {
                        short[] sArray2 = sArray[n5 + 1];
                        int n13 = n6;
                        sArray2[n13] = (short)(sArray2[n13] + 7 * n3 / 16);
                    }
                    if (n5 > 0 && n6 < n10 - 1) {
                        short[] sArray3 = sArray[n5 - 1];
                        int n14 = n6 + 1;
                        sArray3[n14] = (short)(sArray3[n14] + 3 * n3 / 16);
                    }
                    if (n6 < n10 - 1) {
                        short[] sArray4 = sArray[n5];
                        int n15 = n6 + 1;
                        sArray4[n15] = (short)(sArray4[n15] + 5 * n3 / 16);
                    }
                    if (n5 < n9 - 1 && n6 < n10 - 1) {
                        short[] sArray5 = sArray[n5 + 1];
                        int n16 = n6 + 1;
                        sArray5[n16] = (short)(sArray5[n16] + n3 / 16);
                    }
                    ++n5;
                }
                ++n6;
            }
            n5 = (int)Math.ceil((double)n9 / 8.0);
            n4 = n10;
            n5 = n5 % 4 != 0 ? n5 + (4 - n5 % 4) : n5;
            byte[] byArray = new byte[n5 * n4];
            n2 = n10 - 1;
            while (n2 >= 0) {
                n = (n10 - 1 - n2) * n5;
                int n17 = 0;
                int n18 = 0;
                while (n18 < n9) {
                    byte by = (byte)(sArray[n18][n2] > 128 ? 1 : 0);
                    if (by > 0) {
                        by = (byte)(by << 7 - n17);
                        int n19 = n;
                        byArray[n19] = (byte)(byArray[n19] | by);
                    }
                    if (++n17 >= 8) {
                        n17 = 0;
                        ++n;
                    }
                    ++n18;
                }
                --n2;
            }
            pixelConsumer.width = n9;
            pixelConsumer.height = n10;
            return byArray;
        }
        return Util.getImageBytesRGB(pixelConsumer, color);
    }

    public Point getMargin() {
        return this.offset;
    }

    private native int getOffsetX0();

    private native int getOffsetY0();

    public int getOrientation() {
        return this.isLandscape0() ? 0 : 1;
    }

    private native double getPageHeight0();

    public Dimension getPageSize() {
        return this.pageSize;
    }

    private native double getPageWidth0();

    public static int getRGB(Color color) {
        if (color == null) {
            return 0;
        }
        return color.getRed() & 0xFF | (color.getGreen() & 0xFF) << 8 | (color.getBlue() & 0xFF) << 16;
    }

    public int getResolution() {
        return this.resolution;
    }

    private native int getResolutionX0();

    private native int getResolutionY0();

    public native int getToPage0();

    public native double[] getTransform0();

    public void init() {
        this.resolutionX0 = this.getResolutionX0();
        this.resolutionY0 = this.getResolutionY0();
        this.pageSize0 = new Dimension((int)(this.getPageWidth0() * (double)this.resolutionX0), (int)(this.getPageHeight0() * (double)this.resolutionY0));
        this.pageSize = new Dimension(this.pageSize0.width * this.resolution / this.resolutionX0, this.pageSize0.height * this.resolution / this.resolutionY0);
        this.setPen0(Win32Graphics.getRGB(Color.black), this.realW(1.0), 0, 0, 0);
        this.offset.x = this.getOffsetX0();
        this.offset.y = this.getOffsetY0();
    }

    public boolean isDither() {
        try {
            String string = ReportEnv.getProperty("StyleReport.dither");
            return string != null && (this.getBitsPerPixel0() == 1 && string.equalsIgnoreCase("true") || string.equalsIgnoreCase("force"));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isError() {
        return this.error;
    }

    public static boolean isInitialized() {
        return ok;
    }

    private native boolean isLandscape0();

    public native boolean isPages0();

    public void nextPage() {
        if (this.isError()) {
            return;
        }
        this.setError(this.startPage0() < 0);
        if (!this.isError()) {
            Margin margin = StyleSheet.getPrinterMargin();
            this.origin = new Point(this.realX(margin.left * (double)this.resolution) - this.offset.x, this.realY(margin.top * (double)this.resolution) - this.offset.y);
            this.setViewportOrg0(this.origin.x, this.origin.y);
            this.disposed = false;
        }
    }

    public native boolean printDialog0(int var1);

    public void putFontName(String string, String string2) {
        fontmap.put(string, string2);
    }

    public int realH(double d) {
        return (int)Math.round((double)this.pageSize0.height * d / (double)this.pageSize.height);
    }

    public int realW(double d) {
        return (int)Math.round((double)this.pageSize0.width * d / (double)this.pageSize.width);
    }

    public int realX(double d) {
        return (int)Math.round((double)this.pageSize0.width * (d + (double)this.center.x) / (double)this.pageSize.width);
    }

    public int realY(double d) {
        return (int)Math.round((double)this.pageSize0.height * (d + (double)this.center.y) / (double)this.pageSize.height);
    }

    public native void restore0(int var1);

    public native int save0();

    public native void setBrush0(byte[] var1, int var2, int var3, boolean var4);

    public void setClip(double d, double d2, double d3, double d4) {
        if (this.isError()) {
            return;
        }
        Margin margin = StyleSheet.getPrinterMargin();
        this.setClip0(this.realX(d + margin.left * (double)this.resolution) - this.offset.x, this.realY(d2 + margin.top * (double)this.resolution) - this.offset.y, this.realX(d + margin.left * (double)this.resolution + d3) - this.offset.x, this.realY(d2 + margin.top * (double)this.resolution + d4) - this.offset.y);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void setClip(Shape shape) {
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public native void setClip0(int var1, int var2, int var3, int var4);

    public void setColor(Color color) {
        if (this.isError()) {
            return;
        }
        this.color = color;
        this.setColor0(Win32Graphics.getRGB(color), this.realW(1.0));
    }

    private native void setColor0(int var1, int var2);

    public native void setColor1(int var1);

    public native void setCopies0(int var1);

    public void setError(boolean bl) {
        this.error = bl;
    }

    public void setFont(Font font) {
        if (font != null && !this.isError()) {
            this.font = font;
            this.setFont0(this.getFontName(font), font.getStyle(), this.realH(font.getSize()));
        }
    }

    private native void setFont0(String var1, int var2, int var3);

    private native void setLandscape0(boolean var1);

    public void setOrientation(int n) {
        if (this.isError()) {
            return;
        }
        this.setLandscape0(n == 0);
    }

    public native void setPaintMode();

    public native void setPen0(int var1, int var2, int var3, int var4, int var5);

    public native void setTransform0(double var1, double var3, double var5, double var7, double var9, double var11);

    public void setTray(int n) {
        this.setTray0(n);
    }

    private native void setTray0(int var1);

    public native void setViewportOrg0(int var1, int var2);

    public void setXORMode(Color color) {
        this.setXORMode0(Win32Graphics.getRGB(color) & 0xFFFFFF);
    }

    private native void setXORMode0(int var1);

    public native int startDoc0(String var1);

    public native int startPage0();

    public void translate(int n, int n2) {
        this.center.x += n;
        this.center.y += n2;
    }

    private int virtualH(double d) {
        return (int)Math.round((double)this.pageSize.height * d / (double)this.pageSize0.height);
    }

    private int virtualW(double d) {
        return (int)Math.round((double)this.pageSize.width * d / (double)this.pageSize0.width);
    }

    private int virtualX(double d) {
        double d2 = Math.round((double)this.pageSize.width * d / (double)this.pageSize0.width);
        return (int)(d2 - (double)this.center.x);
    }

    private int virtualY(double d) {
        double d2 = Math.round((double)this.pageSize.height * d / (double)this.pageSize0.height);
        return (int)(d2 - (double)this.center.y);
    }
}

