/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import inetsoft.report.Comparer;
import inetsoft.report.ReportElement;
import inetsoft.report.StyleConstants;
import inetsoft.report.StyleSheet;
import inetsoft.report.internal.PixelConsumer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.awt.peer.LightweightPeer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Util
implements StyleConstants {
    public static final int COLOR_CHART = 4096;
    public static final int CHART_NOLABEL_MASK = 8192;
    public static final int CHART_STYLE_MASK = 255;

    public static int breakLine(String string, double d, Font font) {
        int n;
        FontMetrics fontMetrics = Common.getFontMetrics(font);
        if (string.length() > 200) {
            float f = 0.0f;
            int n2 = 0;
            n = 150;
            while (n2 < string.length()) {
                if ((double)(f += Common.stringWidth(string.substring(n2, n = Math.min(n, string.length())), font, fontMetrics)) > d) break;
                n2 = n;
                n += 50;
            }
            if ((double)f < d) {
                return -1;
            }
        } else if ((double)Common.stringWidth(string, font, fontMetrics) <= d) {
            return -1;
        }
        int n3 = string.length() / 2;
        float f = 0.0f;
        n = 0;
        int n4 = string.length() - 1;
        while (n4 > n) {
            n3 = Math.min((n + n4) / 2, n + 150);
            if (n3 == n || n3 == n4) {
                n3 = n4;
                break;
            }
            float f2 = Common.stringWidth(string.substring(n, n3 + 1), font, fontMetrics);
            if ((double)(f + f2) > d) {
                n4 = n3;
                continue;
            }
            n = n3;
            f += f2;
        }
        int n5 = n3;
        while (n5 > 0) {
            if (Character.isWhitespace(string.charAt(n5))) {
                return n5;
            }
            --n5;
        }
        String string2 = string.substring(0, n3 + 1);
        return (double)Common.stringWidth(string2, font) > d ? n3 : n3 + 1;
    }

    public static Color brighter(Color color) {
        return (color.getRGB() & 0xFFFFFF) == 0 ? Color.gray : color.brighter();
    }

    public static Color darker(Color color) {
        return color.darker();
    }

    public static String findDuplicate(StyleSheet styleSheet, boolean bl) {
        int[] nArray = new int[9];
        nArray[1] = 256;
        nArray[2] = 257;
        nArray[3] = 258;
        nArray[4] = 259;
        nArray[5] = 512;
        nArray[6] = 513;
        nArray[7] = 514;
        nArray[8] = 515;
        int[] nArray2 = nArray;
        Vector<Vector> vector = new Vector<Vector>();
        int n = 0;
        while (n < nArray2.length) {
            vector.addElement(styleSheet.getElements(nArray2[n]));
            ++n;
        }
        Enumeration enumeration = styleSheet.getElementHeaders().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Vector)enumeration.nextElement());
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n2 = 0;
        while (n2 < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n2);
            int n3 = 0;
            while (n3 < vector2.size()) {
                ReportElement reportElement = (ReportElement)vector2.elementAt(n3);
                String string = reportElement.getID();
                if (string == null) {
                    string = "";
                }
                if (hashtable.get(string) != null) {
                    if (!bl) {
                        return string;
                    }
                    String string2 = reportElement.getType();
                    int n4 = styleSheet.getElementCount();
                    while (true) {
                        if (hashtable.get(string = styleSheet.getNextID(string2)) == null) {
                            reportElement.setID(string);
                            break;
                        }
                        ++n4;
                    }
                }
                hashtable.put(string, string);
                ++n3;
            }
            ++n2;
        }
        return null;
    }

    public static Frame findFrame(Component component) {
        Component component2 = component;
        while (component2 != null) {
            if (component2 instanceof Frame) {
                return (Frame)component2;
            }
            component2 = component2.getParent();
        }
        return null;
    }

    public static Window findWindow(Component component) {
        Component component2 = component;
        while (component2 != null) {
            if (component2 instanceof Window) {
                return (Window)component2;
            }
            component2 = component2.getParent();
        }
        return null;
    }

    public static String getCaller() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        new Exception("xxx").printStackTrace(printWriter);
        printWriter.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
        try {
            int n;
            String string = bufferedReader.readLine();
            string = bufferedReader.readLine();
            string = bufferedReader.readLine().trim();
            int n2 = string.indexOf(40);
            if (n2 > 0 && (n = (string = string.substring(0, n2)).lastIndexOf(32)) > 0) {
                int n3 = (string = string.substring(n + 1)).lastIndexOf(46);
                return n3 > 0 ? string.substring(0, n3) : string;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static String[] getCallers() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        new Exception("xxx").printStackTrace(printWriter);
        printWriter.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
        Vector<String> vector = new Vector<String>();
        try {
            String string = bufferedReader.readLine();
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                int n2 = (string = string.trim()).indexOf(40);
                if (n2 <= 0 || (n = (string = string.substring(0, n2)).lastIndexOf(32)) <= 0) continue;
                int n3 = (string = string.substring(n + 1)).lastIndexOf(46);
                vector.addElement(n3 > 0 ? string.substring(0, n3) : string);
            }
        }
        catch (Exception exception) {}
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static byte[] getImageBytesRGB(PixelConsumer pixelConsumer, Color color) {
        pixelConsumer.produce();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n = pixelConsumer.height - 1;
            while (n >= 0) {
                int n2;
                int n3 = 0;
                int n4 = 0;
                while (n4 < pixelConsumer.width) {
                    n2 = pixelConsumer.pix[n4][n];
                    if ((n2 & 0xFF000000) == 0) {
                        n2 = color == null ? 0xFFFFFF : color.getRGB();
                    }
                    byteArrayOutputStream.write((byte)(n2 & 0xFF));
                    byteArrayOutputStream.write((byte)((n2 & 0xFF00) >> 8));
                    byteArrayOutputStream.write((byte)((n2 & 0xFF0000) >> 16));
                    n3 += 3;
                    ++n4;
                }
                if (n3 % 4 != 0) {
                    n2 = 4 - n3 % 4;
                    int n5 = 0;
                    while (n5 < n2) {
                        byteArrayOutputStream.write(-1);
                        ++n5;
                    }
                }
                --n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String getLineStyleName(int n) {
        switch (n) {
            case 0: {
                return "NO_BORDER";
            }
            case 4097: {
                return "THIN_LINE";
            }
            case 4098: {
                return "MEDIUM_LINE";
            }
            case 4099: {
                return "THICK_LINE";
            }
            case 8195: {
                return "DOUBLE_LINE";
            }
            case 24578: {
                return "RAISED_3D";
            }
            case 40962: {
                return "LOWERED_3D";
            }
            case 24579: {
                return "DOUBLE_3D_RAISED";
            }
            case 40963: {
                return "DOUBLE_3D_LOWERED";
            }
            case 4113: {
                return "DOT_LINE";
            }
            case 4145: {
                return "DASH_LINE";
            }
            case 4193: {
                return "MEDIUM_DASH";
            }
            case 4241: {
                return "LARGE_DASH";
            }
        }
        return String.valueOf(n);
    }

    public static boolean isFlatDatasetChart(int n) {
        return n == 1 || n == 5 || n == 3 || n == 7 || n == 9 || n == 6 || n == 8 || n == 8198 || n == 8200;
    }

    public static boolean isLightWeight(Component component) {
        return component.getPeer() instanceof LightweightPeer;
    }

    public static int mergeLineStyle(int n, int n2) {
        return Math.max(n & 0xF, n2 & 0xF) | Math.min(n & 0xF0, n2 & 0xF0) | Math.max(n & 0x1000, n2 & 0x1000) | (n | n2) & 0x2000 | (n | n2) & 0x4000 | (n | n2) & 0x8000;
    }

    public static void qsort(Object[] objectArray, int n, int n2, boolean bl, Comparer comparer) {
        if (n >= n2) {
            return;
        }
        int n3 = n;
        int n4 = n2;
        int n5 = bl ? -1 : 1;
        int n6 = bl ? 1 : -1;
        int n7 = (n3 + n4) / 2;
        Object object = objectArray[n7];
        objectArray[n7] = objectArray[n];
        objectArray[n] = object;
        while (n3 < n4) {
            int n8 = comparer.compare(objectArray[n3], objectArray[n]);
            while (n3 < n2 && (n8 == 0 || n8 / Math.abs(n8) == n5)) {
                n8 = comparer.compare(objectArray[++n3], objectArray[n]);
            }
            n8 = comparer.compare(objectArray[n4], objectArray[n]);
            while (n8 != 0 && n8 == Math.abs(n8) * n6) {
                n8 = comparer.compare(objectArray[--n4], objectArray[n]);
            }
            if (n3 >= n4) continue;
            object = objectArray[n3];
            objectArray[n3] = objectArray[n4];
            objectArray[n4] = object;
        }
        object = objectArray[n];
        objectArray[n] = objectArray[n4];
        objectArray[n4] = object;
        Util.qsort(objectArray, n, n4 - 1, bl, comparer);
        Util.qsort(objectArray, n4 + 1, n2, bl, comparer);
    }

    public static void registerKeyListener(Component component, KeyListener keyListener) {
        component.addKeyListener(keyListener);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                Util.registerKeyListener(container.getComponent(n), keyListener);
                ++n;
            }
        }
    }

    public static String replace(String string, String string2, String string3) {
        int n = 0;
        if ((n = string.indexOf(string2, n)) >= 0) {
            string = String.valueOf(string.substring(0, n)) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    public static String replaceAll(String string, String string2, String string3) {
        int n = 0;
        while ((n = string.indexOf(string2, n)) >= 0) {
            string = String.valueOf(string.substring(0, n)) + string3 + string.substring(n + string2.length());
            n += string3.length();
        }
        return string;
    }

    public static String[] split(String string, char c) {
        int n;
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        while ((n = string.indexOf(c)) >= 0) {
            vector.addElement(string.substring(0, n));
            string = string.substring(n + 1);
        }
        vector.addElement(string);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String[] split(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer("X" + string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        objectArray[0] = ((String)objectArray[0]).substring(1);
        return objectArray;
    }

    public static String toString(double d, int n) {
        if (Math.abs(d) > 9.223372036854776E18) {
            return Util.toString(Double.toString(d), n);
        }
        double d2 = Math.pow(10.0, n);
        return Util.toString(new Double((double)((long)(d * d2)) / d2));
    }

    public static String toString(Number number, int n) {
        return Util.toString(number.doubleValue(), n);
    }

    public static String toString(Object object) {
        int n;
        String string = object.toString();
        if (object instanceof Number && (n = string.indexOf(46)) >= 0) {
            int n2 = string.indexOf(69);
            if (n == 1 && n2 > 0) {
                String string2 = string.substring(0, n2);
                StringBuffer stringBuffer = new StringBuffer(string2.substring(2));
                stringBuffer.insert(0, string2.charAt(0));
                int n3 = Integer.parseInt(string.substring(n2 + 1));
                if (n3 > 0) {
                    while (stringBuffer.length() < n3 + 1) {
                        stringBuffer.append("0");
                    }
                } else {
                    int n4 = 0;
                    while (n4 < -n3) {
                        stringBuffer.insert(0, "0");
                        ++n4;
                    }
                    stringBuffer.insert(1, ".");
                }
                return stringBuffer.toString();
            }
            String string3 = string.substring(n + 1);
            int n5 = string3.indexOf("999999");
            if (n5 >= 0) {
                string = Util.toString((Number)object, n5);
            } else {
                n5 = string3.indexOf("000000");
                if (n5 >= 0) {
                    string = string.substring(0, n + n5 + 1);
                }
            }
        }
        return string;
    }

    private static String toString(String string, int n) {
        int n2 = string.indexOf(".");
        String string2 = n2 > 0 && string.length() - n2 - 1 > n ? string.substring(0, n2 + n + 1) : string;
        return string2.endsWith(".0") ? string2.substring(0, string2.length() - 2) : string2;
    }

    public static String trimEnd(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            if (string.charAt(n) > ' ') {
                return string.substring(0, n + 1);
            }
            --n;
        }
        return string;
    }
}

