/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Hashtable;

public class ToolTip
implements MouseListener,
ContainerListener,
Runnable,
Serializable {
    private static ToolTip theInstance = null;
    Hashtable mmap = new Hashtable();
    TipWin currWin;
    Component currComp = null;
    Thread thread = new Thread(this);
    long downTime;
    Dimension scnsize;
    int delay = 500;
    boolean disabled = false;

    private ToolTip() {
        this.thread.setDaemon(true);
        this.thread.start();
        this.scnsize = Toolkit.getDefaultToolkit().getScreenSize();
    }

    public void componentAdded(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        if (!this.mmap.containsKey(component)) {
            Container container = component.getParent();
            while (container != null) {
                if (this.mmap.containsKey(container)) {
                    this.mmap.put(component, this.mmap.get(container));
                }
                container = container.getParent();
            }
        }
        component.addMouseListener(this);
        if (component instanceof Container) {
            ((Container)component).addContainerListener(this);
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        component.removeMouseListener(this);
        if (component instanceof Container) {
            ((Container)component).removeContainerListener(this);
        }
    }

    public void finalize() {
        this.thread.stop();
    }

    public static Frame findFrame(Component component) {
        Component component2 = component;
        while (component2 != null) {
            if (component2 instanceof Frame) {
                return (Frame)component2;
            }
            component2 = component2.getParent();
        }
        return null;
    }

    public int getDelay() {
        return this.delay;
    }

    public static ToolTip getToolTip() {
        if (theInstance == null) {
            theInstance = new ToolTip();
        }
        return theInstance;
    }

    public boolean isEnabled() {
        return this.disabled ^ true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.notifyEnd();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.notifyStart((Component)mouseEvent.getSource());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.notifyEnd();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.notifyEnd();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.notifyStart((Component)mouseEvent.getSource());
    }

    synchronized void notifyEnd() {
        this.popdown();
        this.currComp = null;
    }

    synchronized void notifyStart(Component component) {
        if (this.currWin == null || this.currWin.comp != component && this.currWin.comp.getParent() != component) {
            this.popdown();
            this.currComp = component;
            this.notifyAll();
        }
    }

    synchronized void popdown() {
        if (this.currWin != null) {
            this.downTime = System.currentTimeMillis();
            this.currWin.dispose();
            this.currWin = null;
        }
    }

    synchronized void popup(Component component) {
        this.popdown();
        if (this.mmap.containsKey(component)) {
            this.currWin = new TipWin(component);
            Point point = null;
            try {
                point = component.getLocationOnScreen();
            }
            catch (Exception exception) {
                return;
            }
            ((Component)this.currWin).setSize(this.currWin.getPreferredSize());
            this.currWin.pack();
            Dimension dimension = component.getSize();
            Dimension dimension2 = this.currWin.getSize();
            int n = point.y + dimension.height + 2;
            n = n + dimension2.height > this.scnsize.height ? point.y - dimension2.height - 2 : n;
            int n2 = Math.min(point.x + dimension.width / 2, this.scnsize.width - dimension2.width);
            ((Component)this.currWin).setLocation(n2, n);
            ((Component)this.currWin).setVisible(true);
        }
    }

    public void put(Component component, String string) {
        this.mmap.put(component, string);
        component.addMouseListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this);
            int n = 0;
            while (n < container.getComponentCount()) {
                this.put(container.getComponent(n), string);
                ++n;
            }
        }
    }

    public void remove(Component component) {
        component.removeMouseListener(this);
        this.mmap.remove(component);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            int n = 0;
            while (n < container.getComponentCount()) {
                this.remove(container.getComponent(n));
                ++n;
            }
        }
    }

    public synchronized void run() {
        while (true) {
            try {
                while (this.currComp == null || this.disabled) {
                    this.wait();
                }
                if (System.currentTimeMillis() - this.downTime > (long)this.delay) {
                    this.wait(this.delay);
                }
            }
            catch (Exception exception) {}
            if (this.currComp == null) continue;
            this.popup(this.currComp);
            this.currComp = null;
        }
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public synchronized void setEnabled(boolean bl) {
        this.disabled = bl ^ true;
        this.notifyAll();
    }

    private class TipWin
    extends Window {
        private Component comp;

        public TipWin(Component component) {
            super(ToolTip.findFrame(component));
            ((Component)this).setBackground(new Color(245, 245, 218));
            this.setForeground(Color.black);
            this.comp = component;
            Label label = new Label((String)ToolTip.this.mmap.get(component));
            Panel panel = new Panel(label){
                private final /* synthetic */ Label val$tc;
                {
                    this.val$tc = label;
                    this.setLayout(null);
                    this.add(label);
                }

                public void doLayout() {
                    Dimension dimension = this.getSize();
                    this.val$tc.setBounds(1, 1, dimension.width - 2, dimension.height - 2);
                }

                public Dimension getPreferredSize() {
                    Dimension dimension = this.val$tc.getPreferredSize();
                    ++dimension.width;
                    ++dimension.height;
                    return dimension;
                }

                public void paint(Graphics graphics) {
                    Dimension dimension = this.getSize();
                    graphics.setColor(Color.black);
                    graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                }
            };
            this.add((Component)panel, "Center");
        }
    }
}

