/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ToolButton
extends Canvas
implements MouseListener {
    public static final int LABEL_ONLY = 1;
    public static final int IMAGE_ONLY = 2;
    public static final int LABEL_IMAGE = 3;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 3;
    public static final int RIGHT = 4;
    protected ActionListener actionListener;
    int percent = 50;
    int border = 1;
    transient MediaTracker tracker = new MediaTracker(this);
    transient Image pressedButton = null;
    transient Image normalButton = null;
    transient Image plainButton = null;
    transient Dimension oSize = new Dimension(0, 0);
    Point labelPos = null;
    Point imagePos = null;
    int gap = 2;
    String label = null;
    int pos = 3;
    Image image;
    Image image2;
    int style = 3;
    Dimension iSize = null;
    boolean toggle = false;
    boolean state = false;
    Dimension pSize = null;
    boolean eventEnabled = true;
    int borderGap = 4;
    boolean pointerIn = false;
    boolean inOnly = true;
    transient boolean mousePressed = false;

    public ToolButton() {
        this.addMouseListener(this);
        this.addKeyListener(new IbKeyListener());
    }

    public ToolButton(Image image) {
        this();
        this.setImage(image);
    }

    public ToolButton(Image image, int n) {
        this(image);
        this.border = n;
    }

    public ToolButton(Image image, String string) {
        this(image, string, 3);
    }

    public ToolButton(Image image, String string, int n) {
        this(image);
        this.setLabel(string, n);
    }

    public ToolButton(String string, String string2) {
        this();
        try {
            Image image = Common.getImage(null, string);
            if (image == null) {
                this.setLabel(string2);
            } else {
                this.setImage(image);
            }
        }
        catch (Exception exception) {
            this.setLabel(string2);
            exception.printStackTrace();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    synchronized void calcCoord() {
        if (this.label == null || (this.style & 1) == 0) {
            this.imagePos = new Point(this.border + this.borderGap, this.border + this.borderGap);
            this.iSize = new Dimension(this.getSize().width - 2 * this.border - 2 * this.borderGap, this.getSize().height - 2 * this.border - 2 * this.borderGap);
            return;
        }
        Rectangle rectangle = this.getAreaBounds();
        Font font = this.getFont();
        if (font == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.getAscent();
        int n2 = fontMetrics.stringWidth(this.label);
        if (this.image == null || (this.style & 2) == 0) {
            this.labelPos = new Point((rectangle.width - n2) / 2 + rectangle.x, (rectangle.height - fontMetrics.getHeight()) / 2 + n + rectangle.y);
        } else {
            switch (this.pos) {
                case 1: 
                case 3: {
                    this.iSize = new Dimension(rectangle.width - 2 * (this.border + this.gap), rectangle.height - fontMetrics.getHeight() - this.gap - 2 * this.border);
                    break;
                }
                case 2: 
                case 4: {
                    this.iSize = new Dimension(rectangle.width - n2 - 2 * (this.border + this.gap), rectangle.height - 2 * (this.border + this.gap));
                }
            }
            this.iSize.height = this.iSize.width = Math.min(this.iSize.width, this.iSize.height);
            switch (this.pos) {
                case 1: {
                    this.labelPos = new Point((rectangle.width - n2) / 2, n + this.border);
                    this.imagePos = new Point((rectangle.width - this.iSize.width) / 2, fontMetrics.getHeight() + this.border + this.gap);
                    break;
                }
                case 3: {
                    this.labelPos = new Point((rectangle.width - n2) / 2, n + this.border + this.gap + this.iSize.height);
                    this.imagePos = new Point((rectangle.width - this.iSize.width) / 2, 2 * this.border);
                    break;
                }
                case 2: {
                    this.labelPos = new Point(this.border, (rectangle.height - n) / 2 + n);
                    this.imagePos = new Point(this.border + this.gap + n2, (rectangle.height - this.iSize.height) / 2);
                    break;
                }
                case 4: {
                    this.imagePos = new Point(2 * this.border, (rectangle.height - this.iSize.height) / 2);
                    this.labelPos = new Point(this.imagePos.x + this.gap + this.iSize.width, (rectangle.height - n) / 2 + n);
                    break;
                }
            }
            this.labelPos.x += rectangle.x;
            this.labelPos.y += rectangle.y;
            this.imagePos.x += rectangle.x;
            this.imagePos.y += rectangle.y;
            this.clearCache();
        }
    }

    protected Dimension calcSize() {
        Dimension dimension;
        Dimension dimension2 = dimension = this.image == null || (this.style & 2) == 0 ? new Dimension(2 * this.borderGap, 2 * this.borderGap) : new Dimension(this.image.getWidth(null) + 2 * this.borderGap, this.image.getHeight(null) + 2 * this.borderGap);
        if (this.label == null || (this.style & 1) == 0) {
            return dimension2;
        }
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            switch (this.pos) {
                case 1: 
                case 3: {
                    dimension2.height += fontMetrics.getHeight() + this.gap + 3 * this.border;
                    dimension2.width = Math.max(dimension2.width + 2 * this.border, fontMetrics.stringWidth(this.label) + 2) + 2 * this.border;
                    break;
                }
                case 2: 
                case 4: {
                    dimension2.width += fontMetrics.stringWidth(this.label) + this.gap + 2 * this.border + 2;
                    dimension2.height += 4 * this.border;
                    break;
                }
            }
        }
        return dimension2;
    }

    void clearCache() {
        Dimension dimension = this.oSize;
        synchronized (dimension) {
            this.pressedButton = null;
            this.normalButton = null;
            this.plainButton = null;
        }
    }

    protected void clearImages() {
        this.image2 = null;
        this.image = null;
    }

    private void fire(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    protected Rectangle getAreaBounds() {
        return new Rectangle(this.borderGap, this.borderGap, this.getSize().width - 2 * this.borderGap, this.getSize().height - 2 * this.borderGap);
    }

    public int getBorder() {
        return this.border;
    }

    public int getBorderGap() {
        return this.borderGap;
    }

    public int getDisplay() {
        return this.style;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getImage2() {
        return this.image2;
    }

    Dimension getImageSize() {
        return this.iSize;
    }

    public String getLabel() {
        return this.label;
    }

    public int getLabelPos() {
        return this.pos;
    }

    public Dimension getMinimumSize() {
        if (this.pSize == null) {
            this.pSize = this.calcSize();
        }
        return this.pSize;
    }

    public Dimension getPreferredSize() {
        if (this.pSize == null) {
            this.pSize = this.calcSize();
        }
        return this.pSize;
    }

    public boolean getState() {
        return this.state;
    }

    protected boolean isEventEnabled() {
        return this.eventEnabled;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isShowOnEntry() {
        return this.inOnly;
    }

    public boolean isToggle() {
        return this.toggle;
    }

    protected Image makeImage(Image image, boolean bl) {
        return this.makeImage(image, bl, false);
    }

    protected synchronized Image makeImage(Image image, boolean bl, boolean bl2) {
        Dimension dimension = this.getSize();
        Image image2 = this.createImage(dimension.width, dimension.height);
        Graphics graphics = image2.getGraphics();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        Image image3 = image;
        if ((this.label == null || (this.style & 1) == 0) && image != null && (this.style & 2) != 0) {
            graphics.drawImage(image3, this.imagePos.x, this.imagePos.y, this);
            try {
                this.tracker.addImage(image3, 0);
                this.tracker.waitForID(0);
            }
            catch (Exception exception) {}
            graphics.drawImage(image3, this.imagePos.x, this.imagePos.y, this);
        } else if (this.label != null && (this.style & 1) != 0) {
            graphics.drawString(this.label, this.labelPos.x, this.labelPos.y);
            if (image != null && (this.style & 2) != 0) {
                graphics.drawImage(image3, this.imagePos.x, this.imagePos.y, this);
                try {
                    this.tracker.addImage(image3, 0);
                    this.tracker.waitForID(0);
                }
                catch (Exception exception) {}
                graphics.drawImage(image3, this.imagePos.x, this.imagePos.y, this);
            }
        }
        if (!bl2) {
            graphics.setColor(this.getBackground());
            int n = 0;
            while (n < this.border) {
                graphics.draw3DRect(n, n, dimension.width - n * this.border - 1, dimension.height - n * this.border - 1, bl ^ true);
                ++n;
            }
        }
        graphics.dispose();
        return image2;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.pointerIn = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.pointerIn = false;
        if (!this.toggle) {
            this.mousePressed = false;
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isEnabled() && this.isEventEnabled()) {
            if (this.toggle) {
                this.mousePressed = this.state ^= true;
                this.fire(new ActionEvent(this, 1001, this.label));
            } else {
                this.mousePressed = true;
            }
            this.repaint();
        }
        this.requestFocus();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isEnabled() && this.isEventEnabled() && !this.toggle && this.mousePressed) {
            this.fire(new ActionEvent(this, 1001, this.label));
            this.mousePressed = false;
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension.width != this.oSize.width || dimension.height != this.oSize.height) {
            this.oSize = dimension;
            this.clearCache();
            this.calcCoord();
        }
        try {
            Dimension dimension2 = this.oSize;
            synchronized (dimension2) {
                if (this.normalButton == null) {
                    this.normalButton = this.makeImage(this.image, false, false);
                    this.tracker.addImage(this.normalButton, 1);
                    this.tracker.waitForID(1);
                    this.pressedButton = this.makeImage(this.image2 == null ? this.image : this.image2, true, false);
                    this.tracker.addImage(this.pressedButton, 2);
                    this.tracker.waitForID(2);
                    this.plainButton = this.makeImage(this.image, true, true);
                    this.tracker.addImage(this.plainButton, 3);
                    this.tracker.waitForID(3);
                }
                if ((this.tracker.statusAll(true) & 4) != 0) {
                    graphics.setColor(Color.red);
                    graphics.fillRect(0, 0, dimension.width, dimension.height);
                    graphics.drawString("Error loading image", 5, 5);
                }
                Image image = this.mousePressed ? this.pressedButton : this.normalButton;
                image = this.inOnly && !this.pointerIn ? this.plainButton : image;
                graphics.drawImage(image, 0, 0, this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            graphics.drawImage(this.image, 0, 0, this);
        }
    }

    protected void preSave() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.oSize = new Dimension(0, 0);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void setBackground(Color color) {
        this.clearCache();
        super.setBackground(color);
    }

    public void setBorder(int n) {
        this.border = n;
        this.calcCoord();
    }

    public void setBorderGap(int n) {
        this.borderGap = n;
        this.calcCoord();
    }

    public void setDisplay(int n) {
        this.style = n;
        this.calcCoord();
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() != bl) {
            super.setEnabled(bl);
            this.repaint();
        }
    }

    protected void setEventEnabled(boolean bl) {
        this.eventEnabled = bl;
    }

    public void setFont(Font font) {
        this.clearCache();
        super.setFont(font);
    }

    public void setForeground(Color color) {
        this.clearCache();
        super.setForeground(color);
    }

    public synchronized void setImage(Image image) {
        if (image != null) {
            this.image = image;
            if (this.image.getWidth(null) <= 0) {
                this.tracker.addImage(this.image, 0);
                try {
                    this.tracker.waitForID(0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.iSize = new Dimension(this.image.getWidth(null), this.image.getHeight(null));
            this.clearCache();
        }
    }

    public synchronized void setImage2(Image image) {
        if (image != null) {
            this.image2 = image;
            if (this.image.getWidth(null) <= 0) {
                this.tracker.addImage(this.image, 0);
                try {
                    this.tracker.waitForID(0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.clearCache();
        }
    }

    public void setLabel(String string) {
        this.setLabel(string, this.pos);
    }

    public void setLabel(String string, int n) {
        this.label = string;
        this.pos = n;
        this.calcCoord();
        this.repaint();
    }

    public void setLabelPos(int n) {
        this.setLabel(this.label, n);
    }

    public void setPreferredSize(Dimension dimension) {
        this.pSize = dimension;
        this.calcCoord();
    }

    public void setShowOnEntry(boolean bl) {
        if (this.inOnly != bl) {
            this.inOnly = bl;
            this.repaint();
        }
    }

    public void setState(boolean bl) {
        if (this.toggle) {
            this.mousePressed = this.state = bl;
            this.fire(new ActionEvent(this, 1001, this.label));
            this.repaint();
        }
    }

    public void setToggle(boolean bl) {
        this.toggle = bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.preSave();
        objectOutputStream.defaultWriteObject();
    }

    private class IbKeyListener
    extends KeyAdapter {
        IbKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == ' ') {
                ToolButton.this.mousePressed(new MouseEvent(ToolButton.this, 501, 0L, 0, 0, 0, 0, false));
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            ToolButton.this.mouseReleased(new MouseEvent(ToolButton.this, 502, 0L, 0, 0, 0, 0, false));
        }
    }
}

