/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

public class TokenParser {
    private String str;
    private int idx = 0;

    public TokenParser(String string) {
        this.str = string;
    }

    public void advance() {
        ++this.idx;
    }

    public String getName() {
        this.skipWhitespace();
        if (this.idx >= this.str.length() || !Character.isJavaIdentifierStart(this.str.charAt(this.idx))) {
            return null;
        }
        String string = null;
        int n = this.idx + 1;
        while (n < this.str.length()) {
            if (!Character.isJavaLetterOrDigit(this.str.charAt(n))) {
                string = this.str.substring(this.idx, n);
                this.idx = n;
                break;
            }
            ++n;
        }
        return string;
    }

    public String getString() {
        this.skipWhitespace();
        if (this.idx >= this.str.length() || this.str.charAt(this.idx) != '\"') {
            return null;
        }
        String string = null;
        int n = this.idx + 1;
        while (n < this.str.length()) {
            if (this.str.charAt(n) == '\"') {
                string = this.str.substring(this.idx + 1, n);
                this.idx = n + 1;
                break;
            }
            ++n;
        }
        return string;
    }

    public boolean isNext(char c) {
        boolean bl;
        this.skipWhitespace();
        boolean bl2 = bl = this.idx < this.str.length() && this.str.charAt(this.idx) == c;
        if (bl) {
            ++this.idx;
        }
        return bl;
    }

    public char next() {
        this.skipWhitespace();
        return this.idx < this.str.length() ? this.str.charAt(this.idx) : (char)'\u0000';
    }

    public boolean skipTo(char c) {
        while (this.idx < this.str.length()) {
            if (this.str.charAt(this.idx) == c) {
                ++this.idx;
                return true;
            }
            ++this.idx;
        }
        return false;
    }

    public void skipWhitespace() {
        while (this.idx < this.str.length()) {
            if (!Character.isWhitespace(this.str.charAt(this.idx))) break;
            ++this.idx;
        }
    }
}

