/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import inetsoft.report.Painter;
import inetsoft.report.ReportElement;
import inetsoft.report.Size;
import inetsoft.report.StyleConstants;
import inetsoft.report.TextLens;
import inetsoft.report.internal.Bounds;
import inetsoft.report.internal.DefaultContext;
import inetsoft.report.internal.StyleCore;
import inetsoft.report.lens.DefaultTextLens;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class TextPainter
implements Painter,
StyleConstants {
    private int border = 4097;
    private TextLens text;
    private Insets padding;
    private boolean justify;
    private int talignment = 18;
    private transient ReportElement elem;

    public TextPainter(ReportElement reportElement) {
        this.elem = reportElement;
    }

    public int getBorder() {
        return this.border;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public Dimension getPreferredSize() {
        int n = 2 * (this.border & 0xF);
        String string = this.text.getText();
        Size size = string.length() == 0 ? new Size(20.0f, 15.0f) : StyleCore.getTextSize(string, this.elem.getFont(), 0.0f);
        return new Dimension((int)(size.width + (float)n + (float)this.padding.left + (float)this.padding.right), (int)(size.height + (float)n + (float)this.padding.top + (float)this.padding.bottom));
    }

    public String getText() {
        return this.text.getText();
    }

    public int getTextAlignment() {
        return this.talignment;
    }

    public TextLens getTextLens() {
        return this.text;
    }

    public boolean isJustify() {
        return this.justify;
    }

    public boolean isScalable() {
        return true;
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.border & 0xF;
        graphics.setColor(this.elem.getForeground());
        graphics.setFont(this.elem.getFont());
        Bounds bounds = new Bounds();
        Vector vector = Common.processText(this.text.getText(), new Bounds(n + n5 + this.padding.left, n2 + n5 + this.padding.top, n3 - 2 * n5 - this.padding.left - this.padding.right, n4 - 2 * n5 - this.padding.top - this.padding.bottom), this.getTextAlignment(), true, graphics.getFont(), bounds);
        if (vector.size() > 0) {
            float f = bounds.y;
            float f2 = Math.max(bounds.height / (float)vector.size(), Common.getHeight(this.elem.getFont(), null));
            int n6 = 0;
            while (n6 < vector.size()) {
                Common.paintText(graphics, (String)vector.elementAt(n6), new Bounds(bounds.x, f, bounds.width, f2), this.getTextAlignment(), false, this.isJustify());
                ++n6;
                f += f2;
            }
        }
        if (this.border != 0) {
            Common.drawRect(graphics, n, n2, n3, n4, this.border);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.elem = new DefaultContext();
        ((DefaultContext)this.elem).read(objectInputStream);
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public void setJustify(boolean bl) {
        this.justify = bl;
    }

    public void setPadding(Insets insets) {
        this.padding = insets;
    }

    public void setText(TextLens textLens) {
        this.text = textLens;
    }

    public void setText(String string) {
        this.text = new DefaultTextLens(string);
    }

    public void setTextAlignment(int n) {
        this.talignment = n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DefaultContext.write(objectOutputStream, this.elem);
    }
}

