/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import inetsoft.report.Paintable;
import inetsoft.report.ReportElement;
import inetsoft.report.TextLens;
import inetsoft.report.internal.DefaultTextContext;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TextPaintable
implements Paintable {
    String text;
    TextLens lens;
    transient ReportElement elem;
    float x;
    float y;
    float width;
    boolean highlighted = false;
    Rectangle box = null;

    public TextPaintable(TextLens textLens, float f, float f2, ReportElement reportElement) {
        this.lens = textLens;
        this.text = null;
        this.x = f;
        this.y = f2;
        this.elem = reportElement;
    }

    public TextPaintable(String string, float f, float f2, float f3, ReportElement reportElement) {
        this(string, f, f2, reportElement);
        this.width = f3;
    }

    public TextPaintable(String string, float f, float f2, ReportElement reportElement) {
        this.text = string;
        this.x = f;
        this.y = f2;
        this.elem = reportElement;
    }

    public Rectangle getBounds() {
        if (this.box == null) {
            String string = this.text != null ? this.text : this.lens.getText();
            Font font = this.elem.getFont();
            float f = this.width > 0.0f ? this.width : Common.stringWidth(string, font);
            this.box = new Rectangle((int)this.x, (int)this.y, Common.round(f), Common.round(Common.getHeight(font, null)));
        }
        return this.box;
    }

    public ReportElement getElement() {
        return this.elem;
    }

    public String getText() {
        return this.lens != null ? this.lens.getText() : this.text;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void paint(Graphics graphics) {
        Font font = this.elem.getFont();
        graphics.setFont(font);
        String string = this.text != null ? this.text : this.lens.getText();
        FontMetrics fontMetrics = Common.getFontMetrics(font);
        graphics.setColor(this.elem.getBackground());
        float f = this.width > 0.0f ? this.width : Common.stringWidth(string, font, fontMetrics);
        Common.fillRect(graphics, this.x, this.y, f, Common.getHeight(font, fontMetrics));
        graphics.setColor(this.elem.getForeground());
        if (this.width > 0.0f) {
            Common.drawString(graphics, string, this.x, this.y + Common.getAscent(fontMetrics), this.width);
        } else {
            Common.drawString(graphics, string, this.x, this.y + Common.getAscent(fontMetrics));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.elem = new DefaultTextContext();
        ((DefaultTextContext)this.elem).read(objectInputStream);
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public void setLocation(Point point) {
        this.x = point.x;
        this.y = point.y;
        if (this.box != null) {
            this.box.x = point.x;
            this.box.y = point.y;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DefaultTextContext.write(objectOutputStream, this.elem);
    }
}

