/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import inetsoft.report.ReportElement;
import inetsoft.report.internal.FieldPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;

public class TextFieldPainter
extends FieldPainter {
    private String text;
    private int cols = 15;

    public TextFieldPainter(ReportElement reportElement) {
        super(reportElement);
    }

    public int getCols() {
        return this.cols;
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)(Common.stringWidth("M", this.elem.getFont()) * (float)this.cols), (int)Common.getHeight(this.elem.getFont(), null) + 2);
    }

    public String getText() {
        return this.text;
    }

    public Object getValue() {
        return this.getText();
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        Shape shape = graphics.getClip();
        graphics.setColor(this.elem.getForeground());
        graphics.setFont(this.elem.getFont());
        graphics.setClip(n + 1, n2 + 1, n3 - 2, n4 - 2);
        FontMetrics fontMetrics = Common.getFontMetrics(graphics.getFont());
        float f = Common.getHeight(graphics.getFont(), fontMetrics);
        Common.drawString(graphics, this.text, n + 2, (float)n2 + ((float)n4 - f) / 2.0f + (float)fontMetrics.getAscent());
        graphics.setClip(shape);
        graphics.setColor(Color.gray);
        graphics.draw3DRect(n, n2, n3 - 1, n4 - 1, false);
    }

    public void setCols(int n) {
        this.cols = n;
    }

    public void setText(String string) {
        this.text = string;
    }
}

