/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import inetsoft.report.ReportElement;
import inetsoft.report.internal.Bounds;
import inetsoft.report.internal.FieldPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;

public class TextAreaPainter
extends FieldPainter {
    private String text;
    private int cols = 15;
    private int rows = 4;

    public TextAreaPainter(ReportElement reportElement) {
        super(reportElement);
    }

    public int getCols() {
        return this.cols;
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)(Common.stringWidth("M", this.elem.getFont()) * (float)this.cols), (int)Common.getHeight(this.elem.getFont(), null) * this.rows + 2);
    }

    public int getRows() {
        return this.rows;
    }

    public String getText() {
        return this.text;
    }

    public Object getValue() {
        return this.getText();
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(this.elem.getForeground());
        graphics.setFont(this.elem.getFont());
        Bounds bounds = new Bounds();
        Vector vector = Common.processText(this.text, new Bounds(n + 2, n2 + 2, n3 - 4, n4 - 4), 9, true, graphics.getFont(), bounds);
        if (vector.size() > 0) {
            float f = bounds.y;
            float f2 = Math.max(bounds.height / (float)vector.size(), Common.getHeight(this.elem.getFont(), null));
            int n5 = 0;
            while (n5 < vector.size()) {
                Common.paintText(graphics, (String)vector.elementAt(n5), new Bounds(bounds.x, f, bounds.width, f2), 9, false, false);
                ++n5;
                f += f2;
            }
        }
        graphics.setColor(Color.gray);
        graphics.draw3DRect(n, n2, n3 - 1, n4 - 1, false);
    }

    public void setCols(int n) {
        this.cols = n;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public void setText(String string) {
        this.text = string;
    }
}

