/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import inetsoft.report.Paintable;
import inetsoft.report.Painter;
import inetsoft.report.Presenter;
import inetsoft.report.ReportElement;
import inetsoft.report.Size;
import inetsoft.report.SummaryTableLens;
import inetsoft.report.TableLens;
import inetsoft.report.internal.Bounds;
import inetsoft.report.internal.DefaultContext;
import inetsoft.report.internal.StyleCore;
import inetsoft.report.internal.Util;
import inetsoft.report.lens.DefaultTableLens;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;
import java.util.Hashtable;
import java.util.Vector;

public class TablePaintable
implements Paintable {
    float height = 0.0f;
    float width = 0.0f;
    Rectangle reg;
    float x;
    float y;
    int resolution;
    Rectangle printBox;
    Bounds box;
    int headerR;
    int headerC;
    transient int summaryR;
    transient int[][] hor;
    transient int[][] ver;
    transient Vector[][] textCache = null;
    transient Bounds[][] boundCache = null;
    transient Bounds[][] nboundCache = null;
    float headerW;
    float headerH;
    float trailerH;
    transient ReportElement elem;
    transient TableLens lens;
    transient SummaryTableLens summary;
    Hashtable sumspan;
    Hashtable spanmap;
    Hashtable presenters;
    Hashtable formats;
    Insets padding;
    transient float[] rowHeight;
    transient float[] rowBorderH;
    float[] colWidth;
    float[] colBorderW;
    private int R = 1;

    public TablePaintable(Rectangle rectangle, float f, float f2, int n, Rectangle rectangle2, float f3, float f4, float f5, float[] fArray, float[] fArray2, TableLens tableLens, ReportElement reportElement, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, Hashtable hashtable4, Insets insets, float[] fArray3, float[] fArray4) {
        this.reg = rectangle;
        this.resolution = n;
        this.x = f;
        this.y = f2;
        this.printBox = new Rectangle(rectangle2);
        this.headerW = f3;
        this.headerH = f4;
        this.trailerH = f5;
        this.colWidth = fArray;
        this.rowHeight = fArray2;
        this.lens = tableLens;
        this.elem = reportElement;
        this.sumspan = hashtable;
        this.spanmap = hashtable2;
        this.rowBorderH = fArray3;
        this.colBorderW = fArray4;
        this.presenters = hashtable3;
        this.formats = hashtable4;
        this.init();
    }

    public Rectangle getBounds() {
        return new Rectangle((int)this.box.x, (int)this.box.y, (int)this.box.width + 2, (int)this.box.height + 2);
    }

    public Bounds getCellBounds(int n, int n2, boolean bl) {
        int n3;
        int n4;
        Rectangle rectangle;
        int n5 = n2 == this.reg.x ? this.lens.getHeaderColCount() - 1 : n2 - 1;
        int n6 = n == this.reg.y ? this.lens.getHeaderRowCount() - 1 : n - 1;
        float f = this.lens.getColBorder(n, n5) & 0xF;
        float f2 = this.lens.getRowBorder(n6, n2) & 0xF;
        Bounds bounds = new Bounds(this.box.x + f, this.box.y + f2, -f, -f2);
        Rectangle rectangle2 = rectangle = bl ? (Rectangle)this.sumspan.get(new Integer(n2)) : (Rectangle)this.spanmap.get(new Point(n2, n));
        if (rectangle != null) {
            rectangle = new Rectangle(rectangle);
        }
        if (rectangle != null && (rectangle.x != 0 || rectangle.y != 0)) {
            n4 = n + rectangle.y;
            while (n4 < n) {
                bounds.y -= this.rowHeight[n4];
                ++n4;
            }
            n3 = n2 + rectangle.x;
            while (n3 < n2) {
                bounds.x -= this.colWidth[n3];
                ++n3;
            }
            n += rectangle.y;
            n2 += rectangle.x;
            rectangle.width -= rectangle.x;
            rectangle.height -= rectangle.y;
        }
        if (n >= this.lens.getHeaderRowCount()) {
            bounds.y += this.headerH;
        } else {
            n4 = 0;
            while (n4 < n) {
                bounds.y += this.rowHeight[n4];
                ++n4;
            }
        }
        n4 = this.reg.y;
        while (n4 < n) {
            bounds.y += this.rowHeight[n4];
            ++n4;
        }
        if (n2 >= this.lens.getHeaderColCount()) {
            bounds.x += this.headerW;
        } else {
            n3 = 0;
            while (n3 < n2) {
                bounds.x += this.colWidth[n3];
                ++n3;
            }
        }
        n3 = this.reg.x;
        while (n3 < n2) {
            bounds.x += this.colWidth[n3];
            ++n3;
        }
        if (rectangle != null) {
            int n7 = n2;
            while (n7 < n2 + rectangle.width) {
                bounds.width += this.colWidth[n7];
                ++n7;
            }
            if (bl) {
                bounds.height += this.trailerH;
            } else {
                int n8 = n;
                while (n8 < n + rectangle.height) {
                    bounds.height += this.rowHeight[n8];
                    ++n8;
                }
            }
        } else {
            bounds.width += this.colWidth[n2];
            bounds.height = bounds.height + (bl ? this.trailerH : this.rowHeight[n]);
        }
        return bounds.round();
    }

    public ReportElement getElement() {
        return this.elem;
    }

    public float getHeight() {
        return this.height;
    }

    public Bounds getPrintBounds(int n, int n2, boolean bl) {
        Rectangle rectangle;
        Bounds bounds = this.getCellBounds(n, n2, bl);
        Rectangle rectangle2 = rectangle = bl ? (Rectangle)this.sumspan.get(new Integer(n2)) : (Rectangle)this.spanmap.get(new Point(n2, n));
        if (rectangle == null) {
            return bounds;
        }
        int n3 = n2 + rectangle.x;
        while (n3 < n2) {
            bounds.width -= this.colWidth[n3];
            bounds.x += this.colWidth[n3];
            ++n3;
        }
        int n4 = n + rectangle.y;
        while (n4 < n) {
            bounds.height -= this.rowHeight[n4];
            bounds.y += this.rowHeight[n4];
            ++n4;
        }
        return bounds.round();
    }

    public TableLens getTable() {
        return this.lens;
    }

    public Rectangle getTableRegion() {
        return this.reg;
    }

    public void init() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.lens instanceof SummaryTableLens) {
            this.summary = (SummaryTableLens)this.lens;
        }
        this.width = this.headerW;
        int n6 = this.reg.x;
        while (n6 < this.reg.x + this.reg.width) {
            this.width += this.colWidth[n6];
            ++n6;
        }
        this.height = this.headerH + this.trailerH;
        int n7 = this.reg.y;
        while (n7 < this.reg.y + this.reg.height) {
            this.height += this.rowHeight[n7];
            ++n7;
        }
        this.box = new Bounds(0.0f, (float)this.printBox.y + this.y, this.width, this.height);
        this.headerR = this.lens.getHeaderRowCount();
        this.headerC = this.lens.getHeaderColCount();
        this.summaryR = this.trailerH > 0.0f ? 1 : 0;
        this.hor = new int[this.headerR + this.reg.height + this.summaryR + 2][this.headerC + this.reg.width + 2];
        this.ver = new int[this.headerR + this.reg.height + this.summaryR + 2][this.headerC + this.reg.width + 2];
        this.textCache = new Vector[this.hor.length][this.hor[0].length];
        this.boundCache = new Bounds[this.hor.length][this.hor[0].length];
        this.nboundCache = new Bounds[this.hor.length][this.hor[0].length];
        this.box.x = (this.elem.getAlignment() & 2) != 0 ? (float)this.printBox.x + ((float)this.printBox.width - this.box.width) / 2.0f : ((this.elem.getAlignment() & 4) != 0 ? (float)(this.printBox.x + this.printBox.width) - this.box.width : (float)this.printBox.x + (float)this.elem.getIndent() * (float)this.resolution + 1.0f);
        int n8 = 0;
        while (n8 < this.hor.length - 1) {
            n5 = 0;
            while (n5 < this.hor[n8].length - 1) {
                n4 = n8 <= this.headerR ? n8 - 1 : n8 - this.headerR + this.reg.y - 1;
                n3 = n5 <= this.headerC ? n5 - 1 : n5 - this.headerC + this.reg.x - 1;
                n2 = n8 != this.hor.length - 2 || this.summaryR != 1 ? 0 : 1;
                Rectangle rectangle = null;
                rectangle = n2 != 0 ? (Rectangle)this.sumspan.get(new Integer(n3)) : (Rectangle)this.spanmap.get(new Point(n3, n4));
                if (rectangle != null) {
                    if (n8 <= this.headerR + 1 || n5 <= this.headerC + 1 || rectangle.x == 0 && rectangle.y == 0) {
                        n = n2 != 0 ? this.summary.getSummaryRowBorder(n3) : this.lens.getRowBorder(n4, n3);
                        int n9 = n2 != 0 ? this.summary.getSummaryColBorder(n3) : this.lens.getColBorder(n4, n3);
                        int n10 = 0;
                        while (n10 < rectangle.height && n8 + n10 < this.hor.length - 1) {
                            int n11 = 0;
                            while (n11 < rectangle.width && n5 + n11 < this.hor[n8].length - 1) {
                                this.hor[n8 + n10][n5 + n11] = n10 == rectangle.height - 1 || n8 + n10 == this.hor.length - 2 ? n : 0;
                                this.ver[n8 + n10][n5 + n11] = n11 == rectangle.width - 1 || n5 + n11 == this.hor[n8].length - 2 ? n9 : 0;
                                ++n11;
                            }
                            ++n10;
                        }
                    }
                } else {
                    this.hor[n8][n5] = n5 == 0 ? 0 : (n2 != 0 ? this.summary.getSummaryRowBorder(n3) : this.lens.getRowBorder(n4, n3));
                    this.ver[n8][n5] = n8 == 0 ? 0 : (n2 != 0 ? this.summary.getSummaryColBorder(n3) : this.lens.getColBorder(n4, n3));
                }
                ++n5;
            }
            ++n8;
        }
        n5 = this.hor[0].length - 2;
        n4 = 1;
        while (n4 < this.hor.length - 1) {
            n3 = n4 <= this.headerR ? n4 - 1 : n4 - this.headerR + this.reg.y - 1;
            n2 = this.lens.getColBorder(n3, this.lens.getColCount() - 1);
            this.ver[n4][n5] = Util.mergeLineStyle(this.ver[n4][n5], n2);
            ++n4;
        }
        if (this.summaryR == 0) {
            n3 = this.hor.length - 2;
            n2 = 1;
            while (n2 < this.hor[0].length - 1) {
                int n12 = n2 <= this.headerC ? n2 - 1 : n2 - this.headerC + this.reg.x - 1;
                n = this.lens.getRowBorder(this.lens.getRowCount() - 1, n12);
                this.hor[n3][n2] = Util.mergeLineStyle(this.hor[n3][n2], n);
                ++n2;
            }
        }
    }

    public Point locate(int n, int n2) {
        return this.locate(n, n2, false);
    }

    private Point locate(int n, int n2, boolean bl) {
        float f;
        int n3;
        if ((n -= (int)this.box.x) < 0 || (float)n > this.box.width + 1.0f || (n2 -= (int)this.box.y) < 0 || (float)n2 > this.box.height + 1.0f || this.colWidth == null || this.colBorderW == null || this.rowHeight == null || this.rowBorderH == null || this.colWidth.length < this.lens.getColCount() || this.rowHeight.length < this.lens.getRowCount() || this.colBorderW.length < this.lens.getColCount() || this.rowBorderH.length < this.lens.getRowCount()) {
            return null;
        }
        Point point = new Point(-1, -1);
        int n4 = this.lens.getHeaderRowCount();
        int n5 = this.lens.getHeaderColCount();
        int n6 = 0;
        while (n6 < n4) {
            float f2 = this.rowHeight[n6] + (n6 < n4 - 1 ? Math.max((float)this.R, this.rowBorderH[n6 + 1]) : (float)this.R);
            if (!bl && (float)n2 < this.rowHeight[n6] || bl && (float)n2 >= this.rowHeight[n6] && (float)n2 <= f2) {
                point.y = n6;
                break;
            }
            n2 = (int)((float)n2 - this.rowHeight[n6]);
            ++n6;
        }
        int n7 = 0;
        while (n7 < n5) {
            float f3 = this.colWidth[n7] + (n7 < n5 - 1 ? Math.max((float)this.R, this.colBorderW[n7 + 1]) : (float)this.R);
            if (!bl && (float)n < this.colWidth[n7] || bl && (float)n >= this.colWidth[n7] && (float)n <= f3) {
                point.x = n7;
                break;
            }
            n = (int)((float)n - this.colWidth[n7]);
            ++n7;
        }
        if (point.x < 0) {
            int n8 = this.reg.x + this.reg.width;
            point.x = -1;
            n3 = this.reg.x;
            while (n3 < n8 && n3 < this.colWidth.length) {
                f = this.colWidth[n3] + (n3 < this.colBorderW.length - 1 ? Math.max((float)this.R, this.colBorderW[n3 + 1]) : (float)this.R);
                if (!bl && (float)n < this.colWidth[n3] || bl && (float)n >= this.colWidth[n3] && (float)n <= f) {
                    point.x = n3;
                    break;
                }
                n = (int)((float)n - this.colWidth[n3]);
                ++n3;
            }
        }
        if (point.y < 0) {
            int n9 = this.reg.y + this.reg.height;
            point.y = -1;
            n3 = this.reg.y;
            while (n3 < n9 && n3 < this.rowHeight.length) {
                f = this.rowHeight[n3] + (n3 < this.rowBorderH.length - 1 ? Math.max((float)this.R, this.rowBorderH[n3 + 1]) : (float)this.R);
                if (!bl && (float)n2 < this.rowHeight[n3] || bl && (float)n2 >= this.rowHeight[n3] && (float)n2 <= f) {
                    point.y = n3;
                    break;
                }
                n2 = (int)((float)n2 - this.rowHeight[n3]);
                ++n3;
            }
        }
        return point.x < 0 || point.y < 0 || point.x > this.colWidth.length || point.y > this.rowHeight.length ? null : point;
    }

    public Point locateBorder(int n, int n2) {
        return this.locate(n, n2, true);
    }

    public void paint(Graphics graphics) {
        Serializable serializable;
        boolean bl;
        int n;
        int n2;
        Rectangle rectangle = graphics.getClipBounds();
        float f = Common.getLineAdjustment(graphics);
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        int n3 = 0;
        block0: while (n3 < this.hor.length - 2) {
            int n4 = n3 < this.headerR ? n3 : n3 - this.headerR + this.reg.y;
            boolean bl2 = n3 == this.hor.length - 3 && this.summaryR == 1;
            n2 = 0;
            while (n2 < this.hor[n3].length - 2) {
                Rectangle rectangle2;
                n = n2 < this.headerC ? n2 : n2 - this.headerC + this.reg.x;
                Color color2 = graphics.getColor();
                Object object = bl2 ? this.summary.getSummary(n, this.reg.y, this.reg.height) : this.lens.getObject(n4, n);
                bl = bl2 ? this.summary.isSummaryLineWrap(n) : this.lens.isLineWrap(n4, n);
                Rectangle rectangle3 = rectangle2 = bl2 ? (Rectangle)this.sumspan.get(new Integer(n)) : (Rectangle)this.spanmap.get(new Point(n, n4));
                if (rectangle2 == null || (rectangle2.x == 0 || n2 == this.headerC && n + rectangle2.x >= this.headerC) && (rectangle2.y == 0 || n3 == this.headerR && n4 + rectangle2.y >= this.headerR)) {
                    Bounds bounds = this.getCellBounds(n4, n, bl2);
                    if (rectangle != null && bounds.y > (float)(rectangle.y + rectangle.height)) break block0;
                    if (rectangle == null || !(bounds.y + bounds.height < (float)rectangle.y)) {
                        Color color3 = bl2 ? this.summary.getSummaryBackground(n) : this.lens.getBackground(n4, n);
                        Shape shape = null;
                        if (rectangle2 != null) {
                            int n5 = this.lens.getColBorder(n4, this.headerC - 1) & 0xF;
                            int n6 = this.lens.getRowBorder(this.headerR - 1, n) & 0xF;
                            object = bl2 ? this.summary.getSummary(n + rectangle2.x, this.reg.y, this.reg.height) : this.lens.getObject(n4 + rectangle2.y, n + rectangle2.x);
                            serializable = rectangle2.x == 0 && rectangle2.y == 0 ? new Bounds(bounds) : this.getPrintBounds(n4, n, bl2);
                            ((Bounds)serializable).width = Math.min(((Bounds)serializable).width, this.box.width + this.box.x - ((Bounds)serializable).x);
                            ((Bounds)serializable).height = Math.min(((Bounds)serializable).height, this.box.height + this.box.y - ((Bounds)serializable).y);
                            float f2 = this.box.x + (float)n5 + (n >= this.headerC ? this.headerW : 0.0f);
                            float f3 = this.box.y + (float)n6 + (n4 >= this.headerR ? this.headerH : 0.0f);
                            ((Bounds)serializable).x = Math.max(((Bounds)serializable).x, f2);
                            ((Bounds)serializable).y = Math.max(((Bounds)serializable).y, f3);
                            shape = graphics.getClip();
                            Common.clipRect(graphics, (Bounds)serializable);
                        }
                        if (color3 != null) {
                            graphics.setColor(color3);
                            Common.fillRect(graphics, bounds.x, bounds.y, bounds.width, bounds.height);
                            graphics.setColor(color2);
                        }
                        Color color4 = bl2 ? this.summary.getSummaryForeground(n) : this.lens.getForeground(n4, n);
                        graphics.setColor(color4 != null ? color4 : this.elem.getForeground());
                        Font font2 = bl2 ? this.summary.getSummaryFont(n) : this.lens.getFont(n4, n);
                        graphics.setFont(font2 != null ? font2 : this.elem.getFont());
                        if (object != null) {
                            Serializable serializable2;
                            Serializable serializable3;
                            Object object2;
                            Presenter presenter;
                            Insets insets;
                            int n7 = bl2 ? this.summary.getSummaryAlignment(n) : this.lens.getAlignment(n4, n);
                            Insets insets2 = insets = bl2 ? this.summary.getSummaryInsets(n) : this.lens.getInsets(n4, n);
                            if (insets != null) {
                                bounds.x += (float)insets.left;
                                bounds.y += (float)insets.top;
                                bounds.width -= (float)(insets.left + insets.right);
                                bounds.height -= (float)(insets.top + insets.bottom);
                            }
                            if ((presenter = StyleCore.getPresenter(this.presenters, object.getClass())) != null) {
                                object2 = presenter.getPreferredSize(object);
                                serializable3 = Common.alignCell(bounds, new Size((Dimension)object2), n7);
                                presenter.paint(graphics, object, (int)((Bounds)serializable3).x, (int)((Bounds)serializable3).y, (int)((Bounds)serializable3).width, (int)((Bounds)serializable3).height);
                            } else if (object instanceof Component) {
                                object2 = (Component)object;
                                serializable3 = ((Component)object2).getSize();
                                serializable2 = Common.alignCell(bounds, new Size((Dimension)serializable3), n7);
                                Shape shape2 = graphics.getClip();
                                Common.setClip(graphics, (Bounds)serializable2);
                                graphics.translate((int)((Bounds)serializable2).x, (int)((Bounds)serializable2).y);
                                ((Component)object2).printAll(graphics);
                                graphics.translate(-((int)((Bounds)serializable2).x), -((int)((Bounds)serializable2).y));
                                graphics.setClip(shape2);
                            } else if (object instanceof Image) {
                                object2 = (Image)object;
                                serializable3 = new Dimension(((Image)object2).getWidth(null), ((Image)object2).getHeight(null));
                                serializable2 = Common.alignCell(bounds, new Size((Dimension)serializable3), n7);
                                Common.drawImage(graphics, (Image)object2, ((Bounds)serializable2).x, ((Bounds)serializable2).y, ((Bounds)serializable2).width, ((Bounds)serializable2).height, null);
                            } else if (object instanceof Painter) {
                                object2 = (Painter)object;
                                serializable3 = object2.getPreferredSize();
                                serializable2 = Common.alignCell(bounds, new Size((Dimension)serializable3), n7);
                                Common.paint(graphics, ((Bounds)serializable2).x, ((Bounds)serializable2).y, ((Bounds)serializable2).width, ((Bounds)serializable2).height, (Painter)object2, 0.0f, 0.0f, ((Bounds)serializable2).width, ((Bounds)serializable2).height, ((Bounds)serializable2).height, color4, color3);
                            } else if (object != null) {
                                object2 = null;
                                serializable3 = null;
                                if (this.boundCache[n3][n2] == null) {
                                    if (this.padding != null) {
                                        bounds.x += (float)this.padding.left;
                                        bounds.y += (float)this.padding.top;
                                        bounds.width -= (float)(this.padding.left + this.padding.right);
                                        bounds.height -= (float)(this.padding.top + this.padding.bottom);
                                    }
                                    if ((serializable2 = StyleCore.getFormat(this.formats, object.getClass())) != null) {
                                        object = ((Format)serializable2).format(object);
                                    }
                                    object2 = new Bounds();
                                    serializable3 = Common.processText(Util.toString(object), bounds, n7, bl, graphics.getFont(), (Bounds)object2);
                                    this.textCache[n3][n2] = serializable3;
                                    this.boundCache[n3][n2] = bounds;
                                    this.nboundCache[n3][n2] = object2;
                                } else {
                                    serializable3 = this.textCache[n3][n2];
                                    bounds = this.boundCache[n3][n2];
                                    object2 = this.nboundCache[n3][n2];
                                }
                                if (rectangle2 != null) {
                                    serializable2 = graphics.getClipBounds();
                                    if ((float)((Rectangle)serializable2).y > ((Bounds)object2).y || (float)(((Rectangle)serializable2).y + ((Rectangle)serializable2).height) < ((Bounds)object2).y + ((Bounds)object2).height) {
                                        Serializable serializable4;
                                        float f4 = Common.getHeight(graphics.getFont(), graphics.getFontMetrics());
                                        int n8 = 0;
                                        int n9 = ((Vector)serializable3).size();
                                        float f5 = ((Bounds)object2).y;
                                        int n10 = 0;
                                        while (n10 < ((Vector)serializable3).size()) {
                                            if (f5 + f4 < (float)((Rectangle)serializable2).y) {
                                                n8 = n10 + 1;
                                            } else if ((double)(f5 + f4 - (float)(((Rectangle)serializable2).y + ((Rectangle)serializable2).height)) > 0.5) {
                                                n9 = n10;
                                                break;
                                            }
                                            f5 += f4;
                                            ++n10;
                                        }
                                        if (n8 > 0 || n9 < ((Vector)serializable3).size()) {
                                            serializable4 = new Vector();
                                            int n11 = n8;
                                            while (n11 < n9) {
                                                ((Vector)serializable4).addElement(((Vector)serializable3).elementAt(n11));
                                                ++n11;
                                            }
                                            serializable3 = serializable4;
                                        }
                                        serializable4 = new Bounds((Rectangle)serializable2);
                                        ((Bounds)serializable4).y = Math.max(((Bounds)serializable4).y, ((Bounds)object2).y);
                                        ((Bounds)serializable4).height = (float)(((Rectangle)serializable2).y + ((Rectangle)serializable2).height) - ((Bounds)serializable4).y;
                                        Common.setClip(graphics, (Bounds)serializable4);
                                        object2 = new Bounds(((Bounds)object2).x, ((Bounds)serializable4).y, ((Bounds)object2).width, ((Bounds)serializable4).height);
                                    }
                                }
                                Common.paintText(graphics, (Vector)serializable3, bounds, (Bounds)object2, false);
                            }
                        }
                        graphics.setColor(color2);
                        if (shape != null) {
                            graphics.setClip(shape);
                        }
                    }
                }
                ++n2;
            }
            ++n3;
        }
        float f6 = this.box.x;
        float f7 = this.box.y;
        n2 = Common.round(f6);
        n = Common.round(f7);
        int n12 = 0;
        while (n12 < this.hor.length - 1) {
            int n13 = n12 <= this.headerR ? n12 - 1 : n12 - this.headerR + this.reg.y - 1;
            bl = n12 == this.hor.length - 2 && this.summaryR == 1;
            float f8 = Common.round(bl || n13 < 0 ? this.trailerH : this.rowHeight[n13]);
            float f9 = (float)n - f8;
            f6 = this.box.x;
            n2 = Common.round(f6);
            if (rectangle != null && f7 - f8 > (float)(rectangle.y + rectangle.height)) break;
            if (rectangle == null || f7 + 5.0f > (float)rectangle.y) {
                int n14 = 0;
                while (n14 < this.hor[n12].length - 1) {
                    Color color5;
                    int n15 = n14 <= this.headerC ? n14 - 1 : n14 - this.headerC + this.reg.x - 1;
                    int n16 = this.hor[n12][n14];
                    int n17 = this.ver[n12][n14];
                    serializable = bl ? this.summary.getSummaryRowBorderColor(n15) : this.lens.getRowBorderColor(n13, n15);
                    Color color6 = color5 = bl ? this.summary.getSummaryColBorderColor(n15) : this.lens.getColBorderColor(n13, n15);
                    if (n12 > 0) {
                        graphics.setColor(color5 != null ? color5 : color);
                        if (n17 != 0) {
                            Common.drawVLine(graphics, (float)n2 + f, f9, n, n17, this.hor[n12 - 1][n14], this.hor[n12 - 1][n14 + 1]);
                            if (n14 == 0 && n12 == this.hor.length - 2 && this.hor[n12][1] != 0) {
                                Common.drawVLine(graphics, (float)n2 + f, n, n + (this.hor[n12][1] & 0xF) - 1, n17, 0, this.hor[n12][1]);
                            }
                        }
                    }
                    if (n14 > 0) {
                        graphics.setColor((Color)(serializable != null ? serializable : color));
                        if (n16 != 0) {
                            Common.drawHLine(graphics, (float)n + f, Common.round(f6 - this.colWidth[n15]), n2, n16, this.ver[n12][n14 - 1], this.ver[n12 + 1][n14 - 1]);
                            if (n12 == 0 && n14 == this.hor[n12].length - 2 && this.ver[1][n14] != 0) {
                                Common.drawHLine(graphics, (float)n + f, n2, n2 + (this.ver[1][n14] & 0xF) - 1, n16, 0, this.ver[1][n14]);
                            }
                        }
                    }
                    if (n12 > 0 && n12 == this.hor.length - 2 && n14 > 0 && n14 == this.hor[n12].length - 2) {
                        graphics.setColor(color5 != null ? color5 : color);
                        Common.drawVLine(graphics, (float)n2 + f, n, n + (this.hor[n12][n14] & 0xF) - 1, n17, this.hor[n12][n14 - 1], 0);
                        graphics.setColor((Color)(serializable != null ? serializable : color));
                        Common.drawHLine(graphics, (float)n + f, n2, n2 + (this.ver[n12][n14] & 0xF) - 1, n16, this.ver[n12 - 1][n14], 0);
                    }
                    if (n14 < this.hor[n12].length - 2) {
                        n2 = Common.round(f6 += this.colWidth[n14 == this.headerC ? this.reg.x : n15 + 1]);
                    }
                    ++n14;
                }
            }
            if (this.summaryR == 1 && n12 == this.hor.length - 2 - this.summaryR) {
                f7 += this.trailerH;
            } else if (n12 < this.hor.length - 2 - this.summaryR) {
                f7 += this.rowHeight[n12 == this.headerR ? this.reg.y : n13 + 1];
            }
            n = Common.round(f7);
            ++n12;
        }
        graphics.setColor(color);
        graphics.setFont(font);
    }

    public void readCell(ObjectInputStream objectInputStream, DefaultTableLens defaultTableLens, int n, int n2) throws ClassNotFoundException, IOException {
        defaultTableLens.setRowBorderColor(n, n2, (Color)objectInputStream.readObject());
        defaultTableLens.setColBorderColor(n, n2, (Color)objectInputStream.readObject());
        defaultTableLens.setRowBorder(n, n2, objectInputStream.readInt());
        defaultTableLens.setColBorder(n, n2, objectInputStream.readInt());
        defaultTableLens.setInsets(n, n2, (Insets)objectInputStream.readObject());
        defaultTableLens.setSpan(n, n2, (Dimension)objectInputStream.readObject());
        defaultTableLens.setAlignment(n, n2, objectInputStream.readInt());
        defaultTableLens.setFont(n, n2, (Font)objectInputStream.readObject());
        defaultTableLens.setLineWrap(n, n2, objectInputStream.readBoolean());
        defaultTableLens.setForeground(n, n2, (Color)objectInputStream.readObject());
        defaultTableLens.setBackground(n, n2, (Color)objectInputStream.readObject());
        defaultTableLens.setObject(n, n2, objectInputStream.readObject());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n;
        int n2;
        int n3;
        objectInputStream.defaultReadObject();
        this.elem = new DefaultContext();
        ((DefaultContext)this.elem).read(objectInputStream);
        int n4 = objectInputStream.readInt();
        int n5 = objectInputStream.readInt();
        DefaultTableLens defaultTableLens = new DefaultTableLens(n4, n5);
        this.lens = defaultTableLens;
        defaultTableLens.setHeaderRowCount(objectInputStream.readInt());
        defaultTableLens.setHeaderColCount(objectInputStream.readInt());
        int n6 = this.reg.y;
        while (n6 < this.reg.y + this.reg.height) {
            defaultTableLens.setRowHeight(n6, objectInputStream.readInt());
            ++n6;
        }
        int n7 = this.reg.x;
        while (n7 < this.reg.x + this.reg.width) {
            defaultTableLens.setColWidth(n7, objectInputStream.readInt());
            ++n7;
        }
        if (this.reg.y > 0) {
            n3 = 0;
            while (n3 < defaultTableLens.getHeaderRowCount()) {
                n2 = this.reg.x;
                while (n2 < this.reg.x + this.reg.width) {
                    this.readCell(objectInputStream, defaultTableLens, n3, n2);
                    ++n2;
                }
                ++n3;
            }
        }
        if (this.reg.x > 0) {
            n3 = this.reg.y;
            while (n3 < this.reg.y + this.reg.height) {
                n2 = 0;
                while (n2 < defaultTableLens.getHeaderColCount()) {
                    this.readCell(objectInputStream, defaultTableLens, n3, n2);
                    ++n2;
                }
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < defaultTableLens.getHeaderRowCount()) {
            n2 = 0;
            while (n2 < defaultTableLens.getHeaderColCount()) {
                this.readCell(objectInputStream, defaultTableLens, n3, n2);
                ++n2;
            }
            ++n3;
        }
        n2 = this.reg.y;
        while (n2 < this.reg.y + this.reg.height) {
            n = this.reg.x;
            while (n < this.reg.x + this.reg.width) {
                this.readCell(objectInputStream, defaultTableLens, n2, n);
                Rectangle rectangle = (Rectangle)this.spanmap.get(new Point(n, n2));
                if (rectangle != null && rectangle.width == 0 && rectangle.height == 0) {
                    this.readCell(objectInputStream, defaultTableLens, n2 + rectangle.y, n + rectangle.x);
                }
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < defaultTableLens.getRowCount()) {
            defaultTableLens.setColBorder(n, -1, objectInputStream.readInt());
            defaultTableLens.setColBorderColor(n, -1, (Color)objectInputStream.readObject());
            ++n;
        }
        int n8 = 0;
        while (n8 < defaultTableLens.getColCount()) {
            defaultTableLens.setRowBorder(-1, n8, objectInputStream.readInt());
            defaultTableLens.setRowBorderColor(-1, n8, (Color)objectInputStream.readObject());
            ++n8;
        }
        this.rowHeight = new float[objectInputStream.readInt()];
        this.rowBorderH = new float[objectInputStream.readInt()];
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[2];
        nArray[1] = defaultTableLens.getHeaderRowCount() + 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{this.reg.y, this.reg.y + this.reg.height + 3};
        int[][] nArrayArray2 = nArrayArray;
        float[][] fArrayArray = new float[][]{this.rowHeight, this.rowBorderH};
        int n9 = 0;
        while (n9 < nArrayArray2.length) {
            int n10 = nArrayArray2[n9][0];
            while (n10 < nArrayArray2[n9][1]) {
                int n11 = 0;
                while (n11 < fArrayArray.length) {
                    if (n10 < fArrayArray[n11].length) {
                        fArrayArray[n11][n10] = objectInputStream.readFloat();
                    }
                    ++n11;
                }
                ++n10;
            }
            ++n9;
        }
        this.init();
    }

    public void setLocation(Point point) {
        this.box.setLocation(point);
    }

    public void writeCell(ObjectOutputStream objectOutputStream, TableLens tableLens, int n, int n2) throws IOException {
        objectOutputStream.writeObject(tableLens.getRowBorderColor(n, n2));
        objectOutputStream.writeObject(tableLens.getColBorderColor(n, n2));
        objectOutputStream.writeInt(tableLens.getRowBorder(n, n2));
        objectOutputStream.writeInt(tableLens.getColBorder(n, n2));
        objectOutputStream.writeObject(tableLens.getInsets(n, n2));
        objectOutputStream.writeObject(tableLens.getSpan(n, n2));
        objectOutputStream.writeInt(tableLens.getAlignment(n, n2));
        objectOutputStream.writeObject(tableLens.getFont(n, n2));
        objectOutputStream.writeBoolean(tableLens.isLineWrap(n, n2));
        objectOutputStream.writeObject(tableLens.getForeground(n, n2));
        objectOutputStream.writeObject(tableLens.getBackground(n, n2));
        objectOutputStream.writeObject(tableLens.getObject(n, n2));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        int n2;
        objectOutputStream.defaultWriteObject();
        DefaultContext.write(objectOutputStream, this.elem);
        objectOutputStream.writeInt(this.lens.getRowCount());
        objectOutputStream.writeInt(this.lens.getColCount());
        objectOutputStream.writeInt(this.lens.getHeaderRowCount());
        objectOutputStream.writeInt(this.lens.getHeaderColCount());
        int n3 = this.reg.y;
        while (n3 < this.reg.y + this.reg.height) {
            objectOutputStream.writeInt(this.lens.getRowHeight(n3));
            ++n3;
        }
        int n4 = this.reg.x;
        while (n4 < this.reg.x + this.reg.width) {
            objectOutputStream.writeInt(this.lens.getColWidth(n4));
            ++n4;
        }
        if (this.reg.y > 0) {
            n2 = 0;
            while (n2 < this.lens.getHeaderRowCount()) {
                n = this.reg.x;
                while (n < this.reg.x + this.reg.width) {
                    this.writeCell(objectOutputStream, this.lens, n2, n);
                    Rectangle rectangle = (Rectangle)this.spanmap.get(new Point(n, n2));
                    if (rectangle != null && rectangle.width == 0 && rectangle.height == 0) {
                        this.writeCell(objectOutputStream, this.lens, n2 + rectangle.y, n + rectangle.x);
                    }
                    ++n;
                }
                ++n2;
            }
        }
        if (this.reg.x > 0) {
            n2 = this.reg.y;
            while (n2 < this.reg.y + this.reg.height) {
                n = 0;
                while (n < this.lens.getHeaderColCount()) {
                    this.writeCell(objectOutputStream, this.lens, n2, n);
                    ++n;
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.lens.getHeaderRowCount()) {
            n = 0;
            while (n < this.lens.getHeaderColCount()) {
                this.writeCell(objectOutputStream, this.lens, n2, n);
                ++n;
            }
            ++n2;
        }
        n = this.reg.y;
        while (n < this.reg.y + this.reg.height) {
            int n5 = this.reg.x;
            while (n5 < this.reg.x + this.reg.width) {
                this.writeCell(objectOutputStream, this.lens, n, n5);
                ++n5;
            }
            ++n;
        }
        int n6 = 0;
        while (n6 < this.lens.getRowCount()) {
            objectOutputStream.writeInt(this.lens.getColBorder(n6, -1));
            objectOutputStream.writeObject(this.lens.getColBorderColor(n6, -1));
            ++n6;
        }
        int n7 = 0;
        while (n7 < this.lens.getColCount()) {
            objectOutputStream.writeInt(this.lens.getRowBorder(-1, n7));
            objectOutputStream.writeObject(this.lens.getRowBorderColor(-1, n7));
            ++n7;
        }
        objectOutputStream.writeInt(this.rowHeight.length);
        objectOutputStream.writeInt(this.rowBorderH.length);
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[2];
        nArray[1] = this.lens.getHeaderRowCount() + 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{this.reg.y, this.reg.y + this.reg.height + 3};
        int[][] nArrayArray2 = nArrayArray;
        float[][] fArrayArray = new float[][]{this.rowHeight, this.rowBorderH};
        int n8 = 0;
        while (n8 < nArrayArray2.length) {
            int n9 = nArrayArray2[n8][0];
            while (n9 < nArrayArray2[n8][1]) {
                int n10 = 0;
                while (n10 < fArrayArray.length) {
                    if (n9 < fArrayArray[n10].length) {
                        objectOutputStream.writeFloat(fArrayArray[n10][n9]);
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
    }
}

