/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import inetsoft.report.Paintable;
import inetsoft.report.ReportElement;
import inetsoft.report.internal.DefaultContext;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TabPaintable
implements Paintable {
    float x;
    float y;
    float w;
    float h;
    int fill;
    transient Image tabMarker;
    transient ReportElement elem;

    public TabPaintable(float f, float f2, float f3, float f4, int n, Image image, ReportElement reportElement) {
        this.w = f3;
        this.h = f4;
        this.x = f;
        this.y = f2;
        this.fill = n;
        this.tabMarker = image;
        this.elem = reportElement;
    }

    public Rectangle getBounds() {
        return new Rectangle((int)this.x, (int)this.y, (int)this.w, (int)this.h);
    }

    public ReportElement getElement() {
        return this.elem;
    }

    public int getFill() {
        return this.fill;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.elem.getForeground());
        if (this.fill != 0) {
            float f = this.y + Common.getHeight(this.elem.getFont(), null) - (float)(this.fill & 0xF);
            Common.drawHLine(graphics, f, this.x, this.x + this.w, this.fill, 0, 0);
        } else if (this.tabMarker != null) {
            int n = this.tabMarker.getWidth(null);
            int n2 = this.tabMarker.getHeight(null);
            graphics.drawImage(this.tabMarker, (int)(this.x + (this.w - (float)n) / 2.0f), (int)(this.y + (this.h - (float)n2) / 2.0f), null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.elem = new DefaultContext();
        ((DefaultContext)this.elem).read(objectInputStream);
    }

    public void setLocation(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DefaultContext.write(objectOutputStream, this.elem);
    }
}

