/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.ChartLens;
import inetsoft.report.ChartPainter;
import inetsoft.report.Common;
import inetsoft.report.CompositeLens;
import inetsoft.report.Context;
import inetsoft.report.FormLens;
import inetsoft.report.FormTable;
import inetsoft.report.HeadingLens;
import inetsoft.report.Margin;
import inetsoft.report.PageArea;
import inetsoft.report.Paintable;
import inetsoft.report.Painter;
import inetsoft.report.Position;
import inetsoft.report.Presenter;
import inetsoft.report.ReportElement;
import inetsoft.report.ReportEnv;
import inetsoft.report.Size;
import inetsoft.report.StyleConstants;
import inetsoft.report.StylePage;
import inetsoft.report.SummaryTableLens;
import inetsoft.report.TOC;
import inetsoft.report.TableFilter;
import inetsoft.report.TableLens;
import inetsoft.report.TextLens;
import inetsoft.report.internal.ButtonPainter;
import inetsoft.report.internal.CheckBoxPainter;
import inetsoft.report.internal.ChoicePainter;
import inetsoft.report.internal.FieldPainter;
import inetsoft.report.internal.ImageButtonPainter;
import inetsoft.report.internal.PainterPaintable;
import inetsoft.report.internal.RadioButtonPainter;
import inetsoft.report.internal.SeparatorPaintable;
import inetsoft.report.internal.TabPaintable;
import inetsoft.report.internal.TablePaintable;
import inetsoft.report.internal.TextAreaPainter;
import inetsoft.report.internal.TextContext;
import inetsoft.report.internal.TextFieldPainter;
import inetsoft.report.internal.TextPaintable;
import inetsoft.report.internal.TextPainter;
import inetsoft.report.internal.Util;
import inetsoft.report.lens.DefaultHeadingLens;
import inetsoft.report.lens.DefaultTextLens;
import inetsoft.report.locale.Catalog;
import inetsoft.report.painter.BulletPainter;
import inetsoft.report.painter.ImagePainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public abstract class StyleCore
implements StyleConstants {
    Image tabMarker = null;
    Image newlineMarker = null;
    protected Margin margin = new Margin(1.0, 1.0, 1.0, 1.0);
    protected Margin pmargin = new Margin(g_pmargin);
    protected static Margin g_pmargin = new Margin(0.0, 0.0, 0.0, 0.0);
    protected double headerFromEdge = 0.5;
    protected double footerFromEdge = 0.75;
    protected String header = null;
    protected Vector headerElements = new Vector();
    protected Vector footerElements = new Vector();
    protected Vector firstHeader = new Vector();
    protected Vector firstFooter = new Vector();
    protected Vector evenHeader = new Vector();
    protected Vector evenFooter = new Vector();
    protected Vector oddHeader = new Vector();
    protected Vector oddFooter = new Vector();
    protected Hashtable elemHeader = new Hashtable();
    protected Hashtable elemFooter = new Hashtable();
    protected Vector currHeader = this.headerElements;
    protected Vector currFooter = this.footerElements;
    protected Vector overrideHeader = null;
    protected Vector overrideFooter = null;
    protected int pgStart = 0;
    protected int alignment = 1;
    protected double indent = 0.0;
    protected Position anchor = null;
    protected int hindent = 0;
    protected double[] tabStops = new double[]{0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0};
    protected int spacing = 0;
    protected Insets padding = new Insets(1, 1, 1, 1);
    protected Font font = new Font("Serif", 0, 10);
    protected Color foreground = Color.black;
    protected Color background = Color.white;
    protected int autosize = 1;
    protected int painterLayout = 0;
    protected Insets painterMargin = new Insets(1, 1, 1, 1);
    protected double tableW = 0.0;
    protected Hashtable presentermap = new Hashtable();
    protected Hashtable formatmap = new Hashtable();
    protected boolean justify = false;
    protected int textadv = 3;
    protected int tableadv = 3;
    protected int wrapping = 3;
    protected boolean orphan = false;
    protected int current = 0;
    protected Position printHead = new Position(0.0f, 0.0f);
    protected float lineH = 0.0f;
    protected Rectangle printBox = new Rectangle(72, 72, 468, 648);
    protected Position lastHead = new Position(0.0f, 0.0f);
    protected Rectangle[] frames = null;
    protected int currFrame = 0;
    protected PageArea[] areas = null;
    protected float advanceLine = 0.0f;
    protected int[] headingCnt = new int[20];
    protected Hashtable headingMap = new Hashtable();
    protected int resolution = 72;
    protected Vector elements = new Vector(50);
    protected Hashtable contexts = new Hashtable();
    protected Hashtable idmap = new Hashtable();
    protected boolean designtime = false;
    protected Properties prop = new Properties();
    private boolean limited = false;

    static {
        try {
            String string;
            if (ReportEnv.getProperty("os.name").startsWith("Win") && ((string = ReportEnv.getProperty("java.version")).compareTo("1.1.7") < 0 || string.compareTo("1.2") >= 0 && string.compareTo("1.3") < 0)) {
                g_pmargin = new Margin(0.25, 0.25, 0.25, 0.25);
            }
        }
        catch (Exception exception) {}
    }

    protected void advance(float f, float f2) {
        this.printHead.y += f2;
        this.printHead.x = f == 0.0f && f2 != 0.0f ? 0.0f : (this.printHead.x += f);
    }

    static String format(String string, int n, int n2, Date date) {
        int n3 = 0;
        while (n3 < string.length()) {
            if (string.charAt(n3) == '\\') {
                ++n3;
            } else if (string.charAt(n3) == '{') {
                String string2 = null;
                switch (string.charAt(++n3)) {
                    case 'P': 
                    case 'p': {
                        string2 = "0";
                        break;
                    }
                    case 'N': 
                    case 'n': {
                        string2 = "1";
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        string2 = "2,date";
                        break;
                    }
                    case 'T': 
                    case 't': {
                        string2 = "2,time";
                        break;
                    }
                }
                if (string2 != null) {
                    string = String.valueOf(string.substring(0, n3)) + string2 + string.substring(n3 + 1);
                    n3 += string2.length() - 1;
                }
            }
            ++n3;
        }
        return MessageFormat.format(string, new Integer(n), new Integer(n2), date);
    }

    public ReportElement getCompositeElement(String string, Object object, Context context) {
        Element element = null;
        if (object == CompositeLens.PAGE_BREAK) {
            element = new PageBreakElement();
        } else if (object == CompositeLens.AREA_BREAK) {
            element = new AreaBreakElement();
        } else if (object == CompositeLens.NEWLINE) {
            element = new NewlineElement(1, false);
        } else if (object == CompositeLens.BREAK) {
            element = new NewlineElement(1, true);
        } else if (object instanceof CompositeLens.Tab) {
            int n = ((CompositeLens.Tab)object).getFillStyle();
            element = new TabElement(n);
        } else if (object instanceof CompositeLens.Separator) {
            int n = ((CompositeLens.Separator)object).getStyle();
            element = new SeparatorElement(n);
        } else if (object instanceof CompositeLens.Space) {
            int n = ((CompositeLens.Space)object).getSpace();
            element = new SpaceElement(n);
        } else if (object instanceof TableLens) {
            element = new TableElement((TableLens)object);
        } else if (object instanceof TextLens) {
            element = new TextElement((TextLens)object);
        } else if (object instanceof String) {
            element = new TextElement(new DefaultTextLens((String)object));
        } else if (object instanceof FormLens) {
            element = new FormElement((FormLens)object);
        } else if (object instanceof ChartLens) {
            element = new ChartElement((ChartLens)object);
        } else if (object instanceof Image) {
            element = new PainterElement(new ImagePainter((Image)object));
        } else if (object instanceof Painter) {
            element = new PainterElement((Painter)object);
        }
        if (element != null) {
            element.setID(String.valueOf(string) + "." + element.getID());
            element.setContext(context);
        }
        return element;
    }

    public Hashtable getElementFooters() {
        return this.elemFooter;
    }

    public Hashtable getElementHeaders() {
        return this.elemHeader;
    }

    public static Format getFormat(Hashtable hashtable, Class clazz) {
        Format format = null;
        while (clazz != null && (format = (Format)hashtable.get(clazz)) == null) {
            clazz = clazz.getSuperclass();
        }
        return format;
    }

    protected String getNextHeadingNumber(int n) {
        int n2 = n;
        while (n2 < this.headingCnt.length) {
            this.headingCnt[n2] = 0;
            ++n2;
        }
        int n3 = n - 1;
        this.headingCnt[n3] = this.headingCnt[n3] + 1;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < n) {
            stringBuffer.append(String.valueOf(n4 > 0 ? "." : "") + this.headingCnt[n4]);
            ++n4;
        }
        return stringBuffer.toString();
    }

    public String getNextID(String string) {
        Integer n = (Integer)this.idmap.get(string);
        if (n == null) {
            n = new Integer(1);
        }
        this.idmap.put(string, new Integer(n + 1));
        return String.valueOf(string) + n;
    }

    public static Presenter getPresenter(Hashtable hashtable, Class clazz) {
        Presenter presenter = null;
        while (clazz != null && (presenter = (Presenter)hashtable.get(clazz)) == null) {
            clazz = clazz.getSuperclass();
        }
        return presenter;
    }

    public Properties getProperties() {
        return this.prop;
    }

    static Size getTextSize(String string, Font font, float f) {
        FontMetrics fontMetrics = Common.getFontMetrics(font);
        int n = 0;
        int n2 = 0;
        Size size = new Size(0.0f, 0.0f);
        float f2 = 0.0f;
        while (n >= 0) {
            n = string.indexOf("\n", n2);
            String string2 = n >= 0 ? string.substring(n2, n) : string.substring(n2);
            float f3 = Common.stringWidth(string2, font, fontMetrics);
            size.width = Math.max(size.width, f3);
            size.height += Common.getHeight(font, fontMetrics);
            if (f > 0.0f && string2.length() > 0) {
                int n3 = 0;
                int n4 = 0;
                int n5 = string2.indexOf(32);
                while (n4 >= 0) {
                    int n6;
                    int n7 = n6 = n5 > 0 ? n5 - n4 : string2.length();
                    if (n6 > n3) {
                        n3 = n6;
                    }
                    n4 = n5;
                    int n8 = n5 = n5 > 0 ? string2.indexOf(32, n5 + 1) : -1;
                }
                f2 = Math.max(f2, f3 * (float)n3 / (float)string2.length());
            }
            n2 = n + 1;
        }
        if (f > 0.0f) {
            size.width = Math.max(Math.min(f, size.width), f2);
        }
        return size;
    }

    protected abstract boolean printNextArea(StylePage var1);

    private float roundup(float f, float f2) {
        return (float)Math.ceil(f / f2) * f2;
    }

    public void setDesignTime(boolean bl) {
        this.designtime = bl;
    }

    public void setHindent(int n) {
        this.hindent = n;
    }

    public void setOverrideFooter(Vector vector) {
        this.overrideFooter = vector;
    }

    public void setOverrideHeader(Vector vector) {
        this.overrideHeader = vector;
    }

    public class Element
    implements ReportElement {
        private String id = null;
        private int alignment;
        private double indent;
        private int hindent;
        private Font font;
        private Color foreground;
        private Color background;
        private int spacing;
        private boolean visible = true;
        private Rectangle frame;
        private boolean block;
        private boolean conti;
        private Element parent;

        public Element(boolean bl) {
            this.block = bl;
            this.alignment = StyleCore.this.alignment;
            this.indent = StyleCore.this.indent;
            this.hindent = StyleCore.this.hindent;
            this.font = StyleCore.this.font;
            this.foreground = StyleCore.this.foreground;
            this.background = StyleCore.this.background;
            this.spacing = StyleCore.this.spacing;
            this.id = StyleCore.this.getNextID(this.getType());
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public boolean equals(Object object) {
            try {
                return this.getID().equals(((ReportElement)object).getID());
            }
            catch (Exception exception) {
                return this == object;
            }
        }

        public int getAlignment() {
            return this.alignment;
        }

        public Color getBackground() {
            return this.background;
        }

        public Font getFont() {
            return this.font;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public Rectangle getFrame() {
            return this.frame;
        }

        public int getHindent() {
            return this.hindent;
        }

        public String getID() {
            return this.id;
        }

        public double getIndent() {
            return this.indent;
        }

        public Element getParent() {
            return this.parent;
        }

        public Size getPreferredSize() {
            return new Size(0.0f, 0.0f);
        }

        public int getSpacing() {
            return this.spacing;
        }

        public String getType() {
            return "";
        }

        public int hashCode() {
            return this.getID() == null ? super.hashCode() : this.getID().hashCode();
        }

        public boolean isBlock() {
            return this.block;
        }

        public boolean isBreakable() {
            return false;
        }

        public boolean isContinuation() {
            return this.conti;
        }

        public boolean isFlowControl() {
            return false;
        }

        public boolean isLastOnLine() {
            return this.block;
        }

        public boolean isNewline() {
            return this.block;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public boolean print(StylePage stylePage) {
            if (!this.isVisible()) {
                return false;
            }
            if (StyleCore.this.printHead.x == 0.0f) {
                StyleCore.this.printHead.x = (float)this.indent * (float)stylePage.getPageResolution() + (float)this.hindent;
            }
            StyleCore.this.advanceLine = 0.0f;
            this.setFrame();
            return false;
        }

        public void reset() {
            this.frame = null;
        }

        public void setAlignment(int n) {
            this.alignment = n;
        }

        public void setBackground(Color color) {
            this.background = color;
        }

        public void setBlock(boolean bl) {
            this.block = bl;
        }

        public void setContext(ReportElement reportElement) {
            if (reportElement != null) {
                this.alignment = reportElement.getAlignment();
                this.indent = reportElement.getIndent();
                this.font = reportElement.getFont();
                this.foreground = reportElement.getForeground();
                this.background = reportElement.getBackground();
                this.spacing = reportElement.getSpacing();
            }
        }

        public void setContinuation(boolean bl) {
            this.conti = bl;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public void setForeground(Color color) {
            this.foreground = color;
        }

        public void setFrame() {
            this.frame = StyleCore.this.frames != null ? StyleCore.this.frames[StyleCore.this.currFrame] : null;
        }

        public void setHindent(int n) {
            this.hindent = n;
        }

        public void setID(String string) {
            this.id = string;
        }

        public void setIndent(double d) {
            this.indent = d;
        }

        public void setParent(Element element) {
            this.parent = element;
        }

        public void setSpacing(int n) {
            this.spacing = n;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }
    }

    public static interface TextBased {
        public String getText();

        public boolean isJustify();

        public void setJustify(boolean var1);

        public void setText(String var1);
    }

    public abstract class TabSupport
    extends Element {
        private int fill;
        private double[] stops;

        public TabSupport(int n) {
            super(false);
            this.fill = n;
            this.stops = (double[])StyleCore.this.tabStops.clone();
        }

        public int getFillStyle() {
            return this.fill;
        }

        public double[] getTabStops() {
            return this.stops;
        }

        public boolean printTab(StylePage stylePage) {
            if (StyleCore.this.designtime && StyleCore.this.tabMarker == null) {
                try {
                    StyleCore.this.tabMarker = Common.getImage(this, "/inetsoft/report/images/tabmarker.gif");
                    MediaTracker mediaTracker = new MediaTracker(Common.getInvisibleFrame());
                    mediaTracker.addImage(StyleCore.this.tabMarker, 0);
                    mediaTracker.waitForAll();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            int n = 0;
            int n2 = 0;
            while (n2 < this.stops.length) {
                n = (int)(this.stops[n2] * (double)StyleCore.this.resolution);
                if (StyleCore.this.printHead.x < (float)n) break;
                ++n2;
            }
            if ((float)n > StyleCore.this.printHead.x) {
                float f = (float)n - StyleCore.this.printHead.x;
                float f2 = Common.getHeight(this.getFont(), null) + (float)this.getSpacing();
                stylePage.addPaintable(new TabPaintable(StyleCore.this.printHead.x + (float)StyleCore.this.printBox.x, StyleCore.this.printHead.y + (float)StyleCore.this.printBox.y - (float)(this.fill & 0xF), f, f2, this.fill, StyleCore.this.tabMarker, this));
                StyleCore.this.advance(f, f2);
            }
            return false;
        }

        public void setContext(ReportElement reportElement) {
            super.setContext(reportElement);
            if (reportElement instanceof Context) {
                Context context = (Context)reportElement;
                this.setTabStops(context.getTabStops());
            }
        }

        public void setFillStyle(int n) {
            this.fill = n;
        }

        public void setTabStops(double[] dArray) {
            this.stops = dArray;
        }
    }

    public class TextElement
    extends TabSupport
    implements TextBased,
    inetsoft.report.TextElement {
        private TextLens lens;
        private String text;
        private String lensText;
        private boolean cache = true;
        private boolean justify;
        private int textadv;
        private boolean orphan;

        public TextElement(TextLens textLens) {
            super(0);
            this.lens = textLens;
            this.justify = StyleCore.this.justify;
            this.textadv = StyleCore.this.textadv;
            this.orphan = StyleCore.this.orphan;
            this.cache = textLens instanceof HTextLens ^ true;
        }

        public Object clone() throws CloneNotSupportedException {
            return this.clone(this.getText());
        }

        public TextElement clone(String string) {
            try {
                TextElement textElement = (TextElement)super.clone();
                textElement.lens = new DefaultTextLens(string);
                return textElement;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public String getDisplayText() {
            return this.getText();
        }

        public Size getPreferredSize() {
            Size size = StyleCore.getTextSize(this.getDisplayText(), this.getFont(), 0.0f);
            size.width += (float)this.textadv;
            return size;
        }

        public String getText() {
            if (!this.cache || this.lensText == null) {
                this.lensText = this.lens.getText();
            }
            return this.lensText;
        }

        public int getTextAdvance() {
            return this.textadv;
        }

        public TextLens getTextLens() {
            return this.lens;
        }

        public String getType() {
            return "Text";
        }

        public boolean isBreakable() {
            return true;
        }

        public boolean isJustify() {
            return this.justify;
        }

        public boolean isLastOnLine() {
            return this.getText().indexOf("\n") >= 0;
        }

        public boolean isOrphanControl() {
            return this.orphan;
        }

        public boolean print(StylePage stylePage) {
            if (!this.isVisible()) {
                return false;
            }
            super.print(stylePage);
            StyleCore.this.resolution = stylePage.getPageResolution();
            boolean bl = this.orphan && this.text == null && !(this.lens instanceof HTextLens);
            int n = stylePage.getPaintableCount();
            if (this.text == null) {
                this.text = this.getDisplayText();
            }
            FontMetrics fontMetrics = Common.getFontMetrics(this.getFont());
            float f = Common.getHeight(this.getFont(), fontMetrics) + (float)this.getSpacing();
            if (StyleCore.this.printHead.y + f > (float)StyleCore.this.printBox.height) {
                return true;
            }
            if (StyleCore.this.printHead.x >= (float)StyleCore.this.printBox.width) {
                return true;
            }
            int n2 = this.text.indexOf(10);
            float f2 = (float)this.getIndent() * (float)StyleCore.this.resolution + (float)this.getHindent();
            float f3 = StyleCore.this.lastHead.x;
            float f4 = StyleCore.this.lineH;
            String string = null;
            while (this.text != null && this.text.length() > 0) {
                boolean bl2 = true;
                char c = '\n';
                string = n2 >= 0 ? this.text.substring(0, n2) : this.text;
                int n3 = string.indexOf(9);
                if (n3 >= 0) {
                    n2 = n3;
                    string = this.text.substring(0, n2);
                    c = '\t';
                }
                this.text = n2 >= 0 ? this.text.substring(n2 + 1) : null;
                while (bl2) {
                    String string2 = string;
                    float f5 = (float)StyleCore.this.printBox.width - StyleCore.this.printHead.x;
                    TextPaintable textPaintable = null;
                    int n4 = Util.breakLine(string, f5, this.getFont());
                    if (n4 >= 0) {
                        if (StyleCore.this.printHead.x > f2 && StyleCore.this.printHead.x > f3 && !Character.isWhitespace(string.charAt(n4))) {
                            n4 = 0;
                        }
                        bl2 = true;
                        string2 = string.substring(0, n4);
                        while (n4 < string.length() && Character.isWhitespace(string.charAt(n4))) {
                            ++n4;
                        }
                        string = string.substring(n4);
                    } else {
                        string = "";
                        bl2 = false;
                    }
                    if (this.lens instanceof HTextLens) {
                        textPaintable = new TextPaintable(this.lens, (float)StyleCore.this.printBox.x + StyleCore.this.printHead.x, (float)StyleCore.this.printBox.y + StyleCore.this.printHead.y, (ReportElement)this);
                        stylePage.addPaintable(textPaintable);
                        this.text = null;
                        return false;
                    }
                    textPaintable = this.justify && bl2 ? new TextPaintable(string2, (float)StyleCore.this.printBox.x + StyleCore.this.printHead.x, (float)StyleCore.this.printBox.y + StyleCore.this.printHead.y, f5, this) : new TextPaintable(string2, (float)StyleCore.this.printBox.x + StyleCore.this.printHead.x, (float)StyleCore.this.printBox.y + StyleCore.this.printHead.y, (ReportElement)this);
                    stylePage.addPaintable(textPaintable);
                    f4 -= f;
                    if ((c == '\n' || StyleCore.this.printHead.x >= (float)StyleCore.this.printBox.width) && (this.text != null && this.text.length() > 0 || bl2)) {
                        float f6;
                        Rectangle rectangle;
                        if ((this.getAlignment() & 2) != 0) {
                            rectangle = textPaintable.getBounds();
                            f6 = StyleCore.this.printBox.x + (StyleCore.this.printBox.width - rectangle.width) / 2;
                            f6 = Math.max(f6, (float)rectangle.x);
                            textPaintable.setLocation(new Point((int)f6, rectangle.y));
                        } else if ((this.getAlignment() & 4) != 0) {
                            rectangle = textPaintable.getBounds();
                            f6 = StyleCore.this.printBox.x + (StyleCore.this.printBox.width - rectangle.width);
                            f6 = Math.max(f6, (float)rectangle.x);
                            textPaintable.setLocation(new Point((int)f6, rectangle.y));
                        }
                        StyleCore.this.printHead.x = f4 > 0.0f || this.getHindent() > 0 ? f3 : f2;
                        StyleCore.this.printHead.y += f;
                        StyleCore.this.advanceLine = Math.max(StyleCore.this.advanceLine, f);
                        if (!(StyleCore.this.printHead.y + f > (float)StyleCore.this.printBox.height) || this.text == null && !bl2) continue;
                        this.text = String.valueOf(string) + (this.text == null || this.text.length() == 0 ? "" : String.valueOf(c) + this.text);
                        if (bl) {
                            if (stylePage.getPaintableCount() == n + 1) {
                                stylePage.removePaintable(n);
                                this.text = this.getDisplayText();
                            } else if (Common.stringWidth(this.text, this.getFont()) <= f5) {
                                if (stylePage.getPaintableCount() > n + 2) {
                                    this.text = String.valueOf(string2) + " " + this.text;
                                    stylePage.removePaintable(stylePage.getPaintableCount() - 1);
                                } else {
                                    int n5 = stylePage.getPaintableCount() - 1;
                                    while (n5 >= n) {
                                        stylePage.removePaintable(n5);
                                        --n5;
                                    }
                                    this.text = this.getDisplayText();
                                }
                            }
                        }
                        return true;
                    }
                    StyleCore.this.printHead.x += Common.stringWidth(string2, this.getFont()) + (float)this.textadv;
                }
                if (c == '\t') {
                    float f7 = StyleCore.this.printHead.y;
                    this.printTab(stylePage);
                    StyleCore.this.printHead.y = f7;
                }
                int n6 = n2 = this.text != null ? this.text.indexOf(10) : -1;
            }
            StyleCore.this.printHead.y += f;
            this.text = null;
            return false;
        }

        public void reset() {
            this.text = null;
            this.lensText = null;
        }

        public void setJustify(boolean bl) {
            this.justify = bl;
        }

        public void setOrphanControl(boolean bl) {
            this.orphan = bl;
        }

        public void setText(TextLens textLens) {
            this.lens = textLens;
        }

        public void setText(String string) {
            this.lens = new DefaultTextLens(string);
        }

        public void setTextAdvance(int n) {
            this.textadv = n;
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + "]";
        }
    }

    public class HeadingElement
    extends TextElement
    implements TextContext,
    inetsoft.report.HeadingElement {
        private HeadingLens heading;
        private String number = null;

        public HeadingElement(HeadingLens headingLens) {
            super(headingLens);
            this.heading = headingLens;
        }

        public String getDisplayText() {
            if (this.number == null) {
                this.number = StyleCore.this.getNextHeadingNumber(this.getLevel());
            }
            return String.valueOf(this.heading.format(this.number)) + " " + super.getDisplayText();
        }

        public int getLevel() {
            return this.heading.getLevel();
        }

        public String getType() {
            return "Heading";
        }

        public void reset() {
            super.reset();
            this.number = null;
        }

        public void setLevel(int n) {
            if (this.heading instanceof DefaultHeadingLens) {
                ((DefaultHeadingLens)this.heading).setLevel(n);
            }
        }

        public void setText(String string) {
            this.heading = new DefaultHeadingLens(string, this.heading.getLevel());
            super.setText(this.heading);
        }
    }

    public class HeaderTextElement
    extends TextElement {
        private TextElement text;
        private int pgnum;
        private int pgcnt;
        private Date now;

        public HeaderTextElement(TextElement textElement, int n, int n2, Date date) {
            super(textElement.lens);
            this.text = textElement;
            this.pgnum = n;
            this.pgcnt = n2;
            this.now = date;
        }

        public Object clone() throws CloneNotSupportedException {
            HeaderTextElement headerTextElement = (HeaderTextElement)super.clone();
            headerTextElement.text = (TextElement)this.text.clone();
            return headerTextElement;
        }

        public int getAlignment() {
            return this.text.getAlignment();
        }

        public Color getBackground() {
            return this.text.getBackground();
        }

        public String getDisplayText() {
            return StyleCore.format(this.getText(), this.pgnum, this.pgcnt, this.now);
        }

        public Font getFont() {
            return this.text.getFont();
        }

        public Color getForeground() {
            return this.text.getForeground();
        }

        public Rectangle getFrame() {
            return this.text.getFrame();
        }

        public int getHindent() {
            return this.text.getHindent();
        }

        public String getID() {
            return this.text.getID();
        }

        public double getIndent() {
            return this.text.getIndent();
        }

        public int getSpacing() {
            return this.text.getSpacing();
        }

        public String getText() {
            return this.text.getText();
        }

        public boolean isBlock() {
            return this.text.isBlock();
        }

        public boolean isBreakable() {
            return this.text.isBreakable();
        }

        public boolean isContinuation() {
            return this.text.isContinuation();
        }

        public boolean isLastOnLine() {
            return this.text.isLastOnLine();
        }

        public boolean isNewline() {
            return this.text.isNewline();
        }

        public void reset() {
            this.text.reset();
        }

        public void setAlignment(int n) {
            this.text.setAlignment(n);
        }

        public void setBackground(Color color) {
            this.text.setBackground(color);
        }

        public void setBlock(boolean bl) {
            this.text.setBlock(bl);
        }

        public void setContinuation(boolean bl) {
            this.text.setContinuation(bl);
        }

        public void setFont(Font font) {
            this.text.setFont(font);
        }

        public void setForeground(Color color) {
            this.text.setForeground(color);
        }

        public void setHindent(int n) {
            this.text.setHindent(n);
        }

        public void setID(String string) {
            this.text.setID(string);
        }

        public void setIndent(double d) {
            this.text.setIndent(d);
        }

        public void setSpacing(int n) {
            this.text.setSpacing(n);
        }

        public void setText(String string) {
            this.text.setText(string);
        }
    }

    public class TableElement
    extends Element
    implements inetsoft.report.TableElement {
        private TableLens lens;
        private double tableW;
        private int autosize;
        private Insets padding;
        private Hashtable presenters;
        private Hashtable formats;
        private int[] fixedWidths;
        private int tableadv;
        private boolean valid = false;
        private Vector regions = new Vector();
        private int currentRegion = 0;
        private float[] colWidth;
        private float[] rowHeight;
        private float[] rowBorderH;
        private float[] colBorderW;
        private float headerW = 0.0f;
        private float headerH = 0.0f;
        private float trailerH = 0.0f;
        private SummaryTableLens summary = null;
        private Hashtable spanmap = new Hashtable();
        private Hashtable sumspan = new Hashtable();

        public TableElement(TableLens tableLens) {
            super(true);
            this.lens = tableLens;
            this.autosize = StyleCore.this.autosize;
            this.tableW = StyleCore.this.tableW;
            this.padding = StyleCore.this.padding;
            this.tableadv = StyleCore.this.tableadv;
            this.presenters = (Hashtable)StyleCore.this.presentermap.clone();
            this.formats = (Hashtable)StyleCore.this.formatmap.clone();
            if (tableLens instanceof SummaryTableLens) {
                this.summary = (SummaryTableLens)tableLens;
            }
        }

        public void addFormat(Class clazz, Format format) {
            this.formats.put(clazz, format);
        }

        public void addPresenter(Class clazz, Presenter presenter) {
            this.presenters.put(clazz, presenter);
        }

        public float[] calcColBorderW() {
            float[] fArray = new float[this.lens.getColCount()];
            int n = 0;
            while (n < this.lens.getRowCount()) {
                float f = this.lens.getColBorder(n, this.lens.getHeaderColCount() - 1) & 0xF;
                int n2 = 0;
                while (n2 < fArray.length) {
                    fArray[n2] = Math.max(fArray[n2], (float)(this.lens.getColBorder(n, n2 - 1) & 0xF));
                    fArray[n2] = Math.max(fArray[n2], f);
                    ++n2;
                }
                ++n;
            }
            return fArray;
        }

        public float[] calcColWidth(float f) {
            Hashtable<Point, Float> hashtable = new Hashtable<Point, Float>();
            float[] fArray = new float[this.lens.getColCount()];
            int n = this.lens.getHeaderColCount() - 1;
            this.colBorderW = this.calcColBorderW();
            int n2 = 0;
            while (n2 < this.lens.getColCount()) {
                float f2 = this.lens.getColWidth(n2);
                if (f2 == 0.0f) {
                    fArray[n2] = 0.0f;
                } else {
                    if (f2 < 0.0f) {
                        int n3 = 0;
                        while (n3 < this.lens.getRowCount()) {
                            float f3 = 0.0f;
                            Float f4 = (Float)hashtable.get(new Point(n2, n3));
                            if (f4 == null) {
                                Dimension dimension;
                                Font font = this.lens.getFont(n3, n2);
                                font = font == null ? this.getFont() : font;
                                f3 = this.calcPreferredWidth(this.lens.getObject(n3, n2), font, this.lens.isLineWrap(n3, n2) ? f : 0.0f);
                                Insets insets = this.lens.getInsets(n3, n2);
                                if (insets != null) {
                                    f3 += (float)(insets.left + insets.right);
                                }
                                if ((dimension = this.lens.getSpan(n3, n2)) != null) {
                                    f3 /= (float)dimension.width;
                                    int n4 = n3;
                                    while (n4 < n3 + dimension.height) {
                                        int n5 = n2;
                                        while (n5 < n2 + dimension.width) {
                                            hashtable.put(new Point(n5, n4), new Float(f3));
                                            ++n5;
                                        }
                                        ++n4;
                                    }
                                }
                            } else {
                                f3 = f4.intValue();
                                hashtable.remove(new Point(n2, n3));
                            }
                            f2 = Math.max(f2, f3);
                            ++n3;
                        }
                    }
                    if (this.getPadding() != null) {
                        f2 += (float)(this.getPadding().left + this.getPadding().right);
                    }
                    fArray[n2] = f2 + this.colBorderW[n2];
                }
                ++n2;
            }
            return fArray;
        }

        private float calcPreferredHeight(Font font, Object object, float f, boolean bl) {
            if (object == null) {
                return 0.0f;
            }
            Presenter presenter = this.getPresenter(object.getClass());
            if (presenter != null) {
                return presenter.getPreferredSize((Object)object).height;
            }
            Format format = this.getFormat(object.getClass());
            if (format != null) {
                object = format.format(object);
            }
            if (object instanceof Painter) {
                return ((Painter)object).getPreferredSize().height;
            }
            if (object instanceof Component) {
                return ((Component)object).getSize().height;
            }
            if (object instanceof Image) {
                return ((Image)object).getHeight(null);
            }
            String string = Util.toString(object);
            FontMetrics fontMetrics = Common.getFontMetrics(font);
            float f2 = 0.0f;
            int n = string.indexOf(10);
            int n2 = 0;
            String string2 = null;
            while (n2 >= 0) {
                string2 = n >= 0 ? string.substring(n2, n) : string.substring(n2);
                while (string2 != null && string2.length() > 0) {
                    f2 += Common.getHeight(font, fontMetrics) + (float)this.getSpacing();
                    int n3 = Util.breakLine(string2, f, font);
                    string2 = bl && n3 >= 0 ? string2.substring(Math.max(1, n3)) : null;
                }
                if (n < 0) break;
                n2 = n;
                n = string.indexOf(10, n + 1);
            }
            return Math.max(f2, Common.getHeight(font, fontMetrics));
        }

        private float calcPreferredWidth(Object object, Font font, float f) {
            if (object == null) {
                return 0.0f;
            }
            Presenter presenter = this.getPresenter(object.getClass());
            if (presenter != null) {
                return presenter.getPreferredSize((Object)object).width;
            }
            Format format = this.getFormat(object.getClass());
            if (format != null) {
                object = format.format(object);
            }
            if (object instanceof String) {
                return StyleCore.getTextSize((String)((String)object), (Font)font, (float)f).width;
            }
            if (object instanceof Painter) {
                return ((Painter)object).getPreferredSize().width;
            }
            if (object instanceof Component) {
                return ((Component)object).getSize().width;
            }
            if (object instanceof Image) {
                return ((Image)object).getWidth(null);
            }
            return StyleCore.getTextSize((String)Util.toString((Object)object), (Font)font, (float)f).width;
        }

        private float[] calcRowHeight(float[] fArray) {
            Hashtable<Point, Float> hashtable = new Hashtable<Point, Float>();
            float[] fArray2 = new float[this.lens.getRowCount()];
            this.rowBorderH = new float[this.lens.getRowCount()];
            int n = 0;
            while (n < this.rowBorderH.length) {
                int n2 = 0;
                while (n2 < this.lens.getColCount()) {
                    this.rowBorderH[n] = Math.max(this.rowBorderH[n], (float)(this.lens.getRowBorder(n - 1, n2) & 0xF));
                    ++n2;
                }
                ++n;
            }
            Insets insets = this.getPadding();
            int n3 = 0;
            while (n3 < this.lens.getRowCount()) {
                float f = this.lens.getRowHeight(n3);
                if (f < 0.0f) {
                    int n4 = 0;
                    while (n4 < this.lens.getColCount()) {
                        Float f2 = (Float)hashtable.get(new Point(n4, n3));
                        float f3 = 0.0f;
                        if (f2 == null) {
                            Dimension dimension;
                            int n5;
                            float f4;
                            Font font = this.lens.getFont(n3, n4);
                            font = font == null ? this.getFont() : font;
                            Rectangle rectangle = (Rectangle)this.spanmap.get(new Point(n4, n3));
                            Insets insets2 = this.lens.getInsets(n3, n4);
                            float f5 = f4 = insets2 == null ? fArray[n4] : fArray[n4] - (float)insets2.left - (float)insets2.right;
                            if (insets != null) {
                                f4 -= (float)(insets.left + insets.right);
                            }
                            if (rectangle != null) {
                                n5 = n4 + rectangle.x;
                                while (n5 < n4 + rectangle.width) {
                                    if (n5 != n4) {
                                        f4 += this.colWidth[n5];
                                    }
                                    ++n5;
                                }
                            }
                            n5 = this.lens.getHeaderColCount() - 1;
                            f3 = this.calcPreferredHeight(font, this.lens.getObject(n3, n4), f4 -= (float)Math.max(this.lens.getColBorder(n3, n4 - 1) & 0xF, this.lens.getColBorder(n3, n5) & 0xF), this.lens.isLineWrap(n3, n4));
                            if (insets2 != null) {
                                f3 += (float)(insets2.top + insets2.bottom);
                            }
                            if ((dimension = this.lens.getSpan(n3, n4)) != null) {
                                float f6 = Common.getHeight(font, null);
                                FontMetrics fontMetrics = Common.getFontMetrics(font);
                                float f7 = f3;
                                int n6 = n3;
                                while (n6 < n3 + dimension.height) {
                                    float f8 = StyleCore.this.roundup(f7 / (float)(dimension.height - n6 + n3), f6);
                                    if (n6 == n3) {
                                        f3 = f8;
                                    }
                                    int n7 = n4;
                                    while (n7 < n4 + dimension.width) {
                                        hashtable.put(new Point(n7, n6), new Float(f8));
                                        ++n7;
                                    }
                                    f7 = StyleCore.this.roundup(f7 - f8, f6);
                                    ++n6;
                                }
                            }
                        } else {
                            f3 = f2.intValue();
                            hashtable.remove(new Point(n4, n3));
                        }
                        f = Math.max(f, f3);
                        ++n4;
                    }
                }
                if (insets != null) {
                    f += (float)(insets.top + insets.bottom);
                }
                fArray2[n3] = f + this.rowBorderH[n3];
                ++n3;
            }
            return fArray2;
        }

        public boolean fitNext(float f) {
            if (this.currentRegion < this.regions.size()) {
                if (this.regions.elementAt(this.currentRegion) == CompositeLens.AREA_BREAK) {
                    ++this.currentRegion;
                    return false;
                }
                float f2 = this.headerH;
                Rectangle rectangle = (Rectangle)this.regions.elementAt(this.currentRegion);
                int n = 0;
                while (n < rectangle.height) {
                    f2 += this.rowHeight[rectangle.y + n];
                    ++n;
                }
                return f >= f2;
            }
            return true;
        }

        public float getColWidth(int n) {
            return this.colWidth[n];
        }

        public int[] getFixedWidths() {
            return this.fixedWidths;
        }

        public Format getFormat(Class clazz) {
            return StyleCore.getFormat(this.formats, clazz);
        }

        public int getLayout() {
            return this.autosize;
        }

        public Insets getPadding() {
            return this.padding;
        }

        public Size getPreferredSize() {
            return new Size(0.0f, 0.0f);
        }

        public Presenter getPresenter(Class clazz) {
            return StyleCore.getPresenter(this.presenters, clazz);
        }

        public TableLens getTable() {
            return this.lens;
        }

        public int getTableAdvance() {
            return this.tableadv;
        }

        public double getTableWidth() {
            return this.tableW;
        }

        public String getType() {
            return "Table";
        }

        public boolean isBreakable() {
            return true;
        }

        private void layout(StylePage stylePage) {
            int n;
            int n2;
            float f;
            int n3;
            int n4;
            Dimension dimension;
            int n5;
            StyleCore.this.resolution = stylePage.getPageResolution();
            if (StyleCore.this.limited && this.lens.getRowCount() > 50) {
                throw new Error("Style Report/Lite is limited to 50 rows per table: " + this.lens.getRowCount());
            }
            this.spanmap.clear();
            int n6 = 0;
            while (n6 < this.lens.getRowCount()) {
                n5 = 0;
                while (n5 < this.lens.getColCount()) {
                    dimension = this.lens.getSpan(n6, n5);
                    if (dimension != null) {
                        n4 = 0;
                        while (n4 < dimension.height) {
                            int n7 = 0;
                            while (n7 < dimension.width) {
                                Rectangle rectangle = new Rectangle(-n7, -n4, dimension.width - n7, dimension.height - n4);
                                this.spanmap.put(new Point(n7 + n5, n4 + n6), rectangle);
                                ++n7;
                            }
                            ++n4;
                        }
                    }
                    ++n5;
                }
                ++n6;
            }
            this.sumspan.clear();
            if (this.summary != null) {
                n5 = 0;
                while (n5 < this.lens.getColCount()) {
                    dimension = this.summary.getSummarySpan(n5);
                    if (dimension != null) {
                        n4 = 0;
                        while (n4 < dimension.width) {
                            Rectangle rectangle = new Rectangle(-n4, 0, dimension.width - n4, 1);
                            this.sumspan.put(new Integer(n4 + n5), rectangle);
                            ++n4;
                        }
                    }
                    ++n5;
                }
            }
            float f2 = this.tableW > 0.0 ? (float)(this.tableW * (double)StyleCore.this.resolution) : (float)((double)StyleCore.this.printBox.width - this.getIndent() * (double)StyleCore.this.resolution - (double)this.getHindent());
            f2 -= 2.0f;
            if (this.autosize == 2) {
                n3 = this.lens.getColCount();
                this.colWidth = new float[n3];
                f = f2 / (float)n3;
                n2 = 0;
                while (n2 < this.colWidth.length) {
                    this.colWidth[n2] = f;
                    ++n2;
                }
                this.colBorderW = this.calcColBorderW();
            } else {
                if (this.fixedWidths == null) {
                    this.colWidth = this.calcColWidth(this.autosize == 1 ? 2.0f * f2 / (float)this.lens.getColCount() : f2 / 2.0f);
                } else {
                    this.colWidth = new float[this.lens.getColCount()];
                    int n8 = 0;
                    while (n8 < this.colWidth.length) {
                        this.colWidth[n8] = n8 < this.fixedWidths.length ? this.fixedWidths[n8] : -1;
                        ++n8;
                    }
                    this.colBorderW = this.calcColBorderW();
                }
                n3 = 0;
                f = 0.0f;
                n2 = 0;
                while (n2 < this.colWidth.length) {
                    if (this.colWidth[n2] == 0.0f) {
                        ++n3;
                    } else {
                        f += this.colWidth[n2];
                    }
                    ++n2;
                }
                if (n3 > 0 && f2 > f) {
                    float f3 = (f2 - f) / (float)n3;
                    n = 0;
                    while (n < this.colWidth.length) {
                        if (this.colWidth[n] == 0.0f) {
                            this.colWidth[n] = f3;
                        }
                        ++n;
                    }
                } else if (this.autosize == 1) {
                    int n9 = 0;
                    while (n9 < this.colWidth.length) {
                        this.colWidth[n9] = this.colWidth[n9] * f2 / f;
                        ++n9;
                    }
                }
            }
            n3 = this.lens.getHeaderRowCount();
            int n10 = this.lens.getHeaderColCount();
            this.headerH = 0.0f;
            this.headerW = 0.0f;
            n2 = 0;
            while (n2 < n10) {
                this.headerW += this.colWidth[n2];
                ++n2;
            }
            int n11 = n10;
            while (n11 < this.lens.getColCount()) {
                if (this.headerW + this.colWidth[n11] > (float)StyleCore.this.printBox.width) {
                    this.colWidth[n11] = (float)StyleCore.this.printBox.width - this.headerW;
                }
                ++n11;
            }
            this.rowHeight = this.calcRowHeight(this.colWidth);
            n = 0;
            while (n < n3) {
                this.headerH += this.rowHeight[n];
                ++n;
            }
            if (this.summary != null) {
                this.trailerH = this.summary.getSummaryHeight();
            }
            this.regions.removeAllElements();
            this.currentRegion = 0;
            Rectangle rectangle = new Rectangle(StyleCore.this.printBox);
            int n12 = StyleCore.this.currFrame + 1;
            rectangle.height = (int)((float)rectangle.height - StyleCore.this.printHead.y);
            rectangle.x = (int)((double)rectangle.x + (this.getIndent() * (double)StyleCore.this.resolution + (double)this.getHindent()));
            rectangle.width = (int)((double)rectangle.width - (this.getIndent() * (double)StyleCore.this.resolution + (double)this.getHindent()));
            Point point = new Point(n10, n3);
            int n13 = 0;
            while (point.x < this.colWidth.length && point.y < this.rowHeight.length) {
                int n14;
                float f4;
                int n15;
                Rectangle rectangle2 = new Rectangle(point.x, point.y, this.colWidth.length - point.x, this.rowHeight.length - point.y);
                if (rectangle2.y != n3) {
                    int n16 = rectangle2.y;
                    this.rowHeight[n16] = this.rowHeight[n16] - (this.rowBorderH[rectangle2.y] - this.rowBorderH[n3]);
                }
                if (rectangle2.x != n10) {
                    int n17 = rectangle2.x;
                    this.colWidth[n17] = this.colWidth[n17] - (this.colBorderW[rectangle2.x] - this.colBorderW[n10]);
                }
                float f5 = this.headerW;
                int n18 = point.x;
                while (n18 < this.colWidth.length) {
                    if ((f5 += this.colWidth[n18]) > (float)rectangle.width) {
                        rectangle2.width = n18 - point.x;
                        break;
                    }
                    ++n18;
                }
                if (this.autosize == 4) {
                    n15 = point.x + rectangle2.width - 1;
                    f4 = (float)rectangle.width - (f5 - (n15 + 1 < this.colWidth.length ? this.colWidth[n15 + 1] : 0.0f));
                    int n19 = n15;
                    this.colWidth[n19] = this.colWidth[n19] + f4;
                }
                n15 = 0;
                if (point.x != n10) {
                    rectangle2.height = n13;
                } else {
                    f4 = this.headerH + this.trailerH;
                    n14 = point.y;
                    while (n14 < this.rowHeight.length) {
                        f4 += this.rowHeight[n14];
                        int n20 = n15 = (this.lens.getRowBorder(n14, 0) & 0x1000000) == 0 ? 0 : 1;
                        if (n15 != 0) {
                            rectangle2.height = n13 = n14 - point.y + 1;
                            break;
                        }
                        if (f4 > (float)rectangle.height) {
                            rectangle2.height = n13 = n14 - point.y;
                            break;
                        }
                        ++n14;
                    }
                }
                if (rectangle2.width > 0 && rectangle2.height > 0) {
                    this.regions.addElement(rectangle2);
                    if (n15 != 0) {
                        this.regions.addElement(CompositeLens.AREA_BREAK);
                    }
                    n13 = rectangle2.height;
                    if (rectangle2.x + rectangle2.width == this.colWidth.length) {
                        point.x = n10;
                        point.y += rectangle2.height;
                    } else {
                        point.x += rectangle2.width;
                    }
                    f4 = this.headerH + this.trailerH;
                    n14 = rectangle2.y;
                    while (n14 < rectangle2.y + rectangle2.height) {
                        f4 += this.rowHeight[n14];
                        ++n14;
                    }
                    rectangle.height = (int)((float)rectangle.height - f4);
                    rectangle.y = (int)((float)rectangle.y + f4);
                } else {
                    if (rectangle.height == StyleCore.this.printBox.height && rectangle.width == StyleCore.this.printBox.width) {
                        return;
                    }
                    rectangle.height = 0;
                }
                if (this.autosize != 3 && (point.y >= this.rowHeight.length || !((float)rectangle.height < this.headerH + this.rowHeight[point.y] + 30.0f))) continue;
                rectangle = new Rectangle(StyleCore.this.frames[n12 % StyleCore.this.frames.length]);
                ++n12;
                rectangle.x = (int)((double)rectangle.x + (this.getIndent() * (double)StyleCore.this.resolution + (double)this.getHindent()));
                rectangle.width = (int)((double)rectangle.width - (this.getIndent() * (double)StyleCore.this.resolution + (double)this.getHindent()));
            }
            if (this.regions.size() == 0 && (point.x > 0 || point.y > 0)) {
                this.regions.addElement(new Rectangle(point.x, point.y, this.lens.getColCount() - point.x, this.lens.getRowCount() - point.y));
            }
        }

        public boolean print(StylePage stylePage) {
            if (!this.isVisible()) {
                return false;
            }
            if (this.lens.getRowCount() <= 0 || this.lens.getColCount() <= 0 || this.currentRegion >= this.regions.size()) {
                return false;
            }
            this.validate(stylePage);
            super.print(stylePage);
            Object e = this.regions.elementAt(this.currentRegion++);
            if (e == CompositeLens.AREA_BREAK) {
                return true;
            }
            Rectangle rectangle = (Rectangle)e;
            TablePaintable tablePaintable = new TablePaintable(rectangle, StyleCore.this.printHead.x, StyleCore.this.printHead.y, stylePage.getPageResolution(), StyleCore.this.printBox, this.headerW, this.headerH, this.trailerH, this.colWidth, this.rowHeight, this.lens, this, this.sumspan, this.spanmap, this.presenters, this.formats, this.getPadding(), this.rowBorderH, this.colBorderW);
            stylePage.addPaintable(tablePaintable);
            StyleCore.this.printHead.y += tablePaintable.getHeight() + (float)this.getSpacing() + (float)this.tableadv;
            StyleCore.this.printHead.x = 0.0f;
            return this.currentRegion < this.regions.size();
        }

        public void reset() {
            this.valid = false;
            this.regions.removeAllElements();
            this.currentRegion = 0;
        }

        public void setContext(ReportElement reportElement) {
            super.setContext(reportElement);
            if (reportElement instanceof Context) {
                Context context = (Context)reportElement;
                this.setLayout(context.getTableLayout());
                this.setTableWidth(context.getTableWidth());
                this.setPadding(context.getCellPadding());
            }
        }

        public void setFixedWidths(int[] nArray) {
            this.fixedWidths = nArray;
        }

        public void setLayout(int n) {
            this.autosize = n;
        }

        public void setPadding(Insets insets) {
            this.padding = insets;
        }

        public void setTable(TableLens tableLens) {
            this.lens = tableLens;
        }

        public void setTableAdvance(int n) {
            this.tableadv = n;
        }

        public void setTableWidth(double d) {
            this.tableW = d;
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + "]";
        }

        public void validate(StylePage stylePage) {
            if (!this.valid) {
                if (this.lens instanceof TableFilter) {
                    ((TableFilter)this.lens).refresh();
                }
                this.layout(stylePage);
                this.valid = true;
            }
        }
    }

    public class FormElement
    extends TableElement
    implements inetsoft.report.FormElement {
        protected FormLens form;

        public FormElement(FormLens formLens) {
            super(new FormTable(formLens));
            this.form = formLens;
        }

        public FormLens getForm() {
            return this.form;
        }

        public void setForm(FormLens formLens) {
            this.form = formLens;
            this.setTable(new FormTable(this.form));
        }
    }

    public class PainterElement
    extends Element
    implements inetsoft.report.PainterElement {
        private Painter painter;
        private int layout;
        private int wrapping;
        private Position anchor = null;
        private ReportElement anchorElem = null;
        private Size psize;
        private int offsetY;
        private float anchorDepth = 0.0f;
        private Insets margin;

        public PainterElement(Painter painter) {
            super(false);
            this.layout = StyleCore.this.painterLayout;
            this.anchor = StyleCore.this.anchor;
            this.wrapping = StyleCore.this.wrapping;
            StyleCore.this.anchor = null;
            this.painter = painter;
            this.margin = StyleCore.this.painterMargin;
        }

        public PainterElement(Painter painter, double d, double d2) {
            this(painter);
            if (d > 0.0 && d2 > 0.0) {
                this.psize = new Size((float)d, (float)d2);
            }
        }

        public Position getAnchor() {
            return this.anchor;
        }

        public float getAnchorDepth() {
            return this.anchorDepth;
        }

        public ReportElement getAnchorElement() {
            return this.anchorElem;
        }

        public int getLayout() {
            return this.layout;
        }

        public Insets getMargin() {
            return this.margin;
        }

        public Painter getPainter() {
            return this.painter;
        }

        public Size getPreferredSize() {
            if (this.painter instanceof BulletPainter) {
                float f = Common.getHeight(this.getFont(), null);
                return new Size(f, f);
            }
            int n = 0;
            int n2 = 0;
            if (this.margin != null) {
                n = this.margin.left + this.margin.right;
                n2 = this.margin.top + this.margin.bottom;
            }
            if (this.psize != null) {
                return new Size(this.psize.width * (float)StyleCore.this.resolution + (float)n, this.psize.height * (float)StyleCore.this.resolution + (float)n2);
            }
            Dimension dimension = this.painter.getPreferredSize();
            if (dimension.width < 0) {
                dimension.width = -dimension.width * StyleCore.this.printBox.width / 1000;
            }
            if (dimension.height < 0) {
                dimension.height = -dimension.height * StyleCore.this.printBox.width / 1000;
            }
            return new Size(dimension.width + n, dimension.height + n2);
        }

        public Size getSize() {
            return this.psize;
        }

        public String getType() {
            return "Painter";
        }

        public int getWrapping() {
            return this.wrapping;
        }

        public boolean isBreakable() {
            return this.layout == 1;
        }

        public boolean isLastOnLine() {
            return this.wrapping == 1 || this.wrapping == 256;
        }

        public boolean isNewline() {
            return super.isNewline() || this.wrapping == 2 || this.wrapping == 256 || this.anchor != null && this.anchor.y > 0.0f;
        }

        public boolean print(StylePage stylePage) {
            if (!this.isVisible()) {
                return false;
            }
            Size size = this.getPreferredSize();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (this.margin != null) {
                n3 = this.margin.left + this.margin.right;
                size.width -= (float)n3;
                n4 = this.margin.top + this.margin.bottom;
                size.height -= (float)n4;
                n = this.margin.left;
                n2 = this.margin.top;
            }
            if ((float)this.offsetY >= size.height) {
                this.reset();
            }
            Dimension dimension = !this.painter.isScalable() ? this.painter.getPreferredSize() : size.getDimension();
            int n5 = (int)Math.min(size.height - (float)this.offsetY, (float)StyleCore.this.printBox.height - StyleCore.this.printHead.y);
            int n6 = (int)Math.min((float)StyleCore.this.printBox.width - StyleCore.this.printHead.x, size.width);
            if (dimension.width < 0) {
                dimension.width = -dimension.width * StyleCore.this.printBox.width / 1000;
            }
            if (dimension.height < 0) {
                dimension.height = -dimension.height * StyleCore.this.printBox.width / 1000;
            }
            super.print(stylePage);
            stylePage.addPaintable(new PainterPaintable(StyleCore.this.printHead.x + (float)StyleCore.this.printBox.x + (float)n, StyleCore.this.printHead.y + (float)StyleCore.this.printBox.y + (float)n2, n6, n5, dimension, (int)size.height, this, this.painter, this.offsetY));
            if (this.getWrapping() != 0) {
                StyleCore.this.printHead.x += (float)(n6 + n3);
                StyleCore.this.printHead.y += (float)(n5 + n4);
            }
            this.offsetY += n5;
            return this.isBreakable() && (int)((float)this.offsetY - size.height) < 0;
        }

        public void reset() {
            this.offsetY = 0;
            this.anchorDepth = 0.0f;
        }

        public void setAnchor(Position position) {
            if (position == null) {
                this.anchorElem = null;
            }
            this.anchor = position != null ? new Position(position.x, this.anchorDepth + position.y) : null;
        }

        public void setAnchorDepth(float f) {
            this.anchorDepth = f;
        }

        public void setAnchorElement(ReportElement reportElement) {
            this.anchorElem = reportElement;
        }

        public void setContext(ReportElement reportElement) {
            super.setContext(reportElement);
            if (reportElement instanceof Context) {
                Context context = (Context)reportElement;
                this.setLayout(context.getPainterLayout());
            }
        }

        public void setLayout(int n) {
            this.layout = n;
        }

        public void setMargin(Insets insets) {
            this.margin = insets;
        }

        public void setPainter(Painter painter) {
            this.painter = painter;
        }

        public void setSize(Size size) {
            this.psize = size;
        }

        public void setWrapping(int n) {
            this.wrapping = n;
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + "]";
        }
    }

    public class ChartElement
    extends PainterElement
    implements inetsoft.report.ChartElement {
        protected ChartLens chart;

        public ChartElement(ChartLens chartLens) {
            super(null);
            this.setPainter(new ChartPainter(chartLens, this));
            this.chart = chartLens;
        }

        public ChartElement(ChartLens chartLens, double d, double d2) {
            super(null, d, d2);
            this.setPainter(new ChartPainter(chartLens, this));
            this.chart = chartLens;
        }

        public Object clone() throws CloneNotSupportedException {
            ChartElement chartElement = (ChartElement)super.clone();
            chartElement.setPainter(new ChartPainter(chartElement.chart, chartElement));
            return chartElement;
        }

        public ChartLens getChart() {
            return this.chart;
        }

        public String getType() {
            return "Chart";
        }

        public void setChart(ChartLens chartLens) {
            this.chart = chartLens;
            this.setPainter(new ChartPainter(chartLens, this));
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + "]";
        }
    }

    public class TextBoxElement
    extends PainterElement
    implements TextBased,
    inetsoft.report.TextBoxElement {
        TextPainter painter = new TextPainter(this);

        public TextBoxElement(TextLens textLens) {
            super(null);
            this.setPainter(this.painter);
            this.painter.setText(textLens);
            this.painter.setPadding(StyleCore.this.padding);
            this.painter.setJustify(StyleCore.this.justify);
        }

        public TextBoxElement(TextLens textLens, double d, double d2) {
            super(null, d, d2);
            this.setPainter(this.painter);
            this.painter.setText(textLens);
            this.painter.setPadding(StyleCore.this.padding);
            this.painter.setJustify(StyleCore.this.justify);
        }

        public Object clone() throws CloneNotSupportedException {
            TextBoxElement textBoxElement = (TextBoxElement)super.clone();
            textBoxElement.setPainter(new TextPainter(textBoxElement));
            textBoxElement.setText(this.painter.getTextLens());
            return textBoxElement;
        }

        public TextBoxElement clone(String string) {
            try {
                TextBoxElement textBoxElement = (TextBoxElement)this.clone();
                return textBoxElement;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public int getBorder() {
            return this.painter.getBorder();
        }

        public Insets getPadding() {
            return this.painter.getPadding();
        }

        public String getText() {
            return this.painter.getText();
        }

        public int getTextAlignment() {
            return this.painter.getTextAlignment();
        }

        public TextLens getTextLens() {
            return this.painter.getTextLens();
        }

        public String getType() {
            return "TextBox";
        }

        public boolean isJustify() {
            return this.painter.isJustify();
        }

        public void setBorder(int n) {
            this.painter.setBorder(n);
        }

        public void setJustify(boolean bl) {
            this.painter.setJustify(bl);
        }

        public void setPadding(Insets insets) {
            this.painter.setPadding(insets);
        }

        public void setText(TextLens textLens) {
            this.painter.setText(textLens);
        }

        public void setText(String string) {
            this.painter.setText(string);
        }

        public void setTextAlignment(int n) {
            this.painter.setTextAlignment(n);
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + "]";
        }
    }

    public class TabElement
    extends TabSupport
    implements inetsoft.report.TabElement {
        public TabElement(int n) {
            super(n);
        }

        public String getType() {
            return "Tab";
        }

        public boolean print(StylePage stylePage) {
            if (!this.isVisible()) {
                return false;
            }
            super.print(stylePage);
            return this.printTab(stylePage);
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + ": " + Util.getLineStyleName(this.getFillStyle()) + "]";
        }
    }

    public class NewlineElement
    extends Element
    implements inetsoft.report.NewlineElement {
        private int count;
        private int skipped = 0;

        public NewlineElement(int n, boolean bl) {
            super(bl ^ true);
            this.count = n;
            this.setContinuation(bl);
        }

        static /* synthetic */ StyleCore access$0(NewlineElement newlineElement) {
            return newlineElement.StyleCore.this;
        }

        public int getCount() {
            return this.count;
        }

        public Size getPreferredSize() {
            return new Size(0.0f, Common.getHeight(this.getFont(), null) + (float)this.getSpacing());
        }

        public int getRemain() {
            return this.count - this.skipped;
        }

        public String getType() {
            return "Newline";
        }

        public boolean isBreak() {
            return this.isBlock() ^ true;
        }

        public boolean isFlowControl() {
            return true;
        }

        public boolean isLastOnLine() {
            return true;
        }

        public boolean print(StylePage stylePage) {
            if (!this.isVisible()) {
                return false;
            }
            super.print(stylePage);
            if (StyleCore.this.designtime && StyleCore.this.newlineMarker == null) {
                try {
                    StyleCore.this.newlineMarker = Common.getImage(this, "/inetsoft/report/images/paramarker.gif");
                    MediaTracker mediaTracker = new MediaTracker(Common.getInvisibleFrame());
                    mediaTracker.addImage(StyleCore.this.newlineMarker, 0);
                    mediaTracker.waitForAll();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            float f = Common.getHeight(this.getFont(), null) + (float)this.getSpacing();
            int n = StyleCore.this.newlineMarker != null ? StyleCore.this.newlineMarker.getWidth(null) : 1;
            int n2 = 0;
            do {
                if (StyleCore.this.designtime) {
                    stylePage.addPaintable(new Paintable(f, this, n){
                        private final /* synthetic */ NewlineElement this$1;
                        Rectangle box;
                        {
                            this.this$1 = newlineElement;
                            this.box = new Rectangle((int)(NewlineElement.access$0((NewlineElement)newlineElement).printHead.x + (float)NewlineElement.access$0((NewlineElement)newlineElement).printBox.x), (int)(NewlineElement.access$0((NewlineElement)newlineElement).printHead.y + (float)NewlineElement.access$0((NewlineElement)newlineElement).printBox.y), n, Common.round(f));
                        }

                        public Rectangle getBounds() {
                            return this.box;
                        }

                        public ReportElement getElement() {
                            return this.this$1;
                        }

                        public void paint(Graphics graphics) {
                            if (NewlineElement.access$0((NewlineElement)this.this$1).newlineMarker != null) {
                                graphics.drawImage(NewlineElement.access$0((NewlineElement)this.this$1).newlineMarker, this.box.x, this.box.y, null);
                            }
                        }

                        public void setLocation(Point point) {
                            this.box.x = point.x;
                            this.box.y = point.y;
                        }
                    });
                }
                if (n2 >= this.count - this.skipped) continue;
                StyleCore.this.advance(0.0f, f);
            } while (++n2 < this.count - this.skipped);
            return false;
        }

        public void reset() {
            this.skipped = 0;
        }

        public void setBreak(boolean bl) {
            this.setBlock(bl ^ true);
        }

        public void setCount(int n) {
            this.count = n;
        }

        public void skip() {
            ++this.skipped;
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + ": " + this.count + "]";
        }
    }

    public class AreaBreakElement
    extends Element
    implements inetsoft.report.AreaBreakElement {
        protected String label = Catalog.getString("Area Break");
        Font defFont = new Font("Serif", 0, 10);

        public AreaBreakElement() {
            super(true);
        }

        static /* synthetic */ StyleCore access$0(AreaBreakElement areaBreakElement) {
            return areaBreakElement.StyleCore.this;
        }

        public String getType() {
            return "AreaBreak";
        }

        public boolean isFlowControl() {
            return true;
        }

        public boolean print(StylePage stylePage) {
            if (!this.isVisible()) {
                return false;
            }
            super.print(stylePage);
            if (StyleCore.this.designtime) {
                stylePage.addPaintable(new Paintable(this){
                    private final /* synthetic */ AreaBreakElement this$1;
                    float x;
                    float y;
                    float w;
                    float h;
                    Rectangle box;
                    {
                        this.this$1 = areaBreakElement;
                        this.x = AreaBreakElement.access$0((AreaBreakElement)areaBreakElement).printHead.x + (float)AreaBreakElement.access$0((AreaBreakElement)areaBreakElement).printBox.x;
                        this.y = AreaBreakElement.access$0((AreaBreakElement)areaBreakElement).printHead.y + (float)AreaBreakElement.access$0((AreaBreakElement)areaBreakElement).printBox.y;
                        this.w = AreaBreakElement.access$0((AreaBreakElement)areaBreakElement).printBox.width;
                        this.h = Common.getHeight(areaBreakElement.defFont, null);
                        this.box = AreaBreakElement.access$0((AreaBreakElement)areaBreakElement).designtime ? new Rectangle((int)this.x, (int)this.y, (int)this.w, (int)this.h) : new Rectangle((int)this.x, (int)this.y, 1, 1);
                    }

                    public Rectangle getBounds() {
                        return this.box;
                    }

                    public ReportElement getElement() {
                        return this.this$1;
                    }

                    public void paint(Graphics graphics) {
                        graphics.setColor(Color.gray);
                        float f = Common.stringWidth(this.this$1.label, this.this$1.defFont);
                        float f2 = this.x + (this.w - f) / 2.0f;
                        float f3 = f2 + f;
                        Common.drawHLine(graphics, this.y + this.h / 2.0f, this.x, f2, 4145, 0, 0);
                        graphics.setFont(this.this$1.defFont);
                        Common.drawString(graphics, this.this$1.label, f2, this.y + Common.getAscent(this.this$1.defFont));
                        Common.drawHLine(graphics, this.y + this.h / 2.0f, f3, this.x + this.w, 4145, 0, 0);
                    }

                    public void setLocation(Point point) {
                        this.x = point.x;
                        this.y = point.y;
                    }
                });
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + "]";
        }
    }

    public class PageBreakElement
    extends AreaBreakElement
    implements inetsoft.report.PageBreakElement {
        public PageBreakElement() {
            this.label = Catalog.getString("Page Break");
        }

        public String getType() {
            return "PageBreak";
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + "]";
        }
    }

    public class PageLayoutElement
    extends Element
    implements inetsoft.report.PageLayoutElement {
        private PageArea[] areas;

        public PageLayoutElement(PageArea[] pageAreaArray) {
            super(true);
            this.areas = pageAreaArray;
        }

        static /* synthetic */ StyleCore access$0(PageLayoutElement pageLayoutElement) {
            return pageLayoutElement.StyleCore.this;
        }

        public PageArea[] getPageAreas() {
            return this.areas;
        }

        public String getType() {
            return "PageLayout";
        }

        public boolean isFlowControl() {
            return true;
        }

        public boolean print(StylePage stylePage) {
            if (!this.isVisible()) {
                return false;
            }
            StyleCore.this.areas = this.areas;
            super.print(stylePage);
            if (StyleCore.this.designtime) {
                stylePage.addPaintable(new Paintable(this){
                    private final /* synthetic */ PageLayoutElement this$1;
                    Rectangle box;
                    {
                        this.this$1 = pageLayoutElement;
                        this.box = new Rectangle((int)(PageLayoutElement.access$0((PageLayoutElement)pageLayoutElement).printHead.x + (float)PageLayoutElement.access$0((PageLayoutElement)pageLayoutElement).printBox.x), (int)(PageLayoutElement.access$0((PageLayoutElement)pageLayoutElement).printHead.y + (float)PageLayoutElement.access$0((PageLayoutElement)pageLayoutElement).printBox.y), 0, 0);
                    }

                    public Rectangle getBounds() {
                        return this.box;
                    }

                    public ReportElement getElement() {
                        return this.this$1;
                    }

                    public void paint(Graphics graphics) {
                    }

                    public void setLocation(Point point) {
                        this.box.x = point.x;
                        this.box.y = point.y;
                    }
                });
            }
            return false;
        }

        public void setPageAreas(PageArea[] pageAreaArray) {
            this.areas = pageAreaArray;
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + ": " + this.areas.length + "]";
        }
    }

    public class CondPageBreakElement
    extends Element
    implements inetsoft.report.CondPageBreakElement {
        private int pixels = 0;
        private double inch = 0.0;

        public CondPageBreakElement(double d) {
            super(true);
            this.inch = d;
        }

        public CondPageBreakElement(int n) {
            super(true);
            this.pixels = n;
        }

        static /* synthetic */ StyleCore access$0(CondPageBreakElement condPageBreakElement) {
            return condPageBreakElement.StyleCore.this;
        }

        public double getCondHeight() {
            return this.pixels > 0 ? (double)this.pixels / (double)StyleCore.this.resolution : this.inch;
        }

        public int getMinimumHeight() {
            return this.pixels > 0 ? this.pixels : (int)(this.inch * (double)StyleCore.this.resolution);
        }

        public String getType() {
            return "CondPageBreak";
        }

        public boolean isFlowControl() {
            return true;
        }

        public boolean print(StylePage stylePage) {
            if (!this.isVisible()) {
                return false;
            }
            super.print(stylePage);
            if (StyleCore.this.designtime) {
                stylePage.addPaintable(new Paintable(this){
                    private final /* synthetic */ CondPageBreakElement this$1;
                    Rectangle box;
                    {
                        this.this$1 = condPageBreakElement;
                        this.box = new Rectangle((int)(CondPageBreakElement.access$0((CondPageBreakElement)condPageBreakElement).printHead.x + (float)CondPageBreakElement.access$0((CondPageBreakElement)condPageBreakElement).printBox.x), (int)(CondPageBreakElement.access$0((CondPageBreakElement)condPageBreakElement).printHead.y + (float)CondPageBreakElement.access$0((CondPageBreakElement)condPageBreakElement).printBox.y), 0, 0);
                    }

                    public Rectangle getBounds() {
                        return this.box;
                    }

                    public ReportElement getElement() {
                        return this.this$1;
                    }

                    public void paint(Graphics graphics) {
                    }

                    public void setLocation(Point point) {
                        this.box.x = point.x;
                        this.box.y = point.y;
                    }
                });
            }
            return false;
        }

        public void setCondHeight(double d) {
            this.inch = d;
            this.pixels = 0;
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString("Conditional PageBreak") + ": " + this.pixels + ":" + this.inch + "]";
        }
    }

    public class SpaceElement
    extends Element
    implements inetsoft.report.SpaceElement {
        private int pixels;

        public SpaceElement(int n) {
            super(false);
            this.pixels = n;
        }

        static /* synthetic */ StyleCore access$0(SpaceElement spaceElement) {
            return spaceElement.StyleCore.this;
        }

        static /* synthetic */ int access$1(SpaceElement spaceElement) {
            return spaceElement.pixels;
        }

        public Size getPreferredSize() {
            FontMetrics fontMetrics = Common.getFontMetrics(this.getFont());
            return new Size(this.pixels, Common.getHeight(this.getFont(), fontMetrics));
        }

        public int getSpace() {
            return this.pixels;
        }

        public String getType() {
            return "Space";
        }

        public boolean print(StylePage stylePage) {
            int n;
            if (!this.isVisible()) {
                return false;
            }
            super.print(stylePage);
            int n2 = n = this.pixels == 0 ? 0 : (int)Common.getHeight(this.getFont(), null) + this.getSpacing();
            if (StyleCore.this.designtime) {
                stylePage.addPaintable(new Paintable(n, this){
                    private final /* synthetic */ SpaceElement this$1;
                    private final /* synthetic */ int val$h;
                    Rectangle box;
                    {
                        this.val$h = n;
                        this.this$1 = spaceElement;
                        this.box = new Rectangle((int)(SpaceElement.access$0((SpaceElement)spaceElement).printHead.x + (float)SpaceElement.access$0((SpaceElement)spaceElement).printBox.x), (int)(SpaceElement.access$0((SpaceElement)spaceElement).printHead.y + (float)SpaceElement.access$0((SpaceElement)spaceElement).printBox.y), SpaceElement.access$1(spaceElement), n);
                    }

                    public Rectangle getBounds() {
                        return this.box;
                    }

                    public ReportElement getElement() {
                        return this.this$1;
                    }

                    public void paint(Graphics graphics) {
                        graphics.setColor(Color.gray);
                        int n = this.box.y + this.val$h / 2;
                        int n2 = this.box.x + 2;
                        while (n2 < this.box.x + this.box.width) {
                            graphics.drawLine(n2, n, n2, n);
                            n2 += 4;
                        }
                    }

                    public void setLocation(Point point) {
                        this.box.x = point.x;
                        this.box.y = point.y;
                    }
                });
            }
            StyleCore.this.advance(this.pixels, n);
            return false;
        }

        public void setSpace(int n) {
            this.pixels = n;
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + ": " + this.pixels + "]";
        }
    }

    public class SeparatorElement
    extends Element
    implements inetsoft.report.SeparatorElement {
        private int style;
        private int height = 5;

        public SeparatorElement(int n) {
            super(true);
            this.setStyle(n);
        }

        public Size getPreferredSize() {
            return new Size(5000.0f, this.height);
        }

        public int getStyle() {
            return this.style;
        }

        public String getType() {
            return "Separator";
        }

        public boolean print(StylePage stylePage) {
            if (!this.isVisible()) {
                return false;
            }
            super.print(stylePage);
            Dimension dimension = stylePage.getPageDimension();
            stylePage.addPaintable(new SeparatorPaintable(StyleCore.this.printHead.x + (float)StyleCore.this.printBox.x, StyleCore.this.printHead.y + (float)StyleCore.this.printBox.y, StyleCore.this.printBox.width, this.style, this));
            StyleCore.this.advance(0.0f, this.height);
            return false;
        }

        public void setStyle(int n) {
            this.style = n;
            this.height = (n & 0xF) + 4;
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + ": " + Util.getLineStyleName(this.style) + "]";
        }
    }

    public class CompositeElement
    extends Element
    implements inetsoft.report.CompositeElement {
        private CompositeLens composite;
        private Vector elems = null;
        private int curr = 0;

        public CompositeElement(CompositeLens compositeLens) {
            super(true);
            this.composite = compositeLens;
        }

        public CompositeLens getComposite() {
            return this.composite;
        }

        public Size getPreferredSize() {
            return new Size();
        }

        public String getType() {
            return "Composite";
        }

        public boolean print(StylePage stylePage) {
            Cloneable cloneable;
            if (!this.isVisible()) {
                return false;
            }
            super.print(stylePage);
            if (this.elems == null) {
                Object object;
                this.elems = new Vector();
                cloneable = new Context(this);
                this.composite.reset();
                while ((object = this.composite.nextElement((Context)cloneable)) != null) {
                    Element element = null;
                    element = object instanceof ReportElement ? (Element)object : (Element)StyleCore.this.getCompositeElement(this.getID(), object, (Context)cloneable);
                    if (element != null) {
                        element.setParent(this);
                        this.elems.addElement(element);
                    }
                    cloneable = new Context(this);
                }
            }
            int n = StyleCore.this.current;
            cloneable = StyleCore.this.elements;
            StyleCore.this.current = this.curr;
            StyleCore.this.elements = this.elems;
            boolean bl = StyleCore.this.printNextArea(stylePage);
            this.curr = StyleCore.this.current;
            StyleCore.this.current = n;
            StyleCore.this.elements = cloneable;
            return this.curr < this.elems.size();
        }

        public void reset() {
            this.elems = null;
            this.curr = 0;
        }

        public void setComposite(CompositeLens compositeLens) {
            this.composite = compositeLens;
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + "]";
        }
    }

    public class TOCElement
    extends CompositeElement
    implements inetsoft.report.TOCElement {
        private final /* synthetic */ StyleCore this$0;
        private TOC toc;

        public TOCElement(StyleCore styleCore, TOC tOC) {
            StyleCore styleCore2 = styleCore;
            styleCore2.getClass();
            super(styleCore2.new TOCLens(tOC));
            this.this$0 = styleCore;
            this.toc = tOC;
        }

        public Font getFont() {
            return TOC.getBaseFont();
        }

        public TOC getTOC() {
            return this.toc;
        }

        public void setFont(Font font) {
            TOC.setBaseFont(font);
        }

        public void setTOC(TOC tOC) {
            this.toc = tOC;
            this.setComposite(this.this$0.new TOCLens(this.toc));
        }
    }

    class TOCLens
    implements CompositeLens,
    Serializable {
        private TOC toc;
        private int step = 0;
        private int curr = 0;
        private Vector headings = new Vector();

        public TOCLens(TOC tOC) {
            this.toc = tOC;
        }

        public Object nextElement(Context context) {
            if (this.curr >= this.headings.size()) {
                return null;
            }
            HeadingElement headingElement = (HeadingElement)this.headings.elementAt(this.curr);
            Object object = null;
            switch (this.step) {
                case 0: {
                    object = new DefaultTextLens(headingElement.getDisplayText());
                    context.setIndent(this.toc.getIndent(headingElement.getLevel()));
                    context.setFont(this.toc.getFont(headingElement.getLevel()));
                    break;
                }
                case 1: {
                    if (this.toc.isPageNumberRight()) {
                        object = new CompositeLens.Tab(this.toc.getLeader(headingElement.getLevel()));
                        double d = (double)StyleCore.this.printBox.width / (double)StyleCore.this.resolution - 0.4;
                        context.setTabStops(new double[]{d});
                        context.setFont(this.toc.getFont(headingElement.getLevel()));
                        break;
                    }
                    object = new CompositeLens.Space(15);
                    break;
                }
                case 2: {
                    object = new HTextLens(headingElement);
                    context.setFont(this.toc.getFont(headingElement.getLevel()));
                    break;
                }
                case 3: {
                    if (this.toc.getSeparator(headingElement.getLevel()) != 0) {
                        object = new CompositeLens.Separator(this.toc.getSeparator(headingElement.getLevel()));
                        break;
                    }
                    object = CompositeLens.NEWLINE;
                    break;
                }
            }
            context.setAlignment(this.toc.getAlignment(headingElement.getLevel()));
            ++this.step;
            if (this.step > 3) {
                this.step = 0;
                ++this.curr;
            }
            return object;
        }

        public void reset() {
            Object object;
            this.curr = 0;
            this.step = 0;
            this.headings.removeAllElements();
            int n = 0;
            while (n < StyleCore.this.elements.size()) {
                object = StyleCore.this.elements.elementAt(n);
                if (object instanceof HeadingElement) {
                    this.headings.addElement(object);
                }
                ++n;
            }
            if (StyleCore.this.designtime && this.headings.size() == 0) {
                object = new DefaultHeadingLens("Empty Table of Contents", 1);
                this.headings.addElement(new HeadingElement((HeadingLens)object));
            }
        }
    }

    public abstract class FieldElement
    extends PainterElement {
        FieldPainter painter = this.createPainter();

        public FieldElement(String string, String string2, double d, double d2) {
            super(null, d, d2);
            this.setPainter(this.painter);
            this.painter.setForm(string);
            this.painter.setName(string2);
        }

        protected abstract FieldPainter createPainter();

        public String getForm() {
            return this.painter.getForm();
        }

        public String getName() {
            return this.painter.getName();
        }

        public void setForm(String string) {
            this.painter.setForm(string);
        }

        public void setName(String string) {
            this.painter.setName(string);
        }

        public void setPainter(Painter painter) {
            super.setPainter(painter);
            this.painter = (FieldPainter)painter;
        }

        public String toString() {
            return String.valueOf(this.getID()) + " [" + Catalog.getString(this.getType()) + "]";
        }
    }

    public class ButtonElement
    extends FieldElement {
        ButtonPainter painter;

        public ButtonElement(String string, String string2, String string3) {
            this(string, string2, string3, 0.0, 0.0);
        }

        public ButtonElement(String string, String string2, String string3, double d, double d2) {
            super(string, string2, d, d2);
            this.painter.setText(string3);
        }

        public Object clone() throws CloneNotSupportedException {
            ButtonElement buttonElement = (ButtonElement)super.clone();
            buttonElement.setPainter(new ButtonPainter(buttonElement));
            buttonElement.setText(this.painter.getText());
            return buttonElement;
        }

        protected FieldPainter createPainter() {
            this.painter = new ButtonPainter(this);
            return this.painter;
        }

        public String getText() {
            return this.painter.getText();
        }

        public String getType() {
            return "Button";
        }

        public void setPainter(Painter painter) {
            super.setPainter(painter);
            this.painter = (ButtonPainter)painter;
        }

        public void setText(String string) {
            this.painter.setText(string);
        }
    }

    public class ImageButtonElement
    extends FieldElement {
        ImageButtonPainter painter;

        public ImageButtonElement(String string, String string2) {
            this(string, string2, 0.0, 0.0);
        }

        public ImageButtonElement(String string, String string2, double d, double d2) {
            super(string, string2, d, d2);
        }

        public Object clone() throws CloneNotSupportedException {
            ImageButtonElement imageButtonElement = (ImageButtonElement)super.clone();
            imageButtonElement.setPainter(new ImageButtonPainter(imageButtonElement));
            imageButtonElement.setResource(this.painter.getResource());
            return imageButtonElement;
        }

        protected FieldPainter createPainter() {
            this.painter = new ImageButtonPainter(this);
            return this.painter;
        }

        public String getResource() {
            return this.painter.getResource();
        }

        public String getType() {
            return "ImageButton";
        }

        public void setPainter(Painter painter) {
            super.setPainter(painter);
            this.painter = (ImageButtonPainter)painter;
        }

        public void setResource(String string) {
            this.painter.setResource(string);
        }
    }

    public class CheckBoxElement
    extends FieldElement {
        CheckBoxPainter painter;

        public CheckBoxElement(String string, String string2, String string3, boolean bl) {
            this(string, string2, string3, bl, 0.0, 0.0);
        }

        public CheckBoxElement(String string, String string2, String string3, boolean bl, double d, double d2) {
            super(string, string2, d, d2);
            this.painter.setText(string3);
            this.painter.setSelected(bl);
        }

        public Object clone() throws CloneNotSupportedException {
            CheckBoxElement checkBoxElement = (CheckBoxElement)super.clone();
            checkBoxElement.setPainter(new CheckBoxPainter(checkBoxElement));
            checkBoxElement.setText(this.painter.getText());
            checkBoxElement.setSelected(this.painter.isSelected());
            return checkBoxElement;
        }

        protected FieldPainter createPainter() {
            this.painter = new CheckBoxPainter(this);
            return this.painter;
        }

        public String getText() {
            return this.painter.getText();
        }

        public String getType() {
            return "CheckBox";
        }

        public boolean isSelected() {
            return this.painter.isSelected();
        }

        public void setPainter(Painter painter) {
            super.setPainter(painter);
            this.painter = (CheckBoxPainter)painter;
        }

        public void setSelected(boolean bl) {
            this.painter.setSelected(bl);
        }

        public void setText(String string) {
            this.painter.setText(string);
        }
    }

    public class RadioButtonElement
    extends CheckBoxElement {
        RadioButtonPainter rpainter;

        public RadioButtonElement(String string, String string2, String string3, boolean bl, String string4) {
            this(string, string2, string3, bl, string4, 0.0, 0.0);
        }

        public RadioButtonElement(String string, String string2, String string3, boolean bl, String string4, double d, double d2) {
            super(string, string2, string3, bl, d, d2);
            this.rpainter.setGroup(string4);
        }

        public Object clone() throws CloneNotSupportedException {
            RadioButtonElement radioButtonElement = (RadioButtonElement)super.clone();
            radioButtonElement.setPainter(new RadioButtonPainter(radioButtonElement));
            radioButtonElement.setText(this.painter.getText());
            radioButtonElement.setSelected(this.painter.isSelected());
            radioButtonElement.setGroup(this.rpainter.getGroup());
            return radioButtonElement;
        }

        protected FieldPainter createPainter() {
            this.rpainter = new RadioButtonPainter(this);
            this.painter = this.rpainter;
            return this.rpainter;
        }

        public String getGroup() {
            return this.rpainter.getGroup();
        }

        public String getType() {
            return "RadioButton";
        }

        public void setGroup(String string) {
            this.rpainter.setGroup(string);
        }

        public void setPainter(Painter painter) {
            super.setPainter(painter);
            if (painter instanceof RadioButtonPainter) {
                this.painter = (RadioButtonPainter)painter;
            }
        }
    }

    public class ChoiceElement
    extends FieldElement {
        ChoicePainter painter;

        public ChoiceElement(String string, String string2, Object object, Object[] objectArray) {
            this(string, string2, object, objectArray, 0.0, 0.0);
        }

        public ChoiceElement(String string, String string2, Object object, Object[] objectArray, double d, double d2) {
            super(string, string2, d, d2);
            this.painter.setSelectedItem(object);
            this.painter.setChoices(objectArray);
        }

        public Object clone() throws CloneNotSupportedException {
            ChoiceElement choiceElement = (ChoiceElement)super.clone();
            choiceElement.setPainter(new ChoicePainter(choiceElement));
            choiceElement.setSelectedItem(this.painter.getSelectedItem());
            choiceElement.setChoices(this.painter.getChoices());
            return choiceElement;
        }

        protected FieldPainter createPainter() {
            this.painter = new ChoicePainter(this);
            return this.painter;
        }

        public Object[] getChoices() {
            return this.painter.getChoices();
        }

        public Object getSelectedItem() {
            return this.painter.getSelectedItem();
        }

        public String getType() {
            return "Choice";
        }

        public void setChoices(Object[] objectArray) {
            this.painter.setChoices(objectArray);
        }

        public void setPainter(Painter painter) {
            super.setPainter(painter);
            this.painter = (ChoicePainter)painter;
        }

        public void setSelectedItem(Object object) {
            this.painter.setSelectedItem(object);
        }
    }

    public class TextFieldElement
    extends FieldElement {
        TextFieldPainter painter;

        public TextFieldElement(String string, String string2, String string3) {
            this(string, string2, string3, 0.0, 0.0);
        }

        public TextFieldElement(String string, String string2, String string3, double d, double d2) {
            super(string, string2, d, d2);
            this.painter.setText(string3);
        }

        public Object clone() throws CloneNotSupportedException {
            TextFieldElement textFieldElement = (TextFieldElement)super.clone();
            textFieldElement.setPainter(new TextFieldPainter(textFieldElement));
            textFieldElement.setText(this.painter.getText());
            return textFieldElement;
        }

        protected FieldPainter createPainter() {
            this.painter = new TextFieldPainter(this);
            return this.painter;
        }

        public int getCols() {
            return this.painter.getCols();
        }

        public String getText() {
            return this.painter.getText();
        }

        public String getType() {
            return "TextField";
        }

        public void setCols(int n) {
            this.painter.setCols(n);
        }

        public void setPainter(Painter painter) {
            super.setPainter(painter);
            this.painter = (TextFieldPainter)painter;
        }

        public void setText(String string) {
            this.painter.setText(string);
        }
    }

    public class TextAreaElement
    extends FieldElement {
        TextAreaPainter painter;

        public TextAreaElement(String string, String string2, String string3) {
            this(string, string2, string3, 0.0, 0.0);
        }

        public TextAreaElement(String string, String string2, String string3, double d, double d2) {
            super(string, string2, d, d2);
            this.painter.setText(string3);
        }

        public Object clone() throws CloneNotSupportedException {
            TextAreaElement textAreaElement = (TextAreaElement)super.clone();
            textAreaElement.setPainter(new TextAreaPainter(textAreaElement));
            textAreaElement.setText(this.painter.getText());
            return textAreaElement;
        }

        protected FieldPainter createPainter() {
            this.painter = new TextAreaPainter(this);
            return this.painter;
        }

        public int getCols() {
            return this.painter.getCols();
        }

        public int getRows() {
            return this.painter.getRows();
        }

        public String getText() {
            return this.painter.getText();
        }

        public String getType() {
            return "TextArea";
        }

        public void setCols(int n) {
            this.painter.setCols(n);
        }

        public void setPainter(Painter painter) {
            super.setPainter(painter);
            this.painter = (TextAreaPainter)painter;
        }

        public void setRows(int n) {
            this.painter.setRows(n);
        }

        public void setText(String string) {
            this.painter.setText(string);
        }
    }

    class HTextLens
    implements TextLens {
        private HeadingElement heading;

        public HTextLens(HeadingElement headingElement) {
            this.heading = headingElement;
        }

        public String getText() {
            Object v = StyleCore.this.headingMap.get(this.heading);
            return v == null ? "000" : v.toString();
        }
    }
}

