/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import inetsoft.report.Paintable;
import inetsoft.report.Painter;
import inetsoft.report.ReportElement;
import inetsoft.report.internal.DefaultContext;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class PainterPaintable
implements Paintable {
    float x;
    float y;
    int oY;
    int painterW;
    int painterH;
    int prefH;
    Dimension pd;
    transient ReportElement elem;
    Painter painter;

    public PainterPaintable(float f, float f2, int n, int n2, Dimension dimension, int n3, ReportElement reportElement, Painter painter, int n4) {
        this.x = Common.round(f);
        this.y = Common.round(f2);
        this.painterW = n;
        this.painterH = n2;
        this.prefH = n3;
        this.pd = dimension;
        this.elem = reportElement;
        this.painter = painter;
        this.oY = n4;
    }

    public Rectangle getBounds() {
        return new Rectangle((int)this.x, (int)this.y, this.painterW, this.painterH);
    }

    public ReportElement getElement() {
        return this.elem;
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void paint(Graphics graphics) {
        boolean bl;
        Shape shape = graphics.getClip();
        graphics.clipRect((int)this.x, (int)this.y, this.painterW, this.painterH);
        int n = this.pd.width;
        int n2 = this.pd.height * this.painterH / Math.max(1, this.prefH);
        boolean bl2 = bl = !this.painter.isScalable() && (n != this.painterW || n2 != this.painterH);
        if (bl) {
            Common.paint(graphics, this.x, this.y, this.painterW, this.painterH, this.painter, 0.0f, -this.oY, this.pd.width, this.pd.height, n2, this.elem.getForeground(), this.elem.getBackground());
        } else {
            graphics.setColor(this.elem.getBackground());
            graphics.fillRect((int)this.x, (int)this.y, n, n2);
            graphics.setColor(this.elem.getForeground());
            this.painter.paint(graphics, (int)this.x, (int)(this.y - (float)this.oY), this.pd.width, this.pd.height);
        }
        graphics.setClip(shape);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.elem = new DefaultContext();
        ((DefaultContext)this.elem).read(objectInputStream);
    }

    public void setLocation(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DefaultContext.write(objectOutputStream, this.elem);
    }
}

