/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import inetsoft.report.locale.Catalog;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class PagesMenu
extends Window {
    MenuListener menuListener = new MenuListener();
    protected ActionListener actionListener;
    Image page;
    Dimension isize;
    int borderW = 3;
    int buttonH = 22;
    Rectangle[][] pages;
    Rectangle button = new Rectangle();
    Point currPage = new Point(-1, -1);
    String label = Catalog.getString("Cancel");

    public PagesMenu(Frame frame) {
        this(frame, 2, 3);
    }

    public PagesMenu(Frame frame, int n, int n2) {
        this(frame, n, n2, "/inetsoft/report/images/page.gif");
    }

    public PagesMenu(Frame frame, int n, int n2, String string) {
        super(frame);
        this.pages = new Rectangle[n][n2];
        if (string != null) {
            try {
                this.page = Common.getImage(this, string);
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(this.page, 0);
                mediaTracker.waitForAll();
                this.isize = new Dimension(this.page.getWidth(null), this.page.getHeight(null));
                this.isize.width += 8;
                this.isize.height += 8;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.isize = new Dimension(30, 30);
        }
        this.addMouseListener(this.menuListener);
        this.addMouseMotionListener(this.menuListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    private void fire(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public int getCols() {
        return this.currPage.x + 1;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.pages[0].length * this.isize.width + (this.pages[0].length + 1) * this.borderW, this.pages.length * this.isize.height + (this.pages.length + 1) * this.borderW + this.buttonH);
    }

    public int getRows() {
        return this.currPage.y + 1;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Dimension dimension = this.getSize();
        Image image = this.createImage(dimension.width, dimension.height);
        Graphics graphics2 = image.getGraphics();
        graphics2.setColor(((Component)this).getBackground());
        graphics2.fill3DRect(0, 0, dimension.width, dimension.height, true);
        int n3 = 0;
        while (n3 < this.pages.length) {
            int n4 = this.borderW;
            n2 = this.borderW * (n3 + 1) + this.isize.height * n3;
            n = 0;
            while (n < this.pages[n3].length) {
                if (n3 <= this.currPage.y && n <= this.currPage.x) {
                    graphics2.setColor(new Color(0, 0, 128));
                    graphics2.fillRect(n4, n2, this.isize.width, this.isize.height);
                    graphics2.setColor(((Component)this).getBackground());
                }
                this.pages[n3][n] = new Rectangle(n4, n2, this.isize.width, this.isize.height);
                if (this.page != null) {
                    graphics2.drawImage(this.page, n4 + 4, n2 + 4, this);
                }
                graphics2.draw3DRect(n4, n2, this.isize.width, this.isize.height, false);
                n4 += this.isize.width + this.borderW;
                ++n;
            }
            ++n3;
        }
        this.button = new Rectangle(this.borderW, dimension.height - this.buttonH - this.borderW, dimension.width - 2 * this.borderW, dimension.height - (this.pages.length + 1) * this.borderW - this.pages.length * this.isize.height);
        graphics2.setColor(((Component)this).getBackground());
        graphics2.draw3DRect(this.button.x, this.button.y, this.button.width, this.button.height, false);
        this.label = this.currPage.x >= 0 && this.currPage.y >= 0 ? String.valueOf(this.currPage.y + 1) + "x" + (this.currPage.x + 1) : Catalog.getString("Cancel");
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n2 = (dimension.width - fontMetrics.stringWidth(this.label)) / 2;
        n = this.button.y + (this.button.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
        graphics2.setColor(this.getForeground());
        graphics2.drawString(this.label, n2, n);
        graphics2.setColor(((Component)this).getBackground());
        graphics2.draw3DRect(this.button.x, this.button.y, this.button.width, this.button.height, false);
        graphics2.dispose();
        graphics.drawImage(image, 0, 0, this);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void show(Component component) {
        Point point = component.getLocationOnScreen();
        point.y += component.getSize().height;
        this.pack();
        ((Component)this).setLocation(point);
        ((Component)this).setVisible(true);
        ((Component)this).setLocation(point);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    class MenuListener
    extends MouseAdapter
    implements MouseMotionListener {
        MenuListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (PagesMenu.this.button.contains(mouseEvent.getX(), mouseEvent.getY())) {
                PagesMenu.this.dispose();
            } else if (PagesMenu.this.currPage.x != -1 && PagesMenu.this.currPage.y != -1) {
                PagesMenu.this.fire(new ActionEvent(PagesMenu.this, 1, PagesMenu.this.label));
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = 0;
            while (n < PagesMenu.this.pages.length) {
                int n2 = 0;
                while (n2 < PagesMenu.this.pages[n].length) {
                    if (PagesMenu.this.pages[n][n2] != null && PagesMenu.this.pages[n][n2].contains(mouseEvent.getX(), mouseEvent.getY())) {
                        if (PagesMenu.this.currPage.x != n2 && PagesMenu.this.currPage.y != n) {
                            PagesMenu.this.currPage.x = n2;
                            PagesMenu.this.currPage.y = n;
                            PagesMenu.this.repaint();
                        }
                        return;
                    }
                    ++n2;
                }
                ++n;
            }
            if (PagesMenu.this.currPage.x != -1 || PagesMenu.this.currPage.y != -1) {
                PagesMenu.this.currPage.y = -1;
                PagesMenu.this.currPage.x = -1;
                PagesMenu.this.repaint();
            }
        }
    }
}

