/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import inetsoft.report.Margin;
import inetsoft.report.StyleSheet;
import inetsoft.report.internal.PixelConsumer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Vector;

public class PSGraphics
extends Graphics
implements Serializable,
Cloneable {
    private boolean closed = false;
    private Point center = new Point(0, 0);
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private Vector oblique = new Vector();
    protected int pageheight = 792;
    protected int pagewidth = 612;
    protected static final int RESOLUTION = 72;
    static final char[] hd = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final int charsPerRow = 72;
    protected PrintWriter writer = new PrintWriter(System.out);
    int orientation = 1;
    Color clr = Color.black;
    Color backClr = Color.white;
    Font font = new Font("Helvetica", 0, 10);
    boolean cloned = false;
    int savelevel = 0;
    Rectangle clippingRect = new Rectangle(0, 0, this.pagewidth, this.pageheight);
    private boolean disposed = false;
    private boolean inited = false;
    private Hashtable fontset = new Hashtable();
    private static Hashtable fontmap = new Hashtable();

    public PSGraphics() {
        fontmap.put("dialog", "Helvetica");
        fontmap.put("dialoginput", "Courier");
        fontmap.put("serif", "Times");
        fontmap.put("sansserif", "Helvetica");
        fontmap.put("monospaced", "Courier");
        fontmap.put("timesroman", "Times");
        fontmap.put("courier", "Courier");
        fontmap.put("helvetica", "Helvetica");
        this.oblique.addElement("Courier");
        this.oblique.addElement("Helvetica");
        this.oblique.addElement("Courier");
    }

    public PSGraphics(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    public PSGraphics(OutputStream outputStream) {
        fontmap.put("dialog", "Helvetica");
        fontmap.put("dialoginput", "Courier");
        fontmap.put("serif", "Times");
        fontmap.put("sansserif", "Helvetica");
        fontmap.put("monospaced", "Courier");
        fontmap.put("timesroman", "Times");
        fontmap.put("courier", "Courier");
        fontmap.put("helvetica", "Helvetica");
        this.oblique.addElement("Courier");
        this.oblique.addElement("Helvetica");
        this.oblique.addElement("Courier");
        this.setOutput(outputStream);
    }

    public PSGraphics(String string) throws IOException {
        this(Runtime.getRuntime().exec(string).getOutputStream());
    }

    public void clearRect(double d, double d2, double d3, double d4) {
        this.debug(this.writer, "%clearRect");
        this.gsave();
        Color color = this.getColor();
        this.setColor(this.backClr);
        this.doRect(d, d2, d3, d4, true);
        this.setColor(color);
        this.grestore();
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.clearRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void clipRect(double d, double d2, double d3, double d4) {
        this.debug(this.writer, "%clipRect");
        this.clippingRect = this.clippingRect.intersection(new Rectangle((int)d + this.center.x, (int)d2 + this.center.y, (int)d3, (int)d4));
        d2 = this.transformY(d2);
        d = this.transformX(d);
        this.writer.println(String.valueOf(d) + " " + d2 + " moveto");
        this.writer.println(String.valueOf(d + d3) + " " + d2 + " lineto");
        this.writer.println(String.valueOf(d + d3) + " " + (d2 - d4) + " lineto");
        this.writer.println(String.valueOf(d) + " " + (d2 - d4) + " lineto");
        this.writer.println("closepath eoclip newpath");
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clipRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void close() {
        if (!this.closed) {
            this.writer.println("%%EOF");
            this.writer.close();
            this.closed = true;
        }
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new RuntimeException("copyArea not supported");
    }

    public Graphics create() {
        try {
            this.debug(this.writer, "%create");
            PSGraphics pSGraphics = (PSGraphics)this.clone();
            pSGraphics.center = new Point(this.center);
            pSGraphics.savelevel = 0;
            pSGraphics.cloned = true;
            pSGraphics.gsave();
            pSGraphics.gsave();
            return pSGraphics;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    void debug(PrintWriter printWriter, String string) {
        this.writer.println(string);
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.cloned) {
            while (this.savelevel > 0) {
                this.debug(this.writer, "%dispose");
                this.grestore();
            }
        } else {
            this.debug(this.writer, "%dispose");
            this.writer.println("showpage");
            this.writer.flush();
            this.startPage();
        }
    }

    private void doArc(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        this.debug(this.writer, "%doArc");
        d2 = this.transformY(d2);
        d = this.transformX(d);
        this.gsave();
        double d7 = d + d3 / 2.0;
        double d8 = d2 - d4 / 2.0;
        this.writer.print(d7);
        this.writer.print(" ");
        this.writer.print(d8);
        this.writer.println(" translate");
        double d9 = d4 / d3;
        this.writer.print(1.0);
        this.writer.print(" ");
        this.writer.print(d9);
        this.writer.println(" scale");
        if (bl) {
            this.writer.println("0 0 moveto");
        } else if (d5 == 0.0 && d6 == 360.0) {
            this.writer.println(String.valueOf(d3 / 2.0) + " 0 moveto");
        }
        double d10 = d5 + d6;
        this.writer.print("0 0 ");
        this.writer.print(d3 / 2.0);
        this.writer.print(" ");
        this.writer.print(d5);
        this.writer.print(" ");
        this.writer.print(d10);
        this.writer.println(" arc");
        if (bl) {
            this.writer.println("closepath eofill");
        } else {
            this.writer.println("stroke");
        }
        this.grestore();
    }

    boolean doImage(PixelConsumer pixelConsumer, int n, int n2, int n3, int n4, ImageObserver imageObserver, Color color) {
        this.debug(this.writer, "%doImage");
        pixelConsumer.produce();
        n2 = (int)this.transformY(n2);
        n = (int)this.transformX(n);
        this.gsave();
        this.debug(this.writer, "% build a temporary dictionary");
        this.writer.println("20 dict begin");
        this.emitColorImageProlog(pixelConsumer.width);
        this.debug(this.writer, "% lower left corner");
        this.writer.print(n);
        this.writer.print(" ");
        this.writer.print(n2);
        this.writer.println(" translate");
        if (n4 == 0 || n3 == 0) {
            n4 = pixelConsumer.height;
            n3 = pixelConsumer.width;
        }
        this.debug(this.writer, "% size of image");
        this.writer.print(n3);
        this.writer.print(" ");
        this.writer.print(n4);
        this.writer.println(" scale");
        this.writer.print(pixelConsumer.width);
        this.writer.print(" ");
        this.writer.print(pixelConsumer.height);
        this.writer.println(" 8");
        this.writer.print("[");
        this.writer.print(pixelConsumer.width);
        this.writer.print(" 0 0 -");
        this.writer.print(pixelConsumer.height);
        this.writer.print(" 0 ");
        this.writer.print(0);
        this.writer.println("]");
        this.writer.println("{currentfile pix readhexstring pop}");
        this.writer.println("false 3 colorimage");
        this.writer.println("");
        int n5 = 0;
        char[] cArray = new char[73];
        int n6 = 0;
        while (n6 < pixelConsumer.height) {
            int n7 = 0;
            ++n5;
            int n8 = 0;
            while (n8 < pixelConsumer.width) {
                int n9 = pixelConsumer.pix[n8][n6];
                if ((n9 & 0xFF000000) == 0) {
                    n9 = color == null ? 0xFFFFFF : color.getRGB();
                }
                cArray[n7++] = hd[(n9 & 0xF00000) >> 20];
                cArray[n7++] = hd[(n9 & 0xF0000) >> 16];
                cArray[n7++] = hd[(n9 & 0xF000) >> 12];
                cArray[n7++] = hd[(n9 & 0xF00) >> 8];
                cArray[n7++] = hd[(n9 & 0xF0) >> 4];
                cArray[n7++] = hd[n9 & 0xF];
                if (n7 >= 72) {
                    String string = String.copyValueOf(cArray, 0, n7);
                    this.writer.println(string);
                    if (n5 > 5) {
                        try {
                            Thread.sleep(15L);
                        }
                        catch (InterruptedException interruptedException) {}
                        n5 = 0;
                    }
                    n7 = 0;
                }
                ++n8;
            }
            if (n7 != 0) {
                String string = String.copyValueOf(cArray, 0, n7);
                this.writer.println(string);
            }
            ++n6;
        }
        this.writer.println("");
        this.writer.println("end");
        this.grestore();
        return true;
    }

    public boolean doImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver, Color color) {
        PixelConsumer pixelConsumer = new PixelConsumer(image, n5, n6, n7, n8);
        return this.doImage(pixelConsumer, n, n2, n3, n4, imageObserver, color);
    }

    public boolean doImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver, Color color) {
        PixelConsumer pixelConsumer = new PixelConsumer(image);
        return this.doImage(pixelConsumer, n, n2, n3, n4, imageObserver, color);
    }

    private void doPoly(int[] nArray, int[] nArray2, int n, boolean bl) {
        if (n < 2) {
            return;
        }
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray3[n2] = (int)this.transformY(nArray2[n2]);
            nArray4[n2] = (int)this.transformX(nArray[n2]);
            ++n2;
        }
        this.writer.println(String.valueOf(nArray4[0]) + " " + nArray3[0] + " moveto");
        n2 = 0;
        while (n2 < n) {
            this.writer.println(String.valueOf(nArray4[n2]) + " " + nArray3[n2] + " lineto");
            ++n2;
        }
        this.writer.println(String.valueOf(nArray4[0]) + " " + nArray3[0] + " lineto");
        if (bl) {
            this.writer.println("eofill");
        } else {
            this.writer.println("stroke");
        }
    }

    void doRect(double d, double d2, double d3, double d4, boolean bl) {
        this.debug(this.writer, "%doRect");
        d2 = this.transformY(d2);
        d = this.transformX(d);
        this.writer.print(d);
        this.writer.print(" ");
        this.writer.print(d2);
        this.writer.println(" moveto ");
        this.writer.print(d + d3);
        this.writer.print(" ");
        this.writer.print(d2);
        this.writer.println(" lineto ");
        this.writer.print(d + d3);
        this.writer.print(" ");
        this.writer.print(d2 - d4);
        this.writer.println(" lineto ");
        this.writer.print(d);
        this.writer.print(" ");
        this.writer.print(d2 - d4);
        this.writer.println(" lineto ");
        this.writer.print(d);
        this.writer.print(" ");
        this.writer.print(d2);
        this.writer.println(" lineto ");
        if (bl) {
            this.writer.println("eofill");
        } else {
            this.writer.println("stroke");
        }
    }

    private void doRoundRect(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        this.debug(this.writer, "%doRoundRect");
        d2 = this.transformY(d2);
        d = this.transformX(d);
        this.writer.print(d + d6);
        this.writer.print(" ");
        this.writer.print(d2);
        this.writer.println(" moveto");
        this.writer.print(d + d3);
        this.writer.print(" ");
        this.writer.print(d2);
        this.writer.print(" ");
        this.writer.print(d + d3);
        this.writer.print(" ");
        this.writer.print(d2 - d4);
        this.writer.print(" ");
        this.writer.print(d6);
        this.writer.println(" arcto");
        this.writer.println("4 {pop} repeat");
        this.writer.print(d + d3);
        this.writer.print(" ");
        this.writer.print(d2 - d4);
        this.writer.print(" ");
        this.writer.print(d);
        this.writer.print(" ");
        this.writer.print(d2 - d4);
        this.writer.print(" ");
        this.writer.print(d6);
        this.writer.println(" arcto");
        this.writer.println("4 {pop} repeat");
        this.writer.print(d);
        this.writer.print(" ");
        this.writer.print(d2 - d4);
        this.writer.print(" ");
        this.writer.print(d);
        this.writer.print(" ");
        this.writer.print(d2);
        this.writer.print(" ");
        this.writer.print(d6);
        this.writer.println(" arcto");
        this.writer.println("4 {pop} repeat");
        this.writer.print(d);
        this.writer.print(" ");
        this.writer.print(d2);
        this.writer.print(" ");
        this.writer.print(d + d3);
        this.writer.print(" ");
        this.writer.print(d2);
        this.writer.print(" ");
        this.writer.print(d6);
        this.writer.println(" arcto");
        this.writer.println("4 {pop} repeat");
        if (bl) {
            this.writer.println("eofill");
        } else {
            this.writer.println("stroke");
        }
    }

    public void draw3DRect(double d, double d2, double d3, double d4, boolean bl) {
        this.debug(this.writer, "%draw3DRect");
        d2 = this.transformY(d2);
        d = this.transformX(d);
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        this.setColor(bl ? color2 : color3);
        this.drawLine(d, d2, d, d2 - d4);
        this.drawLine(d + 1.0, d2, d + d3 - 1.0, d2);
        this.setColor(bl ? color3 : color2);
        this.drawLine(d + 1.0, d2 - d4, d + d3, d2 - d4);
        this.drawLine(d + d3, d2, d + d3, d2 - d4);
        this.setColor(color);
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.draw3DRect((double)n, (double)n2, (double)n3, (double)n4, bl);
    }

    public void drawArc(double d, double d2, double d3, double d4, double d5, double d6) {
        this.debug(this.writer, "%drawArc");
        this.doArc(d, d2, d3, d4, d5, d6, false);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawArc((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.debug(this.writer, "%drawBytes");
        this.drawString(new String(byArray, n, n2), n3, n4);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.debug(this.writer, "%drawChars");
        this.drawString(new String(cArray, n, n2), n3, n4);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        this.debug(this.writer, "%drawImage-6");
        return this.doImage(image, n, n2, n3 - n + 1, n4 - n2 + 1, n5, n6, n7, n8, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        this.debug(this.writer, "%drawImage-5");
        return this.doImage(image, n, n2, n3 - n + 1, n4 - n2 + 1, n5, n6, n7, n8, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.debug(this.writer, "%drawImage-4");
        return this.doImage(image, n, n2, n3, n4, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.debug(this.writer, "%drawImage-2");
        return this.doImage(image, n, n2, n3, n4, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        this.debug(this.writer, "%drawImage-3");
        return this.doImage(image, n, n2, 0, 0, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.debug(this.writer, "%drawImage-1");
        return this.doImage(image, n, n2, 0, 0, imageObserver, null);
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        this.debug(this.writer, "%drawLine");
        d2 = this.transformY(d2);
        d4 = this.transformY(d4);
        d = this.transformX(d);
        d3 = this.transformX(d3);
        this.writer.print(d);
        this.writer.print(" ");
        this.writer.print(d2);
        this.writer.print(" moveto ");
        this.writer.print(d3);
        this.writer.print(" ");
        this.writer.print(d4);
        this.writer.println(" lineto stroke");
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.drawLine((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void drawOval(double d, double d2, double d3, double d4) {
        this.debug(this.writer, "%drawOval");
        this.doArc(d, d2, d3, d4, 0.0, 360.0, false);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.drawOval((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void drawPolygon(Polygon polygon) {
        this.debug(this.writer, "%drawPoly");
        this.doPoly(polygon.xpoints, polygon.ypoints, polygon.npoints, false);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.debug(this.writer, "%drawPoly");
        this.doPoly(nArray, nArray2, n, false);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        int n2 = 1;
        while (n2 < n) {
            this.drawLine(nArray[n2 - 1], nArray2[n2 - 1], nArray[n2], nArray2[n2]);
            ++n2;
        }
    }

    public void drawRect(double d, double d2, double d3, double d4) {
        this.debug(this.writer, "%drawRect");
        this.doRect(d, d2, d3, d4, false);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.drawRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void drawRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
        this.debug(this.writer, "%drawRoundRect");
        this.doRoundRect(d, d2, d3, d4, d5, d6, false);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawRoundRect((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    public void drawString(String string, double d, double d2) {
        this.debug(this.writer, "%drawString");
        d2 = this.transformY(d2);
        d = this.transformX(d);
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < string.length()) {
            if (string.charAt(n3) == ' ') {
                ++n;
            }
            ++n3;
        }
        String string2 = PSGraphics.escapeString(string);
        this.writer.print(String.valueOf(Common.stringWidth(string, this.getFont())) + " ");
        this.writer.println("(" + string2 + ") dup 3 1 roll ");
        this.writer.print("stringwidth pop " + (n *= n2) + " sub ");
        this.writer.println("sub " + string.length() + " div");
        this.writer.print(String.valueOf(d) + " " + d2 + " moveto ");
        this.writer.println("-" + n2 + " 0 32 4 -1 roll 0 6 -1 roll awidthshow");
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (double)n, (double)n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }

    public void emit(String string) {
        this.writer.println(string);
    }

    void emitColorImageProlog(int n) {
        this.debug(this.writer, "% Color picture stuff, lifted from XV's PS files");
        this.debug(this.writer, "% define string to hold a scanline's worth of data");
        this.writer.print("/pix ");
        this.writer.print(n * 3);
        this.writer.println(" string def");
        this.debug(this.writer, "% define space for color conversions");
        this.writer.print("/grays ");
        this.writer.print(n);
        this.writer.println(" string def  % space for gray scale line");
        this.writer.println("/npixls 0 def");
        this.writer.println("/rgbindx 0 def");
        this.debug(this.writer, "% define 'colorimage' if it isn't defined");
        this.debug(this.writer, "%   ('colortogray' and 'mergeprocs' come from xwd2ps");
        this.debug(this.writer, "%     via xgrab)");
        this.writer.println("/colorimage where   % do we know about 'colorimage'?");
        this.writer.println("{ pop }           % yes: pop off the 'dict' returned");
        this.writer.println("{                 % no:  define one");
        this.writer.println("/colortogray {  % define an RGB->I function");
        this.writer.println("/rgbdata exch store    % call input 'rgbdata'");
        this.writer.println("rgbdata length 3 idiv");
        this.writer.println("/npixls exch store");
        this.writer.println("/rgbindx 0 store");
        this.writer.println("0 1 npixls 1 sub {");
        this.writer.println("grays exch");
        this.writer.println("rgbdata rgbindx       get 20 mul    % Red");
        this.writer.println("rgbdata rgbindx 1 add get 32 mul    % Green");
        this.writer.println("rgbdata rgbindx 2 add get 12 mul    % Blue");
        this.writer.println("add add 64 idiv      % I = .5G + .31R + .18B");
        this.writer.println("put");
        this.writer.println("/rgbindx rgbindx 3 add store");
        this.writer.println("} for");
        this.writer.println("grays 0 npixls getinterval");
        this.writer.println("} bind def");
        this.writer.println("");
        this.debug(this.writer, "% Utility procedure for colorimage operator.");
        this.debug(this.writer, "% This procedure takes two procedures off the");
        this.debug(this.writer, "% stack and merges them into a single procedure.");
        this.writer.println("");
        this.writer.println("/mergeprocs { % def");
        this.writer.println("dup length");
        this.writer.println("3 -1 roll");
        this.writer.println("dup");
        this.writer.println("length");
        this.writer.println("dup");
        this.writer.println("5 1 roll");
        this.writer.println("3 -1 roll");
        this.writer.println("add");
        this.writer.println("array cvx");
        this.writer.println("dup");
        this.writer.println("3 -1 roll");
        this.writer.println("0 exch");
        this.writer.println("putinterval");
        this.writer.println("dup");
        this.writer.println("4 2 roll");
        this.writer.println("putinterval");
        this.writer.println("} bind def");
        this.writer.println("");
        this.writer.println("/colorimage { % def");
        this.writer.println("pop pop     % remove 'false 3' operands");
        this.writer.println("{colortogray} mergeprocs");
        this.writer.println("image");
        this.writer.println("} bind def");
        this.writer.println("} ifelse          % end of 'false' case");
    }

    public static String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '(': {
                    stringBuffer.append("\\(");
                    break;
                }
                case ')': {
                    stringBuffer.append("\\)");
                    break;
                }
                default: {
                    if (string.charAt(n) > '\u007f') {
                        stringBuffer.append("\\" + Integer.toString(string.charAt(n), 8));
                        break;
                    }
                    stringBuffer.append(string.charAt(n));
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void fill3DRect(double d, double d2, double d3, double d4, boolean bl) {
        this.debug(this.writer, "%fill3DRect");
        d2 = this.transformY(d2);
        d = this.transformX(d);
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        if (!bl) {
            this.setColor(color3);
        }
        this.fillRect(d + 1.0, d2 + 1.0, d3 - 2.0, d4 - 2.0);
        this.setColor(bl ? color2 : color3);
        this.drawLine(d, d2, d, d2 - d4 - 1.0);
        this.drawLine(d + 1.0, d2, d + d3 - 2.0, d2);
        this.setColor(bl ? color3 : color2);
        this.drawLine(d + 1.0, d2 - d4 - 1.0, d + d3 - 1.0, d2 - d4 - 1.0);
        this.drawLine(d + d3 - 1.0, d2, d + d3 - 1.0, d2 - d4 - 1.0);
        this.setColor(color);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.fill3DRect((double)n, (double)n2, (double)n3, (double)n4, bl);
    }

    public void fillArc(double d, double d2, double d3, double d4, double d5, double d6) {
        this.debug(this.writer, "%fillArc");
        this.doArc(d, d2, d3, d4, d5, d6, true);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillArc((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    public void fillOval(double d, double d2, double d3, double d4) {
        this.debug(this.writer, "%fillOval");
        this.doArc(d, d2, d3, d4, 0.0, 360.0, true);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fillOval((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void fillPolygon(Polygon polygon) {
        this.debug(this.writer, "%fillPoly");
        this.doPoly(polygon.xpoints, polygon.ypoints, polygon.npoints, true);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.debug(this.writer, "%fillPoly");
        this.doPoly(nArray, nArray2, n, true);
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        this.debug(this.writer, "%fillRect");
        this.doRect(d, d2, d3, d4, true);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.fillRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void fillRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
        this.debug(this.writer, "%fillRoundRect");
        this.doRoundRect(d, d2, d3, d4, d5, d6, true);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillRoundRect((double)n, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6);
    }

    public void finalize() {
        this.dispose();
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public Rectangle getClipBounds() {
        return new Rectangle(this.clippingRect.x - this.center.x, this.clippingRect.y - this.center.y, this.clippingRect.width, this.clippingRect.height);
    }

    public Color getColor() {
        return this.clr;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.toolkit.getFontMetrics(font);
    }

    public String getFontName(Font font) {
        int n;
        String string = Common.getPSName(font);
        String string2 = (String)fontmap.get(string.toLowerCase());
        if (string2 == null && (n = string.indexOf(46)) > 0) {
            string2 = (String)fontmap.get(string.substring(0, n).toLowerCase());
        }
        return string2 == null ? string : string2;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Dimension getPageDimension() {
        return new Dimension(this.pagewidth, this.pageheight);
    }

    public void grestore() {
        this.writer.println("grestore");
        --this.savelevel;
    }

    public void gsave() {
        this.writer.println("gsave");
        ++this.savelevel;
    }

    public void putFontName(String string, String string2) {
        fontmap.put(string, string2);
    }

    public void reset() {
        this.fontset.clear();
        this.disposed = false;
    }

    public double rtransformX(double d) {
        return d - (double)this.center.x;
    }

    public double rtransformY(double d) {
        return -(d + (double)this.center.y);
    }

    public void setBackground(Color color) {
        this.backClr = color;
    }

    public void setClip(double d, double d2, double d3, double d4) {
        this.debug(this.writer, "%setClip");
        this.clippingRect = new Rectangle((int)d + this.center.x, (int)d2 + this.center.y, (int)d3, (int)d4);
        d2 = this.transformY(d2);
        d = this.transformX(d);
        this.writer.println("initclip");
        this.writer.println(String.valueOf(d) + " " + d2 + " moveto");
        this.writer.println(String.valueOf(d + d3) + " " + d2 + " lineto");
        this.writer.println(String.valueOf(d + d3) + " " + (d2 - d4) + " lineto");
        this.writer.println(String.valueOf(d) + " " + (d2 - d4) + " lineto");
        this.writer.println("closepath eoclip newpath");
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void setClip(Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setColor(Color color) {
        this.debug(this.writer, "%setColor");
        this.clr = color != null ? color : this.backClr;
        this.writer.print((double)this.clr.getRed() / 255.0);
        this.writer.print(" ");
        this.writer.print((double)this.clr.getGreen() / 255.0);
        this.writer.print(" ");
        this.writer.print((double)this.clr.getBlue() / 255.0);
        this.writer.println(" setrgbcolor");
    }

    public void setFont(Font font) {
        this.debug(this.writer, "%setFont");
        if (font != null) {
            this.font = font;
            int n = this.font.getStyle();
            String string = this.getFontName(this.font);
            if ((n & 1) != 0 && (n & 2) != 0) {
                string = String.valueOf(string) + (this.oblique.contains(string) ? "-BoldOblique" : "-BoldItalic");
            } else if ((n & 1) != 0) {
                string = String.valueOf(string) + "-Bold";
            } else if ((n & 2) != 0) {
                string = String.valueOf(string) + (this.oblique.contains(string) ? "-Oblique" : "-Italic");
            } else if (string.equals("Times")) {
                string = String.valueOf(string) + "-Roman";
            }
            if (this.fontset.get(string) == null) {
                this.writer.println("/(" + string + ") findfont");
                this.writer.println("dup length dict begin");
                this.writer.println("{1 index /FID ne {def} {pop pop} ifelse} forall");
                this.writer.println("/Encoding ISOLatin1Encoding def");
                this.writer.println("currentdict");
                this.writer.println("end");
                this.writer.println("/" + string.replace(' ', '-') + "-ISOLatin1 exch definefont pop");
                this.fontset.put(string, string);
            }
            this.writer.println("/" + string.replace(' ', '-') + "-ISOLatin1 findfont");
            this.writer.print(this.font.getSize());
            this.writer.println(" scalefont setfont");
        }
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public void setOutput(OutputStream outputStream) {
        this.writer = new PrintWriter(outputStream);
    }

    public void setPageSize(double d, double d2) {
        this.pagewidth = (int)(72.0 * d);
        this.pageheight = (int)(72.0 * d2);
        this.clippingRect = new Rectangle(0, 0, this.pagewidth, this.pageheight);
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
        System.err.println("Not supported");
    }

    public void startDoc() {
        if (!this.inited) {
            this.writer.println("%!PS-Adobe-2.0 Created by PSGraphics Java Context");
            if (this.orientation == 0) {
                this.writer.println("2 dict dup /PageSize[ " + this.pageheight + " " + this.pagewidth + " ] put dup /ImagingBBox null put setpagedevice");
            } else {
                this.writer.println("2 dict dup /PageSize[ " + this.pagewidth + " " + this.pageheight + " ] put dup /ImagingBBox null put setpagedevice");
            }
            this.startPage();
            this.inited = true;
        }
    }

    public void startPage() {
        Margin margin = StyleSheet.getPrinterMargin();
        if (this.orientation == 1) {
            this.writer.println(String.valueOf(margin.left * 72.0) + " " + ((double)this.pageheight - margin.top * 72.0) + " translate");
        } else if (this.orientation == 0) {
            this.writer.println(String.valueOf((double)this.pageheight - margin.top * 72.0) + " " + ((double)this.pagewidth - margin.left * 72.0) + " translate");
            this.writer.println("-90 rotate");
        }
        this.setFont(this.font);
        this.gsave();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[font=" + this.getFont() + ",color=" + this.getColor() + "]";
    }

    public double transformX(double d) {
        return d + (double)this.center.x;
    }

    public double transformY(double d) {
        return -(d + (double)this.center.y);
    }

    public void translate(int n, int n2) {
        this.debug(this.writer, "%translate");
        this.center.x += n;
        this.center.y += n2;
    }
}

