/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import inetsoft.report.ReportElement;
import inetsoft.report.internal.Encoder;
import inetsoft.report.internal.FieldPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ImageButtonPainter
extends FieldPainter {
    private transient Image icon = null;
    private String resource;

    public ImageButtonPainter(ReportElement reportElement) {
        super(reportElement);
    }

    public Image getIcon() {
        if (this.icon == null) {
            if (this.resource != null && this.resource.length() > 0) {
                this.icon = Common.getImage(this, this.resource);
                this.waitImage(this.icon);
            } else {
                this.icon = Common.createImage(40, 18);
                Graphics graphics = this.icon.getGraphics();
                graphics.setColor(Color.lightGray);
                graphics.fillRect(0, 0, 40, 18);
                graphics.draw3DRect(0, 0, 39, 17, true);
            }
        }
        return this.icon;
    }

    public Dimension getPreferredSize() {
        Image image = this.getIcon();
        return new Dimension(image.getWidth(null), image.getHeight(null));
    }

    public String getResource() {
        return this.resource;
    }

    public Object getValue() {
        return this.getResource();
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        Image image = this.getIcon();
        graphics.drawImage(image, n += (n3 - image.getWidth(null)) / 2, n2 += (n4 - image.getHeight(null)) / 2, null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        if (byArray != null) {
            int n = objectInputStream.readInt();
            int n2 = objectInputStream.readInt();
            this.icon = Encoder.decodeImage(n, n2, byArray);
        }
    }

    public void setResource(String string) {
        this.resource = string;
        this.icon = null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.resource != null) {
            this.getIcon();
        }
        byte[] byArray = this.icon != null ? Encoder.encodeImage(this.icon) : null;
        objectOutputStream.writeObject(byArray);
        if (byArray != null) {
            objectOutputStream.writeInt(this.icon.getWidth(null));
            objectOutputStream.writeInt(this.icon.getHeight(null));
        }
    }
}

