/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import inetsoft.report.ReportElement;
import inetsoft.report.Size;
import inetsoft.report.internal.FieldPainter;
import inetsoft.report.internal.StyleCore;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class ChoicePainter
extends FieldPainter {
    private transient Image icon = null;
    private transient String longest = null;
    private Object selected;
    private Object[] choices;
    static final String icon_url = "/inetsoft/report/images/choice_arrow.gif";

    public ChoicePainter(ReportElement reportElement) {
        super(reportElement);
    }

    public Object[] getChoices() {
        return this.choices;
    }

    protected Image getIcon() {
        if (this.icon == null) {
            this.icon = Common.getImage(this, icon_url);
            this.waitImage(this.icon);
        }
        return this.icon;
    }

    public Dimension getPreferredSize() {
        if (this.longest == null) {
            this.longest = "";
            int n = 0;
            while (n < this.choices.length) {
                if (this.choices[n].toString().length() > this.longest.length()) {
                    this.longest = this.choices[n].toString();
                }
                ++n;
            }
        }
        Size size = StyleCore.getTextSize(this.longest, this.elem.getFont(), 0.0f);
        return new Dimension((int)(size.width + 20.0f), Math.max((int)(size.height + 2.0f), 16));
    }

    public Object getSelectedItem() {
        return this.selected;
    }

    public Object getValue() {
        return this.getSelectedItem();
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(this.elem.getForeground());
        graphics.setFont(this.elem.getFont());
        FontMetrics fontMetrics = Common.getFontMetrics(graphics.getFont());
        float f = Common.getHeight(graphics.getFont(), fontMetrics);
        graphics.drawImage(this.getIcon(), n + n3 - 16, n2 + (n4 - 16) / 2, null);
        Common.drawString(graphics, this.selected == null ? "" : this.selected.toString(), n + 1, (float)n2 + ((float)n4 - f) / 2.0f + (float)fontMetrics.getAscent());
        graphics.setColor(Color.gray);
        graphics.draw3DRect(n, n2, n3 - 1, n4 - 1, false);
    }

    public void setChoices(Object[] objectArray) {
        this.choices = objectArray;
        this.longest = null;
    }

    public void setSelectedItem(Object object) {
        this.selected = object;
    }
}

