/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import inetsoft.report.ReportElement;
import inetsoft.report.Size;
import inetsoft.report.internal.FieldPainter;
import inetsoft.report.internal.StyleCore;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class CheckBoxPainter
extends FieldPainter {
    private transient Image true_icon = null;
    private transient Image false_icon = null;
    private String text;
    private boolean selected = false;
    static final String true_cb = "/inetsoft/report/images/checkbox_true.gif";
    static final String false_cb = "/inetsoft/report/images/checkbox_false.gif";

    public CheckBoxPainter(ReportElement reportElement) {
        super(reportElement);
    }

    protected Image getIcon() {
        return this.getIcon(true_cb, false_cb);
    }

    protected Image getIcon(String string, String string2) {
        if (this.selected && this.true_icon == null) {
            this.true_icon = Common.getImage(this, string);
            this.waitImage(this.true_icon);
        }
        if (!this.selected && this.false_icon == null) {
            this.false_icon = Common.getImage(this, string2);
            this.waitImage(this.false_icon);
        }
        return this.selected ? this.true_icon : this.false_icon;
    }

    public Dimension getPreferredSize() {
        Size size = StyleCore.getTextSize(this.text, this.elem.getFont(), 0.0f);
        return new Dimension((int)(size.width + 20.0f), Math.max((int)(size.height + 2.0f), 14));
    }

    public String getText() {
        return this.text;
    }

    public Object getValue() {
        return this.isSelected() ? this.getName() : null;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(this.elem.getForeground());
        graphics.setFont(this.elem.getFont());
        FontMetrics fontMetrics = Common.getFontMetrics(graphics.getFont());
        float f = Common.getHeight(graphics.getFont(), fontMetrics);
        graphics.drawImage(this.getIcon(), n + 1, n2 + (n4 - 14) / 2, null);
        Common.drawString(graphics, this.text, n + 20, (float)n2 + ((float)n4 - f) / 2.0f + (float)fontMetrics.getAscent());
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void setText(String string) {
        this.text = string;
    }
}

