/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.internal;

import inetsoft.report.Common;
import inetsoft.report.ReportElement;
import inetsoft.report.Size;
import inetsoft.report.internal.FieldPainter;
import inetsoft.report.internal.StyleCore;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class ButtonPainter
extends FieldPainter {
    private String text;

    public ButtonPainter(ReportElement reportElement) {
        super(reportElement);
    }

    public Dimension getPreferredSize() {
        Size size = StyleCore.getTextSize(this.text, this.elem.getFont(), 0.0f);
        return new Dimension((int)(size.width + 10.0f), (int)(size.height + 4.0f));
    }

    public String getText() {
        return this.text;
    }

    public Object getValue() {
        return this.getText();
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.lightGray);
        graphics.fillRect(n, n2, n3 - 1, n4 - 1);
        graphics.setColor(Color.gray);
        graphics.draw3DRect(n, n2, n3 - 1, n4 - 1, true);
        graphics.setColor(this.elem.getForeground());
        graphics.setFont(this.elem.getFont());
        FontMetrics fontMetrics = Common.getFontMetrics(graphics.getFont());
        float f = Common.getHeight(graphics.getFont(), fontMetrics);
        float f2 = Common.stringWidth(this.text, graphics.getFont(), fontMetrics);
        Common.drawString(graphics, this.text, (float)n + ((float)n3 - f2) / 2.0f, (float)n2 + ((float)n4 - f) / 2.0f + (float)fontMetrics.getAscent());
    }

    public void setText(String string) {
        this.text = string;
    }
}

