/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.filter;

import inetsoft.report.Comparer;
import inetsoft.report.TableFilter;
import inetsoft.report.filter.DefaultComparer;
import inetsoft.report.filter.GroupedTable;
import inetsoft.report.internal.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.Serializable;
import java.util.Vector;

public class TopNFilter
implements TableFilter,
GroupedTable,
Cloneable {
    public static final int ALL = -1;
    GroupedTable table;
    int[] rowmap;
    int[] sums;
    int N;
    boolean asc = false;
    Comparer[] comparers;

    public TopNFilter(GroupedTable groupedTable, int n, int n2) {
        this(groupedTable, n, new int[]{n2}, true);
    }

    public TopNFilter(GroupedTable groupedTable, int n, int[] nArray, boolean bl) {
        this.table = groupedTable;
        this.N = n;
        this.asc = bl ^ true;
        this.sums = nArray;
        this.comparers = new Comparer[groupedTable.getColCount()];
        DefaultComparer defaultComparer = new DefaultComparer();
        int n2 = 0;
        while (n2 < nArray.length) {
            this.comparers[nArray[n2]] = defaultComparer;
            ++n2;
        }
    }

    private void checkInit() {
        if (this.rowmap == null) {
            this.refresh();
        }
    }

    public int getAlignment(int n, int n2) {
        this.checkInit();
        return this.table.getAlignment(this.rowmap[n], n2);
    }

    public Color getBackground(int n, int n2) {
        this.checkInit();
        return this.table.getBackground(this.rowmap[n], n2);
    }

    public int getColBorder(int n, int n2) {
        this.checkInit();
        return this.table.getColBorder(n >= 0 ? this.rowmap[n] : n, n2);
    }

    public Color getColBorderColor(int n, int n2) {
        this.checkInit();
        return this.table.getColBorderColor(n >= 0 ? this.rowmap[n] : n, n2);
    }

    public int getColCount() {
        return this.table.getColCount();
    }

    public int getColWidth(int n) {
        return this.table.getColWidth(n);
    }

    public Comparer getComparer(int n) {
        return this.comparers[n];
    }

    public Font getFont(int n, int n2) {
        this.checkInit();
        return this.table.getFont(this.rowmap[n], n2);
    }

    public Color getForeground(int n, int n2) {
        this.checkInit();
        return this.table.getForeground(this.rowmap[n], n2);
    }

    public int getHeaderColCount() {
        return this.table.getHeaderColCount();
    }

    public int getHeaderRowCount() {
        return this.table.getHeaderRowCount();
    }

    public Insets getInsets(int n, int n2) {
        this.checkInit();
        return this.table.getInsets(this.rowmap[n], n2);
    }

    public Object getObject(int n, int n2) {
        this.checkInit();
        return this.table.getObject(this.rowmap[n], n2);
    }

    public int getRowBorder(int n, int n2) {
        this.checkInit();
        return this.table.getRowBorder(n >= 0 ? this.rowmap[n] : n, n2);
    }

    public Color getRowBorderColor(int n, int n2) {
        this.checkInit();
        return this.table.getRowBorderColor(n >= 0 ? this.rowmap[n] : n, n2);
    }

    public int getRowCount() {
        this.checkInit();
        return this.rowmap.length;
    }

    public int getRowHeight(int n) {
        this.checkInit();
        return this.table.getRowHeight(this.rowmap[n]);
    }

    public Dimension getSpan(int n, int n2) {
        this.checkInit();
        return this.table.getSpan(this.rowmap[n], n2);
    }

    public boolean hasGrandSummary() {
        return false;
    }

    public boolean isAscending() {
        return this.asc;
    }

    public boolean isGroupHeaderCell(int n, int n2) {
        this.checkInit();
        return this.table.isGroupHeaderCell(this.rowmap[n], n2);
    }

    public boolean isGroupHeaderRow(int n) {
        this.checkInit();
        return this.table.isGroupHeaderRow(this.rowmap[n]);
    }

    public boolean isLineWrap(int n, int n2) {
        this.checkInit();
        return this.table.isLineWrap(this.rowmap[n], n2);
    }

    public boolean isSummaryCol(int n) {
        return this.table.isSummaryCol(n);
    }

    public boolean isSummaryRow(int n) {
        this.checkInit();
        return this.table.isSummaryRow(this.rowmap[n]);
    }

    public void refresh() {
        int n;
        Object[] objectArray;
        if (this.table instanceof TableFilter) {
            ((TableFilter)((Object)this.table)).refresh();
        }
        Vector<Object[]> vector = new Vector<Object[]>();
        int n2 = this.table.hasGrandSummary() ? this.table.getRowCount() - 1 : this.table.getRowCount();
        int n3 = this.table.getHeaderRowCount();
        while (n3 < n2) {
            objectArray = new Section();
            objectArray.srow = n3;
            while (!(n3 >= this.table.getRowCount() || this.table.isSummaryRow(n3) && this.table.getObject(n3, 0) != null && this.table.getObject(n3, 1) == null)) {
                ++n3;
            }
            objectArray.erow = n3;
            if (objectArray.erow < this.table.getRowCount()) {
                objectArray.values = new Object[this.sums.length];
                n = 0;
                while (n < this.sums.length) {
                    objectArray.values[n] = this.table.getObject(n3, this.sums[n]);
                    ++n;
                }
                vector.addElement(objectArray);
            }
            ++n3;
        }
        objectArray = new Section[vector.size()];
        vector.copyInto(objectArray);
        Util.qsort(objectArray, 0, objectArray.length - 1, this.asc, new SComparer());
        n = this.table.getHeaderRowCount();
        int n4 = this.N > 0 ? Math.min(this.N, objectArray.length) : objectArray.length;
        int n5 = 0;
        while (n5 < n4) {
            n += ((Section)objectArray[n5]).erow - ((Section)objectArray[n5]).srow + 1;
            ++n5;
        }
        this.rowmap = new int[n];
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.table.getHeaderRowCount()) {
            this.rowmap[n6++] = n7++;
        }
        int n8 = 0;
        while (n8 < n4) {
            int n9 = ((Section)objectArray[n8]).srow;
            while (n9 <= ((Section)objectArray[n8]).erow) {
                this.rowmap[n6++] = n9++;
            }
            ++n8;
        }
    }

    public void setAscending(boolean bl) {
        this.asc = bl;
    }

    public void setComparer(int n, Comparer comparer) {
        if (comparer == null) {
            comparer = new DefaultComparer();
        }
        this.comparers[n] = comparer;
    }

    static class Section
    implements Serializable {
        int srow;
        int erow;
        Object[] values;

        Section() {
        }
    }

    class SComparer
    implements Comparer {
        SComparer() {
        }

        public int compare(Object object, Object object2) {
            Section section = (Section)object;
            Section section2 = (Section)object2;
            int n = 0;
            while (n < section.values.length) {
                int n2 = TopNFilter.this.comparers[TopNFilter.this.sums[n]].compare(section.values[n], section2.values[n]);
                if (n2 != 0) {
                    return n2;
                }
                ++n;
            }
            return 0;
        }
    }
}

