/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.filter;

import inetsoft.report.Comparer;
import inetsoft.report.TableFilter;
import inetsoft.report.TableLens;
import inetsoft.report.filter.DefaultComparer;
import inetsoft.report.filter.SortedTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;

public class SortFilter
implements TableFilter,
SortedTable,
Cloneable {
    Object[][] cache;
    TableLens table;
    int[] rowmap;
    int[] cols;
    boolean asc = true;
    Comparer[] comparers;

    public SortFilter(TableLens tableLens, int[] nArray) {
        this(tableLens, nArray, true);
    }

    public SortFilter(TableLens tableLens, int[] nArray, boolean bl) {
        this.table = tableLens;
        this.cols = nArray;
        this.asc = bl;
        this.comparers = new Comparer[tableLens.getColCount()];
        DefaultComparer defaultComparer = new DefaultComparer();
        int n = 0;
        while (n < nArray.length) {
            this.comparers[nArray[n]] = defaultComparer;
            ++n;
        }
    }

    private void checkInit() {
        if (this.rowmap == null) {
            this.refresh();
        }
    }

    private int compare(int n, int n2) {
        int n3 = 0;
        while (n3 < this.cols.length) {
            int n4 = this.comparers[this.cols[n3]].compare(this.cache[this.rowmap[n]][n3], this.cache[this.rowmap[n2]][n3]);
            if (n4 != 0) {
                return n4 / Math.abs(n4);
            }
            ++n3;
        }
        return 0;
    }

    public int getAlignment(int n, int n2) {
        this.checkInit();
        return this.table.getAlignment(this.rowmap[n], n2);
    }

    public Color getBackground(int n, int n2) {
        this.checkInit();
        return this.table.getBackground(this.rowmap[n], n2);
    }

    public int getColBorder(int n, int n2) {
        this.checkInit();
        return this.table.getColBorder(n < 0 ? n : this.rowmap[n], n2);
    }

    public Color getColBorderColor(int n, int n2) {
        this.checkInit();
        return this.table.getColBorderColor(n < 0 ? n : this.rowmap[n], n2);
    }

    public int getColCount() {
        return this.table.getColCount();
    }

    public int getColWidth(int n) {
        return this.table.getColWidth(n);
    }

    public Comparer getComparer(int n) {
        return this.comparers[n];
    }

    public Font getFont(int n, int n2) {
        this.checkInit();
        return this.table.getFont(this.rowmap[n], n2);
    }

    public Color getForeground(int n, int n2) {
        this.checkInit();
        return this.table.getForeground(this.rowmap[n], n2);
    }

    public int getHeaderColCount() {
        return this.table.getHeaderColCount();
    }

    public int getHeaderRowCount() {
        return this.table.getHeaderRowCount();
    }

    public Insets getInsets(int n, int n2) {
        this.checkInit();
        return this.table.getInsets(this.rowmap[n], n2);
    }

    public Object getObject(int n, int n2) {
        this.checkInit();
        return this.table.getObject(this.rowmap[n], n2);
    }

    public int getRowBorder(int n, int n2) {
        this.checkInit();
        return this.table.getRowBorder(n < 0 ? n : this.rowmap[n], n2);
    }

    public Color getRowBorderColor(int n, int n2) {
        this.checkInit();
        return this.table.getRowBorderColor(n < 0 ? n : this.rowmap[n], n2);
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public int getRowHeight(int n) {
        this.checkInit();
        return this.table.getRowHeight(this.rowmap[n]);
    }

    public int[] getSortCols() {
        return this.cols;
    }

    public Dimension getSpan(int n, int n2) {
        this.checkInit();
        return this.table.getSpan(this.rowmap[n], n2);
    }

    public boolean isLineWrap(int n, int n2) {
        this.checkInit();
        return this.table.isLineWrap(this.rowmap[n], n2);
    }

    /*
     * Unable to fully structure code
     */
    private void qsort(boolean var1_1, int var2_2, int var3_3) {
        if (var2_2 >= var3_3) {
            return;
        }
        var4_4 = var2_2;
        var5_5 = var3_3;
        var6_6 = var1_1 != false ? -1 : 1;
        var7_7 = var1_1 != false ? 1 : -1;
        var8_8 = (var4_4 + var5_5) / 2;
        var9_9 = this.rowmap[var8_8];
        this.rowmap[var8_8] = this.rowmap[var2_2];
        this.rowmap[var2_2] = var9_9;
        ** GOTO lbl22
        {
            ++var4_4;
            do {
                if (var4_4 < var3_3 && ((var10_10 = this.compare(var4_4, var2_2)) == var6_6 || var10_10 == 0)) continue block0;
                while (this.compare(var5_5, var2_2) == var7_7) {
                    --var5_5;
                }
                if (var4_4 >= var5_5) continue;
                var9_9 = this.rowmap[var4_4];
                this.rowmap[var4_4] = this.rowmap[var5_5];
                this.rowmap[var5_5] = var9_9;
lbl22:
                // 3 sources

            } while (var4_4 < var5_5);
        }
        var9_9 = this.rowmap[var2_2];
        this.rowmap[var2_2] = this.rowmap[var5_5];
        this.rowmap[var5_5] = var9_9;
        this.qsort(var1_1, var2_2, var5_5 - 1);
        this.qsort(var1_1, var5_5 + 1, var3_3);
    }

    public void refresh() {
        if (this.table instanceof TableFilter) {
            ((TableFilter)this.table).refresh();
        }
        this.sort(this.asc);
    }

    public void setComparer(int n, Comparer comparer) {
        if (comparer == null) {
            comparer = new DefaultComparer();
        }
        this.comparers[n] = comparer;
    }

    private void sort(boolean bl) {
        this.rowmap = new int[this.table.getRowCount()];
        int n = 0;
        while (n < this.rowmap.length) {
            this.rowmap[n] = n;
            ++n;
        }
        this.cache = new Object[this.table.getRowCount()][this.cols.length];
        int n2 = 0;
        while (n2 < this.cache.length) {
            int n3 = 0;
            while (n3 < this.cache[n2].length) {
                this.cache[n2][n3] = this.table.getObject(n2, this.cols[n3]);
                ++n3;
            }
            ++n2;
        }
        this.qsort(bl, this.table.getHeaderRowCount(), this.rowmap.length - 1);
        this.cache = null;
    }
}

