/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report.filter;

import inetsoft.report.TableFilter;
import inetsoft.report.filter.ColumnMapFilter;
import inetsoft.report.filter.Formula;
import inetsoft.report.filter.GroupedTable;
import inetsoft.report.filter.SortedTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Vector;

public class GroupFilter
implements TableFilter,
GroupedTable,
Cloneable {
    public static final int GROUP_HEADER_ROWS = 1;
    public static final int GROUP_HEADER_IN_PLACE = 2;
    SortedTable table;
    int[] rowmap;
    Hashtable headermap;
    Vector sumrows;
    Vector groupboundries;
    int[] cols;
    int[] sums;
    Formula[][] calcs;
    Formula[] grand;
    boolean headerrow;
    boolean grpcols;
    boolean groupPerPage;
    String grandLabel;
    Font bold;
    int headerS;

    public GroupFilter(SortedTable sortedTable) {
        this(sortedTable, new int[0], (Formula[])null, (Formula[])null);
    }

    public GroupFilter(SortedTable sortedTable, int n, Formula formula, Formula formula2) {
        Formula[] formulaArray;
        int[] nArray = new int[]{n};
        Formula[] formulaArray2 = new Formula[]{formula};
        if (formula2 != null) {
            Formula[] formulaArray3 = new Formula[1];
            formulaArray = formulaArray3;
            formulaArray3[0] = formula2;
        } else {
            formulaArray = null;
        }
        this(sortedTable, nArray, formulaArray2, formulaArray);
    }

    public GroupFilter(SortedTable sortedTable, int[] nArray, Formula formula, Formula formula2) {
        this.headermap = new Hashtable();
        this.sumrows = new Vector();
        this.groupboundries = new Vector();
        this.headerrow = false;
        this.grpcols = true;
        this.groupPerPage = false;
        this.grandLabel = null;
        this.bold = new Font("Serif", 1, 10);
        this.headerS = 1;
        this.sums = nArray;
        this.cols = sortedTable.getSortCols();
        Formula[] formulaArray = new Formula[nArray.length];
        int n = 0;
        while (n < formulaArray.length) {
            try {
                formulaArray[n] = (Formula)formula.clone();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        if (formula2 != null) {
            this.grand = new Formula[nArray.length];
            int n2 = 0;
            while (n2 < nArray.length) {
                try {
                    this.grand[n2] = (Formula)formula2.clone();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n2;
            }
        }
        this.init(sortedTable, formulaArray);
    }

    public GroupFilter(SortedTable sortedTable, int[] nArray, Formula[] formulaArray, Formula[] formulaArray2) {
        this.headermap = new Hashtable();
        this.sumrows = new Vector();
        this.groupboundries = new Vector();
        this.headerrow = false;
        this.grpcols = true;
        this.groupPerPage = false;
        this.grandLabel = null;
        this.bold = new Font("Serif", 1, 10);
        this.headerS = 1;
        this.sums = nArray;
        this.grand = formulaArray2;
        this.cols = sortedTable.getSortCols();
        this.init(sortedTable, formulaArray);
    }

    private int addSummaryRow(int n, int n2, Vector vector) {
        if (n2 == 0) {
            this.groupboundries.addElement(new Integer(vector.size() - 1));
        }
        if (this.sums.length == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = this.cols.length - 1;
        while (n4 >= n2) {
            vector.addElement(new Integer(-this.sumrows.size()));
            ++n3;
            Vector<Object> vector2 = new Vector<Object>();
            vector2.setSize(this.table.getColCount());
            int n5 = 0;
            while (n5 <= n4) {
                vector2.setElementAt(this.table.getObject(n - 1, n5), n5);
                ++n5;
            }
            int n6 = 0;
            while (n6 < this.sums.length) {
                vector2.setElementAt(this.calcs[n4][n6].getResult(), this.sums[n6]);
                ++n6;
            }
            this.sumrows.addElement(vector2);
            --n4;
        }
        return n3;
    }

    private void checkInit() {
        if (this.rowmap == null) {
            this.refresh();
        }
    }

    public int getAlignment(int n, int n2) {
        this.checkInit();
        return this.rowmap[n] >= 0 ? this.table.getAlignment(this.rowmap[n], n2) : 1;
    }

    public Color getBackground(int n, int n2) {
        this.checkInit();
        return this.rowmap[n] >= 0 ? this.table.getBackground(this.rowmap[n], n2) : null;
    }

    public int getColBorder(int n, int n2) {
        return 0;
    }

    public Color getColBorderColor(int n, int n2) {
        this.checkInit();
        return n < 0 || this.rowmap[n] >= 0 ? this.table.getColBorderColor(n < 0 ? n : this.rowmap[n], n2) : Color.black;
    }

    public int getColCount() {
        return this.table.getColCount();
    }

    public int getColWidth(int n) {
        return this.table.getColWidth(n);
    }

    public Font getFont(int n, int n2) {
        if (this.headerrow && this.headerS == 2 && n2 < this.cols.length) {
            return this.bold;
        }
        this.checkInit();
        return n >= this.table.getHeaderRowCount() && this.rowmap[n] >= 0 ? this.table.getFont(this.rowmap[n], n2) : this.bold;
    }

    public Color getForeground(int n, int n2) {
        this.checkInit();
        return this.rowmap[n] >= 0 ? this.table.getForeground(this.rowmap[n], n2) : null;
    }

    public String getGrandLabel() {
        return this.grandLabel;
    }

    public int getGroupHeaderStyle() {
        return this.headerS;
    }

    public int getHeaderColCount() {
        return this.table.getHeaderColCount();
    }

    public int getHeaderRowCount() {
        return this.table.getHeaderRowCount();
    }

    public Insets getInsets(int n, int n2) {
        return null;
    }

    public Object getObject(int n, int n2) {
        Integer n3;
        this.checkInit();
        Object object = null;
        if (this.rowmap[n] < 0) {
            object = ((Vector)this.sumrows.elementAt(-this.rowmap[n])).elementAt(n2);
        } else if (this.grpcols || n2 >= this.cols.length || n < this.table.getHeaderRowCount()) {
            object = this.table.getObject(this.rowmap[n], n2);
        } else if (this.headerrow && this.headerS == 2 && (n3 = (Integer)this.headermap.get(new Integer(n))) != null && n2 >= n3) {
            object = this.table.getObject(this.rowmap[n], n2);
        }
        return object;
    }

    public int getRowBorder(int n, int n2) {
        int n3;
        int n4 = n3 = n == this.table.getHeaderRowCount() - 1 || n2 < 0 || n >= 0 && (!this.isSummaryRow(n) || this.isSummaryCol(n2)) ? 4097 : 0;
        if (this.groupPerPage && n2 == 0 && this.groupboundries.contains(new Integer(n))) {
            return 0x1000000 | n3;
        }
        return n3;
    }

    public Color getRowBorderColor(int n, int n2) {
        this.checkInit();
        return n < 0 || this.rowmap[n] >= 0 ? this.table.getRowBorderColor(n < 0 ? n : this.rowmap[n], n2) : Color.black;
    }

    public int getRowCount() {
        this.checkInit();
        return this.rowmap.length;
    }

    public int getRowHeight(int n) {
        this.checkInit();
        return this.table.getRowHeight(this.rowmap[n] >= 0 ? this.rowmap[n] : 0);
    }

    public Dimension getSpan(int n, int n2) {
        return null;
    }

    public boolean hasGrandSummary() {
        this.checkInit();
        return this.grand != null;
    }

    private void init(SortedTable sortedTable, Formula[] formulaArray) {
        int n;
        int[] nArray = new int[sortedTable.getColCount()];
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 0;
        while (n2 < nArray.length) {
            vector.addElement(new Integer(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.cols.length) {
            vector.removeElement(new Integer(this.cols[n3]));
            ++n3;
        }
        int n4 = 0;
        while (n4 < nArray.length) {
            if (n4 < this.cols.length) {
                nArray[n4] = this.cols[n4];
            } else {
                nArray[n4] = (Integer)vector.elementAt(0);
                vector.removeElementAt(0);
            }
            ++n4;
        }
        this.table = new ColumnMapFilter(sortedTable, nArray);
        int n5 = 0;
        while (n5 < this.sums.length) {
            n = 0;
            while (n < nArray.length) {
                if (nArray[n] == this.sums[n5]) {
                    this.sums[n5] = n;
                    break;
                }
                ++n;
            }
            ++n5;
        }
        this.calcs = new Formula[this.cols.length][this.sums.length];
        n = 0;
        while (n < this.calcs.length) {
            int n6 = 0;
            while (n6 < this.calcs[n].length) {
                try {
                    this.calcs[n][n6] = (Formula)formulaArray[n6].clone();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n6;
            }
            ++n;
        }
    }

    public boolean isAddGroupHeader() {
        return this.headerrow;
    }

    public boolean isBreakAfterSection() {
        return this.groupPerPage;
    }

    public boolean isGroupHeaderCell(int n, int n2) {
        this.checkInit();
        if (this.headerrow && this.headerS == 2) {
            Integer n3 = (Integer)this.headermap.get(new Integer(n));
            return n3 != null && n2 >= n3 && n2 < this.cols.length;
        }
        return this.isGroupHeaderRow(n);
    }

    public boolean isGroupHeaderRow(int n) {
        this.checkInit();
        return this.rowmap[n] < 0 && (this.sums.length == 0 || this.getObject(n, this.sums[0]) == null);
    }

    public boolean isLineWrap(int n, int n2) {
        this.checkInit();
        return this.rowmap[n] >= 0 ? this.table.isLineWrap(this.rowmap[n], n2) : true;
    }

    public boolean isShowGroupColumns() {
        return this.grpcols;
    }

    public boolean isSummaryCol(int n) {
        this.checkInit();
        int n2 = 0;
        while (n2 < this.sums.length) {
            if (this.sums[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSummaryRow(int n) {
        this.checkInit();
        return this.rowmap[n] < 0 && this.sums.length > 0 && this.getObject(n, this.sums[0]) != null;
    }

    public void refresh() {
        int n;
        int n2;
        if (this.table instanceof TableFilter) {
            ((TableFilter)((Object)this.table)).refresh();
        }
        Object[] objectArray = new Object[this.cols.length];
        Vector<Integer> vector = new Vector<Integer>();
        boolean bl = true;
        int n3 = 0;
        this.sumrows.setSize(1);
        this.groupboundries.removeAllElements();
        int n4 = 0;
        while (n4 < this.calcs.length) {
            n2 = 0;
            while (n2 < this.calcs[n4].length) {
                this.calcs[n4][n2].reset();
                ++n2;
            }
            ++n4;
        }
        this.headermap.clear();
        if (this.grand != null) {
            n2 = 0;
            while (n2 < this.grand.length) {
                this.grand[n2].reset();
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.table.getRowCount()) {
            if (n2 < this.table.getHeaderRowCount()) {
                vector.addElement(new Integer(n2));
            } else {
                int n5;
                Object object;
                boolean bl2 = true;
                n = 0;
                while (n < this.cols.length) {
                    Object object2 = objectArray[n];
                    object = this.table.getObject(n2, n);
                    if (object2 == null || object == null || !object2.equals(object)) {
                        bl2 = false;
                        n3 = n;
                        break;
                    }
                    ++n;
                }
                if (!bl2) {
                    if (bl) {
                        bl = false;
                    } else {
                        this.addSummaryRow(n2, n3, vector);
                    }
                    int n6 = 0;
                    while (n6 < this.cols.length) {
                        objectArray[n6] = this.table.getObject(n2, n6);
                        ++n6;
                    }
                    int n7 = n3;
                    while (n7 < this.calcs.length) {
                        n5 = 0;
                        while (n5 < this.calcs[n7].length) {
                            this.calcs[n7][n5].reset();
                            ++n5;
                        }
                        ++n7;
                    }
                    if (this.headerrow) {
                        if (this.headerS == 1) {
                            n5 = n3;
                            while (n5 < this.cols.length) {
                                vector.addElement(new Integer(-this.sumrows.size()));
                                Vector<Object> vector2 = new Vector<Object>();
                                vector2.setSize(this.table.getColCount());
                                vector2.setElementAt(this.table.getObject(n2, n5), n5);
                                this.sumrows.addElement(vector2);
                                ++n5;
                            }
                        } else if (this.headerS == 2) {
                            this.headermap.put(new Integer(vector.size()), new Integer(n3));
                        }
                    }
                }
                int n8 = 0;
                while (n8 < this.sums.length) {
                    object = this.table.getObject(n2, this.sums[n8]);
                    if (this.grand != null) {
                        this.grand[n8].addValue(object);
                    }
                    n5 = 0;
                    while (n5 < this.calcs.length) {
                        this.calcs[n5][n8].addValue(object);
                        ++n5;
                    }
                    ++n8;
                }
                vector.addElement(new Integer(n2));
            }
            ++n2;
        }
        this.addSummaryRow(this.table.getRowCount(), 0, vector);
        if (this.grand != null) {
            vector.addElement(new Integer(-this.sumrows.size()));
            Vector<Object> vector3 = new Vector<Object>();
            vector3.setSize(this.table.getColCount());
            vector3.setElementAt(this.grandLabel, 0);
            n = 0;
            while (n < this.sums.length) {
                vector3.setElementAt(this.grand[n].getResult(), this.sums[n]);
                ++n;
            }
            this.sumrows.addElement(vector3);
        }
        this.rowmap = new int[vector.size()];
        int n9 = 0;
        while (n9 < this.rowmap.length) {
            this.rowmap[n9] = (Integer)vector.elementAt(n9);
            ++n9;
        }
    }

    public void setAddGroupHeader(boolean bl) {
        this.headerrow = bl;
    }

    public void setBreakAfterSection(boolean bl) {
        this.groupPerPage = bl;
    }

    public void setGrandLabel(String string) {
        this.grandLabel = string;
    }

    public void setGroupHeaderStyle(int n) {
        this.headerS = n;
    }

    public void setShowGroupColumns(boolean bl) {
        this.grpcols = bl;
    }
}

