/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report;

import inetsoft.report.ChartLens;
import inetsoft.report.CompositeLens;
import inetsoft.report.FormLens;
import inetsoft.report.Painter;
import inetsoft.report.Presenter;
import inetsoft.report.ReportElement;
import inetsoft.report.TableLens;
import inetsoft.report.TextLens;
import inetsoft.report.internal.StyleCore;
import inetsoft.report.internal.XStyleCore;
import inetsoft.report.lens.AttributeChartLens;
import inetsoft.report.lens.AttributeFormLens;
import inetsoft.report.lens.AttributeTableLens;
import inetsoft.report.lens.DefaultTableLens;
import inetsoft.report.lens.DefaultTextLens;
import inetsoft.report.lens.ElementContainer;
import inetsoft.report.lens.TableChartLens;
import inetsoft.report.painter.ComponentPainter;
import inetsoft.report.painter.ImagePainter;
import inetsoft.report.style.TableStyle;
import java.awt.Component;
import java.awt.Image;
import java.text.Format;
import java.util.NoSuchElementException;

public class XStyleSheet
extends XStyleCore {
    public void addFormat(String string, Class clazz, Format format) {
        ReportElement reportElement = this.getElement(string);
        if (reportElement == null || !(reportElement instanceof StyleCore.TableElement)) {
            throw new NoSuchElementException(string);
        }
        ((StyleCore.TableElement)reportElement).addFormat(clazz, format);
    }

    public void addPresenter(String string, Class clazz, Presenter presenter) {
        ReportElement reportElement = this.getElement(string);
        if (reportElement == null || !(reportElement instanceof StyleCore.TableElement)) {
            throw new NoSuchElementException(string);
        }
        ((StyleCore.TableElement)reportElement).addPresenter(clazz, presenter);
    }

    public AttributeChartLens getChart(String string) {
        ReportElement reportElement = this.getElement(string);
        if (reportElement == null || !(reportElement instanceof XStyleCore.ChartXElement)) {
            throw new NoSuchElementException(string);
        }
        ChartLens chartLens = ((StyleCore.ChartElement)reportElement).getChart();
        try {
            return (AttributeChartLens)chartLens;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public AttributeFormLens getForm(String string) {
        ReportElement reportElement = this.getElement(string);
        if (reportElement == null || !(reportElement instanceof XStyleCore.FormXElement)) {
            throw new NoSuchElementException(string);
        }
        return (AttributeFormLens)((StyleCore.FormElement)reportElement).getForm();
    }

    public TableLens getTable(String string) {
        ReportElement reportElement = this.getElement(string);
        if (reportElement == null || !(reportElement instanceof StyleCore.TableElement)) {
            throw new NoSuchElementException(string);
        }
        return ((XStyleCore.TableXElement)reportElement).getTable();
    }

    public TableStyle getTableStyle(String string) {
        ReportElement reportElement = this.getElement(string);
        if (reportElement == null || !(reportElement instanceof StyleCore.TableElement)) {
            throw new NoSuchElementException(string);
        }
        if (reportElement instanceof XStyleCore.TableXElement) {
            return ((XStyleCore.TableXElement)reportElement).getStyle();
        }
        return null;
    }

    public String getText(String string) {
        ReportElement reportElement = this.getElement(string);
        if (reportElement == null || !(reportElement instanceof StyleCore.TextBased)) {
            throw new NoSuchElementException(string);
        }
        return ((StyleCore.TextBased)((Object)reportElement)).getText();
    }

    public void setDirectory(String string) {
        XStyleCore.topdir = string;
        if (string.indexOf(":\\") > 0) {
            XStyleCore.topdir = string.toLowerCase();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(String string, Object object) throws NoSuchElementException, IllegalArgumentException {
        ReportElement reportElement = this.getElement(string);
        if (reportElement == null) {
            throw new NoSuchElementException(string);
        }
        if (reportElement instanceof StyleCore.TableElement) {
            TableLens tableLens;
            if (object instanceof TableLens) {
                ((StyleCore.TableElement)reportElement).setTable((TableLens)object);
            } else if (object instanceof FormLens) {
                ((XStyleCore.FormXElement)reportElement).setForm((FormLens)object);
            } else {
                if (!(object instanceof Object[][])) throw new IllegalArgumentException("Only TableLens or FormLens can be used in a Table: " + object.getClass());
                tableLens = ((StyleCore.TableElement)reportElement).getTable();
                TableStyle tableStyle = null;
                if (tableLens instanceof TableStyle) {
                    tableStyle = (TableStyle)tableLens;
                    while ((tableLens = tableStyle.getTable()) instanceof TableStyle) {
                        tableStyle = (TableStyle)tableLens;
                    }
                }
                if (tableLens instanceof DefaultTableLens) {
                    ((DefaultTableLens)tableLens).setData((Object[][])object);
                } else if (tableStyle != null) {
                    tableStyle.setTable(new DefaultTableLens((Object[][])object));
                } else {
                    ((StyleCore.TableElement)reportElement).setTable(new DefaultTableLens((Object[][])object));
                }
            }
            tableLens = this.getTableStyle(string);
            if (tableLens == null) return;
            ((AttributeTableLens)tableLens).refresh();
            return;
        } else if (reportElement instanceof StyleCore.ChartElement) {
            if (object instanceof ChartLens) {
                ((StyleCore.ChartElement)reportElement).setChart((ChartLens)object);
                return;
            } else {
                if (!(object instanceof TableLens)) throw new IllegalArgumentException("Only ChartLens can be used in a Chart: " + object.getClass());
                ((StyleCore.ChartElement)reportElement).setChart(new TableChartLens((TableLens)object));
            }
            return;
        } else if (reportElement instanceof StyleCore.TextBoxElement) {
            if (object instanceof String) {
                ((StyleCore.TextBoxElement)reportElement).setText(new DefaultTextLens(object.toString()));
                return;
            } else if (object instanceof TextLens) {
                ((StyleCore.TextBoxElement)reportElement).setText((TextLens)object);
                return;
            } else {
                ((StyleCore.TextBoxElement)reportElement).setText(this.toString(object));
            }
            return;
        } else if (reportElement instanceof StyleCore.TextElement) {
            if (object instanceof String) {
                ((StyleCore.TextElement)reportElement).setText(new DefaultTextLens(object.toString()));
                return;
            } else if (object instanceof TextLens) {
                ((StyleCore.TextElement)reportElement).setText((TextLens)object);
                return;
            } else {
                ((StyleCore.TextElement)reportElement).setText(this.toString(object));
            }
            return;
        } else if (reportElement instanceof StyleCore.PainterElement) {
            if (object instanceof Image) {
                ((StyleCore.PainterElement)reportElement).setPainter(new ImagePainter((Image)object));
                return;
            } else if (object instanceof Painter) {
                ((StyleCore.PainterElement)reportElement).setPainter((Painter)object);
                return;
            } else {
                if (!(object instanceof Component)) throw new IllegalArgumentException("Only Image, Component, or  Painter can be used in a Painter: " + object.getClass());
                ((StyleCore.PainterElement)reportElement).setPainter(new ComponentPainter((Component)object));
            }
            return;
        } else {
            if (!(reportElement instanceof StyleCore.CompositeElement)) throw new IllegalArgumentException(String.valueOf(String.valueOf(reportElement)) + ":" + object);
            if (!(object instanceof ElementContainer)) throw new IllegalArgumentException("Only ElementContainer can be used in a Composite: " + object.getClass());
            ((StyleCore.CompositeElement)reportElement).setComposite((CompositeLens)object);
        }
    }

    public void setTableStyle(String string, TableStyle tableStyle) {
        ReportElement reportElement = this.getElement(string);
        if (reportElement == null || !(reportElement instanceof StyleCore.TableElement)) {
            throw new NoSuchElementException(string);
        }
        ((XStyleCore.TableXElement)reportElement).setStyle(tableStyle);
    }

    public String toString() {
        return "Report Template [[header:" + this.getHeaderElementCount() + "] [body:" + this.getElementCount() + "] [footer:" + this.getFooterElementCount() + "]]";
    }

    protected String toString(Object object) {
        if (object == null) {
            return "";
        }
        Format format = StyleCore.getFormat(this.formatmap, object.getClass());
        return format != null ? format.format(object) : object.toString();
    }
}

