/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report;

import java.awt.Font;
import java.io.Serializable;

public abstract class TOC
implements Serializable {
    private static Font defFn = new Font("Serif", 0, 10);
    public static final TOC DEFAULT = new Default();
    public static final TOC CLASSIC = new Classic();
    public static final TOC DISTINCTIVE = new Distinctive();
    public static final TOC FANCY = new Fancy();
    public static final TOC MODERN = new Modern();
    public static final TOC FORMAL = new Formal();
    public static final TOC SIMPLE = new Simple();

    public int getAlignment(int n) {
        return 1;
    }

    public static Font getBaseFont() {
        return defFn;
    }

    public Font getFont(int n) {
        return defFn;
    }

    public double getIndent(int n) {
        return 0.0;
    }

    public int getLeader(int n) {
        return 0;
    }

    public int getSeparator(int n) {
        return 0;
    }

    public boolean isPageNumberRight() {
        return true;
    }

    public static void setBaseFont(Font font) {
        defFn = font;
    }

    public static class Default
    extends TOC {
        public double getIndent(int n) {
            return (double)(n - 1) * 0.1;
        }

        public int getLeader(int n) {
            return 4113;
        }
    }

    public static class Classic
    extends TOC {
        public Font getFont(int n) {
            return new Font(defFn.getName(), n < 3 ? 1 : 0, n == 1 ? defFn.getSize() + 2 : defFn.getSize());
        }

        public double getIndent(int n) {
            return n > 2 ? (double)(n - 2) * 0.1 : 0.0;
        }
    }

    public static class Distinctive
    extends TOC {
        public Font getFont(int n) {
            switch (n) {
                case 1: {
                    return new Font(defFn.getName(), 3, defFn.getSize() + 2);
                }
                case 2: {
                    return new Font(defFn.getName(), 1, defFn.getSize() + 1);
                }
            }
            return defFn;
        }

        public double getIndent(int n) {
            return (double)(n - 1) * 0.1;
        }

        public int getLeader(int n) {
            return 4097;
        }
    }

    public static class Fancy
    extends TOC {
        public Font getFont(int n) {
            switch (n) {
                case 1: {
                    return new Font(defFn.getName(), 1, defFn.getSize() + 2);
                }
                case 2: {
                    return new Font(defFn.getName(), 1, defFn.getSize() + 1);
                }
            }
            return defFn;
        }

        public int getSeparator(int n) {
            return n == 1 ? 4097 : 0;
        }
    }

    public static class Modern
    extends TOC {
        public int getAlignment(int n) {
            return 2;
        }

        public Font getFont(int n) {
            switch (n) {
                case 1: {
                    return new Font(defFn.getName(), 2, defFn.getSize() + 2);
                }
                case 2: {
                    return new Font(defFn.getName(), 2, defFn.getSize() + 1);
                }
            }
            return defFn;
        }

        public int getSeparator(int n) {
            return n == 1 ? 8195 : 0;
        }

        public boolean isPageNumberRight() {
            return false;
        }
    }

    public static class Formal
    extends TOC {
        public Font getFont(int n) {
            switch (n) {
                case 1: {
                    return new Font(defFn.getName(), 1, defFn.getSize() + 2);
                }
                case 2: {
                    return new Font(defFn.getName(), 1, defFn.getSize() + 1);
                }
            }
            return defFn;
        }

        public double getIndent(int n) {
            return (double)(n - 1) * 0.1;
        }

        public int getLeader(int n) {
            return 4113;
        }
    }

    public static class Simple
    extends TOC {
        public Font getFont(int n) {
            switch (n) {
                case 1: {
                    return new Font(defFn.getName(), 1, defFn.getSize() + 2);
                }
                case 2: {
                    return new Font(defFn.getName(), 2, defFn.getSize() + 1);
                }
            }
            return defFn;
        }

        public double getIndent(int n) {
            return (double)(n - 1) * 0.1;
        }
    }
}

