/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report;

import inetsoft.report.ChartLens;
import inetsoft.report.Common;
import inetsoft.report.Context;
import inetsoft.report.EmptyPaintable;
import inetsoft.report.FormLens;
import inetsoft.report.HeadingLens;
import inetsoft.report.Margin;
import inetsoft.report.PageArea;
import inetsoft.report.Paintable;
import inetsoft.report.Painter;
import inetsoft.report.Position;
import inetsoft.report.Presenter;
import inetsoft.report.ReportElement;
import inetsoft.report.ScaledPainter;
import inetsoft.report.Size;
import inetsoft.report.StylePage;
import inetsoft.report.TOC;
import inetsoft.report.TableLens;
import inetsoft.report.TextLens;
import inetsoft.report.event.PageBreakEvent;
import inetsoft.report.event.PageBreakListener;
import inetsoft.report.internal.StyleCore;
import inetsoft.report.internal.TablePaintable;
import inetsoft.report.internal.TextPaintable;
import inetsoft.report.internal.Util;
import inetsoft.report.lens.DefaultTextLens;
import inetsoft.report.painter.BulletPainter;
import inetsoft.report.painter.ComponentPainter;
import inetsoft.report.painter.ImagePainter;
import inetsoft.report.painter.PresenterPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.image.ImageProducer;
import java.io.Serializable;
import java.net.URL;
import java.text.Format;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StyleSheet
extends StyleCore {
    public static final int TABLE_FIT_CONTENT = 0;
    public static final int TABLE_FIT_PAGE = 1;
    public static final int TABLE_EQUAL_WIDTH = 2;
    public static final int TABLE_FIT_CONTENT_1PP = 3;
    public static final int TABLE_FIT_CONTENT_PAGE = 4;
    public static final int PAINTER_NON_BREAK = 0;
    public static final int PAINTER_BREAKABLE = 1;
    public static final int DEFAULT_HEADER = 256;
    public static final int FIRST_PAGE_HEADER = 257;
    public static final int EVEN_PAGE_HEADER = 258;
    public static final int ODD_PAGE_HEADER = 259;
    public static final int DEFAULT_FOOTER = 512;
    public static final int FIRST_PAGE_FOOTER = 513;
    public static final int EVEN_PAGE_FOOTER = 514;
    public static final int ODD_PAGE_FOOTER = 515;
    public static final int BODY = 0;
    public static final int WRAP_NONE = 0;
    public static final int WRAP_LEFT = 1;
    public static final int WRAP_RIGHT = 2;
    public static final int WRAP_BOTH = 3;
    public static final int WRAP_TOP_BOTTOM = 256;
    Vector listeners = new Vector();
    private boolean limited = false;
    private static int counter = 0;
    private static String version = "2.2";

    public StyleSheet() {
        if (this.limited) {
            String[] stringArray = Util.getCallers();
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("inetsoft.report.design.")) {
                    bl = true;
                    break;
                }
                ++n;
            }
            int n2 = 0;
            try {
                Class.forName("inetsoft.sree.SreeEnv");
                n2 = 9;
            }
            catch (Throwable throwable) {}
            if (!bl && counter++ > n2) {
                throw new Error("Style Report/Lite is limited to one report per application!");
            }
        }
    }

    public String addAreaBreak() {
        return this.addElement(new StyleCore.AreaBreakElement(this));
    }

    public String addBreak() {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.NewlineElement(styleSheet, 1, true));
    }

    public String addBullet() {
        BulletPainter bulletPainter = new BulletPainter();
        this.hindent = (int)(bulletPainter.getSize().width * (float)this.resolution);
        return this.addPainter(bulletPainter);
    }

    public String addBullet(Image image) {
        BulletPainter bulletPainter = new BulletPainter(image);
        this.hindent = (int)(bulletPainter.getSize().width * (float)this.resolution);
        return this.addPainter(bulletPainter);
    }

    public String addChart(ChartLens chartLens) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.ChartElement((StyleCore)styleSheet, chartLens));
    }

    public String addChart(ChartLens chartLens, double d, double d2) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.ChartElement((StyleCore)styleSheet, chartLens, d, d2));
    }

    public String addComponent(Component component) {
        return this.addPainter(new ComponentPainter(component));
    }

    public String addComponent(Component component, double d, double d2) {
        return this.addPainter(new ComponentPainter(component), d, d2);
    }

    public String addConditionalPageBreak(double d) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.CondPageBreakElement((StyleCore)styleSheet, d));
    }

    public String addConditionalPageBreak(int n) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.CondPageBreakElement((StyleCore)styleSheet, n));
    }

    public String addElement(ReportElement reportElement) {
        if (((StyleCore.Element)reportElement).isNewline() && !((StyleCore.Element)reportElement).isContinuation()) {
            this.hindent = 0;
        }
        this.elements.addElement(reportElement);
        return reportElement.getID();
    }

    public String addFooterBreak() {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addFooterElement(new StyleCore.NewlineElement(styleSheet, 1, true));
    }

    public String addFooterElement(ReportElement reportElement) {
        this.currFooter.addElement(reportElement);
        return reportElement.getID();
    }

    public String addFooterImage(Image image) {
        return this.addFooterPainter(new ImagePainter(image));
    }

    public String addFooterImage(Image image, double d, double d2) {
        return this.addFooterPainter(new ImagePainter(image), d, d2);
    }

    public String addFooterImage(URL uRL) {
        try {
            return this.addFooterImage(Common.getToolkit().createImage((ImageProducer)uRL.getContent()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String addFooterNewline(int n) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addFooterElement(new StyleCore.NewlineElement(styleSheet, n, false));
    }

    public String addFooterObject(Object object) {
        Presenter presenter = (Presenter)this.presentermap.get(object.getClass());
        String string = null;
        if (presenter != null) {
            StyleSheet styleSheet = this;
            styleSheet.getClass();
            string = this.addFooterElement(new StyleCore.PainterElement((StyleCore)styleSheet, new PresenterPainter(object, presenter)));
        } else {
            Format format = this.getFormat(object.getClass());
            string = this.addFooterText(format != null ? format.format(object) : Util.toString(object));
        }
        return string;
    }

    public String addFooterPainter(Painter painter) {
        if (painter instanceof ScaledPainter) {
            Size size = ((ScaledPainter)painter).getSize();
            return this.addFooterPainter(painter, size.width, size.height);
        }
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addFooterElement(new StyleCore.PainterElement((StyleCore)styleSheet, painter));
    }

    public String addFooterPainter(Painter painter, double d, double d2) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addFooterElement(new StyleCore.PainterElement(styleSheet, painter, d, d2));
    }

    public String addFooterSeparator(int n) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addFooterElement(new StyleCore.SeparatorElement((StyleCore)styleSheet, n));
    }

    public String addFooterSpace(int n) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addFooterElement(new StyleCore.SpaceElement((StyleCore)styleSheet, n));
    }

    public String addFooterTab(int n) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addFooterElement(new StyleCore.TabElement((StyleCore)styleSheet, n));
    }

    public String addFooterTable(TableLens tableLens) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addFooterElement(new StyleCore.TableElement((StyleCore)styleSheet, tableLens));
    }

    public String addFooterText(TextLens textLens) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addFooterElement(new StyleCore.TextElement((StyleCore)styleSheet, textLens));
    }

    public String addFooterText(String string) {
        return this.addFooterText(new DefaultTextLens(string));
    }

    public String addFooterTextBox(TextLens textLens) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addFooterElement(new StyleCore.TextBoxElement((StyleCore)styleSheet, textLens));
    }

    public String addFooterTextBox(TextLens textLens, int n, double d, double d2, int n2) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        StyleCore.TextBoxElement textBoxElement = new StyleCore.TextBoxElement((StyleCore)styleSheet, textLens, d, d2);
        textBoxElement.setBorder(n);
        textBoxElement.setTextAlignment(n2);
        return this.addFooterElement(textBoxElement);
    }

    public String addForm(FormLens formLens) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.FormElement((StyleCore)styleSheet, formLens));
    }

    public void addFormat(Class clazz, Format format) {
        this.formatmap.put(clazz, format);
    }

    public String addHeaderBreak() {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addHeaderElement(new StyleCore.NewlineElement(styleSheet, 1, true));
    }

    public String addHeaderElement(ReportElement reportElement) {
        this.currHeader.addElement(reportElement);
        return reportElement.getID();
    }

    public String addHeaderImage(Image image) {
        return this.addHeaderPainter(new ImagePainter(image));
    }

    public String addHeaderImage(Image image, double d, double d2) {
        return this.addHeaderPainter(new ImagePainter(image), d, d2);
    }

    public String addHeaderImage(URL uRL) {
        try {
            return this.addHeaderImage(Common.getToolkit().createImage((ImageProducer)uRL.getContent()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String addHeaderNewline(int n) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addHeaderElement(new StyleCore.NewlineElement(styleSheet, n, false));
    }

    public String addHeaderObject(Object object) {
        Presenter presenter = (Presenter)this.presentermap.get(object.getClass());
        String string = null;
        if (presenter != null) {
            StyleSheet styleSheet = this;
            styleSheet.getClass();
            string = this.addHeaderElement(new StyleCore.PainterElement((StyleCore)styleSheet, new PresenterPainter(object, presenter)));
        } else {
            Format format = this.getFormat(object.getClass());
            string = this.addHeaderText(format != null ? format.format(object) : Util.toString(object));
        }
        return string;
    }

    public String addHeaderPainter(Painter painter) {
        if (painter instanceof ScaledPainter) {
            Size size = ((ScaledPainter)painter).getSize();
            return this.addHeaderPainter(painter, size.width, size.height);
        }
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addHeaderElement(new StyleCore.PainterElement((StyleCore)styleSheet, painter));
    }

    public String addHeaderPainter(Painter painter, double d, double d2) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addHeaderElement(new StyleCore.PainterElement(styleSheet, painter, d, d2));
    }

    public String addHeaderSeparator(int n) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addHeaderElement(new StyleCore.SeparatorElement((StyleCore)styleSheet, n));
    }

    public String addHeaderSpace(int n) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addHeaderElement(new StyleCore.SpaceElement((StyleCore)styleSheet, n));
    }

    public String addHeaderTab(int n) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addHeaderElement(new StyleCore.TabElement((StyleCore)styleSheet, n));
    }

    public String addHeaderTable(TableLens tableLens) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addHeaderElement(new StyleCore.TableElement((StyleCore)styleSheet, tableLens));
    }

    public String addHeaderText(TextLens textLens) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addHeaderElement(new StyleCore.TextElement((StyleCore)styleSheet, textLens));
    }

    public String addHeaderText(String string) {
        return this.addHeaderText(new DefaultTextLens(string));
    }

    public String addHeaderTextBox(TextLens textLens) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addHeaderElement(new StyleCore.TextBoxElement((StyleCore)styleSheet, textLens));
    }

    public String addHeaderTextBox(TextLens textLens, int n, double d, double d2, int n2) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        StyleCore.TextBoxElement textBoxElement = new StyleCore.TextBoxElement((StyleCore)styleSheet, textLens, d, d2);
        textBoxElement.setBorder(n);
        textBoxElement.setTextAlignment(n2);
        return this.addHeaderElement(textBoxElement);
    }

    public String addImage(Image image) {
        return this.addPainter(new ImagePainter(image));
    }

    public String addImage(Image image, double d, double d2) {
        return this.addPainter(new ImagePainter(image), d, d2);
    }

    public String addImage(URL uRL) {
        try {
            return this.addImage(Common.getToolkit().createImage((ImageProducer)uRL.getContent()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String addNewline(int n) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.NewlineElement(styleSheet, n, false));
    }

    public String addObject(Object object) {
        Presenter presenter = (Presenter)this.presentermap.get(object.getClass());
        String string = null;
        if (presenter != null) {
            StyleSheet styleSheet = this;
            styleSheet.getClass();
            string = this.addElement(new StyleCore.PainterElement((StyleCore)styleSheet, new PresenterPainter(object, presenter)));
        } else {
            Format format = this.getFormat(object.getClass());
            string = this.addText(format != null ? format.format(object) : Util.toString(object));
        }
        return string;
    }

    public String addPageBreak() {
        return this.addElement(new StyleCore.PageBreakElement(this));
    }

    public void addPageBreakListener(PageBreakListener pageBreakListener) {
        this.listeners.addElement(pageBreakListener);
    }

    public String addPainter(Painter painter) {
        if (painter instanceof ScaledPainter) {
            Size size = ((ScaledPainter)painter).getSize();
            return this.addPainter(painter, size.width, size.height);
        }
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.PainterElement((StyleCore)styleSheet, painter));
    }

    public String addPainter(Painter painter, double d, double d2) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.PainterElement(styleSheet, painter, d, d2));
    }

    public void addPresenter(Class clazz, Presenter presenter) {
        this.presentermap.put(clazz, presenter);
    }

    public String addSeparator(int n) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.SeparatorElement((StyleCore)styleSheet, n));
    }

    public String addSpace(int n) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.SpaceElement((StyleCore)styleSheet, n));
    }

    public String addTOC(TOC tOC) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.TOCElement((StyleCore)styleSheet, tOC));
    }

    public String addTab(int n) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.TabElement((StyleCore)styleSheet, n));
    }

    public String addTable(TableLens tableLens) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.TableElement((StyleCore)styleSheet, tableLens));
    }

    public String addText(TextLens textLens) {
        if (textLens instanceof HeadingLens) {
            StyleSheet styleSheet = this;
            styleSheet.getClass();
            return this.addElement(new StyleCore.HeadingElement((StyleCore)styleSheet, (HeadingLens)textLens));
        }
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.TextElement((StyleCore)styleSheet, textLens));
    }

    public String addText(String string) {
        return this.addText(new DefaultTextLens(string));
    }

    public String addTextBox(TextLens textLens) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        return this.addElement(new StyleCore.TextBoxElement((StyleCore)styleSheet, textLens));
    }

    public String addTextBox(TextLens textLens, int n, double d, double d2, int n2) {
        StyleSheet styleSheet = this;
        styleSheet.getClass();
        StyleCore.TextBoxElement textBoxElement = new StyleCore.TextBoxElement((StyleCore)styleSheet, textLens, d, d2);
        textBoxElement.setBorder(n);
        textBoxElement.setTextAlignment(n2);
        return this.addElement(textBoxElement);
    }

    public String addTextBox(String string, int n, double d, double d2, int n2) {
        return this.addTextBox(new DefaultTextLens(string), n, d, d2, n2);
    }

    private void alignLine(int n, int n2, StylePage stylePage, float f) {
        int n3;
        Serializable serializable;
        Serializable serializable2;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n4 = 0;
        boolean bl = true;
        boolean bl2 = true;
        float f4 = this.printBox.x + this.printBox.width;
        float f5 = 0.0f;
        n2 = Math.min(stylePage.getPaintableCount(), n2);
        int n5 = n;
        while (n5 < n2) {
            int n6;
            Paintable paintable = stylePage.getPaintable(n5);
            serializable2 = paintable.getBounds();
            serializable = (StyleCore.Element)paintable.getElement();
            if ((((StyleCore.Element)serializable).getAlignment() & 2) == 0) {
                bl = false;
            }
            if ((((StyleCore.Element)serializable).getAlignment() & 4) == 0) {
                bl2 = false;
            }
            if (bl || bl2) {
                f4 = Math.min(f4, (float)((Rectangle)serializable2).x);
                f5 = Math.max(f5, (float)(((Rectangle)serializable2).x + ((Rectangle)serializable2).width));
            }
            if ((((StyleCore.Element)serializable).getAlignment() & 0x10) != 0) {
                n6 = (int)((float)((Rectangle)serializable2).y + (f - (float)((Rectangle)serializable2).height) / 2.0f);
                paintable.setLocation(new Point(((Rectangle)serializable2).x, n6));
            } else if ((((StyleCore.Element)serializable).getAlignment() & 0x20) != 0) {
                n6 = (int)((float)((Rectangle)serializable2).y + f - (float)((Rectangle)serializable2).height);
                paintable.setLocation(new Point(((Rectangle)serializable2).x, n6));
            }
            if (paintable instanceof TextPaintable) {
                if ((((StyleCore.Element)serializable).getAlignment() & 8) == 0 || (((StyleCore.Element)serializable).getAlignment() & 0x40) != 0) {
                    ++n4;
                }
                if ((float)((Rectangle)serializable2).height > f3) {
                    f3 = ((Rectangle)serializable2).height;
                    f2 = (float)paintable.getBounds().y + Common.getAscent(((StyleCore.Element)serializable).getFont());
                }
            }
            ++n5;
        }
        if (n4 > 1) {
            int n7 = n;
            while (n7 < n2) {
                serializable2 = stylePage.getPaintable(n7);
                serializable = (StyleCore.Element)serializable2.getElement();
                if ((((StyleCore.Element)serializable).getAlignment() & 8) == 0 || (((StyleCore.Element)serializable).getAlignment() & 0x40) != 0) {
                    Rectangle rectangle = serializable2.getBounds();
                    int n8 = (int)(f2 - Common.getAscent(((StyleCore.Element)serializable).getFont()));
                    serializable2.setLocation(new Point(rectangle.x, n8));
                }
                ++n7;
            }
        }
        if ((bl || bl2) && (n3 = (int)(((float)this.printBox.width - (f5 - f4)) / (float)(bl ? 2 : 1) + (float)this.printBox.x - f4)) != 0) {
            int n9 = n;
            while (n9 < n2) {
                serializable = stylePage.getPaintable(n9);
                Rectangle rectangle = serializable.getBounds();
                serializable.setLocation(new Point(rectangle.x + n3, rectangle.y));
                ++n9;
            }
        }
    }

    public void clear() {
        int n;
        Object[] objectArray;
        if (this.limited) {
            objectArray = Util.getCallers();
            n = 0;
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2].startsWith("inetsoft.report.design.")) {
                    n = 1;
                    break;
                }
                ++n2;
            }
            if (n == 0) {
                throw new Error("Style Report/Lite is limited to one report per application!");
            }
        }
        this.elements.removeAllElements();
        objectArray = new Vector[]{this.headerElements, this.footerElements, this.firstHeader, this.firstFooter, this.evenHeader, this.evenFooter, this.oddHeader, this.oddFooter};
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                ((Vector)objectArray[n]).removeAllElements();
            }
            ++n;
        }
        this.elemHeader.clear();
        this.elemFooter.clear();
    }

    public void clearFormat() {
        this.formatmap.clear();
    }

    public void clearPresenter() {
        this.presentermap.clear();
    }

    public static StyleSheet createStyleSheet() {
        return Common.createStyleSheet();
    }

    public void firePageBreakEvent(StylePage stylePage, boolean bl) {
        try {
            if (stylePage.getPaintableCount() == 0) {
                return;
            }
            Vector vector = (Vector)this.listeners.clone();
            Paintable paintable = stylePage.getPaintable(stylePage.getPaintableCount() - 1);
            Rectangle rectangle = null;
            if (paintable instanceof TablePaintable) {
                rectangle = ((TablePaintable)paintable).getTableRegion();
            }
            PageBreakEvent pageBreakEvent = new PageBreakEvent(stylePage, paintable.getElement().getID(), rectangle, bl ^ true);
            int n = vector.size() - 1;
            while (n >= 0) {
                ((PageBreakListener)vector.elementAt(n)).valueChanged(pageBreakEvent);
                --n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getCurrentAlignment() {
        return this.alignment;
    }

    public Color getCurrentBackground() {
        return this.background;
    }

    public Insets getCurrentCellPadding() {
        return this.padding;
    }

    public Font getCurrentFont() {
        return this.font;
    }

    public Color getCurrentForeground() {
        return this.foreground;
    }

    public double getCurrentIndent() {
        return this.indent;
    }

    public int getCurrentLineSpacing() {
        return this.spacing;
    }

    public int getCurrentPainterLayout() {
        return this.painterLayout;
    }

    public Insets getCurrentPainterMargin() {
        return this.painterMargin;
    }

    public double[] getCurrentTabStops() {
        return this.tabStops;
    }

    public int getCurrentTableAdvance() {
        return this.tableadv;
    }

    public int getCurrentTableLayout() {
        return this.autosize;
    }

    public double getCurrentTableWidth() {
        return this.tableW;
    }

    public int getCurrentTextAdvance() {
        return this.textadv;
    }

    public int getCurrentWrapping() {
        return this.wrapping;
    }

    public ReportElement getElement(int n) {
        return (ReportElement)this.elements.elementAt(n);
    }

    /*
     * Unable to fully structure code
     */
    public ReportElement getElement(String var1_1) {
        var2_2 = new Vector[]{this.elements, this.headerElements, this.footerElements, this.firstHeader, this.firstFooter, this.evenHeader, this.evenFooter, this.oddHeader, this.oddFooter};
        var3_3 = 0;
        while (var3_3 < var2_2.length) {
            if (var2_2[var3_3] != null) {
                var4_4 = 0;
                while (var4_4 < var2_2[var3_3].size()) {
                    var5_6 = (ReportElement)var2_2[var3_3].elementAt(var4_4);
                    if (var5_6.getID() != null && var5_6.getID().equals(var1_1)) {
                        return var5_6;
                    }
                    ++var4_4;
                }
            }
            ++var3_3;
        }
        var4_5 = new Enumeration[]{this.elemHeader.elements(), this.elemFooter.elements()};
        var5_7 = 0;
        ** GOTO lbl28
        {
            var6_8 = (Vector)var4_5[var5_7].nextElement();
            var7_9 = 0;
            while (var7_9 < var6_8.size()) {
                var8_10 = (ReportElement)var6_8.elementAt(var7_9);
                if (var8_10.getID() != null && var8_10.getID().equals(var1_1)) {
                    return var8_10;
                }
                ++var7_9;
            }
            do {
                if (var4_5[var5_7].hasMoreElements()) continue block2;
                ++var5_7;
lbl28:
                // 2 sources

            } while (var5_7 < var4_5.length);
        }
        return null;
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public int getElementIndex(ReportElement reportElement) {
        return this.elements.indexOf(reportElement, 0);
    }

    public Vector getElements(int n) {
        switch (n) {
            case 256: {
                return this.headerElements;
            }
            case 257: {
                return this.firstHeader;
            }
            case 258: {
                return this.evenHeader;
            }
            case 259: {
                return this.oddHeader;
            }
            case 512: {
                return this.footerElements;
            }
            case 513: {
                return this.firstFooter;
            }
            case 514: {
                return this.evenFooter;
            }
            case 515: {
                return this.oddFooter;
            }
        }
        return this.elements;
    }

    public Rectangle getFooterBounds(Dimension dimension, int n) {
        return new Rectangle((int)((this.margin.left - this.pmargin.left) * (double)n), dimension.height - (int)(this.footerFromEdge * (double)n), dimension.width - (int)((this.margin.left + this.margin.right) * (double)n), dimension.height - this.printBox.y);
    }

    public ReportElement getFooterElement(int n) {
        return (ReportElement)this.currFooter.elementAt(n);
    }

    public int getFooterElementCount() {
        return this.currFooter.size();
    }

    public int getFooterElementIndex(ReportElement reportElement) {
        return this.currFooter.indexOf(reportElement, 0);
    }

    public double getFooterFromEdge() {
        return this.footerFromEdge;
    }

    public Format getFormat(Class clazz) {
        Format format = null;
        while (clazz != null && (format = (Format)this.formatmap.get(clazz)) == null) {
            clazz = clazz.getSuperclass();
        }
        return format;
    }

    public Rectangle getHeaderBounds(Dimension dimension, int n) {
        return new Rectangle((int)((this.margin.left - this.pmargin.left) * (double)n), (int)((this.headerFromEdge - this.pmargin.top) * (double)n), dimension.width - (int)((this.margin.left + this.margin.right) * (double)n), (int)((this.margin.top - this.headerFromEdge) * (double)n));
    }

    public ReportElement getHeaderElement(int n) {
        return (ReportElement)this.currHeader.elementAt(n);
    }

    public int getHeaderElementCount() {
        return this.currHeader.size();
    }

    public int getHeaderElementIndex(ReportElement reportElement) {
        return this.currHeader.indexOf(reportElement, 0);
    }

    public double getHeaderFromEdge() {
        return this.headerFromEdge;
    }

    public Margin getMargin() {
        return this.margin;
    }

    public int getPageNumberingStart() {
        return this.pgStart;
    }

    public Presenter getPresenter(Class clazz) {
        return StyleCore.getPresenter(this.presentermap, clazz);
    }

    public static Margin getPrinterMargin() {
        return StyleCore.g_pmargin;
    }

    public String getProperty(String string) {
        return this.prop.getProperty(string);
    }

    public static String getVersion() {
        return version;
    }

    public void insertElement(int n, ReportElement reportElement) {
        this.hindent = 0;
        this.elements.insertElementAt(reportElement, n);
    }

    public void insertFooterElement(int n, ReportElement reportElement) {
        this.currFooter.insertElementAt(reportElement, n);
    }

    public void insertHeaderElement(int n, ReportElement reportElement) {
        this.currHeader.insertElementAt(reportElement, n);
    }

    public boolean isCurrentJustify() {
        return this.justify;
    }

    public boolean isCurrentOrphanControl() {
        return this.orphan;
    }

    public void moveAnchor(Position position) {
        this.anchor = position;
    }

    public void print() throws Exception {
        Common.print(this);
    }

    public synchronized void print(PrintJob printJob) {
        StylePage stylePage;
        boolean bl = true;
        Vector<StylePage> vector = new Vector<StylePage>();
        Date date = new Date();
        Dimension dimension = printJob.getPageDimension();
        this.resolution = 72;
        this.reset();
        while (bl) {
            stylePage = new StylePage(dimension, this.resolution);
            bl = this.printNext(stylePage);
            vector.addElement(stylePage);
        }
        int n = 0;
        while (n < vector.size()) {
            stylePage = (StylePage)vector.elementAt(n);
            this.printHeaderFooter(stylePage, n, n - this.pgStart + 1, vector.size() - this.pgStart, date);
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            stylePage = (StylePage)vector.elementAt(n2);
            Graphics graphics = printJob.getGraphics();
            stylePage.print(graphics);
            graphics.dispose();
            ++n2;
        }
    }

    public synchronized void printHeaderFooter(StylePage stylePage, int n, int n2, int n3, Date date) {
        Vector vector = this.elements;
        int n4 = this.current;
        Dimension dimension = stylePage.getPageDimension();
        this.resolution = stylePage.getPageResolution();
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        int n5 = 0;
        while (n5 < stylePage.getPaintableCount()) {
            StyleCore.Element element = (StyleCore.Element)stylePage.getPaintable(n5).getElement();
            if (element instanceof StyleCore.HeadingElement) {
                this.headingMap.put(element, new Integer(n2));
            }
            if (vector3 == null && element != null) {
                vector3 = (Vector)this.elemHeader.get(element.getID());
            }
            if (vector4 == null && element != null) {
                vector4 = (Vector)this.elemFooter.get(element.getID());
            }
            ++n5;
        }
        this.printBox = this.getHeaderBounds(dimension, this.resolution);
        this.frames = new Rectangle[]{this.printBox};
        this.currFrame = 0;
        this.printHead.y = 0.0f;
        this.printHead.x = 0.0f;
        if (!this.designtime && vector3 != null) {
            vector2 = this.overrideHeader = (Vector)vector3.clone();
        }
        vector2 = this.overrideHeader != null ? this.overrideHeader : (n == 0 && this.firstHeader != null && this.firstHeader.size() > 0 ? (Vector)this.firstHeader.clone() : (n % 2 == 0 && this.oddHeader != null && this.oddHeader.size() > 0 ? (Vector)this.oddHeader.clone() : (n % 2 == 1 && this.evenHeader != null && this.evenHeader.size() > 0 ? (Vector)this.evenHeader.clone() : (Vector)this.headerElements.clone())));
        this.processHF(vector2, n2, n3, date);
        this.elements = vector2;
        this.current = 0;
        this.printNextArea(stylePage);
        this.printBox = this.getFooterBounds(dimension, this.resolution);
        this.frames = new Rectangle[]{this.printBox};
        this.currFrame = 0;
        this.printHead.y = 0.0f;
        this.printHead.x = 0.0f;
        if (!this.designtime && vector4 != null) {
            vector2 = this.overrideFooter = (Vector)vector4.clone();
        }
        vector2 = this.overrideFooter != null ? this.overrideFooter : (n == 0 && this.firstFooter != null && this.firstFooter.size() > 0 ? (Vector)this.firstFooter.clone() : (n % 2 == 0 && this.oddFooter != null && this.oddFooter.size() > 0 ? (Vector)this.oddFooter.clone() : (n % 2 == 1 && this.evenFooter != null && this.evenFooter.size() > 0 ? (Vector)this.evenFooter.clone() : (Vector)this.footerElements.clone())));
        this.processHF(vector2, n2, n3, date);
        this.elements = vector2;
        this.current = 0;
        this.printNextArea(stylePage);
        this.elements = vector;
        this.current = n4;
    }

    public synchronized boolean printNext(StylePage stylePage) {
        Dimension dimension = stylePage.getPageDimension();
        this.pmargin = StyleSheet.getPrinterMargin();
        this.resolution = stylePage.getPageResolution();
        this.printBox = new Rectangle((int)((this.margin.left - this.pmargin.left) * (double)this.resolution), (int)((this.margin.top - this.pmargin.top) * (double)this.resolution), dimension.width - (int)((this.margin.left + this.margin.right) * (double)this.resolution), dimension.height - (int)((this.margin.top + this.margin.bottom) * (double)this.resolution));
        this.frames = null;
        while (this.current < this.elements.size() && this.elements.elementAt(this.current) instanceof StyleCore.PageLayoutElement) {
            ((StyleCore.PageLayoutElement)this.elements.elementAt(this.current++)).print(stylePage);
        }
        if (this.areas != null) {
            Vector<Rectangle> vector = new Vector<Rectangle>();
            int n = 0;
            while (n < this.areas.length) {
                if (this.areas[n].isFlow()) {
                    vector.addElement(this.areas[n].getPrintArea(this.printBox, this.resolution));
                }
                if (this.areas[n].getBorder() != 0) {
                    Rectangle rectangle = this.areas[n].getBounds(this.printBox, this.resolution);
                    Common.drawRect(stylePage, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.areas[n].getBorder(), this.areas[n].getBorderColor());
                }
                ++n;
            }
            this.frames = new Rectangle[vector.size()];
            vector.copyInto(this.frames);
        }
        if (this.frames == null || this.frames.length == 0) {
            this.frames = new Rectangle[]{this.printBox};
        }
        this.currFrame = 0;
        while (this.currFrame < this.frames.length) {
            this.printBox = this.frames[this.currFrame];
            this.printHead.y = 0.0f;
            this.printHead.x = 0.0f;
            if (!this.printNextArea(stylePage)) {
                this.firePageBreakEvent(stylePage, false);
                return false;
            }
            if (this.current > 0 && this.elements.elementAt(this.current - 1) instanceof StyleCore.PageBreakElement) {
                this.firePageBreakEvent(stylePage, true);
                return true;
            }
            ++this.currFrame;
        }
        this.firePageBreakEvent(stylePage, true);
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected synchronized boolean printNextArea(StylePage var1_1) {
        var2_2 = this.current;
        while (this.printHead.y < (float)this.printBox.height && this.current < this.elements.size()) {
            block64: {
                var2_2 = this.current;
                while (var2_2 < this.elements.size()) {
                    var3_3 = (StyleCore.Element)this.elements.elementAt(var2_2);
                    if (var3_3.isBlock() || var3_3.isNewline() && var2_2 > this.current) break;
                    ++var2_2;
                }
                if ((var3_3 = (StyleCore.Element)this.elements.elementAt(this.current)) instanceof StyleCore.PainterElement && (var4_4 = (StyleCore.PainterElement)var3_3).getAnchor() != null && var4_4.getAnchor().y - var4_4.getAnchorDepth() > 0.0f) {
                    if (this.current > 0) {
                        var4_4.setAnchorElement((ReportElement)this.elements.elementAt(this.current - 1));
                    }
                    var5_6 = this.printHead.y;
                    this.printHead.y += (var4_4.getAnchor().y - var4_4.getAnchorDepth()) * (float)this.resolution;
                    if (this.printHead.y > (float)this.printBox.height) {
                        var4_4.setAnchorDepth(var4_4.getAnchorDepth() + ((float)this.printBox.height - var5_6) / (float)this.resolution);
                        return true;
                    }
                }
                this.lineH = 0.0f;
                if (var2_2 == this.current) {
                    var4_4 = (StyleCore.Element)this.elements.elementAt(this.current);
                    var5_7 = Common.getFontMetrics(var4_4.getFont());
                    this.printHead.x = 0.0f;
                    if (var4_4 instanceof StyleCore.CondPageBreakElement) {
                        var6_8 = ((StyleCore.CondPageBreakElement)var4_4).getMinimumHeight();
                        ++this.current;
                        var4_4.print(var1_1);
                        if (!((float)var6_8 + this.printHead.y > (float)this.printBox.height)) continue;
                        break;
                    }
                    if (var4_4 instanceof StyleCore.AreaBreakElement) {
                        var4_4.print(var1_1);
                        return ++this.current < this.elements.size();
                    }
                    if (var4_4 instanceof StyleCore.PageLayoutElement) {
                        return true;
                    }
                    if (var4_4 instanceof StyleCore.TableElement) {
                        var6_8 = 1;
                        var7_10 = (StyleCore.TableElement)var4_4;
                        var7_10.validate(var1_1);
                        do {
                            if (!var7_10.fitNext((float)this.printBox.height - this.printHead.y)) {
                                return var6_8 != 0 && this.printHead.y > 0.0f || ++this.current < this.elements.size();
                            }
                            var6_8 = (int)var7_10.print(var1_1);
                            if (var6_8 == 0 || var7_10.getLayout() != 3) continue;
                            return true;
                        } while (var6_8 != 0);
                    } else {
                        if (!var4_4.isBreakable()) {
                            var6_9 = var4_4.getPreferredSize();
                            if (this.printHead.y + var6_9.height > (float)this.printBox.height && this.printHead.y > 0.0f) {
                                return true;
                            }
                        }
                        if (var4_4.print(var1_1)) {
                            return true;
                        }
                    }
                    ++this.current;
                    continue;
                }
                var4_5 = -1;
                var5_6 = 0.0f;
                var6_8 = this.current;
                while (var6_8 < var2_2) {
                    var7_10 = (ReportElement)this.elements.elementAt(var6_8);
                    if (var7_10 instanceof StyleCore.PainterElement && ((StyleCore.PainterElement)var7_10).getAnchor() != null) {
                        var4_5 = var6_8;
                    }
                    ++var6_8;
                }
                if (var4_5 < 0) break block64;
                var7_11 = this.current;
                while (var7_11 < var2_2) {
                    var8_13 = (StyleCore.Element)this.elements.elementAt(var7_11);
                    if (var8_13 instanceof StyleCore.PainterElement) {
                        var9_15 = var8_13.getPreferredSize();
                        var5_6 = Math.max(var5_6, var9_15.height);
                    }
                    ++var7_11;
                }
                var8_13 = new Position(this.printHead);
                var9_15 = new Vector<E>();
                var10_18 = new Vector<Vector<E>>();
                var11_21 = new Vector<StyleCore.Element>();
                var12_23 = new Vector<StyleCore.Element>();
                var13_25 = this.current;
                while (var13_25 < var2_2) {
                    var14_27 /* !! */  = (StyleCore.Element)this.elements.elementAt(var13_25);
                    if (var14_27 /* !! */  instanceof StyleCore.PainterElement && ((StyleCore.PainterElement)var14_27 /* !! */ ).getAnchor() != null) {
                        var15_29 = (StyleCore.PainterElement)var14_27 /* !! */ ;
                        var16_33 = var15_29.getAnchor().x >= 0.0f ? var15_29.getAnchor().x * (float)this.resolution : var15_29.getAnchor().x * (float)this.resolution + (float)this.printBox.width;
                        var17_37 = new Rectangle((int)(this.printHead.x + (float)this.printBox.x), (int)(this.printHead.y + (float)this.printBox.y), (int)(var16_33 - this.printHead.x), (int)var5_6);
                        if (var13_25 > this.current) {
                            var15_29.setAnchorElement((ReportElement)this.elements.elementAt(this.current));
                        }
                        var9_15.addElement(var17_37);
                        var10_18.addElement(var12_23);
                        var12_23 = new Vector<StyleCore.Element>();
                        var11_21.addElement(var14_27 /* !! */ );
                        if (var15_29.getWrapping() != 0) {
                            this.printHead.x = var16_33 + Math.min((float)this.printBox.width - var16_33, var15_29.getPreferredSize().width);
                        }
                    } else {
                        var12_23.addElement(var14_27 /* !! */ );
                    }
                    ++var13_25;
                }
                var14_27 /* !! */  = new Rectangle((int)(this.printHead.x + (float)this.printBox.x), (int)(this.printHead.y + (float)this.printBox.y), (int)((float)this.printBox.width - this.printHead.x), (int)var5_6);
                var9_15.addElement(var14_27 /* !! */ );
                var10_18.addElement(var12_23);
                var15_30 = var2_2;
                var16_34 = this.elements;
                var17_37 = this.printBox;
                var18_40 = 0;
                var19_43 = 0;
                var20_44 = 0;
                while (var20_44 < var10_18.size()) {
                    block65: {
                        var12_23 = (Vector<StyleCore.Element>)var10_18.elementAt(var20_44);
                        if (var20_44 > 0) {
                            var21_46 = (StyleCore.PainterElement)var11_21.elementAt(var20_44 - 1);
                            var22_50 = this.printHead;
                            var23_53 = this.printBox;
                            var24_55 = var8_13.y;
                            if (var21_46.getAnchor().y < 0.0f) {
                                var24_55 += -var21_46.getAnchor().y * (float)this.resolution;
                            }
                            this.printBox = var17_37;
                            var25_56 = var21_46.getAnchor().x >= 0.0f ? var21_46.getAnchor().x * (float)this.resolution : var21_46.getAnchor().x * (float)this.resolution + (float)this.printBox.width;
                            this.printHead = new Position(var25_56, var24_55);
                            var21_46.print(var1_1);
                            this.printHead = var22_50;
                            this.printBox = var23_53;
                        }
                        if (var12_23.size() <= 0) break block65;
                        var21_47 = var18_40;
                        if ((var18_40 = Math.max(var18_40, var20_44)) == 0 || var21_47 != var18_40) {
                            this.printHead.y = 0.0f;
                            this.printHead.x = 0.0f;
                            this.printBox = (Rectangle)var9_15.elementAt(var18_40);
                        }
                        this.elements = var12_23;
                        this.current = 0;
                        if (true) ** GOTO lbl135
                        do {
                            this.printHead.y = 0.0f;
                            this.printHead.x = 0.0f;
                            this.printBox = (Rectangle)var9_15.elementAt(++var18_40);
lbl135:
                            // 2 sources

                            v0 = this.printNextArea(var1_1);
                            var19_43 = (int)v0;
                        } while (v0 && var18_40 < var9_15.size() - 1);
                    }
                    ++var20_44;
                }
                this.printBox = var17_37;
                this.printHead = new Position(0.0f, var8_13.y + var5_6);
                if (var19_43 != 0 && this.printNextArea(var1_1) && (var22_51 = var16_34.indexOf(var21_46 = this.elements.elementAt(this.current))) >= 0) {
                    var15_30 = var22_51;
                }
                this.current = var15_30;
                this.elements = var16_34;
                continue;
            }
            var7_12 = this.current;
            while (var7_12 < var2_2) {
                var8_14 = 0;
                while (var7_12 < var2_2) {
                    var9_16 = (StyleCore.Element)this.elements.elementAt(var7_12);
                    var10_19 = var9_16.getAlignment() & 7;
                    if (var10_19 < var8_14 && !var9_16.isFlowControl() || var9_16.isNewline() && var7_12 > this.current) break;
                    if (var9_16.isLastOnLine()) {
                        ++var7_12;
                        break;
                    }
                    if (!var9_16.isFlowControl()) {
                        var8_14 = var10_19;
                    }
                    ++var7_12;
                }
                this.printHead.x = 0.0f;
                var9_17 = this.printHead.y;
                var10_20 = 0.0f;
                var11_22 = 0.0f;
                var12_24 = 0.0f;
                var13_26 = 0.0f;
                var14_28 = this.current;
                while (var14_28 < var7_12) {
                    var15_31 = (StyleCore.Element)this.elements.elementAt(var14_28);
                    var16_35 = var15_31.getPreferredSize();
                    if (!var15_31.isBreakable() && this.printHead.y + var16_35.height > (float)this.printBox.height) {
                        if (this.current == var7_12 - 1 && this.printHead.y == 0.0f) {
                            var1_1.addPaintable(new EmptyPaintable(this.printHead.x + (float)this.printBox.x, this.printHead.y + (float)this.printBox.y, var15_31));
                            ++this.current;
                        }
                        return true;
                    }
                    if (var14_28 == var4_5) {
                        var17_38 = (StyleCore.PainterElement)var15_31;
                        var18_42 = var17_38.getAnchor().x >= 0.0f ? var17_38.getAnchor().x * (float)this.resolution : var17_38.getAnchor().x * (float)this.resolution + (float)this.printBox.width;
                        var11_22 = var18_42 + var16_35.width;
                    } else {
                        var11_22 += var16_35.width;
                    }
                    if (var14_28 > var4_5 && this.printHead.x + var11_22 > (float)this.printBox.width && !(var15_31 instanceof StyleCore.TextElement)) {
                        var7_12 = Math.max(var15_31.isBreakable() != false ? var14_28 + 1 : var14_28, this.current + 1);
                    }
                    if (var14_28 < (var7_12 = Math.min(var7_12, this.elements.size()))) {
                        if ((var15_31.getAlignment() & 2) != 0) {
                            var12_24 += var16_35.width;
                        } else if ((var15_31.getAlignment() & 4) != 0) {
                            var13_26 += var16_35.width;
                        }
                        if (var15_31 instanceof StyleCore.PainterElement && (var17_38 = (StyleCore.PainterElement)var15_31).getAnchor() != null && var17_38.getAnchor().y < 0.0f) {
                            var16_35.height += -var17_38.getAnchor().y * (float)this.resolution;
                        }
                        var5_6 = Math.max(var5_6, var16_35.height);
                    }
                    ++var14_28;
                }
                var15_32 = this.printHead.x;
                var16_36 = Math.max(((float)this.printBox.width - var12_24) / 2.0f, 0.0f);
                var17_39 = Math.max((float)this.printBox.width - var13_26, 0.0f);
                var18_40 = var1_1.getPaintableCount();
                this.lastHead = new Position(this.printHead);
                var19_43 = this.current;
                while (var19_43 < var7_12) {
                    var20_45 = (StyleCore.Element)this.elements.elementAt(var19_43);
                    var21_48 = 0;
                    this.printHead.y = var9_17;
                    if ((var20_45.getAlignment() & 1) != 0 && var15_32 >= this.printHead.x) {
                        this.printHead.x = var15_32;
                        var21_48 = 0;
                    } else if ((var20_45.getAlignment() & 2) != 0 && var16_36 >= this.printHead.x) {
                        this.printHead.x = var16_36;
                        var21_48 = 1;
                    } else if ((var20_45.getAlignment() & 4) != 0 && var17_39 >= this.printHead.x) {
                        this.printHead.x = var17_39;
                        var21_48 = 2;
                    }
                    if (this.printHead.x >= (float)this.printBox.width) {
                        this.advance(0.0f, this.lineH);
                        var9_17 = this.printHead.y;
                        this.lineH = 0.0f;
                        var17_39 = 0.0f;
                        var16_36 = 0.0f;
                        var15_32 = 0.0f;
                    }
                    var22_52 = var1_1.getPaintableCount();
                    if (var20_45.print(var1_1)) {
                        this.current = var19_43;
                        return true;
                    }
                    if (var20_45 instanceof StyleCore.PainterElement) {
                        this.lastHead = new Position(this.printHead);
                    }
                    var10_20 = this.printHead.x;
                    switch (var21_48) {
                        case 0: {
                            var15_32 = this.printHead.x;
                            break;
                        }
                        case 1: {
                            var16_36 = this.printHead.x;
                            break;
                        }
                        case 2: {
                            var17_39 = this.printHead.x;
                            break;
                        }
                    }
                    if (this.advanceLine > 0.0f) {
                        var23_54 = var9_17;
                        var9_17 = this.printHead.y - this.advanceLine;
                        this.lineH = Math.max(var23_54 + this.lineH - var9_17, this.advanceLine);
                        this.alignLine(var18_40, var22_52 + 1, var1_1, this.lineH);
                        var18_40 = var1_1.getPaintableCount() - 1;
                    } else {
                        this.lineH = Math.max(this.lineH, this.printHead.y - var9_17);
                    }
                    ++var19_43;
                }
                this.alignLine(var18_40, var1_1.getPaintableCount(), var1_1, this.lineH);
                this.printHead.y = var9_17;
                this.printHead.x = var10_20;
                this.current = var7_12;
                if (this.lineH > 0.0f && this.current < this.elements.size() && !(this.elements.elementAt(this.current - 1) instanceof StyleCore.NewlineElement) && this.elements.elementAt(this.current) instanceof StyleCore.NewlineElement) {
                    var20_45 = (StyleCore.NewlineElement)this.elements.elementAt(this.current);
                    var20_45.skip();
                    if (var20_45.getRemain() <= 0) {
                        var21_49 = var20_45.getPreferredSize();
                        this.printHead.y += this.lineH - var21_49.height;
                        var20_45.print(var1_1);
                        this.printHead.y = var9_17;
                        ++this.current;
                    }
                }
                this.advance(0.0f, this.lineH);
            }
        }
        return this.current < this.elements.size();
    }

    private void processHF(Vector vector, int n, int n2, Date date) {
        int n3 = 0;
        while (n3 < vector.size()) {
            StyleCore.Element element = (StyleCore.Element)vector.elementAt(n3);
            element.reset();
            if (element instanceof StyleCore.TextElement) {
                String string = ((StyleCore.TextElement)element).getText();
                StyleSheet styleSheet = this;
                styleSheet.getClass();
                element = new StyleCore.HeaderTextElement(styleSheet, (StyleCore.TextElement)element, n, n2, date);
                vector.setElementAt(element, n3);
            }
            ++n3;
        }
    }

    public void removeContext(String string) {
        this.contexts.remove(string);
    }

    public void removeElement(int n) {
        this.elements.removeElementAt(n);
    }

    public void removeFooterElement(int n) {
        this.currFooter.removeElementAt(n);
    }

    public void removeFormat(Class clazz) {
        this.formatmap.remove(clazz);
    }

    public void removeHeaderElement(int n) {
        this.currHeader.removeElementAt(n);
    }

    public void removePageBreakListener(PageBreakListener pageBreakListener) {
        this.listeners.removeElement(pageBreakListener);
    }

    public void removePresenter(Class clazz) {
        this.presentermap.remove(clazz);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void reset() {
        this.current = 0;
        this.areas = null;
        if (!this.designtime) {
            this.overrideFooter = null;
            this.overrideHeader = null;
        }
        var1_1 = 0;
        while (var1_1 < this.headingCnt.length) {
            this.headingCnt[var1_1] = 0;
            ++var1_1;
        }
        var2_2 = 0;
        while (var2_2 < this.elements.size()) {
            ((StyleCore.Element)this.elements.elementAt(var2_2)).reset();
            ++var2_2;
        }
        var3_3 = new Vector[]{this.headerElements, this.footerElements, this.firstHeader, this.firstFooter, this.evenHeader, this.evenFooter, this.oddHeader, this.oddFooter};
        var4_4 = 0;
        while (var4_4 < var3_3.length) {
            if (var3_3[var4_4] != null) {
                var5_5 = 0;
                while (var5_5 < var3_3[var4_4].size()) {
                    ((StyleCore.Element)var3_3[var4_4].elementAt(var5_5)).reset();
                    ++var5_5;
                }
            }
            ++var4_4;
        }
        var5_6 = new Enumeration[]{this.elemHeader.elements(), this.elemFooter.elements()};
        var6_7 = 0;
        ** GOTO lbl39
        {
            var7_8 = (Vector)var5_6[var6_7].nextElement();
            var8_9 = 0;
            while (var8_9 < var7_8.size()) {
                ((StyleCore.Element)var7_8.elementAt(var8_9)).reset();
                ++var8_9;
            }
            do {
                if (var5_6[var6_7].hasMoreElements()) continue block4;
                ++var6_7;
lbl39:
                // 2 sources

            } while (var6_7 < var5_6.length);
        }
    }

    public void saveContext(String string) {
        this.contexts.put(string, new Context(this));
    }

    public void selectContext(String string) {
        Context context = (Context)this.contexts.get(string);
        if (context != null) {
            context.restore();
        }
    }

    public void setCurrentAlignment(int n) {
        this.alignment = n;
    }

    public void setCurrentBackground(Color color) {
        this.background = color;
    }

    public void setCurrentCellPadding(Insets insets) {
        this.padding = insets;
    }

    public void setCurrentFont(Font font) {
        this.font = font;
    }

    public void setCurrentFooter(int n) {
        switch (n) {
            case 512: {
                this.currFooter = this.footerElements;
                break;
            }
            case 513: {
                this.currFooter = this.firstFooter == null ? (this.firstFooter = new Vector()) : this.firstFooter;
                break;
            }
            case 514: {
                this.currFooter = this.evenFooter == null ? (this.evenFooter = new Vector()) : this.evenFooter;
                break;
            }
            case 515: {
                this.currFooter = this.oddFooter == null ? (this.oddFooter = new Vector()) : this.oddFooter;
                break;
            }
        }
    }

    public void setCurrentFooter(String string) {
        this.currFooter = (Vector)this.elemFooter.get(string);
        if (this.currFooter == null) {
            this.currFooter = new Vector();
            this.elemFooter.put(string, this.currFooter);
        }
    }

    public void setCurrentForeground(Color color) {
        this.foreground = color;
    }

    public void setCurrentHeader(int n) {
        switch (n) {
            case 256: {
                this.currHeader = this.headerElements;
                break;
            }
            case 257: {
                this.currHeader = this.firstHeader == null ? (this.firstHeader = new Vector()) : this.firstHeader;
                break;
            }
            case 258: {
                this.currHeader = this.evenHeader == null ? (this.evenHeader = new Vector()) : this.evenHeader;
                break;
            }
            case 259: {
                this.currHeader = this.oddHeader == null ? (this.oddHeader = new Vector()) : this.oddHeader;
                break;
            }
        }
    }

    public void setCurrentHeader(String string) {
        this.currHeader = (Vector)this.elemHeader.get(string);
        if (this.currHeader == null) {
            this.currHeader = new Vector();
            this.elemHeader.put(string, this.currHeader);
        }
    }

    public void setCurrentIndent(double d) {
        this.indent = d;
    }

    public void setCurrentJustify(boolean bl) {
        this.justify = bl;
    }

    public void setCurrentLineSpacing(int n) {
        this.spacing = n;
    }

    public void setCurrentOrphanControl(boolean bl) {
        this.orphan = bl;
    }

    public void setCurrentPainterLayout(int n) {
        this.painterLayout = n;
    }

    public void setCurrentPainterMargin(Insets insets) {
        this.painterMargin = insets;
    }

    public void setCurrentTabStops(double[] dArray) {
        this.tabStops = dArray;
    }

    public void setCurrentTableAdvance(int n) {
        this.tableadv = n;
    }

    public void setCurrentTableLayout(int n) {
        this.autosize = n;
    }

    public void setCurrentTableWidth(double d) {
        this.tableW = d;
    }

    public void setCurrentTextAdvance(int n) {
        this.textadv = n;
    }

    public void setCurrentWrapping(int n) {
        this.wrapping = n;
    }

    public void setFooterFromEdge(double d) {
        this.footerFromEdge = d;
    }

    public void setHeaderFromEdge(double d) {
        this.headerFromEdge = d;
    }

    public void setMargin(Margin margin) {
        this.margin = margin;
    }

    public void setPageAreas(PageArea[] pageAreaArray) {
        this.setPageAreas(pageAreaArray, null);
    }

    public void setPageAreas(PageArea[] pageAreaArray, ReportElement reportElement) {
        if (reportElement == null) {
            StyleSheet styleSheet = this;
            styleSheet.getClass();
            this.addElement(new StyleCore.PageLayoutElement((StyleCore)styleSheet, pageAreaArray));
        } else if (reportElement instanceof StyleCore.PageLayoutElement) {
            ((StyleCore.PageLayoutElement)reportElement).setPageAreas(pageAreaArray);
        } else {
            int n = this.getElementIndex(reportElement);
            StyleSheet styleSheet = this;
            styleSheet.getClass();
            this.insertElement(n, new StyleCore.PageLayoutElement((StyleCore)styleSheet, pageAreaArray));
        }
    }

    public void setPageColumns(int n) {
        this.setPageColumns(n, null);
    }

    public void setPageColumns(int n, ReportElement reportElement) {
        PageArea[] pageAreaArray = new PageArea[n];
        double d = 0.02;
        double d2 = (1.0 - d * ((double)n - 1.0)) / (double)n;
        int n2 = 0;
        while (n2 < pageAreaArray.length) {
            pageAreaArray[n2] = new PageArea((d + d2) * (double)n2, 0.0, d2, 1.0, true);
            ++n2;
        }
        this.setPageAreas(pageAreaArray, reportElement);
    }

    public void setPageNumberingStart(int n) {
        this.pgStart = n;
    }

    public static void setPrinterMargin(Margin margin) {
        StyleCore.g_pmargin = margin;
    }

    public void setProperty(String string, String string2) {
        ((Hashtable)this.prop).put(string, string2);
    }

    public void setVisible(String string, boolean bl) {
        ReportElement reportElement = this.getElement(string);
        if (reportElement != null) {
            reportElement.setVisible(bl);
        }
    }
}

