/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report;

import inetsoft.report.Common;
import inetsoft.report.Paintable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;

public class StylePage
implements Serializable {
    Dimension size;
    int resolution;
    Font font = new Font("Serif", 0, 10);
    Color color = Color.black;
    Vector items = new Vector();

    public StylePage(Dimension dimension, int n) {
        this.size = dimension;
        this.resolution = n;
    }

    public void addPaintable(Paintable paintable) {
        this.items.addElement(paintable);
    }

    public Font getFont() {
        return this.font;
    }

    public Color getForeground() {
        return this.color;
    }

    public Dimension getPageDimension() {
        return this.size;
    }

    public int getPageResolution() {
        return this.resolution;
    }

    public Paintable getPaintable(int n) {
        return (Paintable)this.items.elementAt(n);
    }

    public int getPaintableCount() {
        return this.items.size();
    }

    public void print(Graphics graphics) {
        Common.startPage(graphics, this);
        Rectangle rectangle = graphics.getClipBounds();
        int n = 0;
        while (n < this.items.size()) {
            Paintable paintable = (Paintable)this.items.elementAt(n);
            if (rectangle == null || rectangle.intersects(paintable.getBounds())) {
                paintable.paint(graphics);
            }
            ++n;
        }
    }

    public void removePaintable(int n) {
        this.items.removeElementAt(n);
    }

    public void reset() {
        this.items.removeAllElements();
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setForeground(Color color) {
        this.color = color;
    }

    public void setPageDimension(Dimension dimension) {
        this.size = dimension;
    }
}

