/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report;

import inetsoft.report.StyleConstants;
import java.awt.Font;
import java.util.StringTokenizer;

public class StyleFont
extends Font
implements StyleConstants {
    public static final int AWT_FONT_MASK = 3;
    public static final int STYLE_FONT_MASK = 65520;
    public static final int UNDERLINE = 16;
    public static final int STRIKETHROUGH = 32;
    public static final int SUPERSCRIPT = 64;
    public static final int SUBSCRIPT = 128;
    public static final int SHADOW = 256;
    public static final int SMALLCAPS = 512;
    public static final int ALLCAPS = 1024;
    private int extstyle;
    private int linetype = 4097;

    public StyleFont(Font font) {
        this(font.getName(), font.getStyle(), font.getSize(), font instanceof StyleFont ? ((StyleFont)font).getLineStyle() : 0);
    }

    public StyleFont(String string, int n, int n2) {
        super(string, n & 3, n2);
        this.extstyle = n;
    }

    public StyleFont(String string, int n, int n2, int n3) {
        this(string, n, n2);
        this.linetype = n3;
    }

    public static Font decode(String string) {
        String string2 = null;
        int n = 12;
        int n2 = 0;
        int n3 = 0;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (string.indexOf("PLAIN") >= 0) {
                n2 |= 0;
            }
            if (string.indexOf("BOLD") >= 0) {
                n2 |= 1;
            }
            if (string.indexOf("ITALIC") >= 0) {
                n2 |= 2;
            }
            if (string.indexOf("UNDERLINE") >= 0) {
                n2 |= 0x10;
            }
            if (string.indexOf("STRIKETHROUGH") >= 0) {
                n2 |= 0x20;
            }
            if (string.indexOf("SUPERSCRIPT") >= 0) {
                n2 |= 0x40;
            }
            if (string.indexOf("SUBSCRIPT") >= 0) {
                n2 |= 0x80;
            }
            if (string.indexOf("SHADOW") >= 0) {
                n2 |= 0x100;
            }
            if (string.indexOf("SMALLCAPS") >= 0) {
                n2 |= 0x200;
            }
            if (string.indexOf("ALLCAPS") >= 0) {
                n2 |= 0x400;
            }
            n = Integer.parseInt(stringTokenizer.nextToken());
            if ((n2 & 0x10) != 0 || (n2 & 0x20) != 0) {
                n3 = StyleFont.decodeLineStyle(stringTokenizer.nextToken());
            }
            if ((n2 & 0xFFF0) != 0) {
                return new StyleFont(string2, n2, n, n3);
            }
            return new Font(string2, n2, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static int decodeLineStyle(String string) {
        if (string.equals("NO_BORDER")) {
            return 0;
        }
        if (string.equals("THIN_LINE")) {
            return 4097;
        }
        if (string.equals("MEDIUM_LINE")) {
            return 4098;
        }
        if (string.equals("THICK_LINE")) {
            return 4099;
        }
        if (string.equals("DOUBLE_LINE")) {
            return 8195;
        }
        if (string.equals("RAISED_3D")) {
            return 24578;
        }
        if (string.equals("LOWERED_3D")) {
            return 40962;
        }
        if (string.equals("DOUBLE_3D_RAISED")) {
            return 24579;
        }
        if (string.equals("DOUBLE_3D_LOWERE")) {
            return 40963;
        }
        if (string.equals("DOT_LINE")) {
            return 4113;
        }
        if (string.equals("DASH_LINE")) {
            return 4145;
        }
        if (string.equals("MEDIUM_DASH")) {
            return 4193;
        }
        if (string.equals("LARGE_DASH")) {
            return 4241;
        }
        return Integer.decode(string);
    }

    public boolean equals(Object object) {
        if (object instanceof StyleFont) {
            StyleFont styleFont = (StyleFont)object;
            return this.extstyle == styleFont.extstyle && this.linetype == styleFont.linetype && super.equals(object);
        }
        if (object instanceof Font) {
            return (this.extstyle & 0xFFF0) == 0 && super.equals(object);
        }
        return false;
    }

    public int getLineStyle() {
        return this.linetype;
    }

    public int getStyle() {
        return this.extstyle;
    }

    public static String toString(Font font) {
        String string = String.valueOf(font.getName()) + "-";
        int n = font.getStyle();
        if (n == 0) {
            string = String.valueOf(string) + "PLAIN";
        }
        if ((n & 1) != 0) {
            string = String.valueOf(string) + "BOLD";
        }
        if ((n & 2) != 0) {
            string = String.valueOf(string) + "ITALIC";
        }
        if ((n & 0x10) != 0) {
            string = String.valueOf(string) + "UNDERLINE";
        }
        if ((n & 0x20) != 0) {
            string = String.valueOf(string) + "STRIKETHROUGH";
        }
        if ((n & 0x40) != 0) {
            string = String.valueOf(string) + "SUPERSCRIPT";
        }
        if ((n & 0x80) != 0) {
            string = String.valueOf(string) + "SUBSCRIPT";
        }
        if ((n & 0x100) != 0) {
            string = String.valueOf(string) + "SHADOW";
        }
        if ((n & 0x200) != 0) {
            string = String.valueOf(string) + "SMALLCAPS";
        }
        if ((n & 0x400) != 0) {
            string = String.valueOf(string) + "ALLCAPS";
        }
        string = String.valueOf(string) + "-" + font.getSize();
        if ((n & 0xFFF0) != 0) {
            string = String.valueOf(string) + "-" + ((StyleFont)font).getLineStyle();
        }
        return string;
    }
}

