/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report;

import inetsoft.report.Common;
import inetsoft.report.PreviewPane;
import inetsoft.report.PreviewView;
import inetsoft.report.StyleSheet;
import inetsoft.report.event.SelectionListener;
import inetsoft.report.internal.PagesMenu;
import inetsoft.report.internal.ToolBar;
import inetsoft.report.internal.ToolButton;
import inetsoft.report.internal.ToolTip;
import inetsoft.report.internal.Util;
import inetsoft.report.io.Builder;
import inetsoft.report.locale.Catalog;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;

public class Previewer
extends Frame
implements PreviewView,
ActionListener {
    ItemListener zoomListener = new ItemListener(){

        public void itemStateChanged(ItemEvent itemEvent) {
            int n = Previewer.this.zoomChoice.getSelectedIndex();
            if (n >= 0) {
                Previewer.this.pane.zoom(zoomperc[n]);
            }
        }
    };
    StyleSheet sheet;
    PreviewPane pane;
    ToolButton pgcombo;
    PagesMenu menu = null;
    Dimension psize;
    Choice zoomChoice;
    PrintJob printjob;
    boolean exitit = false;
    static final String[] zoomname = new String[]{Catalog.getString("500%"), Catalog.getString("200%"), Catalog.getString("150%"), Catalog.getString("100%"), Catalog.getString("75%"), Catalog.getString("50%"), Catalog.getString("25%"), Catalog.getString("10%"), Catalog.getString("Page Width"), Catalog.getString("Whole Page"), Catalog.getString("Two Pages")};
    static final double[] zoomperc = new double[]{5.0, 2.0, 1.5, 1.0, 0.75, 0.5, 0.25, 0.1, -1.0, -2.0, -3.0};

    public Previewer() {
        this(Catalog.getString("Print Preview"));
    }

    public Previewer(String string) {
        super(string);
        this.setLayout(new BorderLayout());
        ToolBar toolBar = new ToolBar();
        ToolButton toolButton = new ToolButton("/inetsoft/report/images/printer.gif", Catalog.getString("Print"));
        toolBar.add(toolButton);
        ToolTip.getToolTip().put(toolButton, Catalog.getString("Print"));
        toolButton.addActionListener(this);
        toolBar.add(new ToolBar.Separator());
        toolButton = new ToolButton("/inetsoft/report/images/onepage.gif", Catalog.getString("One Page"));
        toolBar.add(toolButton);
        ToolTip.getToolTip().put(toolButton, Catalog.getString("One Page"));
        toolButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Previewer.this.zoomChoice.select(Catalog.getString("Whole Page"));
                Previewer.this.zoomListener.itemStateChanged(null);
            }
        });
        this.pgcombo = new ToolButton("/inetsoft/report/images/npage.gif", Catalog.getString("Multi-Pages"));
        toolBar.add(this.pgcombo);
        ToolTip.getToolTip().put(this.pgcombo, Catalog.getString("Multiple Pages"));
        this.pgcombo.setToggle(true);
        this.pgcombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Previewer.this.pgcombo.getState()) {
                    Previewer.this.menu = new PagesMenu(Previewer.this);
                    Point point = Previewer.this.pgcombo.getLocationOnScreen();
                    point.y += Previewer.this.pgcombo.getSize().height;
                    Previewer.this.menu.pack();
                    ((Component)Previewer.this.menu).setLocation(point);
                    ((Component)Previewer.this.menu).setVisible(true);
                    ((Component)Previewer.this.menu).setLocation(point);
                    Previewer.this.menu.addWindowListener(new WindowAdapter(Previewer.this){
                        private final /* synthetic */ Previewer this$0;
                        {
                            this.this$0 = previewer;
                        }

                        public void windowClosed(WindowEvent windowEvent) {
                            this.this$0.menu = null;
                            this.this$0.pgcombo.setState(false);
                        }
                    });
                    Previewer.this.menu.addActionListener(new ActionListener(Previewer.this){
                        private final /* synthetic */ Previewer this$0;
                        {
                            this.this$0 = previewer;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            this.this$0.setPages(this.this$0.menu.getRows(), this.this$0.menu.getCols());
                            this.this$0.menu.dispose();
                            this.this$0.menu = null;
                        }
                    });
                } else if (Previewer.this.menu != null) {
                    Previewer.this.menu.dispose();
                    Previewer.this.menu = null;
                }
            }
        });
        toolBar.add(new ToolBar.Separator());
        this.zoomChoice = new Choice();
        toolBar.add(this.zoomChoice);
        int n = 0;
        while (n < zoomname.length) {
            this.zoomChoice.add(zoomname[n]);
            ++n;
        }
        this.zoomChoice.select(Catalog.getString("100%"));
        ToolTip.getToolTip().put(this.zoomChoice, Catalog.getString("Zoom"));
        this.zoomChoice.addItemListener(this.zoomListener);
        toolBar.add(new ToolBar.Separator());
        toolButton = new ToolButton("/inetsoft/report/images/fullscr.gif", Catalog.getString("Full Screen"));
        toolBar.add(toolButton);
        ToolTip.getToolTip().put(toolButton, Catalog.getString("Full Screen"));
        toolButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Previewer.this.psize = Toolkit.getDefaultToolkit().getScreenSize();
                Previewer.this.pack();
                ((Component)Previewer.this).setLocation(0, 0);
            }
        });
        toolBar.add(new ToolBar.Separator());
        toolButton = new ToolButton(null, Catalog.getString("Close"));
        toolBar.add(toolButton);
        ToolTip.getToolTip().put(toolButton, Catalog.getString("Close Preview"));
        toolButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Previewer.this.dispose();
            }
        });
        this.add((Component)toolBar, "North");
        this.pane = this.createPane();
        this.add((Component)this.pane, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Previewer.this.dispose();
            }
        });
        Util.registerKeyListener(this, this.pane.scrollListener);
        this.addNotify();
    }

    public Previewer(String string, int n, int n2) {
        this(string);
        this.psize = new Dimension(n, n2);
    }

    public Previewer(String string, PrintJob printJob, boolean bl) {
        this(string, bl);
        this.printjob = printJob;
        Dimension dimension = printJob.getPageDimension();
        this.setPageWidth((double)dimension.width / 72.0);
        this.setPageHeight((double)dimension.height / 72.0);
        this.setPageResolution(72);
    }

    public Previewer(String string, boolean bl) {
        this(string);
        if (bl) {
            this.zoomChoice.select(Catalog.getString("Whole Page"));
            this.zoomListener.itemStateChanged(null);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.printAction();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.pane.addSelectionListener(selectionListener);
    }

    protected PreviewPane createPane() {
        return new PreviewPane();
    }

    public static PreviewView createPreviewer() {
        return Common.getPreviewView();
    }

    public void dispose() {
        if (this.exitit) {
            System.exit(0);
        }
        super.dispose();
    }

    public int getOrientation() {
        return this.pane.getOrientation();
    }

    public double getPageHeight() {
        return this.pane.getPageHeight();
    }

    public int getPageResolution() {
        return this.pane.getPageResolution();
    }

    public double getPageWidth() {
        return this.pane.getPageWidth();
    }

    public Dimension getPreferredSize() {
        if (this.psize != null) {
            return this.psize;
        }
        Dimension dimension = new Dimension(this.getToolkit().getScreenSize());
        dimension.width = Math.min(dimension.width, 800);
        dimension.height = Math.min(dimension.height, 800);
        return dimension;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: java inetsoft.report.Previewer report");
            System.exit(1);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            Builder builder = Builder.getBuilder(2, fileInputStream);
            StyleSheet styleSheet = builder.read(".");
            Previewer previewer = new Previewer();
            previewer.setExitOnClose(true);
            previewer.pack();
            ((Component)previewer).setVisible(true);
            previewer.print(styleSheet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void print(StyleSheet styleSheet) {
        this.sheet = styleSheet;
        this.pane.print(this.sheet);
    }

    public void printAction() {
        if (this.sheet == null) {
            return;
        }
        PrintJob printJob = this.printjob;
        if (printJob == null) {
            printJob = this.getToolkit().getPrintJob(this, Catalog.getString("Previewer"), null);
        }
        if (printJob == null) {
            return;
        }
        final PrintJob printJob2 = printJob;
        new Thread(){

            public void run() {
                pane.showStatus(String.valueOf(Catalog.getString("Printing")) + "...");
                sheet.print(printJob2);
                printJob2.end();
                Dimension dimension = printJob2.getPageDimension();
                if ((double)dimension.width != this.getPageWidth() || (double)dimension.height != this.getPageHeight()) {
                    sheet.reset();
                    this.print(sheet);
                }
                pane.showStatus("");
            }
        }.start();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.pane.removeSelectionListener(selectionListener);
    }

    public void setExitOnClose(boolean bl) {
        this.exitit = bl;
    }

    public void setOrientation(int n) {
        this.pane.setOrientation(n);
    }

    public void setPageHeight(double d) {
        this.pane.setPageHeight(d);
    }

    public void setPageResolution(int n) {
        this.pane.setPageResolution(n);
    }

    public void setPageWidth(double d) {
        this.pane.setPageWidth(d);
    }

    public void setPages(int n, int n2) {
        this.pane.setPages(n, n2);
    }

    public void setPreferredSize(Dimension dimension) {
        this.psize = new Dimension(dimension);
    }

    public void update(Graphics graphics) {
        ((Container)this).paint(graphics);
    }

    public void zoom(double d) {
        this.pane.zoom(d);
        int n = 0;
        while (n < zoomperc.length) {
            if (Math.abs(zoomperc[n] - d) < 0.05) {
                this.zoomChoice.select(n);
                break;
            }
            ++n;
        }
    }
}

