/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report;

import inetsoft.report.ChartLens;
import inetsoft.report.ChartPainter;
import inetsoft.report.Margin;
import inetsoft.report.Paintable;
import inetsoft.report.PreviewPage;
import inetsoft.report.ReportElement;
import inetsoft.report.SContainer;
import inetsoft.report.Size;
import inetsoft.report.StylePage;
import inetsoft.report.StyleSheet;
import inetsoft.report.event.SelectionEvent;
import inetsoft.report.event.SelectionListener;
import inetsoft.report.internal.PainterPaintable;
import inetsoft.report.internal.PaperSize;
import inetsoft.report.internal.StyleCore;
import inetsoft.report.internal.TablePaintable;
import inetsoft.report.internal.TextPaintable;
import inetsoft.report.internal.TextPainter;
import inetsoft.report.internal.Util;
import inetsoft.report.io.Builder;
import inetsoft.report.locale.Catalog;
import inetsoft.report.pScrollPane;
import inetsoft.report.painter.ComponentPainter;
import inetsoft.report.painter.ImagePainter;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.Vector;

public class PreviewPane
extends SContainer {
    public static final int PAGE_WIDTH = -1;
    public static final int WHOLE_PAGE = -2;
    public static final int TWO_PAGES = -3;
    Vector listeners = new Vector();
    KeyListener scrollListener = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            Adjustable adjustable = PreviewPane.this.getVAdjustable();
            switch (keyEvent.getKeyCode()) {
                case 33: {
                    adjustable.setValue(adjustable.getValue() - PreviewPane.this.getBlockIncrement(adjustable));
                    break;
                }
                case 34: {
                    adjustable.setValue(adjustable.getValue() + PreviewPane.this.getBlockIncrement(adjustable));
                    break;
                }
                case 38: {
                    adjustable.setValue(adjustable.getValue() - adjustable.getUnitIncrement());
                    break;
                }
                case 40: {
                    adjustable.setValue(adjustable.getValue() + adjustable.getUnitIncrement());
                    break;
                }
                case 83: {
                    Window window;
                    if (keyEvent.isControlDown() && keyEvent.isShiftDown() && keyEvent.isAltDown()) {
                        window = new FileDialog(Util.findFrame(PreviewPane.this), Catalog.getString("Save Report"), 1);
                        ((Component)window).setVisible(true);
                        if (((FileDialog)window).getFile() != null) {
                            try {
                                String string = String.valueOf(((FileDialog)window).getDirectory()) + ((FileDialog)window).getFile();
                                FileOutputStream fileOutputStream = new FileOutputStream(string);
                                Builder builder = Builder.getBuilder(2, fileOutputStream);
                                builder.write(PreviewPane.this.sheet);
                                fileOutputStream.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
                case 115: {
                    Window window;
                    if (!keyEvent.isAltDown() || (window = Util.findWindow(PreviewPane.this)) == null) break;
                    window.dispose();
                }
            }
            ((Component)((Object)adjustable)).dispatchEvent(new AdjustmentEvent(adjustable, 601, 0, adjustable.getValue()));
        }
    };
    AdjustmentListener pagingListener = new AdjustmentListener(){

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Adjustable adjustable = adjustmentEvent.getAdjustable();
            PreviewPane.this.pgnum = adjustable.getValue() * PreviewPane.this.getPageCount() / adjustable.getMaximum() + 1;
            PreviewPane.this.showPageNumber(PreviewPane.this.pgnum);
        }
    };
    Container pages = new SContainer(true);
    GridLayout grid = new GridLayout(0, 1, 10, 10);
    double pageWidth = 8.5;
    double pageHeight = 11.0;
    int resolution = 72;
    int pgnum = 1;
    int numpage = 1;
    boolean ruler = false;
    double zoomperc = 1.0;
    int orientation = 1;
    StatusScrollPane scroller;
    Margin pmargin = StyleSheet.getPrinterMargin();
    protected StyleSheet sheet = null;
    protected Container scrollpane;
    static final int margin = 20;

    public PreviewPane() {
        this.setLayout(new BorderLayout());
        this.scrollpane = this.createScrollPane();
        this.addKeyListener(this.scrollListener);
        this.scrollpane.addKeyListener(this.scrollListener);
        this.getVAdjustable().addAdjustmentListener(this.pagingListener);
        SContainer sContainer = new SContainer(true);
        sContainer.setLayout(new FlowLayout());
        this.pages.setLayout(this.grid);
        sContainer.add(this.pages);
        this.add((Component)this.scrollpane, "Center");
        this.addToScrollPane(sContainer);
        this.getViewport().setBackground(new Color(150, 150, 150));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.listeners.addElement(selectionListener);
    }

    protected void addToScrollPane(Component component) {
        this.scrollpane.add(component);
    }

    protected PreviewPage createPage(double d, double d2, int n) {
        return new PreviewPage(d, d2, n);
    }

    protected Container createScrollPane() {
        this.scroller = new StatusScrollPane();
        this.scroller.bar.pageB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPane.this.gotoPage();
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PreviewPane.this.requestFocus();
            }
        };
        this.scroller.bar.pageB.addMouseListener(mouseAdapter);
        this.scroller.bar.sizeB.addMouseListener(mouseAdapter);
        this.scroller.bar.statusF.addMouseListener(mouseAdapter);
        return this.scroller;
    }

    public void fireSelectionChange(Object object, String string, Object object2, MouseEvent mouseEvent) {
        try {
            Vector vector = (Vector)this.listeners.clone();
            SelectionEvent selectionEvent = new SelectionEvent(object == null ? string : object, string, object2, mouseEvent.getClickCount(), mouseEvent);
            int n = vector.size() - 1;
            while (n >= 0) {
                ((SelectionListener)vector.elementAt(n)).valueChanged(selectionEvent);
                --n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected int getBlockIncrement(Adjustable adjustable) {
        return adjustable.getBlockIncrement();
    }

    public Adjustable getHAdjustable() {
        return ((pScrollPane)this.scrollpane).getHAdjustable();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public PreviewPage getPage(int n) {
        return ((RulerContainer)this.pages.getComponent(n)).getPreviewPage();
    }

    public int getPageCount() {
        return this.numpage;
    }

    public double getPageHeight() {
        return this.pageHeight;
    }

    public int getPageNumber() {
        return this.pgnum;
    }

    public int getPageResolution() {
        return this.resolution;
    }

    public double getPageWidth() {
        return this.pageWidth;
    }

    public KeyListener getScrollListener() {
        return this.scrollListener;
    }

    public Container getScrollPane() {
        return this.scrollpane;
    }

    public Adjustable getVAdjustable() {
        return ((pScrollPane)this.scrollpane).getVAdjustable();
    }

    protected Container getViewport() {
        return ((pScrollPane)this.scrollpane).getViewport();
    }

    public Dimension getViewportSize() {
        return ((pScrollPane)this.scrollpane).getViewportSize();
    }

    public void gotoPage() {
        final Dialog dialog = new Dialog(Util.findFrame(this), Catalog.getString("Go To Page"));
        final TextField textField = new TextField(8);
        dialog.setLayout(new BorderLayout(20, 20));
        dialog.add(new Component(){}, "North");
        Panel panel = new Panel();
        panel.add(new Label(String.valueOf(Catalog.getString("Page")) + ":"));
        panel.add(textField);
        panel.add(new Label(String.valueOf(Catalog.getString("of")) + " " + this.getPageCount()));
        dialog.add((Component)panel, "Center");
        panel = new Panel();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    this.gotoPage(Integer.parseInt(textField.getText()));
                    dialog.dispose();
                }
                catch (NumberFormatException numberFormatException) {
                    textField.setText("");
                }
            }
        };
        Button button = new Button("     " + Catalog.getString("OK") + "     ");
        button.addActionListener(actionListener);
        panel.add(button);
        button = new Button("   " + Catalog.getString("Cancel") + "   ");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dialog.dispose();
            }
        });
        panel.add(button);
        dialog.add((Component)panel, "South");
        ((TextComponent)textField).setText(String.valueOf(this.pgnum));
        textField.selectAll();
        textField.addActionListener(actionListener);
        Point point = this.getLocationOnScreen();
        Dimension dimension = this.getSize();
        ((Component)dialog).setLocation(point.x + dimension.width / 2 - 100, point.y + dimension.height / 2 - 80);
        dialog.setModal(true);
        dialog.pack();
        ((Component)dialog).setVisible(true);
    }

    public void gotoPage(int n) {
        this.pgnum = n;
        Adjustable adjustable = this.getVAdjustable();
        adjustable.setValue((n - 1) * adjustable.getMaximum() / this.getPageCount());
        this.syncScrollPane();
        this.showPageNumber(this.pgnum);
    }

    public boolean isShowRuler() {
        return this.ruler;
    }

    public void print(StyleSheet styleSheet) {
        this.sheet = styleSheet;
        Size size = PaperSize.getSize(styleSheet.getProperty("PageSize"));
        int n = PaperSize.getOrientation(styleSheet.getProperty("Orientation"));
        if (size != null) {
            this.setOrientation(n);
            this.setPageWidth(n == 1 ? size.width : size.height);
            this.setPageHeight(n == 1 ? size.height : size.width);
        }
        int n2 = this.pages.getComponentCount() - 1;
        while (n2 >= 0) {
            this.pages.remove(n2);
            --n2;
        }
        StyleSheet styleSheet2 = styleSheet;
        synchronized (styleSheet2) {
            Vector<StylePage> vector = new Vector<StylePage>();
            styleSheet.reset();
            try {
                boolean bl;
                do {
                    PreviewPage previewPage = this.createPage(this.pageWidth, this.pageHeight, this.resolution);
                    previewPage.setPageIndex(vector.size());
                    previewPage.addMouseListener(new MListener(previewPage));
                    this.pages.add(new RulerContainer(previewPage));
                    previewPage.addKeyListener(this.scrollListener);
                    bl = styleSheet.printNext(previewPage.getStylePage());
                    vector.addElement(previewPage.getStylePage());
                } while (bl);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                outOfMemoryError.printStackTrace();
            }
            int n3 = styleSheet.getPageNumberingStart();
            Date date = new Date();
            int n4 = 0;
            while (n4 < vector.size()) {
                StylePage stylePage = (StylePage)vector.elementAt(n4);
                styleSheet.printHeaderFooter(stylePage, n4, n4 - n3 + 1, vector.size() - n3, date);
                ++n4;
            }
            this.numpage = vector.size();
        }
        if (this.zoomperc == 1.0) {
            this.validate();
        } else {
            this.zoom(this.zoomperc);
        }
        this.pgnum = 1;
        this.showPageNumber(1);
        this.repaint();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.listeners.removeElement(selectionListener);
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    protected void setPageCount(int n) {
        int n2 = this.pages.getComponentCount() - 1;
        while (n2 >= 0) {
            this.pages.remove(n2);
            --n2;
        }
        int n3 = 0;
        while (n3 < n) {
            PreviewPage previewPage = this.createPage(this.pageWidth, this.pageHeight, this.resolution);
            previewPage.setPageIndex(n3);
            previewPage.addMouseListener(new MListener(previewPage));
            this.pages.add(new RulerContainer(previewPage));
            previewPage.addKeyListener(this.scrollListener);
            ++n3;
        }
        this.numpage = n;
    }

    public void setPageHeight(double d) {
        this.pageHeight = d;
        this.showPageSize(new Size(this.pageWidth, this.pageHeight));
    }

    public void setPageResolution(int n) {
        this.resolution = n;
    }

    public void setPageSize(Size size) {
        this.pageWidth = size.width;
        this.pageHeight = size.height;
        this.showPageSize(size);
    }

    public void setPageWidth(double d) {
        this.pageWidth = d;
        this.showPageSize(new Size(this.pageWidth, this.pageHeight));
    }

    public void setPages(int n, int n2) {
        Dimension dimension = this.getViewportSize();
        dimension.width -= 40;
        dimension.height -= 40;
        double d = -1.0;
        int n3 = 0;
        while (n3 < this.pages.getComponentCount()) {
            PreviewPage previewPage = ((RulerContainer)this.pages.getComponent(n3)).getPreviewPage();
            if (d < 0.0) {
                Dimension dimension2 = previewPage.getPageSize();
                d = (double)dimension.width / (double)dimension2.width / (double)n2;
                d = Math.min(d, (double)dimension.height / (double)dimension2.height / (double)n);
            }
            previewPage.setZoom(d);
            ++n3;
        }
        this.grid.setColumns(n2);
        this.validate();
    }

    public void setShowRuler(boolean bl) {
        this.ruler = bl;
        this.repaint();
    }

    public void showPageNumber(int n) {
        this.scroller.bar.pageB.setLabel(String.valueOf(Catalog.getString("Page")) + " " + n + " " + Catalog.getString("of") + " " + this.getPageCount());
    }

    public void showPageSize(Size size) {
        this.scroller.bar.sizeB.setLabel(String.valueOf(size.width) + " x " + size.height + " in");
    }

    public void showStatus(String string) {
        this.scroller.bar.statusF.setLabel(string);
    }

    protected void syncScrollPane() {
        ((pScrollPane)this.scrollpane).sync();
    }

    public void zoom(double d) {
        this.zoomperc = d;
        this.grid.setColumns(1);
        int n = 0;
        while (n < this.pages.getComponentCount()) {
            PreviewPage previewPage = ((RulerContainer)this.pages.getComponent(n)).getPreviewPage();
            if (d < 0.0) {
                Dimension dimension = this.getViewportSize();
                dimension.width -= 40;
                dimension.height -= 40;
                Dimension dimension2 = previewPage.getPageSize();
                if (d == -1.0) {
                    d = (double)dimension.width / (double)dimension2.width;
                } else if (d == -2.0) {
                    d = (double)dimension.height / (double)dimension2.height;
                } else if (d == -3.0) {
                    this.setPages(1, 2);
                    return;
                }
            }
            previewPage.setZoom(d);
            ++n;
        }
        this.validate();
    }

    class Holder
    extends Component {
        private Dimension psize;

        public Holder(int n, int n2) {
            this.psize = new Dimension(n, n2);
        }

        public Dimension getPreferredSize() {
            return this.psize;
        }
    }

    class RulerContainer
    extends Container {
        PreviewPage page;

        public RulerContainer(PreviewPage previewPage) {
            this.setLayout(new FlowLayout(1, 20, 20));
            this.page = previewPage;
            this.add(this.page);
        }

        public PreviewPage getPreviewPage() {
            return this.page;
        }

        public void paint(Graphics graphics) {
            if (PreviewPane.this.ruler) {
                Dimension dimension = this.getSize();
                Rectangle rectangle = this.page.getBounds();
                Size size = this.page.getPageSizeInch();
                graphics.setColor(Color.lightGray);
                graphics.fillRect(0, 0, 20, rectangle.y + rectangle.height);
                graphics.fillRect(0, 0, rectangle.x + rectangle.width, 20);
                graphics.setColor(new Color(40, 40, 40));
                double d = (float)rectangle.height / size.height;
                int n = 0;
                double d2 = 0.0;
                while (d2 < (double)size.height) {
                    int n2 = 5;
                    n2 = n % 16 == 0 ? 5 : (n % 8 == 0 ? 10 : (n % 4 == 0 ? 8 : (n % 2 == 0 ? 6 : 3)));
                    ++n;
                    int n3 = rectangle.y + (int)(d2 * d);
                    graphics.drawLine(0, n3, n2, n3);
                    if (n2 == 5) {
                        FontMetrics fontMetrics = graphics.getFontMetrics();
                        graphics.drawString(Integer.toString(n / 16), n2 + 1, n3 + (fontMetrics.getAscent() - fontMetrics.getDescent()) / 2);
                    }
                    d2 += 0.0625;
                }
                n = 0;
                double d3 = 0.0;
                while (d3 < (double)size.width) {
                    int n4 = 5;
                    n4 = n % 16 == 0 ? 5 : (n % 8 == 0 ? 10 : (n % 4 == 0 ? 8 : (n % 2 == 0 ? 6 : 3)));
                    ++n;
                    int n5 = rectangle.x + (int)(d3 * d);
                    graphics.drawLine(n5, 0, n5, n4);
                    if (n4 == 5) {
                        FontMetrics fontMetrics = graphics.getFontMetrics();
                        String string = Integer.toString(n / 16);
                        graphics.drawString(string, n5 - fontMetrics.stringWidth(string) / 2, n4 + fontMetrics.getAscent());
                    }
                    d3 += 0.0625;
                }
            }
            super.paint(graphics);
        }
    }

    class MListener
    extends MouseAdapter {
        PreviewPage pg;

        public MListener(PreviewPage previewPage) {
            this.pg = previewPage;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            StylePage stylePage = this.pg.getStylePage();
            if (PreviewPane.this.listeners.size() > 0 && stylePage != null) {
                int n = 0;
                while (n < stylePage.getPaintableCount()) {
                    int n2;
                    int n3;
                    Paintable paintable = stylePage.getPaintable(n);
                    Rectangle rectangle = paintable.getBounds();
                    if (rectangle.contains(n3 = mouseEvent.getX() - (int)(PreviewPane.this.pmargin.left * (double)PreviewPane.this.resolution), n2 = mouseEvent.getY() - (int)(PreviewPane.this.pmargin.top * (double)PreviewPane.this.resolution))) {
                        Cloneable cloneable;
                        Object object;
                        ReportElement reportElement = paintable.getElement();
                        if (reportElement.getType().equals("Chart")) {
                            object = (ChartPainter)((PainterPaintable)paintable).getPainter();
                            cloneable = ((ChartPainter)object).locate(n3 - rectangle.x, n2 - rectangle.y);
                            ChartLens chartLens = null;
                            try {
                                chartLens = ((StyleCore.ChartElement)reportElement).getChart();
                            }
                            catch (Exception exception) {}
                            if (cloneable != null) {
                                PreviewPane.this.fireSelectionChange(chartLens, reportElement.getID(), cloneable, mouseEvent);
                            }
                        } else if (reportElement.getType().equals("Table")) {
                            object = ((TablePaintable)paintable).locate(n3, n2);
                            cloneable = null;
                            try {
                                cloneable = ((StyleCore.TableElement)reportElement).getTable();
                            }
                            catch (Exception exception) {}
                            if (object != null) {
                                PreviewPane.this.fireSelectionChange(cloneable, reportElement.getID(), object, mouseEvent);
                            }
                        } else if (reportElement.getType().equals("Text")) {
                            object = ((TextPaintable)paintable).getText();
                            cloneable = null;
                            try {
                                cloneable = ((StyleCore.TextElement)reportElement).getTextLens();
                            }
                            catch (Exception exception) {}
                            PreviewPane.this.fireSelectionChange(cloneable, reportElement.getID(), object, mouseEvent);
                        } else if (reportElement.getType().equals("TextBox")) {
                            object = (TextPainter)((PainterPaintable)paintable).getPainter();
                            PreviewPane.this.fireSelectionChange(((TextPainter)object).getTextLens(), reportElement.getID(), ((TextPainter)object).getText(), mouseEvent);
                        } else if (reportElement.getType().equals("Painter")) {
                            object = ((PainterPaintable)paintable).getPainter();
                            if (object instanceof ComponentPainter) {
                                PreviewPane.this.fireSelectionChange(object, reportElement.getID(), ((ComponentPainter)object).getComponent(), mouseEvent);
                            } else if (object instanceof ImagePainter) {
                                PreviewPane.this.fireSelectionChange(object, reportElement.getID(), ((ImagePainter)object).getImage(), mouseEvent);
                            } else {
                                PreviewPane.this.fireSelectionChange(object, reportElement.getID(), object, mouseEvent);
                            }
                        }
                    }
                    ++n;
                }
            }
        }
    }

    protected class StatusScrollPane
    extends pScrollPane {
        StatusScrollBar bar;

        public StatusScrollPane() {
            this.setForce(true);
        }

        public Adjustable createHorizontalScrollBar() {
            this.bar = new StatusScrollBar();
            return this.bar;
        }
    }

    protected class StatusScrollBar
    extends Container
    implements Adjustable {
        Scrollbar scrollbar = new Scrollbar(0);
        Button pageB;
        Button sizeB;
        Button statusF;

        public StatusScrollBar() {
            this.setLayout(new BorderLayout());
            this.pageB = new SmallButton("Page 1 of 1");
            this.sizeB = new SmallButton("8.5 x 11 in");
            this.statusF = new StatusButton();
            Container container = new Container(){};
            container.setLayout(new BorderLayout());
            container.add((Component)this.pageB, "West");
            container.add((Component)this.sizeB, "Center");
            container.add((Component)this.statusF, "East");
            this.add((Component)container, "West");
            this.add((Component)this.scrollbar, "Center");
        }

        public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
            this.scrollbar.addAdjustmentListener(adjustmentListener);
        }

        public boolean equals(Object object) {
            return object instanceof Scrollbar ? object == this.scrollbar : super.equals(object);
        }

        public int getBlockIncrement() {
            return this.scrollbar.getBlockIncrement();
        }

        public int getBlockIncrement(int n) {
            return this.scrollbar.getBlockIncrement();
        }

        public int getMaximum() {
            return this.scrollbar.getMaximum();
        }

        public int getMinimum() {
            return this.scrollbar.getMinimum();
        }

        public int getOrientation() {
            return this.scrollbar.getOrientation();
        }

        public int getUnitIncrement() {
            return this.scrollbar.getUnitIncrement();
        }

        public int getUnitIncrement(int n) {
            return this.scrollbar.getUnitIncrement();
        }

        public int getValue() {
            return this.scrollbar.getValue();
        }

        public int getVisibleAmount() {
            return this.scrollbar.getVisibleAmount();
        }

        public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
            this.scrollbar.removeAdjustmentListener(adjustmentListener);
        }

        public void setBlockIncrement(int n) {
            this.scrollbar.setBlockIncrement(n);
        }

        public void setEnabled(boolean bl) {
            this.scrollbar.setEnabled(bl);
        }

        public void setMaximum(int n) {
            this.scrollbar.setMaximum(n);
        }

        public void setMinimum(int n) {
            this.scrollbar.setMinimum(n);
        }

        public void setOrientation(int n) {
            this.scrollbar.setOrientation(n);
        }

        public void setUnitIncrement(int n) {
            this.scrollbar.setUnitIncrement(n);
        }

        public void setValue(int n) {
            this.scrollbar.setValue(n);
        }

        public void setVisibleAmount(int n) {
            this.scrollbar.setVisibleAmount(n);
        }

        class StatusButton
        extends Button {
            StatusButton() {
                this.setFont(new Font("Serif", 0, 10));
            }

            public float getAlignmentY() {
                return StatusScrollBar.this.scrollbar.getAlignmentY();
            }

            public Dimension getMaximumSize() {
                return new Dimension(120, StatusScrollBar.this.scrollbar.getMaximumSize().height);
            }

            public Dimension getMinimumSize() {
                return new Dimension(120, StatusScrollBar.this.scrollbar.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(120, StatusScrollBar.this.scrollbar.getPreferredSize().height);
            }
        }

        class SmallButton
        extends Button {
            public SmallButton(String string) {
                super(string);
                this.setFont(new Font("Serif", 0, 10));
            }

            public float getAlignmentY() {
                return StatusScrollBar.this.scrollbar.getAlignmentY();
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, StatusScrollBar.this.scrollbar.getMaximumSize().height);
            }

            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, StatusScrollBar.this.scrollbar.getMinimumSize().height);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width + 20, StatusScrollBar.this.scrollbar.getPreferredSize().height);
            }
        }
    }
}

