/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report;

import inetsoft.report.Size;
import inetsoft.report.StylePage;
import inetsoft.report.StyleSheet;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class PreviewPage
extends Container {
    StylePage page;
    double winch;
    double hinch;
    Dimension pgsize;
    boolean drawBorder = true;
    double percent = 1.0;
    int resolution;
    int index = 0;
    public static Image buffer = null;
    public static Dimension bSize = new Dimension(-1, -1);

    public PreviewPage(double d, double d2) {
        this(d, d2, 72);
    }

    public PreviewPage(double d, double d2, int n) {
        this.winch = d;
        this.hinch = d2;
        this.resolution = n;
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.pgsize = new Dimension((int)(d * (double)n), (int)(d2 * (double)n));
        this.page = new StylePage(this.pgsize, n);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PreviewPage.this.requestFocus();
            }
        });
    }

    public PreviewPage(PrintJob printJob) {
        this((double)printJob.getPageDimension().width / 72.0, (double)printJob.getPageDimension().height / 72.0, 72);
    }

    public int getPageIndex() {
        return this.index;
    }

    public Dimension getPageSize() {
        return this.pgsize;
    }

    public Size getPageSizeInch() {
        return new Size((float)this.winch, (float)this.hinch);
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)((double)this.pgsize.width * this.percent), (int)((double)this.pgsize.height * this.percent));
    }

    public int getResolution() {
        return this.resolution;
    }

    public StylePage getStylePage() {
        return this.page;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void paint(Graphics graphics) {
        PreviewPage.paintPage(graphics, this);
    }

    public void paintBG(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.pgsize.width, this.pgsize.height);
    }

    public void paintContainer(Graphics graphics) {
        super.paint(graphics);
    }

    public static synchronized void paintPage(Graphics graphics, PreviewPage previewPage) {
        Dimension dimension = previewPage.getSize();
        Dimension dimension2 = previewPage.getPageSize();
        if (PreviewPage.bSize.width != dimension2.width || PreviewPage.bSize.height != dimension2.height) {
            buffer = null;
            buffer = previewPage.createImage(dimension2.width, dimension2.height);
            bSize = dimension2;
        }
        Graphics graphics2 = buffer.getGraphics();
        previewPage.paintBG(graphics2);
        graphics2.setColor(Color.black);
        if (previewPage.drawBorder) {
            graphics2.drawRect(0, 0, dimension2.width - 1, dimension2.height - 1);
        }
        Point point = new Point((int)(StyleSheet.getPrinterMargin().left * (double)previewPage.getResolution()), (int)(StyleSheet.getPrinterMargin().top * (double)previewPage.getResolution()));
        graphics2.translate(point.x, point.y);
        if (previewPage.getStylePage() != null) {
            previewPage.getStylePage().print(graphics2);
        }
        graphics2.setColor(Color.black);
        previewPage.paintContainer(graphics2);
        graphics2.dispose();
        graphics.drawImage(buffer, 0, 0, dimension.width, dimension.height, previewPage);
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
    }

    public void setPageIndex(int n) {
        this.index = n;
    }

    public void setPageSize(Dimension dimension) {
        if (dimension.width != this.pgsize.width || dimension.height != this.pgsize.height) {
            this.pgsize = dimension;
            this.winch = (double)this.pgsize.width / (double)this.resolution;
            this.hinch = (double)this.pgsize.height / (double)this.resolution;
        }
    }

    public void setStylePage(StylePage stylePage) {
        this.page = stylePage;
        if (stylePage != null) {
            this.setPageSize(stylePage.getPageDimension());
        }
    }

    public void setZoom(double d) {
        this.percent = d;
        this.invalidate();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

