/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;

public class PageArea
implements Serializable {
    public double x;
    public double y;
    public double width;
    public double height;
    boolean relative = false;
    int border = 0;
    Insets insets = new Insets(0, 0, 0, 0);
    Rectangle rect;
    boolean flow = true;
    Color bcolor = Color.black;

    public PageArea(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, false);
    }

    public PageArea(double d, double d2, double d3, double d4, boolean bl) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
        this.relative = bl;
    }

    public PageArea(Rectangle rectangle) {
        this.rect = rectangle;
    }

    public int getBorder() {
        return this.border;
    }

    public Color getBorderColor() {
        return this.bcolor;
    }

    public Rectangle getBounds(Rectangle rectangle, int n) {
        if (this.rect != null) {
            return this.rect;
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (this.relative) {
            rectangle2.x += (int)(this.x * (double)rectangle.width);
            rectangle2.y += (int)(this.y * (double)rectangle.height);
            rectangle2.width = (int)(this.width * (double)rectangle.width);
            rectangle2.height = (int)(this.height * (double)rectangle.height);
        } else {
            rectangle2.x += (int)(this.x * (double)n);
            rectangle2.y += (int)(this.y * (double)n);
            rectangle2.width = (int)(this.width * (double)n);
            rectangle2.height = (int)(this.height * (double)n);
        }
        return rectangle2;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Rectangle getPrintArea(Rectangle rectangle, int n) {
        Rectangle rectangle2 = this.getBounds(rectangle, n);
        if (this.insets != null) {
            rectangle2.x += this.insets.left;
            rectangle2.y += this.insets.top;
            rectangle2.width -= this.insets.left + this.insets.right;
            rectangle2.height -= this.insets.top + this.insets.bottom;
        }
        return rectangle2;
    }

    public boolean isFlow() {
        return this.flow;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public void setBorder(int n) {
        this.border = n;
        if (this.insets == null) {
            int n2 = n & 0xF;
            this.insets = new Insets(n2 + 2, n2 + 2, n2 + 2, n2 + 2);
        }
    }

    public void setBorderColor(Color color) {
        this.bcolor = color;
    }

    public void setBounds(Rectangle rectangle, Rectangle rectangle2, int n) {
        this.relative = false;
        this.x = (double)(rectangle.x - rectangle2.x) / (double)n;
        this.y = (double)(rectangle.y - rectangle2.y) / (double)n;
        this.width = (double)rectangle.width / (double)n;
        this.height = (double)rectangle.height / (double)n;
    }

    public void setFlow(boolean bl) {
        this.flow = bl;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public void setRelative(boolean bl) {
        this.relative = bl;
    }
}

