/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report;

import inetsoft.report.Common;
import inetsoft.report.Margin;
import inetsoft.report.Size;
import inetsoft.report.StyleSheet;
import inetsoft.report.internal.AFManager;
import inetsoft.report.internal.Encoder;
import inetsoft.report.internal.PixelConsumer;
import inetsoft.report.internal.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PDFPrinter
extends Graphics
implements PrintGraphics,
Serializable {
    protected int pageheight = 792;
    protected int pagewidth = 612;
    protected static final int RESOLUTION = 72;
    static final char[] hd = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final int charsPerRow = 72;
    CountWriter os;
    Color clr = Color.black;
    Color backClr = Color.white;
    Font font = new Font("Helvetica", 0, 10);
    Rectangle default_cliprect;
    Rectangle clippingRect = this.default_cliprect = new Rectangle(0, 0, this.pagewidth, this.pageheight);
    boolean needRestore = false;
    private Vector oblique = new Vector();
    private static Hashtable fontmap = new Hashtable();
    ByteArrayOutputStream othersBuf;
    ByteArrayOutputStream pgBuf;
    protected CountWriter pg;
    protected CountWriter others;
    protected String psFontName;
    protected Hashtable fontFn;
    protected int fontIdx;
    protected int objId;
    protected Vector fnList;
    protected Hashtable fontObj;
    protected Vector pageIds;
    protected String outlines;
    int lengthId;
    int pagesId;
    int contentId;
    int resourceId;
    int egsId;
    Hashtable xrefs;
    boolean inited;
    Vector imgList;
    Point center;
    boolean textObj;
    boolean closed;
    Point marginAdj;
    Hashtable imgmap;
    boolean compressText;
    boolean compressImg;
    boolean ascii;
    Printer job;
    static int NL = 1;
    static String XREF_SPACE = " ";

    public PDFPrinter(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    public PDFPrinter(OutputStream outputStream) {
        fontmap.put("dialog", "Helvetica");
        fontmap.put("dialoginput", "Courier");
        fontmap.put("serif", "Times");
        fontmap.put("sansserif", "Helvetica");
        fontmap.put("monospaced", "Courier");
        fontmap.put("timesroman", "Times");
        fontmap.put("courier", "Courier");
        fontmap.put("helvetica", "Helvetica");
        this.oblique.addElement("Courier");
        this.oblique.addElement("Helvetica");
        this.oblique.addElement("Courier");
        this.othersBuf = new ByteArrayOutputStream(8102);
        this.pgBuf = new ByteArrayOutputStream(8102);
        this.pg = new CountWriter(this.pgBuf);
        this.others = new CountWriter(this.othersBuf);
        this.psFontName = null;
        this.fontFn = new Hashtable();
        this.fontIdx = 1;
        this.objId = 2;
        this.fnList = new Vector();
        this.fontObj = new Hashtable();
        this.pageIds = new Vector();
        this.outlines = null;
        this.lengthId = 0;
        this.pagesId = 1;
        this.contentId = 0;
        this.resourceId = 0;
        this.egsId = 0;
        this.xrefs = new Hashtable();
        this.inited = false;
        this.imgList = new Vector();
        this.center = new Point(0, 0);
        this.textObj = false;
        this.closed = false;
        this.marginAdj = new Point(0, 0);
        this.imgmap = new Hashtable();
        this.compressText = true;
        this.compressImg = true;
        this.ascii = false;
        this.os = new CountWriter(outputStream);
        Margin margin = StyleSheet.getPrinterMargin();
        this.marginAdj = new Point((int)(margin.left * 72.0), (int)(margin.top * 72.0));
        this.emitProlog();
    }

    private Bezier arcToBezier(int n, int n2, int n3, int n4, int n5, int n6) {
        Bezier bezier = new Bezier();
        bezier.p0 = this.getArcPoint(n, n2, n3, n4, n5);
        bezier.p3 = this.getArcPoint(n, n2, n3, n4, n6);
        double d = 0.33;
        double d2 = 0.66;
        Point point = this.getArcPoint(n, n2, n3, n4, n5 + (int)((double)(n6 - n5) * d));
        Point point2 = this.getArcPoint(n, n2, n3, n4, n5 + (int)((double)(n6 - n5) * d2));
        double d3 = (double)point.x - Math.pow(1.0 - d, 3.0) * (double)bezier.p0.x - Math.pow(d, 3.0) * (double)bezier.p3.x;
        double d4 = (double)point.y - Math.pow(1.0 - d, 3.0) * (double)bezier.p0.y - Math.pow(d, 3.0) * (double)bezier.p3.y;
        double d5 = (double)point2.x - Math.pow(1.0 - d2, 3.0) * (double)bezier.p0.x - Math.pow(d2, 3.0) * (double)bezier.p3.x;
        double d6 = (double)point2.y - Math.pow(1.0 - d2, 3.0) * (double)bezier.p0.y - Math.pow(d2, 3.0) * (double)bezier.p3.y;
        double d7 = 3.0 * d * Math.pow(1.0 - d, 2.0);
        double d8 = 3.0 * d2 * Math.pow(1.0 - d2, 2.0);
        double d9 = 3.0 * Math.pow(d, 3.0) * (1.0 - d);
        double d10 = 3.0 * Math.pow(d2, 3.0) * (1.0 - d2);
        double d11 = (d9 / d10 * d5 - d3) / (d8 - d7);
        double d12 = (d10 * d3 - d7 * d11) / d9;
        double d13 = (d9 / d10 * d6 - d4) / (d8 - d7);
        double d14 = (d10 * d4 - d7 * d13) / d9;
        bezier.p1 = new Point((int)d11, (int)d13);
        bezier.p2 = new Point((int)d12, (int)d14);
        return bezier;
    }

    private void checkTextObj(boolean bl) {
        if (this.textObj != bl) {
            this.textObj = bl;
            if (this.textObj) {
                this.pg.println("BT");
                if (this.psFontName == null) {
                    this.emitFont(this.font);
                }
            } else {
                this.pg.println("ET");
                this.psFontName = null;
            }
        }
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.initPage();
        this.debug(this.pg, "%clearRect");
        this.checkTextObj(false);
        if (this.needRestore) {
            this.pg.println("Q");
            this.setColor(this.clr);
            this.setFont(this.font);
            this.needRestore = false;
        }
        this.pg.println("q");
        Color color = this.getColor();
        this.setColor(this.backClr);
        this.doRect(n, n2, n3, n4, true);
        this.setColor(color);
        this.clippingRect = this.default_cliprect;
        this.pg.println("Q");
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.initPage();
        this.debug(this.pg, "%clipRect");
        this.checkTextObj(false);
        this.clippingRect = this.clippingRect.intersection(new Rectangle(n + this.center.x, n2 + this.center.y, n3, n4));
        n2 = this.transformY(n2);
        n = this.transformX(n);
        if (!this.needRestore) {
            this.pg.println("q");
            this.needRestore = true;
        }
        this.pg.println(String.valueOf(n) + " " + n2 + " " + n3 + " -" + n4 + " re");
        this.pg.println("W* n");
    }

    public void close() {
        if (!this.closed) {
            this.emitTrailer();
            this.os.write(26);
            this.os.write(4);
            this.os.close();
            this.closed = true;
        }
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new RuntimeException("copyArea not supported");
    }

    public Graphics create() {
        return new SubGraphics();
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        Graphics graphics = this.create();
        graphics.setClip(n, n2, n3, n4);
        graphics.translate(n, n2);
        return graphics;
    }

    protected void debug(PrintWriter printWriter, String string) {
    }

    public void dispose() {
        if (!this.inited) {
            return;
        }
        this.inited = false;
        this.debug(this.pg, "%dispose");
        this.checkTextObj(false);
        if (this.needRestore) {
            this.pg.println("Q");
            this.needRestore = false;
        }
        this.pg.flush();
        byte[] byArray = this.pgBuf.toByteArray();
        int n = this.os.getOffset();
        if (this.compressText) {
            if (!this.ascii) {
                byArray = Encoder.deflate(byArray);
                try {
                    this.os.write(byArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                byArray = Encoder.encodeAscii85(Encoder.deflate(byArray));
                int n2 = 0;
                while (n2 < byArray.length) {
                    if (n2 > 0) {
                        this.os.println("");
                    }
                    try {
                        this.os.write(byArray, n2, Math.min(byArray.length - n2, 72));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    n2 += 72;
                }
                this.os.println("~>");
            }
        } else {
            try {
                this.os.write(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.pgBuf.reset();
        this.pg.reset();
        int n3 = this.os.getOffset() - n;
        this.resourceId = this.objId++;
        this.os.println("endstream");
        this.os.println("endobj");
        this.xrefs.put(new Integer(this.lengthId), new Integer(this.os.getOffset()));
        this.os.println(String.valueOf(this.lengthId) + " 0 obj");
        this.os.println(String.valueOf(n3));
        this.os.println("endobj");
        this.xrefs.put(new Integer(this.objId), new Integer(this.os.getOffset()));
        this.os.println(String.valueOf(this.objId) + " 0 obj");
        this.os.println("<<");
        this.os.println("/Type /Page");
        this.os.println("/Parent " + this.pagesId + " 0 R");
        this.os.println("/Resources " + this.resourceId + " 0 R");
        this.os.println("/Contents " + this.contentId + " 0 R");
        this.os.println(">>");
        this.os.println("endobj");
        this.pageIds.addElement(String.valueOf(this.objId) + " 0 R");
        ++this.objId;
        this.xrefs.put(new Integer(this.resourceId), new Integer(this.os.getOffset()));
        this.os.println(String.valueOf(this.resourceId) + " 0 obj");
        this.os.println("<<");
        this.os.print("/ProcSet [/PDF");
        if (this.fnList.size() > 0) {
            this.os.print(" /Text");
        }
        if (this.imgList.size() > 0) {
            this.os.print(" /ImageC");
        }
        this.os.println("]");
        this.os.println("/ExtGState <<");
        this.os.println("/GS1 " + this.egsId + " 0 R");
        this.os.println(">>");
        if (this.fnList.size() > 0) {
            this.os.println("/Font <<");
            int n4 = 0;
            while (n4 < this.fnList.size()) {
                this.os.println((String)this.fnList.elementAt(n4));
                ++n4;
            }
            this.os.println(">>");
        }
        if (this.imgList.size() > 0) {
            this.os.println("/XObject <<");
            int n5 = 0;
            while (n5 < this.imgList.size()) {
                this.os.println((String)this.imgList.elementAt(n5));
                ++n5;
            }
            this.os.println(">>");
        }
        this.os.println(">>");
        this.os.println("endobj");
        this.os.flush();
        this.writeOthers();
    }

    private void doArc(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.initPage();
        this.debug(this.pg, "%doArc");
        n2 = this.transformY(n2);
        n = this.transformX(n);
        this.checkTextObj(false);
        boolean bl2 = true;
        int n7 = n5 + n6;
        int n8 = 30;
        int n9 = n5;
        while (n9 < n7) {
            int n10 = n9 + n8;
            if (n10 > n7) {
                n10 = n7;
            }
            Bezier bezier = this.arcToBezier(n, n2, n3, n4, n9, n10);
            if (bl2) {
                this.pg.println(String.valueOf(n + n3 / 2) + " " + (n2 + n4 / 2) + " m");
                this.pg.println(String.valueOf(bezier.p0.x) + " " + bezier.p0.y + " l");
            }
            this.pg.println(String.valueOf(bezier.p1.x) + " " + bezier.p1.y + " " + bezier.p2.x + " " + bezier.p2.y + " " + bezier.p3.x + " " + bezier.p3.y + " c");
            n9 += n8;
        }
        if (bl) {
            this.pg.println("f*");
        } else {
            this.pg.println("S");
        }
    }

    boolean doImage(PixelConsumer pixelConsumer, int n, int n2, int n3, int n4, ImageObserver imageObserver, Color color) {
        this.initPage();
        this.debug(this.pg, "%doImage");
        n2 = this.transformY(n2);
        n = this.transformX(n);
        this.checkTextObj(false);
        if (n4 == 0 || n3 == 0) {
            pixelConsumer.produce();
            n4 = pixelConsumer.height;
            n3 = pixelConsumer.width;
        }
        Integer n5 = (Integer)this.imgmap.get(pixelConsumer);
        int n6 = 1;
        if (n5 != null) {
            n6 = n5;
        } else {
            n6 = this.objId++;
            pixelConsumer.produce();
            this.imgmap.put(pixelConsumer, new Integer(n6));
        }
        if (n5 == null) {
            int n7;
            int n8 = this.objId++;
            this.imgList.addElement("/Im" + n6 + " " + n6 + " 0 R");
            this.others.markObject(n6);
            this.others.println(String.valueOf(n6) + " 0 obj");
            this.others.println("<<");
            this.others.println("/Type /XObject");
            this.others.println("/Subtype /Image");
            this.others.println("/Name /Im" + n6);
            this.others.println("/Width " + pixelConsumer.width);
            this.others.println("/Height " + pixelConsumer.height);
            this.others.println("/BitsPerComponent 8");
            this.others.println("/ColorSpace /DeviceRGB");
            if (this.compressImg) {
                if (this.ascii) {
                    this.others.println("/Filter [ /ASCII85Decode /FlateDecode ]");
                } else {
                    this.others.println("/Filter [ /FlateDecode ]");
                }
            } else if (this.ascii) {
                this.others.println("/Filter /ASCII85Decode");
            }
            this.others.println("/Length " + n8 + " 0 R");
            this.others.println(">>");
            this.others.println("stream");
            int n9 = this.others.getOffset();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n10 = pixelConsumer.height - 1;
            while (n10 >= 0) {
                int n11 = 0;
                while (n11 < pixelConsumer.width) {
                    n7 = pixelConsumer.pix[n11][n10];
                    if ((n7 & 0xFF000000) == 0) {
                        n7 = color == null ? 0xFFFFFF : color.getRGB();
                    }
                    byteArrayOutputStream.write((byte)((n7 & 0xFF0000) >> 16));
                    byteArrayOutputStream.write((byte)((n7 & 0xFF00) >> 8));
                    byteArrayOutputStream.write((byte)(n7 & 0xFF));
                    ++n11;
                }
                --n10;
            }
            byte[] byArray = this.compressImg ? (this.ascii ? Encoder.encodeAscii85(Encoder.deflate(byteArrayOutputStream.toByteArray())) : Encoder.deflate(byteArrayOutputStream.toByteArray())) : (this.ascii ? Encoder.encodeAscii85(byteArrayOutputStream.toByteArray()) : byteArrayOutputStream.toByteArray());
            if (this.ascii) {
                n7 = 0;
                while (n7 < byArray.length) {
                    if (n7 > 0) {
                        this.others.println("");
                    }
                    try {
                        this.others.write(byArray, n7, Math.min(byArray.length - n7, 72));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    n7 += 72;
                }
            } else {
                try {
                    this.others.write(byArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.ascii) {
                this.others.println("~>");
            }
            int n12 = this.others.getOffset() - n9;
            this.others.println("endstream");
            this.others.println("endobj");
            this.others.markObject(n8);
            this.others.println(String.valueOf(n8) + " 0 obj");
            this.others.println(String.valueOf(n12));
            this.others.println("endobj");
        }
        if (this.needRestore) {
            this.pg.println("Q");
            this.setColor(this.clr);
            this.setFont(this.font);
            this.needRestore = false;
        }
        this.pg.println("q");
        this.pg.println(String.valueOf(n3) + " 0 0 -" + n4 + " " + n + " " + n2 + " cm");
        this.pg.println("/Im" + n6 + " Do");
        this.pg.println("Q");
        return true;
    }

    public boolean doImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver, Color color) {
        PixelConsumer pixelConsumer = new PixelConsumer(image, n5, n6, n7, n8);
        return this.doImage(pixelConsumer, n, n2, n3, n4, imageObserver, color);
    }

    public boolean doImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver, Color color) {
        PixelConsumer pixelConsumer = new PixelConsumer(image);
        return this.doImage(pixelConsumer, n, n2, n3, n4, imageObserver, color);
    }

    private void doPoly(int[] nArray, int[] nArray2, int n, boolean bl) {
        this.initPage();
        if (n < 2) {
            return;
        }
        this.checkTextObj(false);
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray3[n2] = this.transformY(nArray2[n2]);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            nArray4[n2] = this.transformX(nArray[n2]);
            ++n2;
        }
        this.pg.print(String.valueOf(nArray4[0]) + " " + nArray3[0] + " m ");
        n2 = 0;
        while (n2 < n) {
            this.pg.println(String.valueOf(nArray4[n2]) + " " + nArray3[n2] + " l");
            ++n2;
        }
        this.pg.print(String.valueOf(nArray4[0]) + " " + nArray3[0] + " l ");
        if (bl) {
            this.pg.println("f*");
        } else {
            this.pg.println("S");
        }
    }

    void doRect(int n, int n2, int n3, int n4, boolean bl) {
        this.initPage();
        this.debug(this.pg, "%doRect");
        n2 = this.transformY(n2);
        n = this.transformX(n);
        this.checkTextObj(false);
        if (bl) {
            this.pg.println(String.valueOf(n) + " " + n2 + " " + n3 + " -" + n4 + " re");
            this.pg.println("f*");
        } else {
            this.pg.println(String.valueOf(n) + " " + n2 + " m");
            this.pg.println(String.valueOf(n + n3) + " " + n2 + " l");
            this.pg.println(String.valueOf(n + n3) + " " + (n2 - n4) + " l");
            this.pg.println(String.valueOf(n) + " " + (n2 - n4) + " l");
            this.pg.println(String.valueOf(n) + " " + n2 + " l");
            this.pg.println("S");
        }
    }

    private void doRoundRect(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.initPage();
        this.debug(this.pg, "%doRoundRect");
        n2 = this.transformY(n2);
        n = this.transformX(n);
        int n7 = n + n3;
        int n8 = n2 + n4;
        this.checkTextObj(false);
        this.pg.println(String.valueOf(n) + " " + (n2 - n6) + " m");
        this.pg.println(String.valueOf(n) + " " + n2 + " " + n + " " + n2 + " " + (n + n5) + " " + n2 + " c");
        this.pg.println(String.valueOf(n7 - n5) + " " + n2 + " l");
        this.pg.println(String.valueOf(n7) + " " + n2 + " " + n7 + " " + n2 + " " + n7 + (n2 - n6) + " c");
        this.pg.println(String.valueOf(n7) + " " + (n8 + n6) + " l");
        this.pg.println(String.valueOf(n7) + " " + n8 + " " + n7 + " " + n8 + " " + (n7 - n5) + " " + n8 + " c");
        this.pg.println(String.valueOf(n + n5) + " " + n8 + " l");
        this.pg.println(String.valueOf(n) + " " + n8 + " " + n + " " + n8 + " " + n + " " + (n8 + n6) + " c");
        this.pg.println(String.valueOf(n) + " " + (n2 - n6) + " l");
        if (bl) {
            this.pg.println("f*");
        } else {
            this.pg.println("S");
        }
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.initPage();
        this.debug(this.pg, "%draw3DRect");
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        this.setColor(bl ? color2 : color3);
        this.drawLine(n, n2, n, n2 + n4);
        this.drawLine(n + 1, n2, n + n3 - 1, n2);
        this.setColor(bl ? color3 : color2);
        this.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        this.drawLine(n + n3, n2, n + n3, n2 + n4);
        this.setColor(color);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.debug(this.pg, "%drawArc");
        this.doArc(n, n2, n3, n4, n5, n6, false);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.debug(this.pg, "%drawBytes");
        this.drawString(new String(byArray, n, n2), n3, n4);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.debug(this.pg, "%drawChars");
        this.drawString(new String(cArray, n, n2), n3, n4);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        this.debug(this.pg, "%drawImage-6");
        return this.doImage(image, n, n2, n3 - n + 1, n4 - n2 + 1, n5, n6, n7, n8, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        this.debug(this.pg, "%drawImage-5");
        return this.doImage(image, n, n2, n3 - n + 1, n4 - n2 + 1, n5, n6, n7, n8, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.debug(this.pg, "%drawImage-4");
        return this.doImage(image, n, n2, n3, n4, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.debug(this.pg, "%drawImage-2");
        return this.doImage(image, n, n2, n3, n4, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        this.debug(this.pg, "%drawImage-3");
        return this.doImage(image, n, n2, 0, 0, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.debug(this.pg, "%drawImage-1");
        return this.doImage(image, n, n2, 0, 0, imageObserver, null);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.initPage();
        this.debug(this.pg, "%drawLine");
        n2 = this.transformY(n2);
        n4 = this.transformY(n4);
        n = this.transformX(n);
        n3 = this.transformX(n3);
        this.checkTextObj(false);
        float f = n3;
        if (n == n3 && n2 == n4) {
            f = (float)((double)f + 0.5);
        }
        this.pg.println(String.valueOf(n) + " " + n2 + " m");
        this.pg.println(String.valueOf(f) + " " + n4 + " l");
        this.pg.println("S");
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.debug(this.pg, "%drawOval");
        this.doArc(n, n2, n3, n4, 0, 360, false);
    }

    public void drawPolygon(Polygon polygon) {
        this.debug(this.pg, "%drawPoly");
        this.doPoly(polygon.xpoints, polygon.ypoints, polygon.npoints, false);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.debug(this.pg, "%drawPoly");
        this.doPoly(nArray, nArray2, n, false);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        int n2 = 1;
        while (n2 < n) {
            this.drawLine(nArray[n2 - 1], nArray2[n2 - 1], nArray[n2], nArray2[n2]);
            ++n2;
        }
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.debug(this.pg, "%drawRect");
        this.doRect(n, n2, n3, n4, false);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.debug(this.pg, "%drawRoundRect");
        this.doRoundRect(n, n2, n3, n4, n5, n6, false);
    }

    public void drawString(String string, int n, int n2) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.initPage();
        this.debug(this.pg, "%drawString");
        this.checkTextObj(true);
        n2 = this.transformY(n2);
        n = this.transformX(n);
        FontMetrics fontMetrics = Common.getFontMetrics(this.getFont());
        float f = Common.stringWidth(string, this.getFont(), fontMetrics);
        String[] stringArray = Util.split(string, ' ');
        float[] fArray = new float[stringArray.length];
        float f2 = 0.0f;
        int n3 = 0;
        while (n3 < stringArray.length) {
            fArray[n3] = Common.stringWidth(stringArray[n3], this.getFont(), fontMetrics);
            f2 += fArray[n3];
            ++n3;
        }
        float f3 = stringArray.length > 0 ? (f - f2) / (float)(stringArray.length - 1) : 0.0f;
        int n4 = 0;
        while (n4 < stringArray.length) {
            int n5 = this.getFontMetrics().stringWidth(stringArray[n4]);
            if (stringArray[n4].length() > 1) {
                float f4 = (float)((int)((fArray[n4] - (float)n5) * 10.0f / (float)(string.length() - 1))) / 10.0f;
                this.pg.println(String.valueOf(f4) + " Tc");
            }
            this.pg.println("1 0 0 1 " + n + " " + n2 + " Tm");
            this.pg.println("(" + PDFPrinter.escapeString(stringArray[n4]) + ") Tj");
            n = (int)((float)n + (fArray[n4] + f3));
            ++n4;
        }
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }

    protected void emitFont(Font font) {
        this.initPage();
        this.debug(this.pg, "%setFont");
        this.psFontName = this.getFontName(font);
        String string = (String)this.fontFn.get(this.psFontName);
        if (string == null) {
            string = "F" + this.fontIdx++;
            String string2 = (String)this.fontObj.get(this.psFontName);
            if (string2 == null) {
                string2 = String.valueOf(this.objId) + " 0 R";
                this.fontObj.put(this.psFontName, string2);
                this.others.markObject(this.objId);
                this.others.println(String.valueOf(this.objId) + " 0 obj");
                this.others.println("<<");
                this.others.println("/Type /Font");
                this.others.println("/Subtype /Type1");
                this.others.println("/Name /" + string);
                this.others.println("/BaseFont /" + this.psFontName);
                this.others.println("/Encoding /WinAnsiEncoding");
                this.others.println(">>");
                this.others.println("endobj");
                ++this.objId;
            }
            this.fnList.addElement("/" + string + " " + string2 + " ");
        }
        this.pg.println("/" + string + " " + font.getSize() + " Tf");
        this.fontFn.put(this.psFontName, string);
    }

    void emitProlog() {
        this.os.println("%PDF-1.2");
        this.os.println("%\u00e2\u00e3\u00cf\u00d3");
        this.egsId = this.objId++;
        this.xrefs.put(new Integer(this.egsId), new Integer(this.os.getOffset()));
        this.os.println(String.valueOf(this.egsId) + " 0 obj");
        this.os.println("<<");
        this.os.println("/Type /ExtGState");
        this.os.println("/SA false");
        this.os.println("/OP false");
        this.os.println("/HT /Default");
        this.os.println(">>");
        this.os.println("endobj");
    }

    void emitTrailer() {
        this.xrefs.put(new Integer(this.pagesId), new Integer(this.os.getOffset()));
        this.os.println(String.valueOf(this.pagesId) + " 0 obj");
        this.os.println("<<");
        this.os.println("/Type /Pages");
        this.os.print("/Kids [");
        int n = 0;
        while (n < this.pageIds.size()) {
            if (n > 0) {
                this.os.print(" ");
            }
            this.os.print((String)this.pageIds.elementAt(n));
            ++n;
        }
        this.os.println("]");
        this.os.println("/Count " + this.pageIds.size());
        this.os.println("/MediaBox [0 0 " + this.pagewidth + " " + this.pageheight + "]");
        this.os.println(">>");
        this.os.println("endobj");
        this.xrefs.put(new Integer(this.objId), new Integer(this.os.getOffset()));
        int n2 = this.objId++;
        this.os.println(String.valueOf(n2) + " 0 obj");
        this.os.println("<<");
        this.os.println("/Type /Catalog");
        this.os.println("/Pages " + this.pagesId + " 0 R");
        if (this.outlines != null) {
            this.os.println("/Outlines " + this.outlines);
        }
        this.os.println(">>");
        this.os.println("endobj");
        int n3 = this.os.getOffset();
        this.os.println("xref");
        this.os.println("0 " + (this.xrefs.size() + 1));
        this.os.println("0000000000 65535 f" + XREF_SPACE);
        int n4 = 0;
        while (n4 < this.xrefs.size()) {
            String string = "0000000000" + this.xrefs.get(new Integer(n4 + 1));
            this.os.println(String.valueOf(string.substring(string.length() - 10)) + " 00000 n" + XREF_SPACE);
            ++n4;
        }
        this.os.println("trailer");
        this.os.println("<<");
        this.os.println("/Size " + (this.xrefs.size() + 1));
        this.os.println("/Root " + n2 + " 0 R");
        this.os.println(">>");
        this.os.println("startxref");
        this.os.println(String.valueOf(n3));
        this.os.println("%%EOF");
    }

    public static String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '(': {
                    stringBuffer.append("\\(");
                    break;
                }
                case ')': {
                    stringBuffer.append("\\)");
                    break;
                }
                default: {
                    stringBuffer.append(string.charAt(n));
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.initPage();
        this.debug(this.pg, "%fill3DRect");
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        if (!bl) {
            this.setColor(color3);
        }
        this.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        this.setColor(bl ? color2 : color3);
        this.drawLine(n, n2, n, n2 + n4 - 1);
        this.drawLine(n + 1, n2, n + n3 - 2, n2);
        this.setColor(bl ? color3 : color2);
        this.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        this.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        this.setColor(color);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.debug(this.pg, "%fillArc");
        this.doArc(n, n2, n3, n4, n5, n6, true);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.debug(this.pg, "%fillOval");
        this.doArc(n, n2, n3, n4, 0, 360, true);
    }

    public void fillPolygon(Polygon polygon) {
        this.debug(this.pg, "%fillPoly");
        this.doPoly(polygon.xpoints, polygon.ypoints, polygon.npoints, true);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.debug(this.pg, "%fillPoly");
        this.doPoly(nArray, nArray2, n, true);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.debug(this.pg, "%fillRect");
        this.doRect(n, n2, n3, n4, true);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.debug(this.pg, "%fillRoundRect");
        this.doRoundRect(n, n2, n3, n4, n5, n6, true);
    }

    public void finalize() {
        if (this.inited) {
            this.dispose();
        }
    }

    private Point getArcPoint(int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 / 2;
        int n7 = n4 / 2;
        double d = Math.tan((double)n5 * Math.PI / 180.0);
        double d2 = (double)(n6 * n6 * n7 * n7) / ((double)(n6 * n6 + n7 * n7) + d * d);
        double d3 = d * d2;
        return new Point((int)d2 + n, (int)d3 + n2);
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public Rectangle getClipBounds() {
        return new Rectangle(this.clippingRect.x - this.center.x, this.clippingRect.y - this.center.y, this.clippingRect.width, this.clippingRect.height);
    }

    public Color getColor() {
        return this.clr;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        return AFManager.getFontMetrics(this.getFontName(font), font.getSize());
    }

    public String getFontName(Font font) {
        int n;
        String string = font.getName().toLowerCase();
        String string2 = (String)fontmap.get(string);
        if (string2 == null && (n = string.indexOf(46)) > 0) {
            string2 = (String)fontmap.get(string.substring(0, n));
        }
        String string3 = string2 == null ? "Courier" : string2;
        int n2 = font.getStyle();
        if ((n2 & 1) != 0 && (n2 & 2) != 0) {
            string3 = String.valueOf(string3) + (this.oblique.contains(string3) ? "-BoldOblique" : "-BoldItalic");
        } else if ((n2 & 1) != 0) {
            string3 = String.valueOf(string3) + "-Bold";
        } else if ((n2 & 2) != 0) {
            string3 = String.valueOf(string3) + (this.oblique.contains(string3) ? "-Oblique" : "-Italic");
        } else if (string3.equals("Times")) {
            string3 = String.valueOf(string3) + "-Roman";
        }
        return string3;
    }

    public int getOutputSize() {
        return this.os.getOffset();
    }

    public Size getPageSize() {
        return new Size((double)this.pagewidth / 72.0, (double)this.pageheight / 72.0);
    }

    public PrintJob getPrintJob() {
        if (this.job == null) {
            this.job = new Printer();
        }
        return this.job;
    }

    protected void initPage() {
        if (!this.inited) {
            this.inited = true;
            this.clippingRect = this.default_cliprect;
            this.needRestore = false;
            this.xrefs.put(new Integer(this.objId), new Integer(this.os.getOffset()));
            this.os.println(String.valueOf(this.objId) + " 0 obj");
            this.contentId = this.objId++;
            this.os.println("<<");
            this.os.println("/Length " + this.objId + " 0 R");
            if (this.compressText) {
                if (this.ascii) {
                    this.os.println("/Filter [ /ASCII85Decode /FlateDecode ]");
                } else {
                    this.os.println("/Filter [ /FlateDecode ]");
                }
            }
            this.os.println(">>");
            this.lengthId = this.objId++;
            this.os.println("stream");
            this.clr = Color.black;
            this.pg.println("0 g");
            this.pg.println("BX /GS1 gs EX");
            this.setClip(this.default_cliprect);
            this.fontFn.clear();
        }
    }

    public boolean isAsciiOnly() {
        return this.ascii;
    }

    public boolean isCompressImage() {
        return this.compressImg;
    }

    public boolean isCompressText() {
        return this.compressText;
    }

    public void putFontName(String string, String string2) {
        fontmap.put(string, string2);
    }

    public void setAsciiOnly(boolean bl) {
        this.ascii = bl;
    }

    public void setBackground(Color color) {
        this.backClr = color;
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.initPage();
        this.debug(this.pg, "%setClip");
        this.checkTextObj(false);
        if (this.needRestore) {
            this.pg.println("Q");
            this.setColor(this.clr);
            this.setFont(this.font);
        }
        this.clippingRect = new Rectangle(n + this.center.x, n2 + this.center.y, n3, n4);
        n2 = this.transformY(n2);
        n = this.transformX(n);
        this.pg.println("q");
        this.needRestore = true;
        this.pg.println(String.valueOf(n) + " " + n2 + " " + n3 + " -" + n4 + " re");
        this.pg.println("W* n");
    }

    public void setClip(Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setColor(Color color) {
        this.initPage();
        this.debug(this.pg, "%setColor");
        if (color != null && this.clr != null && this.clr.equals(color)) {
            return;
        }
        if (color != null) {
            this.clr = color;
            double d = (double)this.clr.getRed() / 255.0;
            double d2 = (double)this.clr.getGreen() / 255.0;
            double d3 = (double)this.clr.getBlue() / 255.0;
            if (d == d2 && d2 == d3) {
                this.pg.println(String.valueOf(Util.toString(d, 3)) + " g");
                this.pg.println(String.valueOf(Util.toString(d, 3)) + " G");
            } else {
                this.pg.println(String.valueOf(Util.toString(d, 3)) + " " + Util.toString(d2, 3) + " " + Util.toString(d3, 3) + " rg");
                this.pg.println(String.valueOf(Util.toString(d, 3)) + " " + Util.toString(d2, 3) + " " + Util.toString(d3, 3) + " RG");
            }
        }
    }

    public void setCompressImage(boolean bl) {
        this.compressImg = bl;
    }

    public void setCompressText(boolean bl) {
        this.compressText = bl;
    }

    public void setFont(Font font) {
        this.font = font;
        if (this.textObj) {
            this.emitFont(this.font);
        } else {
            this.psFontName = null;
        }
    }

    public void setPageSize(double d, double d2) {
        this.pagewidth = (int)(72.0 * d);
        this.pageheight = (int)(72.0 * d2);
        this.clippingRect = this.default_cliprect = new Rectangle(0, 0, this.pagewidth, this.pageheight);
    }

    public void setPageSize(Size size) {
        this.setPageSize(size.width, size.height);
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
        System.err.println("Not supported");
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[font=" + this.getFont() + ",color=" + this.getColor() + "]";
    }

    int transformX(int n) {
        return n + this.center.x + this.marginAdj.x;
    }

    int transformY(int n) {
        return this.pageheight - (n + this.center.y + this.marginAdj.y);
    }

    public void translate(int n, int n2) {
        this.initPage();
        this.debug(this.pg, "%translate");
        this.center.x += n;
        this.center.y += n2;
    }

    protected void writeOthers() {
        try {
            this.others.flush();
            Hashtable hashtable = this.others.getObjectMarks();
            int n = this.os.getOffset();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                int n2 = (Integer)hashtable.get(k);
                this.xrefs.put(k, new Integer(n2 + n));
            }
            this.os.write(this.othersBuf.toByteArray());
            this.others.reset();
            this.othersBuf.reset();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class Printer
    extends PrintJob
    implements Serializable {
        Printer() {
        }

        public void end() {
            PDFPrinter.this.close();
        }

        public Graphics getGraphics() {
            return PDFPrinter.this;
        }

        public Dimension getPageDimension() {
            return new Dimension(PDFPrinter.this.pagewidth, PDFPrinter.this.pageheight);
        }

        public int getPageResolution() {
            return 72;
        }

        public boolean lastPageFirst() {
            return false;
        }
    }

    class Bezier
    implements Serializable {
        Point p0;
        Point p1;
        Point p2;
        Point p3;

        Bezier() {
        }
    }

    protected class CountWriter
    extends PrintWriter
    implements Serializable {
        OutputStream stream;
        int offset = 0;
        Hashtable objmarks = new Hashtable();

        public CountWriter(OutputStream outputStream) {
            super(outputStream);
            this.stream = outputStream;
        }

        public Hashtable getObjectMarks() {
            return this.objmarks;
        }

        public int getOffset() {
            return this.offset;
        }

        public void markObject(int n) {
            this.objmarks.put(new Integer(n), new Integer(this.offset));
        }

        public void print(String string) {
            super.print(string);
            this.offset += string.length();
        }

        public void println(String string) {
            this.print(string);
            this.print("\n");
        }

        public void reset() {
            this.offset = 0;
            this.objmarks.clear();
        }

        public void write(int n) {
            this.flush();
            try {
                this.stream.write(n);
                ++this.offset;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.flush();
            this.stream.write(byArray, n, n2);
            this.offset += n2;
        }
    }

    class SubGraphics
    extends Graphics {
        boolean disposed = false;
        Point ocenter;
        Rectangle clip;

        public SubGraphics() {
            PDFPrinter.this.debug(PDFPrinter.this.pg, "%New SubGraphics");
            this.ocenter = new Point(PDFPrinter.this.center);
            this.clip = new Rectangle(PDFPrinter.this.clippingRect);
        }

        public void clearRect(int n, int n2, int n3, int n4) {
            PDFPrinter.this.clearRect(n, n2, n3, n4);
        }

        public void clipRect(int n, int n2, int n3, int n4) {
            PDFPrinter.this.clipRect(n, n2, n3, n4);
        }

        public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
            PDFPrinter.this.copyArea(n, n2, n3, n4, n5, n6);
        }

        public Graphics create() {
            return PDFPrinter.this.create();
        }

        public void dispose() {
            if (!this.disposed) {
                PDFPrinter.this.checkTextObj(false);
                PDFPrinter.this.debug(PDFPrinter.this.pg, "%SubGraphics disposed");
                PDFPrinter.this.center = this.ocenter;
                this.setClip(this.clip);
                this.disposed = true;
            }
        }

        public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
            PDFPrinter.this.drawArc(n, n2, n3, n4, n5, n6);
        }

        public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
            PDFPrinter.this.drawChars(cArray, n, n2, n3, n4);
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
            return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
            return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
            return PDFPrinter.this.drawImage(image, n, n2, n3, n4, color, imageObserver);
        }

        public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
            return PDFPrinter.this.drawImage(image, n, n2, n3, n4, imageObserver);
        }

        public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
            return PDFPrinter.this.drawImage(image, n, n2, color, imageObserver);
        }

        public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
            return PDFPrinter.this.drawImage(image, n, n2, imageObserver);
        }

        public void drawLine(int n, int n2, int n3, int n4) {
            PDFPrinter.this.drawLine(n, n2, n3, n4);
        }

        public void drawOval(int n, int n2, int n3, int n4) {
            PDFPrinter.this.drawOval(n, n2, n3, n4);
        }

        public void drawPolygon(int[] nArray, int[] nArray2, int n) {
            PDFPrinter.this.drawPolygon(nArray, nArray2, n);
        }

        public void drawPolyline(int[] nArray, int[] nArray2, int n) {
            PDFPrinter.this.drawPolyline(nArray, nArray2, n);
        }

        public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
            PDFPrinter.this.drawRoundRect(n, n2, n3, n4, n5, n6);
        }

        public void drawString(String string, int n, int n2) {
            PDFPrinter.this.drawString(string, n, n2);
        }

        public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
            PDFPrinter.this.drawString(attributedCharacterIterator, n, n2);
        }

        public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
            PDFPrinter.this.fillArc(n, n2, n3, n4, n5, n6);
        }

        public void fillOval(int n, int n2, int n3, int n4) {
            PDFPrinter.this.fillOval(n, n2, n3, n4);
        }

        public void fillPolygon(int[] nArray, int[] nArray2, int n) {
            PDFPrinter.this.fillPolygon(nArray, nArray2, n);
        }

        public void fillRect(int n, int n2, int n3, int n4) {
            PDFPrinter.this.fillRect(n, n2, n3, n4);
        }

        public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
            PDFPrinter.this.fillRoundRect(n, n2, n3, n4, n5, n6);
        }

        public Shape getClip() {
            return this.getClipBounds();
        }

        public Rectangle getClipBounds() {
            return PDFPrinter.this.getClipBounds();
        }

        public Color getColor() {
            return PDFPrinter.this.getColor();
        }

        public Font getFont() {
            return PDFPrinter.this.getFont();
        }

        public FontMetrics getFontMetrics(Font font) {
            return PDFPrinter.this.getFontMetrics(font);
        }

        public void setClip(int n, int n2, int n3, int n4) {
            PDFPrinter.this.setClip(n, n2, n3, n4);
        }

        public void setClip(Shape shape) {
            PDFPrinter.this.setClip(shape);
        }

        public void setColor(Color color) {
            PDFPrinter.this.setColor(color);
        }

        public void setFont(Font font) {
            PDFPrinter.this.setFont(font);
        }

        public void setPaintMode() {
            PDFPrinter.this.setPaintMode();
        }

        public void setXORMode(Color color) {
            PDFPrinter.this.setXORMode(color);
        }

        public void translate(int n, int n2) {
            PDFPrinter.this.translate(n, n2);
        }
    }
}

