/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report;

import inetsoft.report.Paintable;
import inetsoft.report.Painter;
import inetsoft.report.PreviewPage;
import inetsoft.report.PreviewView;
import inetsoft.report.ReportElement;
import inetsoft.report.Size;
import inetsoft.report.StyleFont;
import inetsoft.report.StylePage;
import inetsoft.report.StyleSheet;
import inetsoft.report.internal.Bounds;
import inetsoft.report.internal.Gop;
import inetsoft.report.internal.JpegEncoder;
import inetsoft.report.internal.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Common
extends Util {
    private static Frame root = null;
    static Font lastFn = null;
    static FontMetrics lastFm = null;
    static Hashtable fmcache = new Hashtable();
    private static Toolkit toolkit = null;
    private static Gop g2d = Gop.getInstance();
    private static final Color[] colors = new Color[]{Color.green, Color.red, Color.yellow, Color.magenta, Color.orange, Color.cyan, Color.blue, Color.gray, Color.pink, Color.darkGray, new Color(150, 0, 150), new Color(25, 80, 150), new Color(150, 80, 25), new Color(126, 0, 0), new Color(0, 126, 0), new Color(0, 0, 126), new Color(240, 80, 240), new Color(80, 240, 80), new Color(50, 100, 150), new Color(100, 150, 200), new Color(150, 200, 250), new Color(150, 100, 50), new Color(200, 150, 100), new Color(250, 200, 150), new Color(60, 75, 60), new Color(90, 75, 45), new Color(128, 0, 64), new Color(64, 0, 128), new Color(70, 20, 38), new Color(100, 100, 30)};
    static /* synthetic */ Class class$inetsoft$report$Common;

    public static Bounds alignCell(Bounds bounds, Size size, int n) {
        Bounds bounds2 = new Bounds(bounds.x, bounds.y, bounds.width, bounds.height);
        if (size.width < bounds2.width) {
            if ((n & 2) != 0) {
                bounds2.x += (bounds2.width - size.width) / 2.0f;
                bounds2.width = size.width;
            } else if ((n & 4) != 0) {
                bounds2.x += bounds2.width - size.width - 1.0f;
                bounds2.width = size.width;
            } else if ((n & 1) != 0) {
                bounds2.width = size.width;
            }
        }
        if (size.height < bounds2.height) {
            if ((n & 0x10) != 0) {
                bounds2.y += (bounds2.height - size.height) / 2.0f;
                bounds2.height = size.height;
            } else if ((n & 0x20) != 0) {
                bounds2.y += bounds2.height - size.height - 1.0f;
                bounds2.height = size.height;
            } else if ((n & 8) != 0) {
                bounds2.height = size.height;
            }
        }
        return bounds2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void clipRect(Graphics graphics, Bounds bounds) {
        g2d.clipRect(graphics, bounds);
    }

    public static int compare(Object object, Object object2) {
        return g2d.compare(object, object2);
    }

    public static Image createImage(int n, int n2) {
        return Common.getInvisibleFrame().createImage(n, n2);
    }

    public static Image createImage(byte[] byArray, int n, int n2) {
        return g2d.createImage(byArray, n, n2);
    }

    public static StyleSheet createStyleSheet() {
        return g2d.createStyleSheet();
    }

    public static void drawHLine(Graphics graphics, float f, float f2, float f3, int n, int n2, int n3) {
        g2d.drawHLine(graphics, f, f2, f3, n, n2, n3);
    }

    public static void drawImage(Graphics graphics, Image image, float f, float f2, float f3, float f4, ImageObserver imageObserver) {
        g2d.drawImage(graphics, image, f, f2, f3, f4, imageObserver);
    }

    public static void drawLine(Graphics graphics, float f, float f2, float f3, float f4, int n) {
        g2d.drawLine(graphics, f, f2, f3, f4, n);
    }

    public static void drawRect(StylePage stylePage, final float f, final float f2, final float f3, final float f4, final int n, final Color color) {
        stylePage.addPaintable(new Paintable(){

            public Rectangle getBounds() {
                return new Rectangle(Common.round(f), Common.round(f2), Common.round(f3), Common.round(f4));
            }

            public ReportElement getElement() {
                return null;
            }

            public void paint(Graphics graphics) {
                Color color2 = graphics.getColor();
                if (color != null) {
                    graphics.setColor(color);
                }
                Common.drawRect(graphics, f, f2, f3, f4, n);
                graphics.setColor(color2);
            }

            public void setLocation(Point point) {
            }
        });
    }

    public static void drawRect(Graphics graphics, float f, float f2, float f3, float f4, int n) {
        float f5 = Common.getLineAdjustment(graphics);
        int n2 = n & 0xF;
        Common.drawHLine(graphics, f2 + f5, f, f + (f3 -= (float)n2), n, 0, n);
        Common.drawHLine(graphics, f2 + (f4 -= (float)n2) + f5, f, f + f3, n, n, 0);
        Common.drawVLine(graphics, f + f5, f2, f2 + f4, n, 0, n);
        Common.drawVLine(graphics, f + f3 + f5, f2, f2 + f4, n, n, 0);
        Common.drawVLine(graphics, f + f5, f2 + f4, f2 + f4 + (float)n2 - 1.0f, n, 0, n);
        Common.drawHLine(graphics, f2 + f5, f + f3, f + f3 + (float)n2 - 1.0f, n, 0, n);
        Common.drawVLine(graphics, f + f3 + f5, f2 + f4, f2 + f4 + (float)n2 - 1.0f, n, n, 0);
        Common.drawHLine(graphics, f2 + f4 + f5, f + f3, f + f3 + (float)n2 - 1.0f, n, n, 0);
    }

    public static void drawString(Graphics graphics, String string, float f, float f2) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (graphics.getFont() instanceof StyleFont) {
            float f3;
            StyleFont styleFont = (StyleFont)graphics.getFont();
            FontMetrics fontMetrics = Common.getFontMetrics(styleFont);
            int n = styleFont.getStyle();
            if ((n & 0x40) != 0) {
                f2 -= Common.getAscent(fontMetrics) / 3.0f;
                styleFont = new StyleFont(styleFont.getName(), n, styleFont.getSize() * 2 / 3);
                fontMetrics = Common.getFontMetrics(styleFont);
                graphics.setFont(styleFont);
            } else if ((n & 0x80) != 0) {
                f2 += (float)(fontMetrics.getDescent() / 3);
                styleFont = new StyleFont(styleFont.getName(), n, styleFont.getSize() * 2 / 3);
                fontMetrics = Common.getFontMetrics(styleFont);
                graphics.setFont(styleFont);
            }
            Common.drawStringCase(graphics, string, f, f2);
            if ((n & 0x20) != 0) {
                f3 = f2 - Common.getAscent(fontMetrics) + Common.getHeight(styleFont, fontMetrics) / 2.0f - (float)((styleFont.getLineStyle() & 0xF) / 2);
                Common.drawHLine(graphics, f3, f, f + Common.stringWidth(string, styleFont), styleFont.getLineStyle(), 0, 0);
            }
            if ((n & 0x10) != 0) {
                f3 = f2 + (float)fontMetrics.getDescent() - 1.0f;
                Common.drawHLine(graphics, f3, f, f + Common.stringWidth(string, styleFont), styleFont.getLineStyle(), 0, 0);
            }
        } else {
            g2d.drawString(graphics, string, f, f2);
        }
    }

    public static void drawString(Graphics graphics, String string, float f, float f2, float f3) {
        float f4;
        if (string == null || string.length() == 0) {
            return;
        }
        Font font = graphics.getFont();
        FontMetrics fontMetrics = Common.getFontMetrics(font);
        Vector<String> vector = new Vector<String>();
        Vector<Float> vector2 = new Vector<Float>();
        int n = 0;
        int n2 = 0;
        if (font instanceof StyleFont && (((StyleFont)font).getStyle() & 0x10) != 0) {
            n2 = ((StyleFont)font).getLineStyle();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            f4 = Common.stringWidth(string2, font);
            vector.addElement(string2);
            vector2.addElement(new Float(f4));
            n = (int)((float)n + f4);
        }
        float f5 = (f3 - (float)n) / ((float)vector.size() - 1.0f);
        f4 = f;
        int n3 = 0;
        while (n3 < vector.size()) {
            Common.drawString(graphics, vector.elementAt(n3).toString(), f4, f2);
            f4 += ((Float)vector2.elementAt(n3)).floatValue();
            if (n2 != 0 && n3 < vector.size() - 1) {
                float f6 = f2 + (float)fontMetrics.getDescent() - 1.0f;
                Common.drawHLine(graphics, f6, f4, f4 + f5, n2, 0, 0);
            }
            f4 += f5;
            ++n3;
        }
    }

    static void drawStringCase(Graphics graphics, String string, float f, float f2) {
        StyleFont styleFont = (StyleFont)graphics.getFont();
        int n = styleFont.getStyle();
        if ((n & 0x200) != 0) {
            FontMetrics fontMetrics = Common.getFontMetrics(styleFont);
            Font font = new Font(styleFont.getName(), styleFont.getStyle(), styleFont.getSize() - 2);
            FontMetrics fontMetrics2 = Common.getFontMetrics(font);
            int n2 = 0;
            while (n2 < string.length()) {
                Color color;
                char c = string.charAt(n2);
                if (Character.isLowerCase(c)) {
                    c = Character.toUpperCase(c);
                    graphics.setFont(font);
                    if ((n & 0x100) != 0) {
                        color = graphics.getColor();
                        graphics.setColor(Util.brighter(color));
                        g2d.drawString(graphics, String.valueOf(c), f + 1.0f, f2 + 1.0f);
                        graphics.setColor(color);
                    }
                    g2d.drawString(graphics, String.valueOf(c), f, f2);
                    f += (float)fontMetrics2.charWidth(c);
                } else {
                    graphics.setFont(styleFont);
                    if ((n & 0x100) != 0) {
                        color = graphics.getColor();
                        graphics.setColor(Util.brighter(color));
                        g2d.drawString(graphics, String.valueOf(c), f + 1.0f, f2 + 1.0f);
                        graphics.setColor(color);
                    }
                    g2d.drawString(graphics, String.valueOf(c), f, f2);
                    f += (float)fontMetrics.charWidth(c);
                }
                ++n2;
            }
            graphics.setFont(styleFont);
        } else {
            if ((n & 0x400) != 0) {
                string = string.toUpperCase();
            }
            if ((n & 0x100) != 0) {
                Color color = graphics.getColor();
                graphics.setColor(Util.brighter(color));
                g2d.drawString(graphics, string, f + 1.0f, f2 + 1.0f);
                graphics.setColor(color);
            }
            g2d.drawString(graphics, string, f, f2);
        }
    }

    public static void drawVLine(Graphics graphics, float f, float f2, float f3, int n, int n2, int n3) {
        g2d.drawVLine(graphics, f, f2, f3, n, n2, n3);
    }

    public static void fill(Graphics graphics, Shape shape, Object object) {
        g2d.fill(graphics, shape, object);
    }

    public static void fillRect(Graphics graphics, float f, float f2, float f3, float f4) {
        g2d.fillRect(graphics, f, f2, f3, f4);
    }

    public static String[] getAllFonts() {
        return g2d.getAllFonts();
    }

    public static float getAscent(Font font) {
        return g2d.getAscent(Common.getFontMetrics(font));
    }

    public static float getAscent(FontMetrics fontMetrics) {
        return g2d.getAscent(fontMetrics);
    }

    public static Color getColor(int n) {
        return colors[n % colors.length];
    }

    public static FontMetrics getFontMetrics(Font font) {
        if (font == lastFn) {
            return lastFm;
        }
        FontMetrics fontMetrics = (FontMetrics)fmcache.get(font);
        if (fontMetrics == null) {
            fontMetrics = Common.getToolkit().getFontMetrics(font);
            fmcache.put(font, fontMetrics);
        }
        lastFn = font;
        lastFm = fontMetrics;
        return fontMetrics;
    }

    public static String getFontName(Font font) {
        return g2d.getFontName(font);
    }

    public static float getHeight(Font font, FontMetrics fontMetrics) {
        return g2d.getHeight(font, fontMetrics);
    }

    public static Image getImage(Object object, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = (object == null ? (class$inetsoft$report$Common != null ? class$inetsoft$report$Common : (class$inetsoft$report$Common = Common.class$("inetsoft.report.Common"))) : (object instanceof Class ? (Class)object : object.getClass())).getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            return Common.getToolkit().createImage(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Frame getInvisibleFrame() {
        if (root == null) {
            root = new Frame("invisible");
            root.pack();
        }
        return root;
    }

    public static float getLineAdjustment(Graphics graphics) {
        return g2d.getLineAdjustment(graphics);
    }

    public static String getPSName(Font font) {
        return g2d.getPSName(font);
    }

    public static Object getPaint(int n) {
        return g2d.getPaint(n);
    }

    public static PreviewView getPreviewView() {
        return g2d.getPreviewView();
    }

    public static Toolkit getToolkit() {
        if (toolkit == null) {
            toolkit = Toolkit.getDefaultToolkit();
        }
        return toolkit;
    }

    public static void paint(Graphics graphics, float f, float f2, float f3, float f4, Painter painter, float f5, float f6, float f7, float f8, float f9, Color color, Color color2) {
        g2d.paint(graphics, f, f2, f3, f4, painter, f5, f6, f7, f8, f9, color, color2);
    }

    public static void paintPage(Graphics graphics, PreviewPage previewPage) {
        g2d.paintPage(graphics, previewPage);
    }

    public static void paintRotate(Painter painter, Graphics graphics, float f, float f2, float f3, float f4) {
        g2d.paintRotate(painter, graphics, f, f2, f3, f4);
    }

    public static void paintText(StylePage stylePage, String string, final Bounds bounds, int n, boolean bl, final boolean bl2) {
        final Font font = stylePage.getFont();
        final Color color = stylePage.getForeground();
        final FontMetrics fontMetrics = Common.getFontMetrics(font);
        final Bounds bounds2 = new Bounds();
        final Vector vector = Common.processText(string, bounds, n, bl, stylePage.getFont(), bounds2);
        stylePage.addPaintable(new Paintable(){

            public Rectangle getBounds() {
                return bounds2.getRectangle();
            }

            public ReportElement getElement() {
                return null;
            }

            public void paint(Graphics graphics) {
                Shape shape = graphics.getClip();
                Common.clipRect(graphics, new Bounds(bounds.x, bounds.y, bounds.width, bounds.height));
                graphics.setColor(color);
                graphics.setFont(font);
                float f = bounds2.y + Common.getAscent(fontMetrics);
                int n = 0;
                while (n < vector.size()) {
                    if (bl2 && n < vector.size() - 1) {
                        Common.drawString(graphics, (String)vector.elementAt(n), bounds2.x, f, bounds2.width);
                    } else {
                        Common.drawString(graphics, (String)vector.elementAt(n), bounds2.x, f);
                    }
                    f += Common.getHeight(graphics.getFont(), fontMetrics);
                    ++n;
                }
                graphics.setClip(shape);
            }

            public void setLocation(Point point) {
            }
        });
    }

    public static void paintText(Graphics graphics, String string, Bounds bounds, int n, boolean bl, boolean bl2) {
        Bounds bounds2 = new Bounds();
        Vector vector = Common.processText(string, bounds, n, bl, graphics.getFont(), bounds2);
        Common.paintText(graphics, vector, bounds, bounds2, bl2);
    }

    public static void paintText(Graphics graphics, Vector vector, Bounds bounds, Bounds bounds2, boolean bl) {
        Shape shape = graphics.getClip();
        Common.clipRect(graphics, new Bounds(bounds.x, bounds.y, bounds.width, bounds.height));
        FontMetrics fontMetrics = Common.getFontMetrics(graphics.getFont());
        float f = bounds2.y + Common.getAscent(fontMetrics);
        int n = 0;
        while (n < vector.size()) {
            if (bl && n < vector.size() - 1) {
                Common.drawString(graphics, (String)vector.elementAt(n), bounds2.x, f, bounds2.width);
            } else {
                Common.drawString(graphics, (String)vector.elementAt(n), bounds2.x, f);
            }
            f += Common.getHeight(graphics.getFont(), fontMetrics);
            ++n;
        }
        graphics.setClip(shape);
    }

    public static void print(StyleSheet styleSheet) throws Exception {
        g2d.print(styleSheet);
    }

    public static void print(String string, Enumeration enumeration) throws Exception {
        g2d.print(string, enumeration);
    }

    public static Vector processText(String string, Bounds bounds, int n, boolean bl, Font font, Bounds bounds2) {
        Vector<String> vector = new Vector<String>();
        if (bounds.width <= 0.0f || bounds.height <= 0.0f) {
            return vector;
        }
        Size size = new Size();
        FontMetrics fontMetrics = Common.getFontMetrics(font);
        while (string.length() > 0) {
            int n2 = string.indexOf(10);
            if (bl) {
                int n3 = n2 >= 0 ? n2 : Math.min(string.length(), (int)((double)bounds.width / ((double)fontMetrics.charWidth(' ') * 0.8)));
                String string2 = string.substring(0, n3);
                boolean bl2 = true;
                if (Common.stringWidth(string2, font) > bounds.width) {
                    int n4 = Math.max(1, n3) - 1;
                    string2 = string.substring(0, n4);
                    while (n4 > 0 && Common.stringWidth(string2, font) > bounds.width) {
                        string2 = string.substring(0, --n4);
                    }
                    n3 = n4;
                    while (n3 > 0 && !Character.isWhitespace(string.charAt(n3))) {
                        --n3;
                    }
                    if (n3 <= 0) {
                        n3 = n4;
                        bl2 = false;
                    }
                    string2 = string.substring(0, n3);
                }
                vector.addElement(Util.trimEnd(string2));
                size.width = Math.max(size.width, Common.stringWidth(string2, font));
                if (n3 >= string.length()) break;
                string = string.substring(bl2 ? n3 + 1 : Math.max(n3, 1));
                continue;
            }
            if (n2 >= 0) {
                String string3 = string.substring(0, n2);
                size.width = Math.max(size.width, Common.stringWidth(string3, font));
                string = string.substring(n2 + 1);
                vector.addElement(Util.trimEnd(string3));
                continue;
            }
            size.width = Math.max(size.width, Common.stringWidth(string, font));
            vector.addElement(Util.trimEnd(string));
            break;
        }
        size.height = Common.getHeight(fontMetrics.getFont(), fontMetrics) * (float)vector.size();
        Bounds bounds3 = Common.alignCell(bounds, size, n);
        bounds2.x = bounds3.x;
        bounds2.y = bounds3.y + Math.max((bounds3.height - size.height) / 2.0f, 0.0f);
        bounds2.width = bounds3.width;
        bounds2.height = Math.min(size.height, bounds.y + bounds.height - bounds2.y);
        return vector;
    }

    public static int round(double d) {
        return (int)Math.ceil(d);
    }

    public static void setClip(Graphics graphics, Bounds bounds) {
        g2d.setClip(graphics, bounds);
    }

    public static void startPage(Graphics graphics, StylePage stylePage) {
        g2d.startPage(graphics, stylePage);
    }

    public static float stringWidth(String string, Font font) {
        return Common.stringWidth(string, font, Common.getFontMetrics(font));
    }

    public static float stringWidth(String string, Font font, FontMetrics fontMetrics) {
        if (string == null) {
            return 0.0f;
        }
        if (font instanceof StyleFont) {
            StyleFont styleFont = (StyleFont)font;
            int n = styleFont.getStyle();
            if ((n & 0x40) != 0 || (n & 0x80) != 0) {
                styleFont = new StyleFont(styleFont.getName(), n, styleFont.getSize() * 2 / 3);
                font = styleFont;
                fontMetrics = Common.getFontMetrics(styleFont);
            }
            if ((n & 0x200) != 0) {
                Font font2 = new Font(styleFont.getName(), styleFont.getStyle(), styleFont.getSize() - 2);
                FontMetrics fontMetrics2 = Common.getFontMetrics(font2);
                int n2 = 0;
                int n3 = 0;
                while (n3 < string.length()) {
                    char c = string.charAt(n3);
                    n2 = Character.isLowerCase(c) ? (n2 += fontMetrics2.charWidth(Character.toUpperCase(c))) : (n2 += fontMetrics.charWidth(c));
                    ++n3;
                }
                return n2;
            }
            if ((n & 0x400) != 0) {
                return g2d.stringWidth(string.toUpperCase(), font, fontMetrics);
            }
        }
        return g2d.stringWidth(string, font, fontMetrics);
    }

    public static void writeJPEG(Image image, OutputStream outputStream) {
        JpegEncoder jpegEncoder = new JpegEncoder(image, 80, outputStream);
        jpegEncoder.Compress();
    }
}

