/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.report;

import inetsoft.report.ChartLens;
import inetsoft.report.Common;
import inetsoft.report.Painter;
import inetsoft.report.ReportElement;
import inetsoft.report.StyleConstants;
import inetsoft.report.internal.Bounds;
import inetsoft.report.internal.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ChartPainter
implements Painter,
StyleConstants {
    private double contrast = 0.8;
    FontMetrics fm = null;
    int[] xPos;
    Vector areas = new Vector();
    int xInc;
    int yHeight;
    Point center;
    Point zero;
    double yMin;
    double yMax;
    double ygap = 0.05;
    int xgap = 5;
    int ggap = 8;
    double maxVal;
    double minVal;
    Point titleOff = new Point(0, 0);
    Rectangle legendBox;
    Dimension legendDim;
    Insets legendSpace;
    int legendCnt;
    Vector legendLabels = new Vector();
    static final int lgap = 3;
    ChartLens model;
    ReportElement context;
    Dimension size = null;

    public ChartPainter(ChartLens chartLens, ReportElement reportElement) {
        this.model = chartLens;
        this.context = reportElement;
    }

    private Object brighter(Object object) {
        if (object instanceof Color) {
            Color color = (Color)object;
            return new Color(Math.min((int)((double)color.getRed() * (1.0 / this.contrast)), 255), Math.min((int)((double)color.getGreen() * (1.0 / this.contrast)), 255), Math.min((int)((double)color.getBlue() * (1.0 / this.contrast)), 255));
        }
        return object;
    }

    private void calcRange() {
        if (this.model.getDatasetCount() <= 0) {
            this.maxVal = this.model.getMaximum() == null ? 1.0 : this.model.getMaximum().doubleValue();
            this.minVal = 0.0;
            return;
        }
        this.minVal = 0.0;
        this.maxVal = 0.0;
        boolean bl = true;
        int n = this.model.getStyle();
        int n2 = 0;
        while (n2 < this.model.getDatasetSize()) {
            double d = 0.0;
            double d2 = 0.0;
            int n3 = 0;
            while (n3 < this.model.getDatasetCount()) {
                double d3;
                Number number = this.model.getData(n3, n2);
                double d4 = d3 = number == null ? 0.0 : number.doubleValue();
                if (n == 3 || n == 7 || n == 14) {
                    if (d3 > 0.0) {
                        d += d3;
                    } else {
                        d2 += d3;
                    }
                } else {
                    if (bl || d3 > this.maxVal) {
                        this.maxVal = d3;
                    }
                    if (bl || d3 < this.minVal) {
                        this.minVal = d3;
                    }
                    bl = false;
                }
                ++n3;
            }
            if (n == 3 || n == 7 || n == 14) {
                if (d > this.maxVal) {
                    this.maxVal = d;
                }
                if (d2 != 0.0 && d2 < this.minVal) {
                    this.minVal = d2;
                } else if (d < this.minVal) {
                    this.minVal = d;
                }
            }
            ++n2;
        }
        if (this.model.getMaximum() != null) {
            this.maxVal = this.model.getMaximum().doubleValue();
        }
        if (this.model.getMinimum() != null) {
            this.minVal = this.model.getMinimum().doubleValue();
        } else if (n == 4106) {
            this.minVal = 0.0;
        }
        this.maxVal = this.maxVal == 0.0 ? 1.0 : this.maxVal;
    }

    private Object darker(Object object) {
        if (object instanceof Color) {
            Color color = (Color)object;
            return new Color(Math.max((int)((double)color.getRed() * this.contrast), 0), Math.max((int)((double)color.getGreen() * this.contrast), 0), Math.max((int)((double)color.getBlue() * this.contrast), 0));
        }
        return object;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void doLayout() {
        block35: {
            block39: {
                block38: {
                    block37: {
                        block36: {
                            block33: {
                                block34: {
                                    var1_1 = this.getSize();
                                    if (this.fm == null || this.model.getDatasetCount() == 0 || this.model.getDatasetSize() == 0 || var1_1.width <= 0 || var1_1.height <= 0) {
                                        return;
                                    }
                                    this.calcRange();
                                    var2_2 = this.model.getYTitle();
                                    var3_3 = this.model.getXTitle();
                                    this.legendBox = new Rectangle();
                                    this.legendDim = new Dimension();
                                    if (this.model.getLegendPosition() == 0) break block33;
                                    var4_4 = this.model.getLegendPosition();
                                    var5_6 = var4_4 != 1 && var4_4 != 4 ? 0 : 1;
                                    var6_7 = 0;
                                    var7_10 = (int)Common.getHeight(this.context.getFont(), null);
                                    if (!Util.isFlatDatasetChart(this.model.getStyle()) || this.model.getDatasetCount() != 1) break block34;
                                    this.legendCnt = this.model.getDatasetSize();
                                    this.legendLabels.setSize(this.legendCnt);
                                    var8_11 = 0;
                                    if (true) ** GOTO lbl30
                                }
                                this.legendCnt = this.model.getDatasetCount();
                                this.legendLabels.setSize(this.legendCnt);
                                var8_11 = 0;
                                if (true) ** GOTO lbl35
                            }
                            this.legendSpace = new Insets(0, 0, 0, 0);
                            break block35;
                            do {
                                this.legendLabels.setElementAt(this.model.getLabel(var8_11), var8_11);
                                ++var8_11;
lbl30:
                                // 2 sources

                            } while (var8_11 < this.legendCnt);
                            break block36;
                            do {
                                this.legendLabels.setElementAt(this.model.getDatasetLabel(var8_11), var8_11);
                                ++var8_11;
lbl35:
                                // 2 sources

                            } while (var8_11 < this.legendCnt);
                        }
                        var8_11 = 0;
                        while (var8_11 < this.legendCnt) {
                            var9_13 = (String)this.legendLabels.elementAt(var8_11);
                            var6_7 = Math.max(var6_7, (int)Common.stringWidth(var9_13, this.context.getFont()));
                            ++var8_11;
                        }
                        var6_7 += 3 * this.ggap;
                        var6_7 = Math.min(var6_7, (var5_6 != 0 ? var1_1.width / 2 : var1_1.width) - 40);
                        if (var5_6 == 0) break block37;
                        var9_14 = var1_1.height - 2 * this.ggap;
                        var10_15 = 0;
                        ** GOTO lbl55
                    }
                    var9_14 = var1_1.width - 2 * this.ggap;
                    var10_15 = 0;
                    ** GOTO lbl71
                    while ((var9_14 -= var7_10) >= var7_10) {
                        ++var10_15;
lbl55:
                        // 2 sources

                        if (var10_15 < this.legendCnt) continue;
                    }
                    if (var9_14 < var7_10) break block38;
                    this.legendDim.width = 1;
                    this.legendDim.height = this.legendCnt;
                    this.legendBox = var4_4 == 1 ? new Rectangle(this.ggap, var9_14 / 2 + this.ggap, var6_7, var1_1.height - var9_14 - 2 * this.ggap) : new Rectangle(var1_1.width - var6_7 - this.ggap, var9_14 / 2 + this.ggap, var6_7, var1_1.height - var9_14 - 2 * this.ggap);
                    break block39;
                }
                this.legendDim.height = var10_15;
                this.legendDim.width = (int)Math.ceil((double)this.legendCnt / (double)var10_15);
                this.legendBox = new Rectangle(this.ggap, this.ggap, var6_7 * this.legendDim.width, var1_1.height - 2 * this.ggap);
                if (var4_4 != 4) break block39;
                this.legendBox.x = var1_1.width - this.legendBox.width - 2 * this.ggap;
                break block39;
                while (var9_14 >= var6_7) {
                    var9_14 -= var6_7;
                    ++var10_15;
lbl71:
                    // 2 sources

                    if (var10_15 < this.legendCnt) continue;
                }
                if (var9_14 >= var6_7) {
                    this.legendDim.height = 1;
                    this.legendDim.width = this.legendCnt;
                    this.legendBox = var4_4 == 8 ? new Rectangle(var9_14 / 2 + this.ggap, this.ggap, var1_1.width - var9_14 - 10, var7_10 + 2 * this.ggap) : new Rectangle(var9_14 / 2 + this.ggap, var1_1.height - var7_10 - 2 * this.ggap, var1_1.width - var9_14 - 2 * this.ggap, var7_10 + this.ggap);
                } else {
                    this.legendDim.width = var10_15;
                    this.legendDim.height = (int)Math.ceil((double)this.legendCnt / (double)var10_15);
                    this.legendBox = new Rectangle(this.ggap, this.ggap, var6_7 * this.legendDim.width, var7_10 * this.legendDim.height + this.ggap);
                    if (var4_4 == 32) {
                        this.legendBox.y = var1_1.height - this.legendBox.height - 2 * this.ggap;
                    }
                }
                this.legendBox.x = (var1_1.width - this.legendBox.width) / 2;
            }
            switch (var4_4) {
                case 1: {
                    this.legendSpace = new Insets(0, this.legendBox.x + this.legendBox.width, 0, 0);
                    break;
                }
                case 4: {
                    this.legendSpace = new Insets(0, 0, 0, var1_1.width - this.legendBox.x);
                    break;
                }
                case 8: {
                    this.legendSpace = new Insets(this.legendBox.y + this.legendBox.height, 0, 0, 0);
                    break;
                }
                case 32: {
                    this.legendSpace = new Insets(0, 0, var1_1.height - this.legendBox.y, 0);
                    break;
                }
            }
        }
        this.titleOff = new Point(0, var3_3 == null || var3_3.length() == 0 ? 0 : this.fm.getHeight() + this.ggap);
        if (var2_2 != null && var2_2.length() > 0) {
            var4_5 = new StringTokenizer(var2_2);
            var5_6 = 0;
            var6_8 = this.model.getTitleFont();
            if (var6_8 == null) {
                var6_8 = this.context.getFont();
            }
            while (var4_5.hasMoreElements()) {
                var5_6 = Math.max(var5_6, (int)Common.stringWidth(var4_5.nextElement().toString(), var6_8));
            }
            this.titleOff.x = var5_6 + 2 * this.ggap;
        }
        var4_4 = Math.max(this.fm.stringWidth(this.toString(new Double(this.maxVal))), this.fm.stringWidth(this.toString(new Double(this.minVal)))) + this.fm.charWidth('M');
        var5_6 = this.model.getDatasetSize();
        var6_9 = this.model.getStyle();
        var7_10 = var6_9 == 5 || var6_9 == 7 || var6_9 == 9 ? 1 : 0;
        switch (var6_9) {
            case 1: 
            case 5: {
                var5_6 = var5_6 * this.model.getDatasetCount() + 1;
                break;
            }
            case 4107: {
                var5_6 *= this.model.getDatasetCount();
                break;
            }
            case 9: {
                var7_10 += this.model.getDatasetCount() / 4;
            }
            case 3: 
            case 7: {
                ++var5_6;
                break;
            }
        }
        this.xPos = new int[var5_6];
        var8_12 = this.model.getLabel(this.model.getDatasetSize() - 1);
        var9_14 = var4_4 + this.ggap + this.xgap + this.titleOff.x + this.legendSpace.left;
        var10_15 = var1_1.width - var9_14 - this.ggap - this.legendSpace.right - (var8_12 == null ? 1 : this.fm.stringWidth(var8_12)) / 2;
        this.xInc = Math.max(var10_15 / Math.max((var7_10 += var5_6) - 1, 1), 1);
        var10_15 = this.xInc * var5_6;
        this.center = new Point(var9_14 - this.xgap, var1_1.height - this.fm.getHeight() - this.ggap - this.titleOff.y - this.legendSpace.bottom);
        this.yHeight = this.center.y - this.ggap - this.legendSpace.top - (this.model.isShowValue() != false ? this.fm.getHeight() : 0);
        if (var6_9 == 5 || var6_9 == 7) {
            this.yHeight -= this.xInc / 2;
        } else if (var6_9 == 9) {
            var11_16 = this.yHeight - (this.model.getDatasetCount() + 1) * this.xInc / 4;
            if (var11_16 < 50) {
                this.xInc = (this.yHeight - 50) * 4 / (this.model.getDatasetCount() + 1);
                this.yHeight = 50;
            } else {
                this.yHeight = var11_16;
            }
        }
        var11_16 = 0;
        while (var11_16 < var5_6) {
            this.xPos[var11_16] = var9_14 + var10_15 * var11_16 / var5_6;
            ++var11_16;
        }
        var12_17 = (this.maxVal - this.minVal) * this.ygap;
        this.yMin = this.minVal > 0.0 ? this.minVal - var12_17 : this.minVal;
        this.yMax = this.maxVal + var12_17;
        this.zero = this.minVal >= 0.0 ? new Point(this.center) : new Point(this.center.x, this.translate(new Integer(0)));
    }

    private void draw3DBar(Graphics graphics, int n, int n2, int n3, int n4, Object object, int n5, int n6) {
        int n7 = this.model.getGap() >= n3 ? 0 : this.model.getGap();
        Rectangle rectangle = new Rectangle(n += n7 / 2, n2, n3 - n7, n4);
        Common.fill(graphics, rectangle, this.darker(object));
        this.areas.addElement(new GraphArea(n5, n6, rectangle));
        int[] nArray = new int[]{n, n + n3 / 4, n + n3 + n3 / 4 - n7, n + n3 - n7};
        int[] nArray2 = new int[]{n2, n2 - n3 / 4, n2 - n3 / 4, n2};
        Polygon polygon = new Polygon(nArray, nArray2, nArray.length);
        Common.fill(graphics, polygon, this.brighter(object));
        this.areas.addElement(new GraphArea(n5, n6, polygon));
        int[] nArray3 = new int[]{n + n3 - n7, n + n3 - n7 + n3 / 4, n + n3 - n7 + n3 / 4, n + n3 - n7};
        int[] nArray4 = new int[]{n2, n2 - n3 / 4, n2 + n4 - n3 / 4, n2 + n4};
        Polygon polygon2 = new Polygon(nArray3, nArray4, nArray3.length);
        Common.fill(graphics, polygon2, this.darker(this.darker(object)));
        this.areas.addElement(new GraphArea(n5, n6, polygon2));
    }

    public ChartLens getChart() {
        return this.model;
    }

    public Dimension getPreferredSize() {
        return new Dimension(-1000, -500);
    }

    public Shape[] getShapes(int n, int n2) {
        Object object;
        Vector<Shape> vector = new Vector<Shape>();
        int n3 = this.areas.size() - 1;
        while (n3 >= 0) {
            object = (GraphArea)this.areas.elementAt(n3);
            if (((GraphArea)object).x == n2 && ((GraphArea)object).y == n) {
                vector.addElement(((GraphArea)object).getShape());
            }
            --n3;
        }
        object = new Shape[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public Dimension getSize() {
        return this.size;
    }

    public boolean isScalable() {
        return true;
    }

    public Point locate(int n, int n2) {
        int n3 = this.areas.size() - 1;
        while (n3 >= 0) {
            GraphArea graphArea = (GraphArea)this.areas.elementAt(n3);
            if (graphArea.contains(n, n2)) {
                return new Point(graphArea.x, graphArea.y);
            }
            --n3;
        }
        return null;
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics(this.context.getFont());
        }
        if (this.model.getDatasetCount() == 0 || this.model.getDatasetSize() == 0 || n3 <= 0 || n4 <= 0) {
            return;
        }
        this.size = new Dimension(n3, n4);
        this.doLayout();
        Graphics graphics2 = graphics.create(n, n2, n3, n4);
        graphics2.setColor(this.context.getBackground());
        graphics2.fillRect(0, 0, n3, n4);
        graphics2.setColor(this.context.getForeground());
        graphics2.setFont(this.context.getFont());
        this.areas.removeAllElements();
        int n5 = this.model.getStyle();
        switch (n5) {
            case 4098: {
                this.paintLine(graphics2);
                break;
            }
            case 4100: {
                this.paintPoint(graphics2);
                break;
            }
            case 1: {
                this.paintBar(graphics2);
                break;
            }
            case 5: {
                this.paintBar3D(graphics2);
                break;
            }
            case 9: {
                this.paintBar3D3D(graphics2);
                break;
            }
            case 3: {
                this.paintStackBar(graphics2);
                break;
            }
            case 7: {
                this.paintStackBar3D(graphics2);
                break;
            }
            case 6: {
                this.paintPie(graphics2, false, true);
                break;
            }
            case 8198: {
                this.paintPie(graphics2, false, false);
                break;
            }
            case 8: {
                this.paintPie(graphics2, true, true);
                break;
            }
            case 8200: {
                this.paintPie(graphics2, true, false);
                break;
            }
            case 4106: {
                this.paintStock(graphics2);
                break;
            }
            case 4107: {
                this.paintStick(graphics2);
                break;
            }
            case 12: {
                this.paintArea(graphics2);
                break;
            }
            case 14: {
                this.paintStackArea(graphics2);
                break;
            }
            default: {
                System.err.println("Invalid Chart Type: " + n5);
                System.err.println("You may need to recompile your program.");
            }
        }
        if (this.model.getBorderStyle() != 0) {
            int n6 = this.model.getBorderStyle();
            int n7 = (n6 & 0xF) + 1;
            float f = Common.getLineAdjustment(graphics2);
            Common.drawHLine(graphics2, f, 0.0f, n3 - n7, n6, 0, n6);
            Common.drawVLine(graphics2, f, 0.0f, n4 - n7, n6, 0, n6);
            Common.drawHLine(graphics2, f, n3 - n7, n3 - 2, n6, 0, n6);
            Common.drawVLine(graphics2, f, n4 - n7, n4 - 2, n6, 0, n6);
            if ((n6 & 0x4000) != 0) {
                n6 &= 0xFFFFBFFF;
                n6 |= 0x8000;
            } else if ((n6 & 0x8000) != 0) {
                n6 &= 0xFFFF7FFF;
                n6 |= 0x4000;
            }
            Common.drawHLine(graphics2, (float)(n4 - n7) + f, 0.0f, n3 - n7, n6, n6, 0);
            Common.drawVLine(graphics2, (float)n3 + f - (float)n7, 0.0f, n4 - n7, n6, n6, 0);
            Common.drawVLine(graphics2, (float)(n3 - n7) + f, n4 - n7, n4 - 2, n6, n6, 0);
            Common.drawHLine(graphics2, (float)(n4 - n7) + f, n3 - n7, n3 - 2, n6, n6, 0);
        }
        if (this.model.getLegendPosition() != 0) {
            this.paintLegend(graphics2);
        }
        graphics2.dispose();
    }

    private void paintArea(Graphics graphics) {
        int n;
        int n2;
        int n3;
        this.paintCoord(graphics);
        Color color = graphics.getColor();
        int n4 = this.model.getDatasetCount() - 1;
        while (n4 >= 0) {
            Polygon polygon = new Polygon();
            n3 = 1;
            while (n3 < this.model.getDatasetSize()) {
                n2 = this.xPos[n3 - 1];
                n = this.translate(this.model.getData(n4, n3 - 1));
                int n5 = this.xPos[n3];
                int n6 = this.translate(this.model.getData(n4, n3));
                if (n3 == 1) {
                    polygon.addPoint(n2, this.zero.y);
                    polygon.addPoint(n2, n);
                }
                polygon.addPoint(n5, n6);
                if (n3 == this.model.getDatasetSize() - 1) {
                    polygon.addPoint(n5, this.zero.y);
                }
                int[] nArray = new int[]{n2, n2, n5, n5};
                int[] nArray2 = new int[]{this.zero.y, n, n6, this.zero.y};
                this.areas.addElement(new GraphArea(n3, n4, new Polygon(nArray, nArray2, 4)));
                ++n3;
            }
            Common.fill(graphics, polygon, this.model.getColor(n4));
            --n4;
        }
        graphics.setColor(this.context.getForeground());
        if (this.model.isShowValue()) {
            int n7 = 0;
            while (n7 < this.model.getDatasetCount()) {
                n3 = 0;
                while (n3 < this.model.getDatasetSize()) {
                    n2 = this.xPos[n3] - 1;
                    n = this.translate(this.model.getData(n7, n3));
                    String string = this.toString(this.model.getData(n7, n3));
                    Common.drawString(graphics, string, n2 - this.fm.stringWidth(string) / 2, n - this.fm.getDescent());
                    ++n3;
                }
                ++n7;
            }
        }
        graphics.setColor(color);
    }

    private void paintBar(Graphics graphics) {
        this.paintCoord(graphics);
        boolean bl = this.model.getDatasetCount() == 1;
        Color color = graphics.getColor();
        int n = 0;
        int n2 = this.model.getGap();
        int n3 = 0;
        while (n3 < this.model.getDatasetSize()) {
            int n4 = 0;
            while (n4 < this.model.getDatasetCount()) {
                Object object;
                int n5 = this.translate(this.model.getData(n4, n3));
                Rectangle rectangle = null;
                int n6 = Math.max(1, this.xPos[n + 1] - this.xPos[n] - n2);
                rectangle = n5 < this.zero.y ? new Rectangle(this.xPos[n] + n2 / 2, n5, n6, this.zero.y - n5) : new Rectangle(this.xPos[n] + n2 / 2, this.zero.y, n6, n5 - this.zero.y);
                this.areas.addElement(new GraphArea(n3, n4, rectangle));
                Object object2 = this.model.getColor(bl ? n3 : n4);
                if (object2 instanceof Image) {
                    object = (Image)object2;
                    Shape shape = graphics.getClip();
                    graphics.setClip(rectangle);
                    int n7 = ((Image)object).getHeight(null);
                    int n8 = ((Image)object).getWidth(null);
                    if (n7 < 0) {
                        n7 = n8 = rectangle.width - 2;
                    }
                    int n9 = rectangle.x + (rectangle.width - n8) / 2;
                    int n10 = rectangle.y + rectangle.height;
                    while (n10 > rectangle.y) {
                        graphics.drawImage((Image)object, n9, n10 - n7, null);
                        n10 -= n7;
                    }
                    graphics.setClip(shape);
                } else {
                    Common.fill(graphics, rectangle, object2);
                }
                if (this.model.isShowValue()) {
                    object = this.toString(this.model.getData(n4, n3));
                    graphics.setColor(this.context.getForeground());
                    Common.drawString(graphics, (String)object, rectangle.x + (rectangle.width - this.fm.stringWidth((String)object)) / 2, rectangle.y - this.fm.getDescent());
                }
                ++n4;
                ++n;
            }
            ++n3;
        }
        graphics.setColor(color);
    }

    private void paintBar3D(Graphics graphics) {
        this.paintCoord(graphics);
        boolean bl = this.model.getDatasetCount() == 1;
        Color color = graphics.getColor();
        int n = 0;
        int n2 = 0;
        while (n2 < this.model.getDatasetSize()) {
            int n3 = 0;
            while (n3 < this.model.getDatasetCount()) {
                int n4 = this.translate(this.model.getData(n3, n2));
                Rectangle rectangle = null;
                rectangle = n4 < this.zero.y ? new Rectangle(this.xPos[n], n4, this.xInc, this.zero.y - n4) : new Rectangle(this.xPos[n], this.zero.y, this.xInc, n4 - this.zero.y);
                this.draw3DBar(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.model.getColor(bl ? n2 : n3), n2, n3);
                if (this.model.isShowValue()) {
                    String string = this.toString(this.model.getData(n3, n2));
                    graphics.setColor(this.context.getForeground());
                    Common.drawString(graphics, string, this.xPos[n] + (this.xInc - this.fm.stringWidth(string)) / 2, n4 - this.fm.getDescent());
                }
                ++n3;
                ++n;
            }
            ++n2;
        }
        graphics.setColor(color);
    }

    private void paintBar3D3D(Graphics graphics) {
        this.paintCoord(graphics);
        Color color = graphics.getColor();
        boolean bl = this.model.getDatasetCount() == 1;
        int n = this.xInc / 4;
        int n2 = this.xInc / 4;
        int n3 = this.model.getDatasetCount() - 1;
        while (n3 >= 0) {
            int n4 = 0;
            while (n4 < this.model.getDatasetSize()) {
                int n5 = this.translate(this.model.getData(n3, n4));
                Object var9_9 = null;
                if (n5 < this.zero.y) {
                    this.draw3DBar(graphics, this.xPos[n4] + n3 * n, n5 - n3 * n2, this.xInc, this.zero.y - n5, this.model.getColor(bl ? n4 : n3), n4, n3);
                } else {
                    this.draw3DBar(graphics, this.xPos[n4] + n3 * n, this.zero.y - n3 * n2, this.xInc, n5 - this.zero.y, this.model.getColor(bl ? n4 : n3), n4, n3);
                }
                if (this.model.isShowValue()) {
                    String string = this.toString(this.model.getData(n3, n4));
                    graphics.setColor(this.context.getForeground());
                    Common.drawString(graphics, string, this.xPos[n4] + n3 * n + (this.xInc - this.fm.stringWidth(string)) / 2, n5 - n3 * n2 - this.fm.getDescent());
                }
                ++n4;
            }
            --n3;
        }
        graphics.setColor(color);
    }

    private void paintCoord(Graphics graphics) {
        Object object;
        int n;
        double d;
        float f = Common.getLineAdjustment(graphics);
        Common.drawHLine(graphics, (float)this.zero.y + f, this.center.x, this.xPos[this.xPos.length - 1] + this.xgap, 4097, 0, 0);
        Common.drawVLine(graphics, (float)this.center.x + f, this.center.y, this.center.y - this.yHeight, 4097, 0, 0);
        String string = this.model.getXTitle();
        String string2 = this.model.getYTitle();
        int n2 = this.model.getStyle();
        if (this.model.getTitleFont() != null) {
            graphics.setFont(this.model.getTitleFont());
        }
        if (string != null) {
            Common.drawString(graphics, string, (this.xPos[this.xPos.length - 1] - this.center.x - this.fm.stringWidth(string)) / 2 + this.center.x, this.getSize().height - this.fm.getHeight() - this.legendSpace.bottom + this.fm.getDescent());
        }
        if (string2 != null) {
            Bounds bounds = new Bounds(this.legendSpace.left + 2 * this.ggap, this.center.y - this.yHeight, this.titleOff.x, this.yHeight);
            Common.paintText(graphics, string2, bounds, 18, true, false);
        }
        graphics.setFont(this.context.getFont());
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 < this.model.getDatasetSize()) {
            String string3 = this.model.getLabel(n4);
            int n6 = n2 == 5 || n2 == 1 || n2 == 4107 ? n5 + this.model.getDatasetCount() : n5 + 1;
            int n7 = string3 == null ? 1 : (int)Common.stringWidth(string3, graphics.getFont(), this.fm);
            int n8 = Util.isFlatDatasetChart(n2) ? this.xPos[n5] + this.xInc * (n6 - n5) / 2 : this.xPos[n5];
            int n9 = n8 - n7 / 2;
            if (n9 >= n3 + 2 && string3 != null) {
                Common.drawVLine(graphics, (float)n8 + f, this.zero.y, this.zero.y + 3, 4097, 0, 0);
                Common.drawString(graphics, string3, n9, this.zero.y + this.fm.getAscent() + 3);
                n3 = n9 + n7;
            }
            n5 = n6;
            ++n4;
        }
        if (this.model.getIncrement() == null) {
            double d2 = (this.yMax - this.yMin) / 6.0;
            if (d2 >= 1.0) {
                d = 1.0;
                while (d < d2) {
                    d *= 2.0;
                }
            } else if (d2 > 0.0) {
                d = 0.5;
                while (d > d2) {
                    d /= 5.0;
                }
                d *= 5.0;
            } else {
                d = 0.5;
            }
        } else {
            d = this.model.getIncrement().doubleValue();
        }
        double d3 = 0.0;
        if (this.model.getMinimum() == null) {
            while (this.yMin < 0.0 && d3 > this.yMin + d || this.yMin > 0.0 && d3 < this.yMin) {
                d3 += this.yMin >= 0.0 ? d : -d;
            }
        } else {
            d3 = this.model.getMinimum().doubleValue();
        }
        Rectangle rectangle = null;
        int n10 = 0;
        int n11 = 0;
        if (n2 == 5 || n2 == 7 || n2 == 9) {
            n = (n2 == 9 ? this.model.getDatasetCount() : 1) + 1;
            rectangle = new Rectangle(this.center.x + n * this.xInc / 4, this.center.y - (this.yHeight + n * this.xInc / 4), this.xPos[this.xPos.length - 1] + this.xgap - this.center.x, this.yHeight);
            n10 = rectangle.x - this.center.x;
            n11 = this.center.y - rectangle.y - this.yHeight;
            object = new int[]{this.zero.x, rectangle.x, rectangle.x + rectangle.width, this.zero.x + rectangle.width};
            int[] nArray = new int[]{this.zero.y, this.zero.y - n11, this.zero.y - n11, this.zero.y};
            graphics.drawPolygon((int[])object, nArray, ((Object)object).length);
            graphics.setColor((Color)this.darker(this.context.getBackground()));
            graphics.fillPolygon((int[])object, nArray, ((Object)object).length);
            graphics.setColor(this.context.getForeground());
            graphics.drawLine(this.center.x, this.center.y, rectangle.x, rectangle.y + rectangle.height);
            graphics.drawLine(this.center.x, this.center.y - rectangle.height, rectangle.x, rectangle.y);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        while (d3 < this.yMax) {
            n = this.translate(new Double(d3));
            Object object2 = object = Math.ceil(d3) == d3 ? Integer.toString((int)d3) : Double.toString(d3);
            if (((String)object).length() > 4) {
                boolean bl = false;
                int n12 = 0;
                while (n12 < ((String)object).length()) {
                    if (((String)object).charAt(n12) != '0' && ((String)object).charAt(n12) != '.') break;
                    bl = true;
                    ++n12;
                }
                if (!bl) {
                    n12 = ((String)object).indexOf(46) + 1;
                }
                if (n12 > 0 && ((String)(object = ((String)object).substring(0, Math.min(n12 + 3, ((String)object).length())))).indexOf(46) >= 0) {
                    int n13 = ((String)object).length() - 1;
                    while (n13 >= 0) {
                        if (((String)object).charAt(n13) != '0') {
                            object = ((String)object).substring(0, n13 + 1);
                            break;
                        }
                        --n13;
                    }
                }
            }
            if (n != this.zero.y) {
                Common.drawHLine(graphics, (float)n + f, this.center.x, this.center.x - 3, 4097, 0, 0);
            }
            Common.drawString(graphics, (String)object, this.center.x - this.fm.stringWidth((String)object) - 3, n + this.fm.getHeight() / 2);
            if (this.model.getMinorIncrement() != null) {
                double d4 = this.model.getMinorIncrement().doubleValue();
                double d5 = d3;
                while (d5 < d3 + d && d5 < this.yMax) {
                    int n14 = this.translate(new Double(d5));
                    Common.drawHLine(graphics, (float)n14 + f, this.center.x, this.center.x - 3, 4097, 0, 0);
                    d5 += d4;
                }
            }
            if (this.model.getGridStyle() != 0 && n != this.zero.y) {
                if (rectangle != null) {
                    graphics.drawLine(this.center.x, n, this.center.x + n10, n - n11);
                    Common.drawHLine(graphics, (float)(n - n11) + f, rectangle.x, rectangle.x + rectangle.width, this.model.getGridStyle(), 0, 0);
                } else {
                    Common.drawHLine(graphics, (float)n + f, this.center.x, this.xPos[this.xPos.length - 1] + this.xgap, this.model.getGridStyle(), 0, 0);
                }
            }
            d3 += d;
        }
    }

    private void paintLegend(Graphics graphics) {
        Dimension dimension = new Dimension(this.legendBox.width, this.legendBox.height);
        Graphics graphics2 = graphics.create(this.legendBox.x, this.legendBox.y, this.legendBox.width, this.legendBox.height);
        graphics2.setColor(this.context.getBackground());
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        graphics2.setColor(this.context.getForeground());
        graphics2.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics2.setFont(this.context.getFont());
        int n = 0;
        int n2 = 0;
        while (n2 < this.legendCnt) {
            String string = (String)this.legendLabels.elementAt(n2);
            n = Math.max(n, (int)Common.stringWidth(string, graphics2.getFont()));
            ++n2;
        }
        int n3 = this.legendDim.height;
        int n4 = this.legendDim.width;
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n5 = (dimension.width - 3 * (n4 + 1)) / n4;
        int n6 = (dimension.height - 3 * (n3 + 1)) / n3;
        int n7 = Math.max(n5 - n - 9, 8);
        int n8 = 0;
        int n9 = 0;
        block1: while (n9 < n3) {
            int n10 = 0;
            while (n10 < n4) {
                if (n8 >= this.legendCnt) break block1;
                int n11 = n10 * (n5 + 3) + 3;
                int n12 = n9 * (n6 + 3) + 3;
                Rectangle rectangle = new Rectangle(n11, n12 + (n6 - n7) / 2, n7, n7);
                Common.fill(graphics2, rectangle, this.model.getColor(n8));
                graphics2.setColor(this.context.getForeground());
                Common.drawString(graphics2, (String)this.legendLabels.elementAt(n8), n11 + n7 + 3, n12 + (n6 - this.fm.getHeight()) / 2 + this.fm.getAscent());
                ++n8;
                ++n10;
            }
            ++n9;
        }
        graphics2.dispose();
    }

    private void paintLine(Graphics graphics) {
        this.paintPoint(graphics);
        Color color = graphics.getColor();
        int n = 0;
        while (n < this.model.getDatasetCount()) {
            graphics.setColor((Color)this.model.getColor(n));
            int n2 = 1;
            while (n2 < this.model.getDatasetSize()) {
                int n3 = this.xPos[n2 - 1];
                int n4 = this.translate(this.model.getData(n, n2 - 1));
                int n5 = this.xPos[n2];
                int n6 = this.translate(this.model.getData(n, n2));
                graphics.drawLine(n3, n4, n5, n6);
                int[] nArray = new int[]{n3, n5, n5, n3};
                int[] nArray2 = new int[]{n4 - 2, n6 - 2, n6 + 2, n4 + 2};
                this.areas.addElement(new GraphArea(n2, n, new Polygon(nArray, nArray2, 4)));
                ++n2;
            }
            ++n;
        }
        graphics.setColor(color);
    }

    private void paintPie(Graphics graphics, boolean bl, boolean bl2) {
        double d;
        double d2 = (double)(bl ? 60 : 0) / 180.0 * Math.PI;
        int n = 0;
        int n2 = 3;
        Dimension dimension = this.getSize();
        double d3 = 0.0;
        double[] dArray = new double[this.model.getDatasetSize() + 1];
        int n3 = 0;
        while (n3 < this.model.getDatasetSize()) {
            Number number = this.model.getData(0, n3);
            d3 += number == null ? 0.0 : number.doubleValue();
            ++n3;
        }
        d3 = d3 == 0.0 ? 1.0 : d3;
        double d4 = 0.0;
        int n4 = 0;
        while (n4 < this.model.getDatasetSize()) {
            Number number = this.model.getData(0, n4);
            double d5 = number == null ? 0.0 : number.doubleValue();
            dArray[n4] = d4;
            d4 += d5 / d3 * 2.0 * Math.PI;
            ++n4;
        }
        dArray[dArray.length - 1] = Math.PI * 2;
        int n5 = dimension.width - this.legendSpace.left - this.legendSpace.right;
        int n6 = dimension.height - this.legendSpace.top - this.legendSpace.bottom;
        Point point = new Point(this.legendSpace.left + n5 / 2, this.legendSpace.top + n6 / 2);
        int n7 = Math.min(n5 / 2 - this.fm.stringWidth(String.valueOf(this.model.getLabel(0))), n6 / 2 - this.fm.getHeight()) - n2;
        double d6 = Math.PI / 180;
        double d7 = Math.cos(d2);
        int n8 = 0;
        while (n8 < dArray.length - 1) {
            Polygon polygon = new Polygon();
            polygon.addPoint(point.x, point.y);
            d = dArray[n8];
            while (d < dArray[n8 + 1]) {
                polygon.addPoint(point.x + (int)((double)n7 * Math.cos(d)), point.y - (int)((double)n7 * Math.sin(d) * d7));
                d += d6;
            }
            polygon.addPoint(point.x + (int)((double)n7 * Math.cos(dArray[n8 + 1])), point.y - (int)((double)n7 * Math.sin(dArray[n8 + 1]) * d7));
            Common.fill(graphics, polygon, this.model.getColor(n8));
            this.areas.addElement(new GraphArea(n8, 0, polygon));
            ++n8;
        }
        if (bl && dArray.length > 1) {
            n = n7 / 5;
            int n9 = 0;
            while (n9 < dArray.length) {
                if (dArray[n9] > Math.PI) break;
                ++n9;
            }
            d = Math.PI;
            int n10 = n9;
            while (n10 < dArray.length) {
                Polygon polygon = new Polygon();
                while (d < dArray[n10]) {
                    polygon.addPoint(point.x + (int)((double)n7 * Math.cos(d)), point.y - (int)((double)n7 * Math.sin(d) * d7));
                    d += d6;
                }
                d = dArray[n10];
                polygon.addPoint(point.x + (int)((double)n7 * Math.cos(d)), point.y - (int)((double)n7 * Math.sin(d) * d7));
                int n11 = polygon.npoints - 1;
                while (n11 >= 0) {
                    polygon.addPoint(polygon.xpoints[n11], polygon.ypoints[n11] + n);
                    --n11;
                }
                Common.fill(graphics, polygon, this.darker(this.model.getColor(n10 - 1)));
                this.areas.addElement(new GraphArea(n10 - 1, 0, polygon));
                ++n10;
            }
        }
        if (bl2) {
            graphics.setColor(this.context.getForeground());
            int n12 = 0;
            while (n12 < dArray.length - 1 && n12 < this.model.getDatasetSize()) {
                String string = this.model.getLabel(n12);
                double d8 = (dArray[n12] + dArray[n12 + 1]) / 2.0;
                double d9 = Math.cos(d8);
                double d10 = Math.sin(d8);
                double d11 = d9 > 0.0 ? n2 : -this.fm.stringWidth(string == null ? "" : string) - n2;
                double d12 = d10 > 0.0 ? this.fm.getDescent() : this.fm.getAscent();
                int n13 = d10 > 0.0 ? 0 : n;
                Common.drawString(graphics, this.model.getLabel(n12), point.x + (int)((double)n7 * d9 + d11), point.y - (int)((double)n7 * d10 * Math.cos(d2) + d12 * d10) + n13);
                if (this.model.isShowValue()) {
                    String string2 = this.toString(this.model.getData(0, n12));
                    Common.drawString(graphics, string2, point.x + (int)((double)(n7 * 2 / 3) * d9) - this.fm.stringWidth(string2) / 2, point.y - (int)((double)(n7 * 2 / 3) * d10 * Math.cos(d2) + d12 * d10));
                }
                ++n12;
            }
        }
    }

    private void paintPoint(Graphics graphics) {
        this.paintCoord(graphics);
        Color color = graphics.getColor();
        int n = 0;
        while (n < this.model.getDatasetCount()) {
            int n2 = 0;
            while (n2 < this.model.getDatasetSize()) {
                Rectangle rectangle = new Rectangle(this.xPos[n2] - 1, this.translate(this.model.getData(n, n2)) - 1, 3, 3);
                Common.fill(graphics, rectangle, this.model.getColor(n));
                --rectangle.x;
                --rectangle.y;
                rectangle.width = ++rectangle.height;
                this.areas.addElement(new GraphArea(n2, n, rectangle));
                if (this.model.isShowValue()) {
                    String string = this.toString(this.model.getData(n, n2));
                    graphics.setColor(this.context.getForeground());
                    Common.drawString(graphics, string, rectangle.x - this.fm.stringWidth(string) / 2, rectangle.y - this.fm.getDescent());
                }
                ++n2;
            }
            ++n;
        }
        graphics.setColor(color);
    }

    private void paintStackArea(Graphics graphics) {
        Object object;
        int n;
        this.paintCoord(graphics);
        Color color = graphics.getColor();
        Point[][] pointArray = new Point[this.model.getDatasetCount() + 1][this.model.getDatasetSize()];
        int n2 = 0;
        while (n2 < pointArray[0].length) {
            pointArray[0][n2] = new Point(this.xPos[n2], this.zero.y);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.model.getDatasetSize()) {
            double d = 0.0;
            n = 0;
            while (n < this.model.getDatasetCount()) {
                object = this.model.getData(n, n3);
                pointArray[n + 1][n3] = new Point(this.xPos[n3], this.translate(new Double(d += object == null ? 0.0 : ((Number)object).doubleValue())));
                ++n;
            }
            ++n3;
        }
        int n4 = 1;
        while (n4 < pointArray.length) {
            Polygon polygon = new Polygon();
            n = 0;
            while (n < pointArray[n4].length) {
                polygon.addPoint(pointArray[n4][n].x, pointArray[n4][n].y);
                if (n > 0) {
                    object = new int[]{pointArray[n4][n - 1].x, pointArray[n4][n].x, pointArray[n4 - 1][n].x, pointArray[n4 - 1][n - 1].x};
                    int[] nArray = new int[]{pointArray[n4][n - 1].y, pointArray[n4][n].y, pointArray[n4 - 1][n].y, pointArray[n4 - 1][n - 1].y};
                    this.areas.addElement(new GraphArea(n, n4 - 1, new Polygon((int[])object, nArray, 4)));
                }
                ++n;
            }
            int n5 = pointArray[n4].length - 1;
            while (n5 >= 0) {
                polygon.addPoint(pointArray[n4 - 1][n5].x, pointArray[n4 - 1][n5].y);
                --n5;
            }
            Common.fill(graphics, polygon, this.model.getColor(n4 - 1));
            ++n4;
        }
        graphics.setColor(this.context.getForeground());
        if (this.model.isShowValue()) {
            int n6 = 1;
            while (n6 < pointArray.length) {
                n = 0;
                while (n < pointArray[n6].length) {
                    object = this.toString(this.model.getData(n6 - 1, n));
                    Common.drawString(graphics, (String)object, pointArray[n6][n].x - this.fm.stringWidth((String)object) / 2, pointArray[n6][n].y - this.fm.getDescent());
                    ++n;
                }
                ++n6;
            }
        }
        graphics.setColor(color);
    }

    private void paintStackBar(Graphics graphics) {
        this.paintCoord(graphics);
        boolean bl = this.model.getDatasetCount() == 1;
        Color color = graphics.getColor();
        int n = this.model.getGap();
        int n2 = 0;
        while (n2 < this.model.getDatasetSize()) {
            int n3 = this.zero.y;
            int n4 = this.zero.y;
            int n5 = 0;
            while (n5 < this.model.getDatasetCount()) {
                Number number = this.model.getData(n5, n2);
                int n6 = number != null && number.doubleValue() >= 0.0 ? n3 : n4;
                Rectangle rectangle = null;
                int n7 = Math.max(1, this.xPos[n2 + 1] - this.xPos[n2] - n);
                if (number != null && number.doubleValue() >= 0.0) {
                    n3 = this.translate(number) - this.zero.y + n3;
                    rectangle = new Rectangle(this.xPos[n2] + n / 2, n3, n7, n6 - n3);
                } else {
                    n4 = this.translate(number) - this.zero.y + n4;
                    rectangle = new Rectangle(this.xPos[n2] + n / 2, n6, n7, n4 - n6);
                }
                if (this.model.getGap() == 0) {
                    graphics.setColor(this.context.getForeground());
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    ++rectangle.x;
                    ++rectangle.y;
                    --rectangle.width;
                    --rectangle.height;
                }
                Common.fill(graphics, rectangle, this.model.getColor(bl ? n2 : n5));
                this.areas.addElement(new GraphArea(n2, n5, rectangle));
                if (this.model.isShowValue()) {
                    String string = this.toString(this.model.getData(n5, n2));
                    graphics.setColor(this.context.getForeground());
                    Common.drawString(graphics, string, rectangle.x + (rectangle.width - this.fm.stringWidth(string)) / 2, rectangle.y + (rectangle.height - this.fm.getHeight()) / 2 + this.fm.getAscent());
                }
                ++n5;
            }
            ++n2;
        }
        graphics.setColor(color);
    }

    private void paintStackBar3D(Graphics graphics) {
        this.paintCoord(graphics);
        boolean bl = this.model.getDatasetCount() == 1;
        Color color = graphics.getColor();
        int n = this.model.getGap() >= this.xInc ? 0 : this.model.getGap();
        int n2 = n / 2;
        int n3 = 0;
        while (n3 < this.model.getDatasetSize()) {
            int n4 = this.zero.y;
            int n5 = this.zero.y;
            int n6 = 0;
            while (n6 < this.model.getDatasetCount()) {
                Number number = this.model.getData(n6, n3);
                int n7 = number != null && number.doubleValue() >= 0.0 ? n4 : n5;
                Object object = this.model.getColor(bl ? n3 : n6);
                Rectangle rectangle = null;
                if (number != null && number.doubleValue() >= 0.0) {
                    n4 = this.translate(this.model.getData(n6, n3)) - this.zero.y + n4;
                    rectangle = new Rectangle(this.xPos[n3] + n2, n4, this.xInc, n7 - n4);
                } else {
                    n5 = this.translate(this.model.getData(n6, n3)) - this.zero.y + n5;
                    rectangle = new Rectangle(this.xPos[n3] + n2, n7, this.xInc, n5 - n7);
                }
                Rectangle rectangle2 = new Rectangle(rectangle);
                rectangle2.width -= n;
                Common.fill(graphics, rectangle2, this.darker(object));
                this.areas.addElement(new GraphArea(n3, n6, rectangle2));
                int[] nArray = new int[]{this.xPos[n3] + n2, this.xPos[n3] + n2 + this.xInc / 4, this.xPos[n3 + 1] + this.xInc / 4 - n2, this.xPos[n3 + 1] - n2};
                int[] nArray2 = new int[]{n4, n4 - this.xInc / 4, n4 - this.xInc / 4, n4};
                Polygon polygon = new Polygon(nArray, nArray2, nArray.length);
                Common.fill(graphics, polygon, this.brighter(object));
                this.areas.addElement(new GraphArea(n3, n6, polygon));
                int[] nArray3 = new int[]{this.xPos[n3 + 1] - n2, this.xPos[n3 + 1] - n2 + this.xInc / 4, this.xPos[n3 + 1] - n2 + this.xInc / 4, this.xPos[n3 + 1] - n2};
                int[] nArray4 = new int[]{rectangle.y, rectangle.y - this.xInc / 4, rectangle.y + rectangle.height - this.xInc / 4, rectangle.y + rectangle.height};
                Polygon polygon2 = new Polygon(nArray3, nArray4, nArray3.length);
                Common.fill(graphics, polygon2, this.darker(this.darker(object)));
                this.areas.addElement(new GraphArea(n3, n6, polygon2));
                if (this.model.isShowValue()) {
                    String string = this.toString(this.model.getData(n6, n3));
                    graphics.setColor(this.context.getForeground());
                    Common.drawString(graphics, string, rectangle.x + (rectangle.width - this.fm.stringWidth(string)) / 2, rectangle.y + (rectangle.height - this.fm.getHeight()) / 2 + this.fm.getAscent());
                }
                ++n6;
            }
            ++n3;
        }
        graphics.setColor(color);
    }

    private void paintStick(Graphics graphics) {
        this.paintCoord(graphics);
        Color color = graphics.getColor();
        int n = 0;
        int n2 = 0;
        while (n2 < this.model.getDatasetSize()) {
            int n3 = 0;
            while (n3 < this.model.getDatasetCount()) {
                graphics.setColor((Color)this.model.getColor(n3));
                int n4 = this.translate(this.model.getData(n3, n2));
                Rectangle rectangle = new Rectangle(this.xPos[n], n4, 2, this.zero.y - n4);
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                this.areas.addElement(new GraphArea(n2, 0, rectangle));
                ++n;
                ++n3;
            }
            ++n2;
        }
        graphics.setColor(color);
    }

    private void paintStock(Graphics graphics) {
        this.paintCoord(graphics);
        if (this.model.getDatasetCount() < 2) {
            return;
        }
        Color color = graphics.getColor();
        int n = Math.min(2, this.xPos.length > 1 ? this.xPos[1] - this.xPos[0] - 2 : 2);
        n = Math.max(n, 1);
        int n2 = 0;
        while (n2 < this.model.getDatasetSize()) {
            int n3 = this.translate(this.model.getData(1, n2));
            Rectangle rectangle = new Rectangle(this.xPos[n2] - 1, n3, n, this.translate(this.model.getData(0, n2)) - n3);
            graphics.setColor((Color)this.model.getColor(0));
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
            if (this.model.getDatasetCount() > 2) {
                int n4 = this.translate(this.model.getData(2, n2));
                graphics.drawLine(rectangle.x, n4, rectangle.x + rectangle.width, n4);
            }
            this.areas.addElement(new GraphArea(n2, 0, rectangle));
            ++n2;
        }
        graphics.setColor(color);
    }

    private String toString(Number number) {
        return this.model.getPrecision() > 0 ? Util.toString(number, this.model.getPrecision()) : Util.toString(number);
    }

    protected int translate(Number number) {
        double d = number == null ? 0.0 : number.doubleValue();
        return (int)((double)this.center.y - (d - this.yMin) * (double)this.yHeight / (this.yMax - this.yMin));
    }

    class GraphArea
    implements Serializable {
        int x;
        int y;
        private Shape area;

        public GraphArea(int n, int n2, Shape shape) {
            this.x = n;
            this.y = n2;
            this.area = shape;
        }

        public boolean contains(int n, int n2) {
            return this.area != null && this.area.contains(n, n2);
        }

        public Shape getShape() {
            return this.area;
        }

        public String toString() {
            return String.valueOf(this.x) + "," + this.y + " at " + this.area;
        }
    }
}

