/*
 * Decompiled with CFR 0.152.
 */
package com.dorado.redcell.inventory.base;

import com.dorado.common.utility.OWOID;
import com.dorado.common.widget.components.OWFCParentPanel;
import com.dorado.common.widget.components.OWImageInfo;
import com.dorado.common.widget.components.formlauncher.IOWFormLauncher;
import com.dorado.common.widget.components.interfaces.IOWGButton;
import com.dorado.common.widget.components.interfaces.IOWGLabel;
import com.dorado.common.widget.components.interfaces.IOWGPathSelect;
import com.dorado.common.widget.components.interfaces.IOWGStandardPanel;
import com.dorado.common.widget.components.interfaces.IOWGTextField;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.IOWBOMInternalUseMarker;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMClientUtility;
import com.dorado.core.bom.OWBOMExporterClient;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.bom.OWBOMQueryByKey;
import com.dorado.core.bom.OWBOMQueryByOWOID;
import com.dorado.core.ejb.ruleengine.IOWRuleEngineClient;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.IOWEventListener;
import com.dorado.runtime.IOWFormUserMethods;
import com.dorado.runtime.IOWRuntime;
import com.dorado.runtime.IOWRuntimeForm;
import com.dorado.runtime.OWBean;
import com.dorado.runtime.OWEvent;
import com.dorado.runtime.OWFormAssociationSet;
import com.dorado.runtime.OWRuntimeFormInfo;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import redcell.common.interfaces.IRCOptionPaneListener;
import redcell.common.util.RCOptionPaneUtil;

public abstract class RCExportFiltersPanelGENERIC
extends OWFCParentPanel
implements IOWEventListener,
IOWFormUserMethods,
IOWRuntimeForm,
IRCOptionPaneListener {
    private String id = null;
    private int editMode = 1;
    private IOWRuleEngineClient ruleEngineClient = null;
    protected String Form1_title = "Exporting Filters";
    protected String txtOwner_text = new String();
    public IOWGTextField txtOwner = null;
    protected String pathSelect_text = new String();
    public IOWGPathSelect pathSelect = null;
    protected String pathLabel_text = new String();
    public IOWGLabel pathLabel = null;
    protected String ownerLabel_text = new String();
    public IOWGLabel ownerLabel = null;
    public IOWGStandardPanel Panel1 = null;
    protected String cancelButton_text = new String();
    public IOWGButton cancelButton = null;
    protected String okButton_text = new String();
    public IOWGButton okButton = null;
    private boolean exportPending = false;
    private boolean closeMe = false;

    public abstract void onCreate();

    public abstract void onShow();

    public abstract void getScreenData();

    public abstract void setScreenData();

    public abstract void setReference(boolean var1);

    public abstract boolean getReference();

    public RCExportFiltersPanelGENERIC() {
        this.setFrameworkName("");
        this.onGenericCreate();
    }

    public RCExportFiltersPanelGENERIC(String string) {
        this.setId(string);
        this.setFrameworkName("");
        this.onGenericCreate();
    }

    public RCExportFiltersPanelGENERIC(Hashtable hashtable) {
        super(hashtable);
        this.setFrameworkName("");
        this.onGenericCreate();
    }

    public void onGenericCreate() {
    }

    public void initListeners() throws Exception {
    }

    public abstract Vector readModel(String var1);

    public void storeModel(IOWRuntime iOWRuntime) {
        this.storeModel(null, iOWRuntime);
    }

    public abstract void storeModel(String var1, IOWRuntime var2);

    public int getFormWidth() {
        return 409;
    }

    public int getFormHeight() {
        return 189;
    }

    public void handleTrigger(String string) throws Exception {
        if (string.indexOf(".") > -1) {
            super.handleTrigger(string);
            return;
        }
        if (string.equals("closeTrigger")) {
            this.closePanel();
            if (this.getFormController() != null) {
                this.getFormController().setUseGetScreenData(false);
            }
            return;
        }
        if (string.equals("exportTrigger")) {
            this.export();
            if (this.getFormController() != null) {
                this.getFormController().setUseGetScreenData(false);
            }
            return;
        }
    }

    public void stopListeners() throws Exception {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof IOWRuntimeForm)) continue;
            ((OWFCParentPanel)componentArray[i]).setFormController(this.getFormController(), true);
            ((IOWRuntimeForm)componentArray[i]).stopListeners();
        }
    }

    public static OWRuntimeFormInfo getRuntimeFormInfo() {
        OWRuntimeFormInfo oWRuntimeFormInfo = new OWRuntimeFormInfo();
        OWImageInfo oWImageInfo = new OWImageInfo();
        OWFormAssociationSet oWFormAssociationSet = new OWFormAssociationSet();
        Vector vector = new Vector();
        oWRuntimeFormInfo.setFormName("RCExportFiltersPanel");
        oWRuntimeFormInfo.setFullFormName("com.dorado.redcell.inventory.base.RCExportFiltersPanel");
        oWRuntimeFormInfo.setToolTipText("");
        oWRuntimeFormInfo.setTitle("Exporting Filters");
        return oWRuntimeFormInfo;
    }

    public String getTitle() {
        return this.Form1_title;
    }

    public void setTitle(String string) {
        super.setTitle(string);
        this.Form1_title = string;
    }

    public void closePanel() {
        this.getFormLauncher().removePanel(new Object[]{((Object)((Object)this)).getClass().getName(), this.getId()});
    }

    public void export() {
        File file = new File(this.pathSelect.getPath());
        if (file.exists()) {
            if (file.isDirectory()) {
                RCOptionPaneUtil.showWarningMessage((IOWFormLauncher)this.getFormLauncher(), (IRCOptionPaneListener)this, (String)"The file you specified is an existing directory.\nPlease enter another file name.", (String)"Error");
                return;
            }
            this.exportPending = true;
            RCOptionPaneUtil.showConfirmDialog((IOWFormLauncher)this.getFormLauncher(), (IRCOptionPaneListener)this, (String)"File already exist.  Overwrite this file?", (String)"Exporting Filters");
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.pathSelect.getPath());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            RCOptionPaneUtil.showWarningMessage((IOWFormLauncher)this.getFormLauncher(), (IRCOptionPaneListener)this, (String)"The file name you specified is not valid.\nPlease enter another file name.", (String)"Error");
            return;
        }
        this.exportPending = true;
        this.performExport();
    }

    public int getFormType() {
        return 0;
    }

    public void optionPaneButtonClicked(int n) {
        if (n == 0 && this.exportPending) {
            this.performExport();
        } else if (this.closeMe) {
            this.closePanel();
        }
        this.exportPending = false;
    }

    public void performExport() {
        IOWBOMClient iOWBOMClient = null;
        String string = this.txtOwner.getText();
        this.exportPending = false;
        try {
            iOWBOMClient = OWBOMClientUtility.getIOWBOMClient((IOWBOMInternalUseMarker)new IOWBOMInternalUseMarker(){}, (boolean)true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            RCOptionPaneUtil.showWarningMessage((IOWFormLauncher)this.getFormLauncher(), (IRCOptionPaneListener)this, (String)"Could not create BOM Client.", (String)"Error");
            return;
        }
        try {
            OWBOMQueryByAttribs oWBOMQueryByAttribs = new OWBOMQueryByAttribs("com.dorado.redcell.inventory.base.RCFilterDef", new OWBOMAttribValueOperator("Owner", (Object)string), false);
            Vector vector = (Vector)iOWBOMClient.getObjects((OWBOMQuery)oWBOMQueryByAttribs).getRtnObject();
            oWBOMQueryByAttribs = new OWBOMQueryByAttribs("com.dorado.redcell.inventory.base.RCMgrFilterDef", new OWBOMAttribValueOperator("Owner", (Object)string), false);
            vector.addAll((Vector)iOWBOMClient.getObjects((OWBOMQuery)oWBOMQueryByAttribs).getRtnObject());
            OWBOMExporterClient oWBOMExporterClient = new OWBOMExporterClient();
            Enumeration enumeration = vector.elements();
            oWBOMExporterClient.openFile(this.pathSelect.getPath(), false);
            while (enumeration.hasMoreElements()) {
                OWOID oWOID = ((IOWBean)enumeration.nextElement()).getHandle();
                OWBOMQueryByOWOID oWBOMQueryByOWOID = new OWBOMQueryByOWOID(oWOID);
                OWBean oWBean = (OWBean)iOWBOMClient.getObject((OWBOMQueryByKey)oWBOMQueryByOWOID).getRtnObject();
                oWBOMExporterClient.exportObject((Object)oWBean);
            }
            oWBOMExporterClient.closeFile();
            this.closeMe = true;
            RCOptionPaneUtil.showInformationMessage((IOWFormLauncher)this.getFormLauncher(), (IRCOptionPaneListener)this, (String)("The Filters owned by \"" + string + "\" have been exported."), (String)"Success");
        }
        catch (OWBOMNotFoundException oWBOMNotFoundException) {
            RCOptionPaneUtil.showWarningMessage((IOWFormLauncher)this.getFormLauncher(), (IRCOptionPaneListener)this, (String)("No Filters found for owner \"" + string + "\".  Operation aborted."), (String)"Error");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            RCOptionPaneUtil.showWarningMessage((IOWFormLauncher)this.getFormLauncher(), (IRCOptionPaneListener)this, (String)exception.getMessage(), (String)"Error");
        }
        iOWBOMClient.closeAPI();
    }

    public void action(OWEvent oWEvent) {
        this.storeModel((IOWRuntime)oWEvent);
        this.setScreenData();
    }

    public void disconnectOccurred(String string) {
        System.out.println("A disconnectOccurred error occured: " + string);
    }

    public void exceptionOccurred(Exception exception) {
        exception.printStackTrace();
        System.out.println("**************************An event listen exceptionOccurred error occured: " + exception.getMessage() + exception.toString());
    }
}

