/*
 * Decompiled with CFR 0.152.
 */
package RedCell.Config.Discovery;

import RedCell.Config.CreateDiscoveredNodesEvent;
import RedCell.Config.Discovery.CreateDiscoveryStatusParamSet;
import RedCell.Config.Discovery.DeleteDiscoveryStatusParamSet;
import RedCell.Config.Discovery.DiscoveryStatusChange;
import RedCell.Config.Discovery.UpdateDiscoveryStatusParamSet;
import RedCell.Config.DiscoveryResultsEvent;
import com.dorado.common.utility.OWOID;
import com.dorado.common.widget.components.OWFCParentPanel;
import com.dorado.common.widget.components.OWImageInfo;
import com.dorado.common.widget.components.formlauncher.OWFormLauncher;
import com.dorado.common.widget.components.interfaces.IOWGButton;
import com.dorado.core.ejb.ruleengine.IOWRuleEngineClient;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.IOWEventListener;
import com.dorado.runtime.IOWFormUserMethods;
import com.dorado.runtime.IOWRuntime;
import com.dorado.runtime.IOWRuntimeForm;
import com.dorado.runtime.OWEvent;
import com.dorado.runtime.OWEventAttribValueOperator;
import com.dorado.runtime.OWEventSelector;
import com.dorado.runtime.OWFormAssociationSet;
import com.dorado.runtime.OWRuntimeFormInfo;
import com.dorado.runtime.OWSet;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import oware.job.CreateRootJobEvent;
import oware.job.JobStatusLogFormGENERIC;
import oware.job.RootJobCancelledEvent;
import oware.job.RootJobCompleteEvent;
import redcell.apps.config.discovery.RedCellDiscoveredNode;
import redcell.apps.config.discovery.RedCellDiscoveryWizard;
import redcell.common.util.IRedCellAbstractWizardStep;
import redcell.common.util.RedCellAbstractWizard;
import redcell.common.util.RedCellRuleEngineUtil;
import redcell.common.util.RedCellRuntimeUtil;
import redcell.core.usersys.RCUserUtil;

public abstract class DiscoveryStatusFormGENERIC
extends OWFCParentPanel
implements IOWEventListener,
IOWFormUserMethods,
IOWRuntimeForm,
IRedCellAbstractWizardStep {
    private String id = null;
    private int editMode = 1;
    private IOWRuleEngineClient ruleEngineClient = null;
    protected String frmDiscoveryCommit_title = "Network Inventory Update";
    protected String btnLink_text = new String();
    public IOWGButton btnLink = null;
    protected String btnPause_text = new String();
    public IOWGButton btnPause = null;
    protected String btnResume_text = new String();
    public IOWGButton btnResume = null;
    public JobStatusLogFormGENERIC statusPanel = null;
    public String jobID = null;
    private RedCellDiscoveryWizard parent = null;
    private OWSet newOIDs = null;
    private DiscoveryStatusChange modifyEvent = null;
    private DiscoveryResultsEvent resultsEvent = null;
    private boolean inProcess = false;
    private OWOID statusOID = null;
    private int stepStatus = 0;
    public ArrayList nodeList = new ArrayList();
    public OWSet nrkList = new OWSet(String.class);
    private Hashtable optionsUsedSet = new Hashtable();

    public abstract void onCreate();

    public abstract void onShow();

    public abstract void getScreenData();

    public abstract void setScreenData();

    public abstract void setReference(boolean var1);

    public abstract boolean getReference();

    public DiscoveryStatusFormGENERIC() {
        this.setFrameworkName("");
        this.onGenericCreate();
    }

    public DiscoveryStatusFormGENERIC(String string) {
        this.setId(string);
        this.setFrameworkName("");
        this.onGenericCreate();
    }

    public DiscoveryStatusFormGENERIC(Hashtable hashtable) {
        super(hashtable);
        this.setFrameworkName("");
        this.onGenericCreate();
    }

    public void onGenericCreate() {
    }

    public void initListeners() throws Exception {
    }

    public abstract Vector readModel(String var1);

    public void storeModel(IOWRuntime iOWRuntime) {
        this.storeModel(null, iOWRuntime);
    }

    public abstract void storeModel(String var1, IOWRuntime var2);

    public int getFormWidth() {
        return 558;
    }

    public int getFormHeight() {
        return 439;
    }

    public void handleTrigger(String string) throws Exception {
        if (string.indexOf(".") > -1) {
            super.handleTrigger(string);
            return;
        }
        if (string.equals("linkTrigger")) {
            this.launchLinkDiscovery();
            if (this.getFormController() != null) {
                this.getFormController().setUseGetScreenData(false);
            }
            return;
        }
        if (string.equals("pauseTrigger")) {
            this.pauseClicked();
            if (this.getFormController() != null) {
                this.getFormController().setUseGetScreenData(false);
            }
            return;
        }
        if (string.equals("resumeTrigger")) {
            this.resumeClicked();
            if (this.getFormController() != null) {
                this.getFormController().setUseGetScreenData(false);
            }
            return;
        }
    }

    public void stopListeners() throws Exception {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof IOWRuntimeForm)) continue;
            ((OWFCParentPanel)componentArray[i]).setFormController(this.getFormController(), true);
            ((IOWRuntimeForm)componentArray[i]).stopListeners();
        }
    }

    public static OWRuntimeFormInfo getRuntimeFormInfo() {
        OWRuntimeFormInfo oWRuntimeFormInfo = new OWRuntimeFormInfo();
        OWImageInfo oWImageInfo = new OWImageInfo();
        OWFormAssociationSet oWFormAssociationSet = new OWFormAssociationSet();
        Vector vector = new Vector();
        oWRuntimeFormInfo.setFormName("DiscoveryStatusForm");
        oWRuntimeFormInfo.setFullFormName("RedCell.Config.Discovery.DiscoveryStatusForm");
        oWRuntimeFormInfo.setToolTipText("");
        oWRuntimeFormInfo.setTitle("Network Inventory Update");
        return oWRuntimeFormInfo;
    }

    public String getTitle() {
        return this.frmDiscoveryCommit_title;
    }

    public void setTitle(String string) {
        super.setTitle(string);
        this.frmDiscoveryCommit_title = string;
    }

    public void activate(boolean bl) {
        try {
            if (this.getFormType() == 1) {
                ((OWFormLauncher)this.getFormLauncher()).startProgressBar();
            }
            CreateRootJobEvent createRootJobEvent = new CreateRootJobEvent();
            createRootJobEvent.setLogCategoryName("NetworkDiscovery");
            createRootJobEvent.setDescription("Starting Network Discovery...");
            createRootJobEvent.set_OW_RuleName("oware.job.CreateRootJob");
            RedCellRuleEngineUtil.callRule((String)"oware.job.CreateRootJob", (OWEvent)createRootJobEvent);
            this.jobID = createRootJobEvent.getJobID();
            RootJobCompleteEvent rootJobCompleteEvent = new RootJobCompleteEvent();
            OWEventSelector oWEventSelector = rootJobCompleteEvent.getSelector();
            OWEventAttribValueOperator oWEventAttribValueOperator = new OWEventAttribValueOperator("JobID", "=", (Serializable)((Object)this.jobID));
            oWEventSelector.addAttribValueOperator(oWEventAttribValueOperator);
            rootJobCompleteEvent.addEventListener((IOWEventListener)this);
            this.statusPanel.addLogCategory("NetworkDiscovery");
            this.statusPanel.showDebugFilter(RCUserUtil.isCurrentUserDeveloper());
            this.statusPanel.addJob(createRootJobEvent.getJobID(), "Starting Network Discovery...");
            this.startCommit(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addEventListeners() {
        try {
            this.modifyEvent = new DiscoveryStatusChange();
            this.modifyEvent.addEventListener(this);
            this.resultsEvent = new DiscoveryResultsEvent();
            this.resultsEvent.addEventListener(this);
        }
        catch (Exception exception) {
            RedCellRuntimeUtil.println((String)"RedCellDiscoveryCommitPanel: Unable to add event listeners");
            RedCellRuntimeUtil.printStackTrace((Exception)exception);
        }
    }

    public boolean checkProcess() {
        boolean bl = true;
        String string = "A network inventory save is in progress.\nThis action will stop the save.\n\nAre you sure you want to stop the save?";
        if (this.inProcess) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), string, "Please Confirm", 0, 3);
            if (n == 0) {
                if (this.getFormType() == 1) {
                    ((OWFormLauncher)this.getFormLauncher()).stopProgressBar();
                }
                this.stepStatus = 3;
                this.parent.updateChecklist();
                this.stopCommit(true);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public void checkStatus(OWEvent oWEvent) {
        DiscoveryStatusChange discoveryStatusChange = (DiscoveryStatusChange)oWEvent;
        String string = discoveryStatusChange.getDataValue();
        if (string != null) {
            try {
                switch (discoveryStatusChange.getDataType()) {
                    case 1: {
                        this.nrkList.add((Serializable)((Object)string));
                        break;
                    }
                    case 2: {
                        this.nodeList.remove(string);
                        break;
                    }
                    case 3: {
                        this.optionsUsedSet.put(string, string);
                    }
                }
            }
            catch (Exception exception) {
                RedCellRuntimeUtil.printStackTrace((Exception)exception);
            }
        }
    }

    public OWOID createDiscoveryStatus() throws Exception {
        CreateDiscoveryStatusParamSet createDiscoveryStatusParamSet = new CreateDiscoveryStatusParamSet();
        RedCellRuleEngineUtil.callRule((String)"RedCell.Config.Discovery.CreateDiscoveryStatus", (OWEvent)createDiscoveryStatusParamSet);
        return createDiscoveryStatusParamSet.getStatusOID();
    }

    public void deinit() {
    }

    private void deleteDiscoveryStatus(OWOID oWOID) {
        DeleteDiscoveryStatusParamSet deleteDiscoveryStatusParamSet = new DeleteDiscoveryStatusParamSet();
        deleteDiscoveryStatusParamSet.setStatusOID(oWOID);
        RedCellRuleEngineUtil.callRule((String)"RedCell.Config.Discovery.DeleteDiscoveryStatusRule", (OWEvent)deleteDiscoveryStatusParamSet);
    }

    private void disconnectOccurred(Exception exception) {
        RedCellRuntimeUtil.println((String)("RedCellDiscoveryResultsPanel: IRedCellEventListener Disconnected: " + exception.getMessage()));
    }

    public void enableButtons() {
        if (this.parent != null) {
            this.parent.getCancelButton().setEnabled(this.inProcess);
            this.parent.getBackButton().setEnabled(false);
            this.parent.getFinishButton().setEnabled(this.stepStatus == 1);
            this.btnPause.setEnabled(this.inProcess);
            this.btnResume.setEnabled(!this.inProcess && this.stepStatus != 1);
        }
    }

    public String getHelpTag() {
        return "redcell.discovery_wizard_commit";
    }

    public int getStatus() {
        return this.stepStatus;
    }

    public boolean init(RedCellAbstractWizard redCellAbstractWizard) {
        this.parent = (RedCellDiscoveryWizard)redCellAbstractWizard;
        return true;
    }

    public void launchLinkDiscovery() {
        try {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>(1);
            hashtable.put("Equipment", this.newOIDs);
            hashtable.put("id", String.valueOf(System.currentTimeMillis()));
            hashtable.put("_title", "Link Discovery Wizard");
            hashtable.put("id", String.valueOf(System.currentTimeMillis()));
            this.getFormLauncher().showPanel(new Object[]{"com.dorado.redcell.discovery.link.RCLinkDiscoveryWizardForm", hashtable});
            this.parent.sysCloseDown(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void pauseClicked() {
        this.stopCommit(false);
        this.btnPause.setEnabled(false);
        if (this.stepStatus != 1) {
            this.btnResume.setEnabled(true);
        }
        if (this.getFormType() == 1) {
            ((OWFormLauncher)this.getFormLauncher()).stopProgressBar();
        }
    }

    public void removeEventListeners() {
        final DiscoveryStatusFormGENERIC discoveryStatusFormGENERIC = this;
        Thread thread = new Thread(){

            public void run() {
                try {
                    DiscoveryStatusFormGENERIC.this.modifyEvent.removeEventListener(discoveryStatusFormGENERIC);
                    DiscoveryStatusFormGENERIC.this.resultsEvent.removeEventListener(discoveryStatusFormGENERIC);
                }
                catch (Exception exception) {
                    RedCellRuntimeUtil.println((String)"RedCellDiscoveryCommitPanel: Unable to remove event listeners");
                    RedCellRuntimeUtil.printStackTrace((Exception)exception);
                }
            }
        };
        thread.start();
    }

    public boolean requestBackStep() {
        return this.checkProcess();
    }

    public boolean requestCancel() {
        return this.checkProcess();
    }

    public boolean requestFinish() {
        boolean bl = this.checkProcess();
        if (bl) {
            // empty if block
        }
        return bl;
    }

    public boolean requestNextStep() {
        return this.checkProcess();
    }

    private void resumeClicked() {
        this.updateDiscoveryStatus(false);
        this.startCommit(true);
        this.btnResume.setEnabled(false);
        if (this.stepStatus != 1) {
            if (this.getFormType() == 1) {
                ((OWFormLauncher)this.getFormLauncher()).startProgressBar();
            }
            this.btnPause.setEnabled(true);
        }
    }

    private void startCommit(boolean bl) {
        RedCellDiscoveredNode redCellDiscoveredNode2;
        this.stepStatus = 2;
        if (!bl) {
            redCellDiscoveredNode2 = null;
            for (RedCellDiscoveredNode redCellDiscoveredNode2 : this.parent.getNodes()) {
                this.nodeList.add(redCellDiscoveredNode2.getIPAddress());
            }
            try {
                this.statusOID = this.createDiscoveryStatus();
            }
            catch (Exception exception) {
                RedCellRuntimeUtil.println((String)("Unable to launch network inventory update process: " + exception.getMessage()));
                RedCellRuntimeUtil.printStackTrace((Exception)exception);
                return;
            }
            this.addEventListeners();
        }
        this.inProcess = true;
        try {
            redCellDiscoveredNode2 = new Vector();
            RedCellDiscoveredNode redCellDiscoveredNode32 = null;
            for (RedCellDiscoveredNode redCellDiscoveredNode32 : this.parent.getNodes()) {
                if (!this.nodeList.contains(redCellDiscoveredNode32.getIPAddress())) continue;
                redCellDiscoveredNode2.add(redCellDiscoveredNode32);
            }
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = this.parent.getDeepOptions();
            String string2 = null;
            for (String string2 : hashtable2.keySet()) {
                if (this.optionsUsedSet.containsKey(string2)) continue;
                hashtable.put(string2, hashtable2.get(string2));
            }
            hashtable.put("SubComponents", Boolean.TRUE);
            hashtable.put("Capabilities", Boolean.TRUE);
            CreateDiscoveredNodesEvent createDiscoveredNodesEvent = new CreateDiscoveredNodesEvent();
            createDiscoveredNodesEvent.setNodes((Serializable)redCellDiscoveredNode2);
            createDiscoveredNodesEvent.setOID((Serializable)this.statusOID);
            createDiscoveredNodesEvent.setNRKs(this.nrkList);
            createDiscoveredNodesEvent.setUser(RCUserUtil.getCurrentUser() == null ? RedCellRuntimeUtil.getProductName() : RCUserUtil.getCurrentUser().getLoginName());
            createDiscoveredNodesEvent.setDiscoveryOptions(hashtable);
            createDiscoveredNodesEvent.setDiscoveryJobID(this.jobID);
            createDiscoveredNodesEvent.set_OW_RuleName("RedCell.Config.CreateDiscoveredNodes");
            RedCellRuleEngineUtil.getEngine().execRuleAsync((IOWEvent)createDiscoveredNodesEvent);
        }
        catch (Exception exception) {
            this.removeEventListeners();
            RedCellRuntimeUtil.println((String)("Unable to launch network inventory update process: " + exception.getMessage()));
            RedCellRuntimeUtil.printStackTrace((Exception)exception);
            JOptionPane.showMessageDialog((Component)((Object)this), "Error while launching network inventory", "Update Error", 2);
            return;
        }
        this.enableButtons();
    }

    private void stopCommit(boolean bl) {
        this.inProcess = false;
        this.enableButtons();
        if (bl) {
            this.removeEventListeners();
            this.deleteDiscoveryStatus(this.statusOID);
            this.statusOID = null;
        } else {
            this.updateDiscoveryStatus(true);
        }
    }

    public void updateDiscoveryStatus(boolean bl) {
        UpdateDiscoveryStatusParamSet updateDiscoveryStatusParamSet = new UpdateDiscoveryStatusParamSet();
        updateDiscoveryStatusParamSet.setStatusOID(this.statusOID);
        updateDiscoveryStatusParamSet.setIsPaused(bl);
        RedCellRuleEngineUtil.callRule((String)"RedCell.Config.Discovery.UpdateDiscoveryStatusRule", (OWEvent)updateDiscoveryStatusParamSet);
    }

    public void action(OWEvent oWEvent) {
        if (oWEvent instanceof DiscoveryStatusChange) {
            DiscoveryStatusChange discoveryStatusChange = (DiscoveryStatusChange)oWEvent;
            OWOID oWOID = discoveryStatusChange.getStatusOID();
            if (oWOID != null && oWOID.equals((Object)this.statusOID)) {
                RedCellRuntimeUtil.resetApplicationTimeout();
                this.checkStatus(discoveryStatusChange);
            }
        } else if (oWEvent instanceof DiscoveryResultsEvent) {
            DiscoveryResultsEvent discoveryResultsEvent = (DiscoveryResultsEvent)oWEvent;
            Serializable serializable = discoveryResultsEvent.getDiscoveryStatusOID();
            if (serializable instanceof OWOID) {
                OWOID oWOID = (OWOID)serializable;
                if (oWOID != null && oWOID.equals((Object)this.statusOID)) {
                    this.newOIDs = discoveryResultsEvent.getDiscoveredOWOIDs();
                }
            } else {
                System.out.println("Expecting to find an OWOID, instead we found a " + serializable.getClass().getName());
            }
        } else if (oWEvent instanceof RootJobCompleteEvent) {
            this.btnPause.setEnabled(false);
            this.btnResume.setEnabled(false);
            this.btnLink.setEnabled(true);
            this.stepStatus = 1;
            this.parent.updateChecklist();
            this.stopCommit(false);
            if (this.getFormType() == 1) {
                ((OWFormLauncher)this.getFormLauncher()).stopProgressBar();
            }
        } else if (oWEvent instanceof RootJobCancelledEvent) {
            this.btnPause.setEnabled(false);
            this.btnResume.setEnabled(false);
            this.btnLink.setEnabled(true);
            this.stepStatus = 1;
            this.parent.updateChecklist();
            this.stopCommit(false);
            if (this.getFormType() == 1) {
                ((OWFormLauncher)this.getFormLauncher()).stopProgressBar();
            }
        }
    }

    public void disconnectOccurred(String string) {
        System.out.println("A disconnectOccurred error occured: " + string);
    }

    public void exceptionOccurred(Exception exception) {
        exception.printStackTrace();
        System.out.println("**************************An event listen exceptionOccurred error occured: " + exception.getMessage() + exception.toString());
    }
}

