/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.system.utility;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;

public class ImageUtility {
    public static ImageIcon createDisabledImageIcon(ImageIcon imageIcon) {
        return ImageUtility.createGrayScaleImageIcon(imageIcon, true, 90);
    }

    public static ImageIcon createGrayScaleImageIcon(ImageIcon imageIcon, boolean bl, int n2) {
        GrayFilter grayFilter = new GrayFilter(bl, n2);
        return new ImageIcon(GrayFilter.createDisabledImage(imageIcon.getImage()));
    }

    public static ImageIcon createTransparentImageIcon(ImageIcon imageIcon, int n2) {
        FilteredImageSource filteredImageSource = null;
        AlphaFilter alphaFilter = new AlphaFilter(n2);
        filteredImageSource = new FilteredImageSource(imageIcon.getImage().getSource(), alphaFilter);
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(filteredImageSource));
    }

    public static class ColorSwapFilter
    extends RGBImageFilter {
        private int b = 0;
        private int a = 0;

        public ColorSwapFilter(Color color, Color color2) {
            this.canFilterIndexColorModel = true;
            this.setOldColor(color);
            this.setNewColor(color2);
        }

        public int filterRGB(int n2, int n3, int n4) {
            if (n4 == this.b) {
                n4 = this.a;
            }
            return n4;
        }

        public void setNewColor(Color color) {
            this.a = color.getRGB() | 0xFF000000;
        }

        public void setOldColor(Color color) {
            this.b = color.getRGB() | 0xFF000000;
        }
    }

    public static class AlphaFilter
    extends RGBImageFilter {
        private final int a;

        public AlphaFilter(int n2) {
            if (n2 < 0 || n2 > 255) {
                String string = "Alpha must be between 0 and 255.  Invalid Alpha: " + n2;
                throw new IllegalArgumentException(string);
            }
            this.a = n2 << 24 & 0xFF000000;
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n2, int n3, int n4) {
            return n4 & 0xFFFFFF | this.a;
        }
    }
}

