/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.system.manage;

import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.swing.JOptionPane;
import jpdf_common.gui.ability.WaitCursorable;
import jpdf_common.gui.manage.BasicUserNotificationManager;
import jpdf_common.system.file.NamePatternFileFilter;
import jpdf_common.system.log.BasicLogManager;
import jpdf_common.system.manage.AbortHandler;
import jpdf_common.system.manage.BasicResourceManager;
import jpdf_common.system.manage.Diagnostic;
import jpdf_common.system.manage.ErrorHandler;
import jpdf_common.system.manage.UncaughtExceptionPrintStream;
import jpdf_common.system.utility.SystemUtility;

public class BasicApplicationManager {
    private static AbortHandler a = new DefaultAbortHandler();
    private static ErrorHandler c = new NoLogErrorHandler();
    private static boolean b = false;

    public static void abort(String string, Throwable throwable, String string2, boolean bl) {
        BasicApplicationManager.getAbortHandler().handleAbort(string2, string, throwable, bl);
    }

    public static void abortStart(String string, Throwable throwable) {
        BasicApplicationManager.getAbortHandler().handleStartAbort("Critical system startup error", string, throwable);
    }

    public static void displayDataErrorMessage(String string) {
        BasicApplicationManager.getErrorHandler().displayErrorMessage("Invalid Data Input", string);
    }

    public static void displayErrorMessage(String string, String string2) {
        BasicApplicationManager.getErrorHandler().displayErrorMessage(string, string2);
    }

    public static void establishUncaughtExceptionHandling(String string) {
        String string2 = null;
        int n2 = 0;
        if (string == null) {
            System.setErr(new UncaughtExceptionPrintStream());
        } else {
            n2 = BasicApplicationManager.a(string);
            string = string + "." + n2 + ".error";
            string2 = BasicLogManager.buildQualifiedLogFileName(string);
            try {
                System.setErr(new UncaughtExceptionPrintStream(string2));
            }
            catch (FileNotFoundException fileNotFoundException) {
                BasicApplicationManager.handleError(fileNotFoundException, true);
            }
        }
    }

    public static void exit(int n2) {
        if (BasicLogManager.isInitialized()) {
            BasicLogManager.logMessage("\nExit...");
        }
        BasicLogManager.terminate();
        System.exit(n2);
    }

    public static AbortHandler getAbortHandler() {
        return a;
    }

    public static ErrorHandler getErrorHandler() {
        return c;
    }

    public static void handleError(Throwable throwable) {
        BasicApplicationManager.getErrorHandler().handleError(throwable, true);
    }

    public static void handleError(Throwable throwable, boolean bl) {
        Window window = null;
        if (bl && (window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) instanceof WaitCursorable) {
            ((WaitCursorable)((Object)window)).setDefaultCursor();
        }
        BasicApplicationManager.getErrorHandler().handleError(throwable, bl);
    }

    public static void handleUncaughtError(Throwable throwable) {
        Window window = null;
        window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window instanceof WaitCursorable) {
            ((WaitCursorable)((Object)window)).setDefaultCursor();
        }
        BasicApplicationManager.getErrorHandler().handleUncaughtError(throwable);
    }

    public static void initialize(String string, String string2, ErrorHandler errorHandler, boolean bl, boolean bl2) {
        BasicApplicationManager.initialize(string, string2, errorHandler, bl, true, bl2);
    }

    public static void initialize(String string, String string2, ErrorHandler errorHandler, boolean bl, boolean bl2, boolean bl3) {
        String string3 = null;
        if (errorHandler instanceof AbortHandler) {
            BasicApplicationManager.setAbortHandler((AbortHandler)((Object)errorHandler));
        }
        if (string2 != null) {
            BasicLogManager.initialize(string2, string);
        }
        if (bl) {
            if (bl2) {
                string3 = string2 == null ? "UncaughtException" : string2;
            }
            BasicApplicationManager.establishUncaughtExceptionHandling(string3);
        }
        BasicResourceManager.initialize();
        if (errorHandler != null) {
            BasicApplicationManager.setErrorHandler(errorHandler);
        } else if (string2 != null) {
            BasicApplicationManager.setErrorHandler(new LogErrorHandler());
        }
        if (bl3) {
            BasicApplicationManager.setInitialized(true);
        }
    }

    public static boolean isInitialized() {
        return b;
    }

    public static void setAbortHandler(AbortHandler abortHandler) {
        if (abortHandler == null) {
            throw new IllegalArgumentException("The Abort Handler cannot be NULL.");
        }
        a = abortHandler;
    }

    public static void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException("The Error Handler cannot be NULL.");
        }
        c = errorHandler;
    }

    public static void setInitialized(boolean bl) {
        b = bl;
    }

    private static int a(String string) {
        NamePatternFileFilter namePatternFileFilter = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        File[] fileArray = null;
        File file = new File(BasicLogManager.getLogFilePath());
        int n2 = string.length() + 1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        string2 = string + ".*.error.log";
        namePatternFileFilter = new NamePatternFileFilter(false, false, string2);
        fileArray = file.listFiles(namePatternFileFilter);
        if (fileArray != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                string3 = fileArray[i2].getName();
                n7 = string3.indexOf(".", n2);
                string4 = string3.substring(n2, n7);
                try {
                    n5 = Integer.parseInt(string4);
                    if (n5 <= n3) continue;
                    n3 = n5;
                    n4 = i2;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (n4 >= 0) {
            n6 = fileArray[n4].length() == 0L ? n3 : n3 + 1;
        }
        return n6;
    }

    public static class DefaultAbortHandler
    implements AbortHandler {
        public void handleStartAbort(String string, String string2, Throwable throwable) {
            PrintStream printStream = null;
            String string3 = null;
            String string4 = null;
            String string5 = "";
            String string6 = null;
            try {
                string6 = SystemUtility.getThrowableCausalStackTrace(throwable, 9999);
                System.out.println("\n\n===================================\n" + string + "\n" + "===================================\n");
                System.out.println(string6);
                System.out.println("\n\n===============================\n" + string + "\n" + "===============================\n");
                if (string2 != null) {
                    string3 = BasicLogManager.buildQualifiedLogFileName(string2 + ".abort");
                    printStream = new PrintStream(new FileOutputStream(string3), true);
                    printStream.println(string6);
                    string5 = "<FONT color=\"#0000ff\">Error information has been written to file: " + string3 + "</FONT>";
                }
                if ((string4 = throwable instanceof Diagnostic ? ((Diagnostic)((Object)throwable)).getDetailedExplanation(true, 12) : throwable.getMessage()) == null) {
                    string4 = throwable.toString();
                }
                if (string4 == null) {
                    string4 = throwable.getClass().getName();
                }
                string4 = string4.replaceAll("\n", "<BR>");
                string4 = "<HTML> <B>A Fatal Error has occurred: " + throwable.getClass().getName() + "<HR><B>" + string4 + "</B><HR>" + string5 + "</B></HTML>";
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(null, string4, "Fatal Error", 0);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            System.exit(99);
        }

        public void handleAbort(String string, String string2, Throwable throwable, boolean bl) {
            String string3 = null;
            if (bl) {
                if (string2 != null) {
                    string3 = BasicLogManager.buildQualifiedLogFileName(string2 + ".abort");
                    try {
                        throwable.printStackTrace(new PrintStream(new FileOutputStream(string3), true));
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                System.out.println("\n\n===============================\n" + string + "\n" + "===============================\n");
                BasicApplicationManager.exit(-10);
            } else {
                this.handleStartAbort(string, string2, throwable);
            }
        }
    }

    public static class ConsoleErrorHandler
    implements ErrorHandler {
        public void displayErrorMessage(String string, String string2) {
            System.out.println("\n*** ERROR: " + string);
            System.out.println("------------------------------------------------");
            System.out.println(string2 + "\n");
        }

        public void handleError(Throwable throwable, boolean bl) {
            System.out.println("\n*** ERROR: " + throwable);
            System.out.println("------------------------------------------------");
            throwable.printStackTrace(System.out);
        }

        public void handleUncaughtError(Throwable throwable) {
            System.out.println("\n*** UNCAUGHT ERROR: " + throwable);
            System.out.println("------------------------------------------------");
            throwable.printStackTrace(System.out);
        }
    }

    public static class NoLogErrorHandler
    implements ErrorHandler {
        public void displayErrorMessage(String string, String string2) {
            BasicUserNotificationManager.displayErrorMessage(string, string2);
        }

        public void handleError(Throwable throwable, boolean bl) {
            if (bl) {
                BasicUserNotificationManager.displayException_System(throwable);
            }
        }

        public void handleUncaughtError(Throwable throwable) {
            BasicUserNotificationManager.displayException_Uncaught(throwable);
        }
    }

    public static class LogErrorHandler
    implements ErrorHandler {
        public void displayErrorMessage(String string, String string2) {
            BasicUserNotificationManager.displayErrorMessage(string, string2);
        }

        public void handleError(Throwable throwable, boolean bl) {
            BasicLogManager.logException(throwable, bl);
        }

        public void handleUncaughtError(Throwable throwable) {
            BasicLogManager.logUncaughtException(throwable);
        }
    }
}

