/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.system.manage;

import jpdf_common.system.manage.Diagnostic;

public class ApplicationException
extends Exception
implements Diagnostic {
    protected static final int LOW_SEVERITY = 0;
    protected static final int MEDIUM_SEVERITY = 1;
    protected static final int HIGH_SEVERITY = 2;
    protected final int SEVERITY_LEVEL;
    protected final String DETAILED_EXPLANATION;

    protected ApplicationException(String string, String string2, int n2) {
        super(string);
        this.SEVERITY_LEVEL = n2;
        this.DETAILED_EXPLANATION = string2;
    }

    protected ApplicationException(Throwable throwable, String string, String string2, int n2) {
        super(string, throwable);
        this.SEVERITY_LEVEL = n2;
        this.DETAILED_EXPLANATION = string2;
    }

    public static ApplicationException createCriticalError(String string) {
        return new ApplicationException(string, null, 2);
    }

    public static ApplicationException createCriticalError(String string, String string2) {
        return new ApplicationException(string, string2, 2);
    }

    public static ApplicationException createCriticalError(Throwable throwable, String string) {
        return new ApplicationException(throwable, string, null, 2);
    }

    public static ApplicationException createCriticalError(Throwable throwable, String string, String string2) {
        return new ApplicationException(throwable, string, string2, 2);
    }

    public static ApplicationException createError(String string) {
        return new ApplicationException(string, null, 1);
    }

    public static ApplicationException createError(String string, String string2) {
        return new ApplicationException(string, string2, 1);
    }

    public static ApplicationException createError(Throwable throwable, String string) {
        return new ApplicationException(throwable, string, null, 1);
    }

    public static ApplicationException createError(Throwable throwable, String string, String string2) {
        return new ApplicationException(throwable, string, string2, 1);
    }

    public static ApplicationException createWarning(String string) {
        return new ApplicationException(string, null, 0);
    }

    public static ApplicationException createWarning(String string, String string2) {
        return new ApplicationException(string, string2, 0);
    }

    public static ApplicationException createWarning(Throwable throwable, String string) {
        return new ApplicationException(throwable, string, null, 0);
    }

    public static ApplicationException createWarning(Throwable throwable, String string, String string2) {
        return new ApplicationException(throwable, string, null, 0);
    }

    public String getDetailedExplanation() {
        return this.DETAILED_EXPLANATION;
    }

    public String getDetailedExplanation(boolean bl, int n2) {
        StackTraceElement[] stackTraceElementArray = null;
        StringBuffer stringBuffer = null;
        String string = this.DETAILED_EXPLANATION;
        int n3 = n2;
        if (bl) {
            stackTraceElementArray = this.getStackTrace();
            if (stackTraceElementArray.length < n2) {
                n3 = stackTraceElementArray.length;
            }
            stringBuffer = new StringBuffer(50 * n3);
            for (int i2 = 0; i2 < n3; ++i2) {
                stringBuffer.append("\n  >" + stackTraceElementArray[i2].toString());
            }
            string = string + stringBuffer.toString();
        }
        return string;
    }

    public String getSeverityLabel() {
        String string = null;
        string = this.SEVERITY_LEVEL == 0 ? "warning" : (this.SEVERITY_LEVEL == 0 ? "error" : "critical error");
        return string;
    }

    public static String getThrowableTitle(Throwable throwable) {
        String string = null;
        string = throwable instanceof ApplicationException ? ((ApplicationException)throwable).getTitle() : "System Exception";
        return string;
    }

    public static String getThrowableType(Throwable throwable) {
        String string = null;
        Object var2_2 = null;
        string = throwable instanceof ApplicationException ? "Application Exception (" + ((ApplicationException)throwable).getSeverityLabel() + ")" : throwable.getClass().getName();
        return string;
    }

    public String getTitle() {
        String string = null;
        string = this.isWarning() ? "Application Warning" : (this.isError() ? "Application Error" : "Critical Application Error");
        return string;
    }

    public boolean isCriticalError() {
        return this.SEVERITY_LEVEL == 2;
    }

    public boolean isError() {
        return this.SEVERITY_LEVEL == 1;
    }

    public boolean isWarning() {
        return this.SEVERITY_LEVEL == 0;
    }
}

