/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.system.log;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Style;
import javax.swing.text.View;
import javax.swing.text.html.StyleSheet;
import jpdf_common.system.log.BasicLogManager;
import jpdf_common.system.utility.StringUtility;

public class DebugMessageConstructor {
    protected static final String DEBUG_MESSAGE_PREFIX = "*** DEBUG: ";
    static Class g;
    static Class c;
    static Class h;
    static Class b;
    static Class i;
    static Class d;
    static Class m;
    static Class e;
    static Class a;
    static Class l;
    static Class k;
    static Class j;
    static Class f;

    public static String buildActionListMessage(Action[] actionArray) {
        String string = "[*Action List*]\n  ";
        for (int i2 = 0; i2 < actionArray.length; ++i2) {
            string = string + "\n\t" + actionArray[i2].getValue("Name") + ": " + "accellerator: " + actionArray[i2].getValue("AcceleratorKey") + ", " + "description: " + actionArray[i2].getValue("ShortDescription");
        }
        return string;
    }

    public static String buildActionMapMessage(JComponent jComponent) {
        String string = "[*Component Action Map*]\n  " + DebugMessageConstructor.a((Component)jComponent, true);
        ActionMap actionMap = jComponent.getActionMap();
        Object[] objectArray = actionMap.allKeys();
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                string = string + "\n\t" + objectArray[i2] + " -> " + actionMap.get(objectArray[i2]);
            }
        }
        return string;
    }

    public static String buildAllComponentListenersMessage(JComponent jComponent) {
        return "[*All Component Listeners*]\n  " + DebugMessageConstructor.a((Component)jComponent, false) + DebugMessageConstructor.a(jComponent, g == null ? (g = DebugMessageConstructor.class$("javax.swing.event.AncestorListener")) : g) + DebugMessageConstructor.a(jComponent, c == null ? (c = DebugMessageConstructor.class$("java.awt.event.ComponentListener")) : c) + DebugMessageConstructor.a(jComponent, h == null ? (h = DebugMessageConstructor.class$("java.awt.event.ContainerListener")) : h) + DebugMessageConstructor.a(jComponent, b == null ? (b = DebugMessageConstructor.class$("java.awt.event.FocusListener")) : b) + DebugMessageConstructor.a(jComponent, i == null ? (i = DebugMessageConstructor.class$("java.awt.event.HierarchyBoundsListener")) : i) + DebugMessageConstructor.a(jComponent, d == null ? (d = DebugMessageConstructor.class$("java.awt.event.HierarchyListener")) : d) + DebugMessageConstructor.a(jComponent, m == null ? (m = DebugMessageConstructor.class$("java.awt.event.InputMethodListener")) : m) + DebugMessageConstructor.a(jComponent, e == null ? (e = DebugMessageConstructor.class$("java.awt.event.KeyListener")) : e) + DebugMessageConstructor.a(jComponent, a == null ? (a = DebugMessageConstructor.class$("java.awt.event.MouseListener")) : a) + DebugMessageConstructor.a(jComponent, l == null ? (l = DebugMessageConstructor.class$("java.awt.event.MouseMotionListener")) : l) + DebugMessageConstructor.a(jComponent, k == null ? (k = DebugMessageConstructor.class$("java.beans.PropertyChangeListener")) : k) + DebugMessageConstructor.a(jComponent, j == null ? (j = DebugMessageConstructor.class$("java.beans.VetoableChangeListener")) : j);
    }

    public static String buildAllContainerComponentsMessage(Container container) {
        String string = "[*All Container Components*]\n  " + container;
        return DebugMessageConstructor.a(container, string, 0);
    }

    public static String buildAllSystemPropertiesMessage() {
        String string = null;
        try {
            string = DebugMessageConstructor.buildMapMessageSorted(System.getProperties(), "All System Properties");
        }
        catch (Exception exception) {
            BasicLogManager.logException(exception);
        }
        return string;
    }

    public static String buildArrayMessage(Object[] objectArray, String string) {
        StringBuffer stringBuffer = new StringBuffer(32 * (objectArray.length + 1));
        stringBuffer.append("[*" + string + " Array*] ");
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            stringBuffer.append("\n  " + i2 + ".\t" + objectArray[i2]);
        }
        return stringBuffer.toString();
    }

    public static String buildAttributeSetMessage(AttributeSet attributeSet, String string) {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        Object object = null;
        String string2 = "[*" + string + " Attribute Set*] " + attributeSet.getClass().getName();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            string2 = string2 + "\n\t" + object + " [" + object.getClass().getName() + "] = " + attributeSet.getAttribute(object);
        }
        return string2;
    }

    public static String buildComponentListenersMessage(JComponent jComponent, Class clazz) {
        return "[*Component Listeners*]\n  " + DebugMessageConstructor.a((Component)jComponent, false) + DebugMessageConstructor.a(jComponent, clazz);
    }

    public static String buildContainerComponentsMessage(Container container) {
        String string = "[*Container Components*]\n  " + container;
        Component[] componentArray = container.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            string = string + "\n\t" + DebugMessageConstructor.a(componentArray[i2], true);
        }
        return string;
    }

    public static String buildDebugLogMessage(String string, boolean bl) {
        return DebugMessageConstructor.computeDebugLogMessage(string, bl).toString();
    }

    public static String buildDictionaryMessage(Dictionary dictionary, String string) {
        Enumeration enumeration = dictionary.keys();
        Object var3_3 = null;
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("[*" + string + " Dictionary*] ");
        while (enumeration.hasMoreElements()) {
            var3_3 = enumeration.nextElement();
            stringBuffer.append("\n\t" + var3_3 + " = " + dictionary.get(var3_3));
        }
        return stringBuffer.toString();
    }

    public static String buildDictionaryMessage(Dictionary dictionary, String string, String string2) {
        Enumeration enumeration = dictionary.keys();
        Object object = null;
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("[*" + string + " Dictionary*] ");
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!object.toString().startsWith(string2)) continue;
            stringBuffer.append("\n\t" + object + " = " + dictionary.get(object));
        }
        return stringBuffer.toString();
    }

    public static String buildDictionaryMessage(Dictionary dictionary, String string, Class clazz) {
        Enumeration enumeration = dictionary.keys();
        Object var4_4 = null;
        Object var5_5 = null;
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("[*" + string + " Dictionary*] ");
        while (enumeration.hasMoreElements()) {
            var4_4 = enumeration.nextElement();
            var5_5 = dictionary.get(var4_4);
            if (!clazz.isInstance(var5_5)) continue;
            stringBuffer.append("\n\t" + var4_4 + " = " + var5_5);
        }
        return stringBuffer.toString();
    }

    public static String buildDocumentElementsMessage(Document document, boolean bl) {
        String string = "[*Document Elements*]  " + document + "\n";
        Element element = document.getDefaultRootElement();
        string = bl ? DebugMessageConstructor.buildDocumentElementsAndAttributesMessage(string, "", element) : DebugMessageConstructor.buildDocumentElementsMessage(string, "", element);
        return string;
    }

    public static String buildDocumentElementsMessage(String string, String string2, Element element) {
        Element element2 = null;
        int n2 = element.getElementCount();
        string = string + string2 + element;
        string2 = string2 + "  ";
        for (int i2 = 0; i2 < n2; ++i2) {
            element2 = element.getElement(i2);
            string = DebugMessageConstructor.buildDocumentElementsMessage(string, string2, element2);
        }
        return string;
    }

    public static String buildDocumentElementsAndAttributesMessage(String string, String string2, Element element) {
        AttributeSet attributeSet = null;
        Enumeration<?> enumeration = null;
        Element element2 = null;
        Object object = null;
        int n2 = element.getElementCount();
        string = string + "\n" + string2 + element;
        string2 = string2 + "  ";
        attributeSet = element.getAttributes();
        enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            string = string + "  " + string2 + object + " [" + object.getClass().getName() + "] = " + attributeSet.getAttribute(object) + "\n";
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            element2 = element.getElement(i2);
            string = DebugMessageConstructor.buildDocumentElementsAndAttributesMessage(string, string2, element2);
        }
        return string;
    }

    public static String computeDocumentTextMessage(Document document) {
        String string = null;
        try {
            string = document.getText(0, document.getLength());
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return string;
    }

    public static String buildEnumerationMessage(Enumeration enumeration, String string) {
        String string2 = "[*" + string + " Enumeration*] ";
        while (enumeration.hasMoreElements()) {
            string2 = string2 + "\n\t" + enumeration.nextElement();
        }
        return string2;
    }

    public static String buildInputMapMessage(InputMap inputMap, boolean bl) {
        return "[*Input Map - with" + (bl ? "" : "out") + " parent keys*]\n  " + DebugMessageConstructor.a(inputMap, bl);
    }

    public static String buildInputMapMessage(InputMap inputMap, boolean bl, String string) {
        return string + DebugMessageConstructor.a(inputMap, bl);
    }

    public static String buildInputMapMessage(JComponent jComponent, boolean bl) {
        return "[*Component Input Map - with" + (bl ? "" : "out") + " parent keys*]\n  " + DebugMessageConstructor.a((Component)jComponent, true) + DebugMessageConstructor.a(jComponent.getInputMap(), bl);
    }

    public static String buildInputMapsMessage(JComponent jComponent, boolean bl) {
        return "[*Component Input Map - with" + (bl ? "" : "out") + " parent keys*]\n  " + DebugMessageConstructor.a((Component)jComponent, true) + "\n    When Focused\n    =====================================" + DebugMessageConstructor.a(jComponent.getInputMap(0), bl) + "\n    When Ancestor Of Focused Component\n    =====================================" + DebugMessageConstructor.a(jComponent.getInputMap(1), bl) + "\n    When In Focused Window\n    =====================================" + DebugMessageConstructor.a(jComponent.getInputMap(2), bl);
    }

    public static String buildKeymapMessage(JTextComponent jTextComponent) {
        String string = "[*Text Component Key Map*]\n  " + jTextComponent;
        Keymap keymap = jTextComponent.getKeymap();
        KeyStroke[] keyStrokeArray = keymap.getBoundKeyStrokes();
        for (int i2 = 0; i2 < keyStrokeArray.length; ++i2) {
            string = string + "\n\t" + keyStrokeArray[i2] + " -> " + keymap.getAction(keyStrokeArray[i2]);
        }
        return string;
    }

    public static String buildMapMessageSorted(Map map, String string) {
        StringBuffer stringBuffer = new StringBuffer(256);
        Object[] objectArray = map.keySet().toArray();
        Arrays.sort(objectArray, StringUtility.getCaseInsensitiveStringComparator());
        stringBuffer.append("[*" + string + " Map*] ");
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            stringBuffer.append("\n\t" + objectArray[i2] + " = " + map.get(objectArray[i2]));
        }
        return stringBuffer.toString();
    }

    public static String buildObjectAncestryMessage(Object object) {
        Vector vector = new Vector(5);
        Class<?> clazz = null;
        String string = null;
        String string2 = "";
        int n2 = 0;
        if (object == null) {
            string = "[*Object Ancestry*]  null object";
        } else {
            string = "[*Object Ancestry*]  " + object.toString();
            for (clazz = object.getClass(); clazz != (f == null ? DebugMessageConstructor.class$("java.lang.Object") : f); clazz = clazz.getSuperclass()) {
                vector.addElement(clazz);
            }
            for (int i2 = n2 = vector.size() - 1; i2 >= 0; --i2) {
                string = string + "\n\t" + string2 + ((Class)vector.elementAt(i2)).getName();
                string2 = string2 + "  ";
            }
        }
        return string;
    }

    public static String buildObjectClassInfoMessage(Object object, boolean bl) {
        String string = null;
        Class<?> clazz = null;
        Constructor<?>[] constructorArray = null;
        Method[] methodArray = null;
        if (object == null) {
            string = "[*Class Info*]  null object";
        } else {
            int n2;
            clazz = object.getClass();
            if (bl) {
                constructorArray = clazz.getDeclaredConstructors();
                methodArray = clazz.getDeclaredMethods();
            } else {
                constructorArray = clazz.getConstructors();
                methodArray = clazz.getMethods();
            }
            string = "[*Class Info*]\n  " + clazz.getName() + " extends " + clazz.getSuperclass().getName() + "\n    Constructors\n    -------------";
            for (n2 = 0; n2 < constructorArray.length; ++n2) {
                string = string + "\n\t" + constructorArray[n2];
            }
            string = string + "\n    Methods\n    -------------";
            for (n2 = 0; n2 < methodArray.length; ++n2) {
                if (methodArray[n2].getDeclaringClass() == (f == null ? DebugMessageConstructor.class$("java.lang.Object") : f)) continue;
                string = string + "\n\t" + methodArray[n2];
            }
        }
        return string;
    }

    public static String buildObjectClassInfoMessage(Object object, boolean bl, String string) {
        String string2 = null;
        Class<?> clazz = null;
        Object var5_5 = null;
        Constructor<?>[] constructorArray = null;
        Method[] methodArray = null;
        if (object == null) {
            string2 = "[*Class Info*]  null object";
        } else {
            int n2;
            clazz = object.getClass();
            if (bl) {
                constructorArray = clazz.getDeclaredConstructors();
                methodArray = clazz.getDeclaredMethods();
            } else {
                constructorArray = clazz.getConstructors();
                methodArray = clazz.getMethods();
            }
            string2 = "[*Class Info*]\n  " + clazz.getName() + " extends " + clazz.getSuperclass().getName() + "\n    Constructors\n    -------------";
            for (n2 = 0; n2 < constructorArray.length; ++n2) {
                string2 = string2 + "\n\t" + constructorArray[n2];
            }
            string2 = string2 + "\n    Methods\n    -------------";
            for (n2 = 0; n2 < methodArray.length; ++n2) {
                if (!methodArray[n2].getDeclaringClass().getName().startsWith(string)) continue;
                string2 = string2 + "\n\t" + methodArray[n2];
            }
        }
        return string2;
    }

    public static String buildParentTreeMessage(Component component) {
        Vector<Container> vector = new Vector<Container>(8);
        String string = "[*Parent Tree*] " + component.toString();
        int n2 = 0;
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            vector.addElement(container);
        }
        for (int i2 = n2 = vector.size() - 1; i2 >= 0; --i2) {
            string = string + "\n\t" + vector.elementAt(i2).getClass().getName();
        }
        string = string + "\n\t" + component.getClass().getName();
        return string;
    }

    public static String buildShowingFramesMessage() {
        Frame[] frameArray = Frame.getFrames();
        String string = "[*All Showing Frames*]";
        for (int i2 = 0; i2 < frameArray.length; ++i2) {
            if (!frameArray[i2].isShowing()) continue;
            string = string + "\n\t" + frameArray[i2];
        }
        return string;
    }

    public static String buildStyleSheetMessage(StyleSheet styleSheet) {
        Enumeration<?> enumeration = styleSheet.getStyleNames();
        Enumeration<?> enumeration2 = null;
        Style style = null;
        StringBuffer stringBuffer = new StringBuffer(256);
        String string = null;
        Object var6_6 = null;
        stringBuffer.append("[*Style Sheet*] ");
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement().toString();
            style = styleSheet.getRule(string);
            stringBuffer.append("\n\t" + string + " : {");
            enumeration2 = style.getAttributeNames();
            while (enumeration2.hasMoreElements()) {
                var6_6 = enumeration2.nextElement();
                stringBuffer.append(var6_6 + ":" + style.getAttribute(var6_6) + "; ");
            }
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    public static String buildUIDefaultsMessage() {
        return DebugMessageConstructor.buildDictionaryMessage(UIManager.getDefaults(), "User Default");
    }

    public static String buildUIDefaultsMessage(String string) {
        return DebugMessageConstructor.buildDictionaryMessage((Dictionary)UIManager.getDefaults(), string + " User Default", string);
    }

    public static String buildUIDefaultsMessage(Class clazz) {
        return DebugMessageConstructor.buildDictionaryMessage((Dictionary)UIManager.getDefaults(), clazz.getName() + " User Defaults", clazz);
    }

    public static String buildVectorMessage(Vector vector, String string) {
        String string2 = "[*" + string + " Vector*] ";
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            string2 = string2 + "\n  " + i2 + "\t" + vector.elementAt(i2);
        }
        return string2;
    }

    public static String buildViewsMessage(View view, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(bl ? 1024 : 512);
        stringBuffer.append("[*Root View Views*]  " + view.getClass().getName() + "\n");
        stringBuffer = DebugMessageConstructor.a(stringBuffer, "", view, bl);
        return stringBuffer.toString();
    }

    public static String buildViewsMessage(JTextComponent jTextComponent, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(bl ? 1024 : 512);
        View view = jTextComponent.getUI().getRootView(jTextComponent);
        stringBuffer.append("[*Text Component Views*]  " + jTextComponent.getClass().getName() + "\n");
        stringBuffer = DebugMessageConstructor.a(stringBuffer, "", view, bl);
        return stringBuffer.toString();
    }

    public static String buildViewsWithAttributesMessage(JTextComponent jTextComponent) {
        StringBuffer stringBuffer = new StringBuffer(2048);
        View view = jTextComponent.getUI().getRootView(jTextComponent);
        stringBuffer.append("[*Text Component Views*]  " + jTextComponent.getClass().getName() + "\n");
        stringBuffer = DebugMessageConstructor.a(stringBuffer, "", view);
        return stringBuffer.toString();
    }

    public static String buildViewsWithTextMessage(JTextComponent jTextComponent, Class clazz, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        View view = jTextComponent.getUI().getRootView(jTextComponent);
        stringBuffer.append("[*Text Component Views*]  " + jTextComponent.getClass().getName() + "\n");
        stringBuffer = DebugMessageConstructor.a(jTextComponent.getDocument(), stringBuffer, "", view, clazz, bl);
        return stringBuffer.toString();
    }

    public static String buildViewsWithTextMessage(JTextComponent jTextComponent, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        View view = jTextComponent.getUI().getRootView(jTextComponent);
        stringBuffer.append("[*Text Component Views*]  " + jTextComponent.getClass().getName() + "\n");
        stringBuffer = DebugMessageConstructor.a(jTextComponent.getDocument(), stringBuffer, "", view, string, bl);
        return stringBuffer.toString();
    }

    protected static StringBuffer computeDebugLogMessage(String string, boolean bl) {
        StringBuffer stringBuffer = null;
        stringBuffer = bl ? new StringBuffer("\n*** DEBUG: " + string + "\n================================================= \n" + BasicLogManager.getTraceString(3)) : new StringBuffer(DEBUG_MESSAGE_PREFIX + string);
        return stringBuffer;
    }

    private static String a(InputMap inputMap, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(100);
        KeyStroke[] keyStrokeArray = bl ? inputMap.allKeys() : inputMap.keys();
        String string = null;
        if (keyStrokeArray != null) {
            Arrays.sort(keyStrokeArray, StringUtility.getCaseInsensitiveStringComparator());
            for (int i2 = 0; i2 < keyStrokeArray.length; ++i2) {
                string = KeyEvent.getKeyModifiersText(keyStrokeArray[i2].getModifiers());
                if (string.length() > 0) {
                    stringBuffer.append("\n\t" + string + "+" + KeyEvent.getKeyText(keyStrokeArray[i2].getKeyCode()) + " -> " + inputMap.get(keyStrokeArray[i2]));
                    continue;
                }
                stringBuffer.append("\n\t" + KeyEvent.getKeyText(keyStrokeArray[i2].getKeyCode()) + " -> " + inputMap.get(keyStrokeArray[i2]));
            }
        }
        return stringBuffer.toString();
    }

    private static StringBuffer a(StringBuffer stringBuffer, String string, View view, boolean bl) {
        String string2 = view.getElement().getName();
        View view2 = null;
        int n2 = view.getViewCount();
        stringBuffer.append("\n" + string + view.getClass().getName() + " [" + string2 + "]");
        string = string + "  ";
        for (int i2 = 0; i2 < n2; ++i2) {
            view2 = view.getView(i2);
            if (!bl && view2.getElement().getName().equals("content")) continue;
            stringBuffer = DebugMessageConstructor.a(stringBuffer, string, view2, bl);
        }
        return stringBuffer;
    }

    private static StringBuffer a(StringBuffer stringBuffer, String string, View view) {
        AttributeSet attributeSet = null;
        Enumeration<?> enumeration = null;
        String string2 = view.getElement().getName();
        View view2 = null;
        Object object = null;
        int n2 = view.getViewCount();
        stringBuffer.append("\n" + string + view.getClass().getName() + " [" + string2 + "]");
        string = string + "  ";
        attributeSet = view.getAttributes();
        if (attributeSet != null) {
            enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                stringBuffer.append("\n  " + string + object + " [" + object.getClass().getName() + "] = " + attributeSet.getAttribute(object));
            }
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            view2 = view.getView(i2);
            if (view2.getElement().getName().equals("content")) continue;
            stringBuffer = DebugMessageConstructor.a(stringBuffer, string, view2);
        }
        return stringBuffer;
    }

    private static StringBuffer a(Document document, StringBuffer stringBuffer, String string, View view, Class clazz, boolean bl) {
        String string2 = view.getElement().getName();
        View view2 = null;
        int n2 = view.getViewCount();
        stringBuffer.append("\n" + string + view.getClass().getName() + " [" + string2 + "]");
        string = string + "  ";
        if (clazz.isInstance(view)) {
            stringBuffer.append("\n  " + string + DebugMessageConstructor.a(document, view));
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            view2 = view.getView(i2);
            if (!bl && view2.getElement().getName().equals("content")) continue;
            stringBuffer = DebugMessageConstructor.a(document, stringBuffer, string, view2, clazz, bl);
        }
        return stringBuffer;
    }

    private static StringBuffer a(Document document, StringBuffer stringBuffer, String string, View view, String string2, boolean bl) {
        String string3 = view.getElement().getName();
        View view2 = null;
        int n2 = view.getViewCount();
        stringBuffer.append("\n" + string + view.getClass().getName() + " [" + string3 + "]");
        string = string + "  ";
        if (string3.equalsIgnoreCase(string2)) {
            stringBuffer.append("\n  " + string + DebugMessageConstructor.a(document, view));
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            view2 = view.getView(i2);
            if (!bl && view2.getElement().getName().equals("content")) continue;
            stringBuffer = DebugMessageConstructor.a(document, stringBuffer, string, view2, string2, bl);
        }
        return stringBuffer;
    }

    private static String a(Container container, String string, int n2) {
        int n3;
        Component[] componentArray = container.getComponents();
        String string2 = "\n\t";
        for (n3 = 1; n3 <= n2; ++n3) {
            string2 = string2 + "\t";
        }
        for (n3 = 0; n3 < componentArray.length; ++n3) {
            string = string + string2 + n3 + ". " + DebugMessageConstructor.a(componentArray[n3], true);
            if (!(componentArray[n3] instanceof Container)) continue;
            string = DebugMessageConstructor.a((Container)componentArray[n3], string, n2 + 1);
        }
        return string;
    }

    private static String a(JComponent jComponent, Class clazz) {
        EventListener[] eventListenerArray = jComponent.getListeners(clazz);
        String string = "\n    Class: " + clazz.getName();
        for (int i2 = 0; i2 < eventListenerArray.length; ++i2) {
            string = string + "\n\t" + eventListenerArray[i2].getClass().getName() + ": " + eventListenerArray[i2];
        }
        return string;
    }

    private static String a(Component component, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(80);
        String string = null;
        boolean bl2 = false;
        stringBuffer.append(component.getClass().getName());
        if (component instanceof AbstractButton) {
            string = ((AbstractButton)component).getText();
            if (string != null && !string.trim().equals("")) {
                stringBuffer.append(" [text=" + string);
                bl2 = true;
            } else {
                string = ((AbstractButton)component).getToolTipText();
                if (string != null && !string.trim().equals("")) {
                    stringBuffer.append(" [tip=" + string);
                    bl2 = true;
                }
            }
        } else if (component instanceof JLabel) {
            stringBuffer.append(" [text=" + ((JLabel)component).getText());
            bl2 = true;
        }
        if (!bl2 && component.getName() != null) {
            stringBuffer.append(" [name=" + component.getName());
            bl2 = true;
        }
        if (bl) {
            stringBuffer.append(bl2 ? ", " : "[").append("focusable=");
            stringBuffer.append(component.isFocusable() ? "yes" : "no");
            bl2 = true;
        }
        if (bl2) {
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    private static String a(Document document, View view) {
        Element element = view.getElement();
        String string = null;
        int n2 = element.getStartOffset();
        int n3 = element.getEndOffset() - n2;
        try {
            string = document.getText(n2, n3);
        }
        catch (BadLocationException badLocationException) {
            string = "****ERROR: " + badLocationException.toString();
        }
        return string;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

