/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.system.log;

import java.awt.Component;
import java.awt.Container;
import java.util.Dictionary;
import java.util.Vector;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import jpdf_common.system.log.BasicLogManager;
import jpdf_common.system.log.DebugMessageConstructor;

public class BasicDebugger {
    public static void logActionMap(JComponent jComponent) {
        BasicLogManager.logDebugMessage(DebugMessageConstructor.buildActionMapMessage(jComponent));
    }

    public static void logAllComponentListeners(JComponent jComponent) {
        String string = DebugMessageConstructor.buildAllComponentListenersMessage(jComponent);
        BasicLogManager.logDebugMessage(string);
    }

    public static void logAllContainerComponents(Container container) {
        String string = DebugMessageConstructor.buildAllContainerComponentsMessage(container);
        BasicLogManager.logDebugMessage(string);
    }

    public static void logAllSystemProperties() {
        BasicLogManager.logDebugMessage(DebugMessageConstructor.buildAllSystemPropertiesMessage());
    }

    public static void logArray(Object[] objectArray, String string) {
        BasicLogManager.logDebugMessage(DebugMessageConstructor.buildArrayMessage(objectArray, string));
    }

    public static void logComponentListeners(JComponent jComponent, Class clazz) {
        String string = DebugMessageConstructor.buildComponentListenersMessage(jComponent, clazz);
        BasicLogManager.logDebugMessage(string);
    }

    public static void logContainerComponents(Container container) {
        BasicLogManager.logDebugMessage(DebugMessageConstructor.buildContainerComponentsMessage(container));
    }

    public static void logDictionary(Dictionary dictionary, String string) {
        BasicLogManager.logDebugMessage(DebugMessageConstructor.buildDictionaryMessage(dictionary, string));
    }

    public static void logException(Throwable throwable) {
        BasicLogManager.logException(throwable);
    }

    public static void logInputMap(InputMap inputMap, boolean bl) {
        String string = DebugMessageConstructor.buildInputMapMessage(inputMap, bl);
        BasicLogManager.logDebugMessage(string);
    }

    public static void logInputMap(JComponent jComponent, boolean bl) {
        String string = DebugMessageConstructor.buildInputMapMessage(jComponent, bl);
        BasicLogManager.logDebugMessage(string);
    }

    public static void logInputMaps(JComponent jComponent, boolean bl) {
        String string = DebugMessageConstructor.buildInputMapsMessage(jComponent, bl);
        BasicLogManager.logDebugMessage(string);
    }

    public static void logKeymap(JTextComponent jTextComponent) {
        BasicLogManager.logDebugMessage(DebugMessageConstructor.buildKeymapMessage(jTextComponent));
    }

    public static void logMessage(String string, boolean bl) {
        String string2 = DebugMessageConstructor.computeDebugLogMessage(string, bl).toString();
        BasicLogManager.logDebugMessage(string2);
    }

    public static void logMessage(String string, String string2) {
        boolean bl = string.toUpperCase().indexOf(string2.toUpperCase()) >= 0;
        String string3 = DebugMessageConstructor.computeDebugLogMessage(string, bl).toString();
        BasicLogManager.logDebugMessage(string3);
    }

    public static void logMessageAsIs(String string) {
        BasicLogManager.logDebugMessage(string);
    }

    public static void logObjectAncestry(Object object) {
        BasicLogManager.logDebugMessage(DebugMessageConstructor.buildObjectAncestryMessage(object));
    }

    public static void logObjectClassInfo(Object object, boolean bl) {
        String string = DebugMessageConstructor.buildObjectClassInfoMessage(object, bl);
        BasicLogManager.logDebugMessage(string);
    }

    public static void logParentTree(Component component) {
        BasicLogManager.logDebugMessage(DebugMessageConstructor.buildParentTreeMessage(component));
    }

    public static void logShowingFrames() {
        BasicLogManager.logDebugMessage(DebugMessageConstructor.buildShowingFramesMessage());
    }

    public static void logUIDefaults() {
        BasicLogManager.logDebugMessage(DebugMessageConstructor.buildUIDefaultsMessage());
    }

    public static void logVector(Vector vector, String string) {
        BasicLogManager.logDebugMessage(DebugMessageConstructor.buildVectorMessage(vector, string));
    }
}

