/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.help;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import jpdf_common.gui.constant.ButtonConstant;
import jpdf_common.help.HelpDisplayDialog;
import jpdf_common.help.b;
import jpdf_common.system.manage.BasicApplicationManager;
import jpdf_common.system.manage.BasicLocalizationManager;
import jpdf_common.system.manage.BasicResourceManager;
import jpdf_common.system.manage.IconRetriever;

public class HelpButton
extends JButton
implements ActionListener {
    private static final Icon c = IconRetriever.getHelpTopicIcon();
    private static final Dimension i = new Dimension(18 + ButtonConstant.PLAF_ADJUST_X, 19 + ButtonConstant.PLAF_ADJUST_Y);
    private static String e = "Display Help Information";
    private static String h = BasicResourceManager.RESOURCE_URL_PREFIX;
    private final String b;
    private final String g;
    private final Locale d;
    private HelpDisplayDialog f = null;

    public HelpButton(String string) {
        this(string, null, null, HelpButton.getDefaultTooltip());
    }

    public HelpButton(String string, Locale locale) {
        this(string, locale, null, BasicLocalizationManager.getLocalizedString("displayHelp"));
    }

    public HelpButton(String string, Locale locale, String string2) {
        this(string, locale, string2, BasicLocalizationManager.getLocalizedString("displayHelp"));
    }

    public HelpButton(String string, Locale locale, String string2, String string3) {
        super(c);
        this.g = locale == null ? string + ".html" : string + HelpButton.a(locale) + ".html";
        this.d = locale;
        this.b = string2 == null ? "Help Information" : string2;
        this.a(string3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        HelpDisplayDialog helpDisplayDialog = null;
        Window window = SwingUtilities.windowForComponent(this);
        String string = HelpButton.getHelpFileUrlPrefix();
        URL uRL = null;
        try {
            uRL = string != null ? new URL(string + this.g) : new URL(this.g);
        }
        catch (Exception exception) {
            BasicApplicationManager.handleError(exception);
        }
        helpDisplayDialog = this.a();
        if (helpDisplayDialog == null) {
            helpDisplayDialog = this.createHelpDisplayDialog(window, this.d, this.b, uRL, true);
            helpDisplayDialog.addWindowListener(new b(this, null));
            this.a(helpDisplayDialog);
        } else {
            helpDisplayDialog.loadUrl(uRL);
            helpDisplayDialog.toFront();
        }
    }

    public static String getDefaultTooltip() {
        return e;
    }

    public static String getHelpFileUrlPrefix() {
        return h;
    }

    public Dimension getPreferredSize() {
        return i;
    }

    public static void setDefaultTooltip(String string) {
        e = string;
    }

    public static void setHelpFileUrlPrefix(String string) {
        h = string;
    }

    protected HelpDisplayDialog createHelpDisplayDialog(Window window, Locale locale, String string, URL uRL, boolean bl) {
        HelpDisplayDialog helpDisplayDialog = null;
        if (window instanceof Dialog) {
            helpDisplayDialog = new HelpDisplayDialog((Dialog)window, string, null, locale, null, false);
        } else if (window instanceof Frame) {
            helpDisplayDialog = new HelpDisplayDialog((Frame)window, string, null, locale, null, false);
        } else {
            String string2 = "The Help Dialog Owner window must be a Dialog or Frame.\nInvalid Parent Window: " + window;
            throw new IllegalArgumentException(string2);
        }
        helpDisplayDialog.loadUrl(uRL);
        if (bl) {
            helpDisplayDialog.setVisible(true);
        }
        return helpDisplayDialog;
    }

    private static String a(Locale locale) {
        String string = locale.getLanguage();
        String string2 = null;
        string2 = string.length() > 0 && !string.equals(Locale.ENGLISH.getLanguage()) ? "_" + string : "";
        return string2;
    }

    private HelpDisplayDialog a() {
        return this.f;
    }

    private void a(String string) {
        this.setToolTipText(string);
        this.setFocusable(false);
        this.addActionListener(this);
    }

    private void a(HelpDisplayDialog helpDisplayDialog) {
        this.f = helpDisplayDialog;
    }

    static void a(HelpButton helpButton, HelpDisplayDialog helpDisplayDialog) {
        helpButton.a(helpDisplayDialog);
    }
}

