/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.utility;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.lang.reflect.Array;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import jpdf_common.system.manage.ApplicationException;
import jpdf_common.system.manage.BasicApplicationManager;

public class UIUtility {
    static Class a;

    public static Point computePopupLocation(JPopupMenu jPopupMenu, MouseEvent mouseEvent, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        Point point = mouseEvent.getPoint();
        Point point2 = null;
        Dimension dimension = UIUtility.getScreenSize();
        Dimension dimension2 = jPopupMenu.getPreferredSize();
        Component component = (Component)mouseEvent.getSource();
        n4 = point.x + n2;
        n5 = point.y + n3;
        point2 = component.getLocationOnScreen();
        point2.translate(n4, n5);
        if (point2.x < 5) {
            n4 += 5 - point2.x;
        }
        if (point2.y < 5) {
            n5 += 5 - point2.y;
        }
        if (point2.x + dimension2.width + 5 > dimension.width) {
            n4 -= point2.x + dimension2.width + 5 - dimension.width;
        }
        if (point2.y + dimension2.height + 5 > dimension.height) {
            n5 -= point2.y + dimension2.height + 5 - dimension.height;
        }
        return new Point(n4, n5);
    }

    public static int computeRequiredHeight(Container container) {
        Component[] componentArray = container.getComponents();
        Rectangle rectangle = null;
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            rectangle = componentArray[i2].getBounds();
            n3 = rectangle.y + rectangle.height;
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2 + container.getInsets().bottom;
    }

    public static Container getAncestorInstanceOfClass(Component component, Class clazz) {
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        if (clazz.isInstance(container)) {
            return container;
        }
        return UIUtility.getAncestorInstanceOfClass(container, clazz);
    }

    public static Container getAncestorOfClass(Component component, Class clazz) {
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        if (clazz.equals(container.getClass())) {
            return container;
        }
        return UIUtility.getAncestorOfClass(container, clazz);
    }

    public static JScrollPane getAncestorScrollPane(Component component) {
        return (JScrollPane)UIUtility.getAncestorInstanceOfClass(component, a == null ? (a = UIUtility.class$("javax.swing.JScrollPane")) : a);
    }

    public static Cursor getDirectionalResizeCursor(int n2) {
        Cursor cursor = null;
        switch (n2) {
            case 1: {
                cursor = Cursor.getPredefinedCursor(8);
                break;
            }
            case 5: {
                cursor = Cursor.getPredefinedCursor(9);
                break;
            }
            case 3: {
                cursor = Cursor.getPredefinedCursor(11);
                break;
            }
            case 7: {
                cursor = Cursor.getPredefinedCursor(10);
                break;
            }
            case 2: {
                cursor = Cursor.getPredefinedCursor(7);
                break;
            }
            case 8: {
                cursor = Cursor.getPredefinedCursor(6);
                break;
            }
            case 4: {
                cursor = Cursor.getPredefinedCursor(5);
                break;
            }
            case 6: {
                cursor = Cursor.getPredefinedCursor(4);
                break;
            }
            default: {
                cursor = Cursor.getDefaultCursor();
            }
        }
        return cursor;
    }

    public static Object getMenuElement(JPopupMenu jPopupMenu, Class clazz) {
        Component[] componentArray = jPopupMenu.getComponents();
        Object object = null;
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (clazz.isInstance(componentArray[i2])) {
                object = componentArray[i2];
                break;
            }
            if (componentArray[i2] instanceof JMenu && (object = UIUtility.getMenuElement((JMenu)componentArray[i2], clazz)) != null) break;
        }
        return object;
    }

    public static Object getMenuElement(JMenu jMenu, Class clazz) {
        Component[] componentArray = jMenu.getMenuComponents();
        Object object = null;
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (clazz.isInstance(componentArray[i2])) {
                object = componentArray[i2];
                break;
            }
            if (componentArray[i2] instanceof JMenu && (object = UIUtility.getMenuElement((JMenu)componentArray[i2], clazz)) != null) break;
        }
        return object;
    }

    public static Container getOpaqueParentContainer(Component component) {
        Container container = null;
        for (Container container2 = component.getParent(); container2 != null; container2 = container2.getParent()) {
            if (!container2.isOpaque()) continue;
            container = container2;
            break;
        }
        return container;
    }

    public static JScrollPane getParentScrollPane(Component component) {
        Container container = component.getParent();
        if (container instanceof JViewport && (container = container.getParent()) instanceof JScrollPane) {
            return (JScrollPane)container;
        }
        return null;
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static char[] getUniqueMnemonicArray(String[] stringArray) {
        char[] cArray = new char[stringArray.length];
        char c2 = '?';
        int n2 = 0;
        boolean bl = false;
        block0: for (int i2 = 0; i2 < stringArray.length; ++i2) {
            cArray[i2] = 63;
            n2 = stringArray[i2].length();
            for (int i3 = 0; i3 < n2; ++i3) {
                c2 = stringArray[i2].charAt(i3);
                bl = false;
                for (int i4 = 0; i4 < i2; ++i4) {
                    if (cArray[i4] != c2) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                cArray[i2] = c2;
                continue block0;
            }
        }
        return cArray;
    }

    public static void maximizeInternalFrame(JInternalFrame jInternalFrame) {
        try {
            jInternalFrame.setMaximum(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            UIUtility.a(propertyVetoException, "Internal Frame maximization vetoed.");
        }
    }

    public static void minimizeInternalFrame(JInternalFrame jInternalFrame) {
        try {
            jInternalFrame.setMaximum(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            UIUtility.a(propertyVetoException, "Internal Frame minimization vetoed.");
        }
    }

    public static void refreshComponentDisplay(Component component) {
        Container container = null;
        if (component == null) {
            return;
        }
        container = component.getParent();
        if (container == null) {
            container = SwingUtilities.getWindowAncestor(component);
        }
        if (container != null) {
            component.invalidate();
            ((Component)container).validate();
            container.repaint();
        }
    }

    public static Object[] reorderForColumnarGrid(Object[] objectArray, int n2, int n3, Class clazz) {
        int n4;
        int n5;
        int n6 = 0;
        Object[][] objectArray2 = new Object[n2][n3];
        Object[] objectArray3 = null;
        try {
            objectArray3 = (Object[])Array.newInstance(clazz, n2 * n3);
        }
        catch (Exception exception) {
            return objectArray;
        }
        n6 = 0;
        for (n5 = 0; n5 < n3; ++n5) {
            for (n4 = 0; n4 < n2; ++n4) {
                objectArray2[n4][n5] = objectArray[n6];
                if (++n6 >= objectArray.length) break;
            }
            if (n6 >= objectArray.length) break;
        }
        n6 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n3; ++n4) {
                objectArray3[n6] = objectArray2[n5][n4];
                ++n6;
            }
        }
        return objectArray3;
    }

    public static void reorientSplitPane(JSplitPane jSplitPane, boolean bl) {
        Dimension dimension = null;
        double d2 = 0.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = n2 = bl ? 0 : 1;
        if (jSplitPane.getOrientation() != n2) {
            dimension = jSplitPane.getSize();
            d2 = (double)jSplitPane.getDividerLocation() / (double)(bl ? dimension.width : dimension.height);
            jSplitPane.setOrientation(n2);
            n3 = (int)(d2 * (double)(bl ? dimension.height : dimension.width));
            jSplitPane.setDividerLocation(n3);
        }
    }

    public static void restoreInternalFrameState(JInternalFrame jInternalFrame) {
        try {
            jInternalFrame.setIcon(false);
            jInternalFrame.setMaximum(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            UIUtility.a(propertyVetoException, "Internal Frame state restore vetoed.");
        }
    }

    public static void selectInternalFrame(JInternalFrame jInternalFrame, boolean bl) {
        try {
            jInternalFrame.setSelected(bl);
        }
        catch (PropertyVetoException propertyVetoException) {
            UIUtility.a(propertyVetoException, "Internal Frame selection vetoed.");
        }
    }

    public static void setFixedSize(JComponent jComponent, int n2, int n3) {
        UIUtility.setFixedSize(jComponent, new Dimension(n2, n3));
    }

    public static void setFixedSize(JComponent jComponent, Dimension dimension) {
        jComponent.setSize(dimension);
        jComponent.setMaximumSize(dimension);
        jComponent.setMinimumSize(dimension);
        jComponent.setPreferredSize(dimension);
    }

    public static void setFixedSizeMinimum(JComponent jComponent) {
        Dimension dimension = jComponent.getMinimumSize();
        jComponent.setSize(dimension);
        jComponent.setMaximumSize(dimension);
        jComponent.setPreferredSize(dimension);
    }

    public static void setFixedSizePreferred(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        jComponent.setSize(dimension);
        jComponent.setMaximumSize(dimension);
        jComponent.setMinimumSize(dimension);
    }

    public static void setInputEnabled(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        if (container instanceof JComponent) {
            ((JComponent)container).setEnabled(bl);
        }
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (componentArray[i2] instanceof JPanel || componentArray[i2] instanceof Box) {
                UIUtility.setInputEnabled((Container)componentArray[i2], bl);
                continue;
            }
            if (!(componentArray[i2] instanceof JComponent)) continue;
            ((JComponent)componentArray[i2]).setEnabled(bl);
        }
    }

    private static void a(PropertyVetoException propertyVetoException, String string) {
        BasicApplicationManager.handleError(ApplicationException.createWarning(propertyVetoException, string), false);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

