/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import jpdf_common.gui.component.button.AbstractArrowButton;
import jpdf_common.gui.component.popup.AbstractComboPopupPanel;
import jpdf_common.gui.component.popupmenu.PopupMenuButton;
import jpdf_common.gui.component.spinner.UneditableSpinner;
import jpdf_common.gui.component.table.TableCellRendererWrapper;
import jpdf_common.gui.plaf.DefaultPlafPainter;
import jpdf_common.gui.plaf.MetalPlafPainter;
import jpdf_common.gui.plaf.MotifPlafPainter;
import jpdf_common.gui.plaf.OceanPlafPainter;
import jpdf_common.gui.plaf.WindowsPlafPainter;
import jpdf_common.gui.plaf.WindowsXpPlafPainter;

public abstract class PlafPainter {
    public static final Color CONTROL_COLOR;
    public static final Color CONTROL_SHADOW_COLOR;
    public static final Color CONTROL_DARK_SHADOW_COLOR;
    public static final Color CONTROL_HIGHLIGHT_COLOR;
    public static final Color CONTROL_LIGHT_HIGHLIGHT_COLOR;
    public static final Color CONTROL_TEXT_COLOR;
    public static final Color SELECTION_BACKGROUND_COLOR;
    public static final Color SELECTION_FOREGROUND_COLOR;
    private static PlafPainter k;
    protected final Color FOCUS_COLOR;
    static Class g;
    static Class e;
    static Class d;

    protected PlafPainter() {
        this("Button.focus");
    }

    protected PlafPainter(String string) {
        this.FOCUS_COLOR = UIManager.getColor(string);
    }

    public Icon buildButtonDownArrowIcon() {
        return new ButtonDownArrowIcon(this, this.getStandardArrowHeight());
    }

    public Icon buildButtonDownArrowIcon(int n2) {
        return new ButtonDownArrowIcon(this, n2);
    }

    public JButton buildComboPopupButton() {
        return new DefaultComboPopupButton(this);
    }

    public TableCellRendererWrapper buildHeaderCellRendererWrapper(JTable jTable) {
        return new TableCellRendererWrapper(jTable);
    }

    public void customizeComponent(AbstractArrowButton abstractArrowButton) {
    }

    public void customizeComponent(AbstractComboPopupPanel abstractComboPopupPanel) {
    }

    public void customizeComponent(PopupMenuButton popupMenuButton) {
        Insets insets = popupMenuButton.getMargin();
        int n2 = 0;
        insets.bottom = insets.right = (n2 = insets.top > insets.left ? insets.left : insets.top);
        insets.top = insets.right;
        insets.left = n2 + 4;
        popupMenuButton.setMargin(insets);
        popupMenuButton.setIconTextGap(6);
    }

    public void customizeComponent(UneditableSpinner uneditableSpinner) {
    }

    public Font getDefaultLabelFont() {
        Font font = UIManager.getFont("Label.font");
        if (font == null) {
            font = new JLabel().getFont();
        }
        return font;
    }

    public Color getDefaultTextFieldBackground() {
        Color color = UIManager.getColor("TextField.background");
        if (color == null) {
            color = new JTextField().getBackground();
        }
        return color;
    }

    public String getName() {
        return UIManager.getLookAndFeel().getName();
    }

    public static PlafPainter getPlafPainter() {
        if (k == null) {
            k = PlafPainter.d();
        }
        return k;
    }

    public boolean isButtonRolloverAnimated() {
        return false;
    }

    public static boolean isUsingGtkLookAndFeel() {
        return UIManager.getLookAndFeel().getName().indexOf("GTK") >= 0;
    }

    public static boolean isUsingSynthLookAndFeel() {
        return UIManager.getLookAndFeel().getName().indexOf("Synth") >= 0;
    }

    public abstract void paintButtonDownArrow(Graphics var1, AbstractButton var2);

    public abstract void paintButtonDownArrow(Graphics var1, AbstractButton var2, int var3, int var4, int var5);

    public abstract void paintButtonLeftArrow(Graphics var1, AbstractButton var2);

    public abstract void paintButtonRightArrow(Graphics var1, AbstractButton var2);

    public abstract void paintButtonUpArrow(Graphics var1, AbstractButton var2);

    public void paintComboButtonArrow(Graphics graphics, AbstractButton abstractButton) {
        this.paintButtonDownArrow(graphics, abstractButton);
    }

    public abstract void paintFocusRectangle(Graphics var1, AbstractArrowButton var2);

    public void paintFocusRectangle(Graphics graphics, AbstractComboPopupPanel abstractComboPopupPanel) {
    }

    public void paintFocusRectangle(Graphics graphics, UneditableSpinner uneditableSpinner) {
    }

    public void paintFocusRectangle(Graphics graphics, JComponent jComponent) {
        this.paintFocusRectangle(graphics, jComponent, 0, 0, 1, 1);
    }

    public abstract void paintFocusRectangle(Graphics var1, JComponent var2, int var3, int var4, int var5, int var6);

    public void prepareToPaint(Graphics graphics, AbstractComboPopupPanel abstractComboPopupPanel) {
        AbstractComboPopupPanel.SelectedValuePanel selectedValuePanel = abstractComboPopupPanel.getSelectedValuePanel();
        JComponent jComponent = (JComponent)selectedValuePanel.getComponent(0);
        boolean bl = selectedValuePanel.isFocusOwner() && !abstractComboPopupPanel.isPopupVisible();
        this.prepareToPaintSelectionComponent(abstractComboPopupPanel, jComponent, bl);
    }

    public void prepareToPaint(Graphics graphics, UneditableSpinner uneditableSpinner) {
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)uneditableSpinner.getEditor()).getTextField();
        this.prepareToPaintSelectionComponent(uneditableSpinner, jFormattedTextField, jFormattedTextField.isFocusOwner());
    }

    public void prepareToPrint(JCheckBox jCheckBox) {
    }

    public void prepareToPrint(JTable jTable) {
    }

    public void prepareToPrint(JTree jTree) {
    }

    public static void setPlafPainter(PlafPainter plafPainter) {
        if (k != null) {
            throw new IllegalStateException("The Plaf Painter has already been set.  It cannot be set again.");
        }
        k = plafPainter;
    }

    protected int getStandardArrowHeight() {
        return 5;
    }

    protected void prepareToPaintSelectionComponent(JComponent jComponent, JComponent jComponent2, boolean bl) {
        if (bl) {
            jComponent2.setBackground(SELECTION_BACKGROUND_COLOR);
            jComponent2.setForeground(SELECTION_FOREGROUND_COLOR);
        } else {
            jComponent2.setBackground(jComponent.getBackground());
            jComponent2.setForeground(jComponent.getForeground());
        }
    }

    private static PlafPainter d() {
        PlafPainter plafPainter = null;
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        Class<?> clazz = null;
        if (lookAndFeel != null) {
            clazz = lookAndFeel.getClass();
        }
        plafPainter = clazz == (g == null ? (g = PlafPainter.class$("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) : g) ? new MotifPlafPainter() : (clazz == (e == null ? (e = PlafPainter.class$("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) : e) ? (WindowsPlafPainter.isUsingXpStyle() ? new WindowsXpPlafPainter() : new WindowsPlafPainter()) : (clazz == (d == null ? (d = PlafPainter.class$("javax.swing.plaf.metal.MetalLookAndFeel")) : d) ? (MetalPlafPainter.isUsingOceanTheme() ? new OceanPlafPainter() : new MetalPlafPainter()) : new DefaultPlafPainter()));
        return plafPainter;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        k = null;
        Color color = null;
        if (PlafPainter.isUsingGtkLookAndFeel()) {
            CONTROL_COLOR = UIManager.getColor("control");
            CONTROL_SHADOW_COLOR = new ColorUIResource(CONTROL_COLOR.darker());
            CONTROL_DARK_SHADOW_COLOR = new ColorUIResource(CONTROL_SHADOW_COLOR.darker());
            CONTROL_HIGHLIGHT_COLOR = new ColorUIResource(222, 222, 222);
            CONTROL_LIGHT_HIGHLIGHT_COLOR = new ColorUIResource(Color.WHITE);
            CONTROL_TEXT_COLOR = new ColorUIResource(Color.BLACK);
            SELECTION_BACKGROUND_COLOR = new ColorUIResource(164, 223, 255);
            SELECTION_FOREGROUND_COLOR = CONTROL_TEXT_COLOR;
        } else if (PlafPainter.isUsingSynthLookAndFeel()) {
            color = UIManager.getColor("control");
            CONTROL_COLOR = color != null ? color : new ColorUIResource(111, 111, 111);
            color = UIManager.getColor("controlShadow");
            CONTROL_SHADOW_COLOR = color != null ? color : new ColorUIResource(CONTROL_COLOR.darker());
            color = UIManager.getColor("controlDkShadow");
            CONTROL_DARK_SHADOW_COLOR = color != null ? color : new ColorUIResource(CONTROL_SHADOW_COLOR.darker());
            color = UIManager.getColor("controlHighlight");
            CONTROL_HIGHLIGHT_COLOR = color != null ? color : new ColorUIResource(222, 222, 222);
            color = UIManager.getColor("controlLtHighlight");
            CONTROL_LIGHT_HIGHLIGHT_COLOR = color != null ? color : new ColorUIResource(Color.WHITE);
            color = UIManager.getColor("controlText");
            CONTROL_TEXT_COLOR = color != null ? color : new ColorUIResource(Color.BLACK);
            color = UIManager.getColor("ComboBox.selectionBackground");
            SELECTION_BACKGROUND_COLOR = color != null ? color : new ColorUIResource(164, 223, 255);
            color = UIManager.getColor("ComboBox.selectionForeground");
            SELECTION_FOREGROUND_COLOR = color != null ? color : CONTROL_TEXT_COLOR;
        } else {
            CONTROL_COLOR = UIManager.getColor("control");
            CONTROL_SHADOW_COLOR = UIManager.getColor("controlShadow");
            CONTROL_DARK_SHADOW_COLOR = UIManager.getColor("controlDkShadow");
            CONTROL_HIGHLIGHT_COLOR = UIManager.getColor("controlHighlight");
            CONTROL_LIGHT_HIGHLIGHT_COLOR = UIManager.getColor("controlLtHighlight");
            CONTROL_TEXT_COLOR = UIManager.getColor("controlText");
            SELECTION_BACKGROUND_COLOR = UIManager.getColor("ComboBox.selectionBackground");
            SELECTION_FOREGROUND_COLOR = UIManager.getColor("ComboBox.selectionForeground");
        }
    }

    public class ButtonDownArrowIcon
    implements Icon {
        protected final int ARROW_HEIGHT;
        private final PlafPainter a;

        public ButtonDownArrowIcon(PlafPainter plafPainter, int n2) {
            this.a = plafPainter;
            this.ARROW_HEIGHT = n2;
        }

        public int getIconHeight() {
            return this.ARROW_HEIGHT;
        }

        public int getIconWidth() {
            return this.ARROW_HEIGHT * 2;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            this.a.paintButtonDownArrow(graphics, (AbstractButton)component, this.ARROW_HEIGHT, n2, n3);
        }
    }

    public class DefaultComboPopupButton
    extends AbstractArrowButton {
        private final PlafPainter a;

        public DefaultComboPopupButton(PlafPainter plafPainter) {
            this.a = plafPainter;
            super(true);
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
            this.setFocusTraversalKeysEnabled(false);
        }

        protected void paintArrow(Graphics graphics) {
            this.a.paintComboButtonArrow(graphics, this);
        }
    }
}

