/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.plaf;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import jpdf_common.gui.component.button.AbstractArrowButton;
import jpdf_common.gui.component.popup.AbstractComboPopupPanel;
import jpdf_common.gui.component.popupmenu.PopupMenuButton;
import jpdf_common.gui.component.spinner.UneditableSpinner;
import jpdf_common.gui.plaf.ArrowDrawer;
import jpdf_common.gui.plaf.PlafPainter;

public class MotifPlafPainter
extends PlafPainter {
    protected MotifPlafPainter() {
        super("activeCaptionBorder");
    }

    public Icon buildButtonDownArrowIcon() {
        return new MotifButtonDownArrowIcon(this, this.getStandardArrowHeight());
    }

    public Icon buildButtonDownArrowIcon(int n2) {
        return new MotifButtonDownArrowIcon(this, n2);
    }

    public void customizeComponent(AbstractArrowButton abstractArrowButton) {
        abstractArrowButton.setArmedBorder(null);
        abstractArrowButton.setUnarmedBorder(null);
    }

    public void customizeComponent(PopupMenuButton popupMenuButton) {
        Insets insets = popupMenuButton.getMargin();
        int n2 = 0;
        insets.bottom = insets.right = (n2 = insets.top > insets.left ? insets.left : insets.top);
        insets.top = insets.right;
        insets.left = n2 + 4;
        popupMenuButton.setMargin(insets);
        popupMenuButton.setIconTextGap(8);
    }

    public void paintButtonDownArrow(Graphics graphics, AbstractButton abstractButton) {
        Color color = null;
        Color color2 = null;
        int n2 = abstractButton.getWidth() / 2 - 1;
        int n3 = abstractButton.getHeight() / 2 - 5;
        if (abstractButton.getModel().isPressed()) {
            color = CONTROL_SHADOW_COLOR;
            color2 = CONTROL_LIGHT_HIGHLIGHT_COLOR;
        } else {
            color = CONTROL_LIGHT_HIGHLIGHT_COLOR;
            color2 = CONTROL_SHADOW_COLOR;
        }
        graphics.translate(n2, n3);
        ArrowDrawer.drawDownTricolorTriangle(graphics, color, color2, 5);
        graphics.translate(-n2, -n3);
    }

    public void paintButtonDownArrow(Graphics graphics, AbstractButton abstractButton, int n2, int n3, int n4) {
        Color color = null;
        Color color2 = null;
        int n5 = (n2 + 1) / 2;
        if (abstractButton.getModel().isPressed()) {
            color = CONTROL_SHADOW_COLOR;
            color2 = CONTROL_LIGHT_HIGHLIGHT_COLOR;
        } else {
            color = CONTROL_LIGHT_HIGHLIGHT_COLOR;
            color2 = CONTROL_SHADOW_COLOR;
        }
        graphics.translate(n3, n4);
        ArrowDrawer.drawDownTricolorTriangle(graphics, color, color2, n5);
        graphics.translate(-n3, -n4);
    }

    public void paintButtonLeftArrow(Graphics graphics, AbstractButton abstractButton) {
        Color color = null;
        Color color2 = null;
        int n2 = abstractButton.getWidth() / 2 + 5;
        int n3 = abstractButton.getHeight() / 2 - 2;
        if (abstractButton.getModel().isPressed()) {
            color = CONTROL_SHADOW_COLOR;
            color2 = CONTROL_LIGHT_HIGHLIGHT_COLOR;
        } else {
            color = CONTROL_LIGHT_HIGHLIGHT_COLOR;
            color2 = CONTROL_SHADOW_COLOR;
        }
        graphics.translate(n2, n3);
        ArrowDrawer.drawLeftTricolorTriangle(graphics, color, color2, 5);
        graphics.translate(-n2, -n3);
    }

    public void paintButtonRightArrow(Graphics graphics, AbstractButton abstractButton) {
        Color color = null;
        Color color2 = null;
        int n2 = abstractButton.getWidth() / 2 - 5;
        int n3 = abstractButton.getHeight() / 2 - 2;
        if (abstractButton.getModel().isPressed()) {
            color = CONTROL_SHADOW_COLOR;
            color2 = CONTROL_LIGHT_HIGHLIGHT_COLOR;
        } else {
            color = CONTROL_LIGHT_HIGHLIGHT_COLOR;
            color2 = CONTROL_SHADOW_COLOR;
        }
        graphics.translate(n2, n3);
        ArrowDrawer.drawRightTricolorTriangle(graphics, color, color2, 5);
        graphics.translate(-n2, -n3);
    }

    public void paintButtonUpArrow(Graphics graphics, AbstractButton abstractButton) {
        Color color = null;
        Color color2 = null;
        int n2 = abstractButton.getWidth() / 2 - 1;
        int n3 = abstractButton.getHeight() / 2 + 5;
        if (abstractButton.getModel().isPressed()) {
            color = CONTROL_SHADOW_COLOR;
            color2 = CONTROL_LIGHT_HIGHLIGHT_COLOR;
        } else {
            color = CONTROL_LIGHT_HIGHLIGHT_COLOR;
            color2 = CONTROL_SHADOW_COLOR;
        }
        graphics.translate(n2, n3);
        ArrowDrawer.drawUpTricolorTriangle(graphics, color, color2, 5);
        graphics.translate(-n2, -n3);
    }

    public void paintFocusRectangle(Graphics graphics, AbstractArrowButton abstractArrowButton) {
        this.paintFocusRectangle(graphics, abstractArrowButton, 0, 0, 1, 1);
    }

    public void paintFocusRectangle(Graphics graphics, AbstractComboPopupPanel abstractComboPopupPanel) {
        this.paintFocusRectangle(graphics, abstractComboPopupPanel, 0, 0, 1, 1);
    }

    public void paintFocusRectangle(Graphics graphics, JComponent jComponent, int n2, int n3, int n4, int n5) {
        graphics.setColor(this.FOCUS_COLOR);
        graphics.drawRect(n3, n2, jComponent.getWidth() - (n3 + n5), jComponent.getHeight() - (n2 + n4));
    }

    public void paintFocusRectangle(Graphics graphics, UneditableSpinner uneditableSpinner) {
        this.paintFocusRectangle(graphics, uneditableSpinner, 0, 0, 1, 1);
    }

    public void prepareToPaint(Graphics graphics, AbstractComboPopupPanel abstractComboPopupPanel) {
    }

    public void prepareToPaint(Graphics graphics, UneditableSpinner uneditableSpinner) {
    }

    protected int getStandardArrowHeight() {
        return 10;
    }

    public class MotifButtonDownArrowIcon
    extends PlafPainter.ButtonDownArrowIcon {
        private final MotifPlafPainter this$0;

        public MotifButtonDownArrowIcon(MotifPlafPainter motifPlafPainter, int n2) {
            this.this$0 = motifPlafPainter;
            super(motifPlafPainter, n2);
        }

        public int getIconWidth() {
            return this.ARROW_HEIGHT;
        }
    }
}

