/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import jpdf.wrap.ReplaceIconsTreeCellRendererWrapper;
import jpdf_common.gui.component.button.AbstractArrowButton;
import jpdf_common.gui.component.popup.AbstractComboPopupPanel;
import jpdf_common.gui.component.spinner.UneditableSpinner;
import jpdf_common.gui.plaf.ArrowDrawer;
import jpdf_common.gui.plaf.PlafPainter;
import jpdf_common.gui.plaf.b;
import jpdf_common.gui.plaf.e;
import jpdf_common.gui.plaf.g;
import jpdf_common.gui.plaf.n;

public class MetalPlafPainter
extends PlafPainter {
    public static final Color PRIMARY_CONTROL_SHADOW_COLOR = MetalLookAndFeel.getPrimaryControlShadow();
    public static final Color PRIMARY_CONTROL_INFO_COLOR = MetalLookAndFeel.getPrimaryControlInfo();
    public static final Color PRIMARY_CONTROL_DARK_SHADOW_COLOR = MetalLookAndFeel.getPrimaryControlDarkShadow();
    public static final Color PRIMARY_CONTROL_HIGHLIGHT_COLOR = MetalLookAndFeel.getPrimaryControlHighlight();
    public static final Color PRIMARY_CONTROL_COLOR = MetalLookAndFeel.getPrimaryControl();
    private static final Border a = new StandardBorder();
    static Class f;
    static Class c;
    static Class b;

    protected MetalPlafPainter() {
    }

    public void customizeComponent(AbstractComboPopupPanel abstractComboPopupPanel) {
        AbstractArrowButton abstractArrowButton = (AbstractArrowButton)abstractComboPopupPanel.getPopupButton();
        abstractArrowButton.setArmedBorder(null);
        abstractArrowButton.setUnarmedBorder(null);
        abstractComboPopupPanel.setBorder(a);
    }

    public void customizeComponent(UneditableSpinner uneditableSpinner) {
        JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)uneditableSpinner.getEditor();
        JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
        Dimension dimension = jFormattedTextField.getPreferredSize();
        defaultEditor.setLayout(new FlowLayout(1, 2, 3));
        dimension.height -= 4;
        dimension.width -= 4;
        jFormattedTextField.setPreferredSize(dimension);
    }

    public String getName() {
        return "Steel";
    }

    public static boolean isUsingOceanTheme() {
        Icon icon = UIManager.getIcon("InternalFrame.closeIcon");
        boolean bl = false;
        if (icon != null) {
            bl = icon.getClass().getName().indexOf("Ocean") >= 0;
        }
        return bl;
    }

    public void paintButtonDownArrow(Graphics graphics, AbstractButton abstractButton) {
        Color color = abstractButton.isEnabled() ? Color.BLACK : CONTROL_SHADOW_COLOR;
        int n2 = this.computeArrowHeight(abstractButton.getWidth(), abstractButton.getHeight());
        ArrowDrawer.drawBasicDownArrow(graphics, abstractButton, color, n2);
    }

    public void paintButtonDownArrow(Graphics graphics, AbstractButton abstractButton, int n2, int n3, int n4) {
        Color color;
        Color color2 = color = abstractButton.isEnabled() ? Color.BLACK : CONTROL_SHADOW_COLOR;
        if (n2 < 2) {
            n2 = this.computeArrowHeight(abstractButton.getWidth(), abstractButton.getHeight());
        }
        ArrowDrawer.drawBasicDownArrow(graphics, color, n2, n3, n4);
    }

    public void paintButtonLeftArrow(Graphics graphics, AbstractButton abstractButton) {
        Color color = abstractButton.isEnabled() ? Color.BLACK : CONTROL_SHADOW_COLOR;
        int n2 = this.computeArrowHeight(abstractButton.getWidth(), abstractButton.getHeight());
        ArrowDrawer.drawBasicLeftArrow(graphics, abstractButton, color, n2);
    }

    public void paintButtonRightArrow(Graphics graphics, AbstractButton abstractButton) {
        Color color = abstractButton.isEnabled() ? Color.BLACK : CONTROL_SHADOW_COLOR;
        int n2 = this.computeArrowHeight(abstractButton.getWidth(), abstractButton.getHeight());
        ArrowDrawer.drawBasicRightArrow(graphics, abstractButton, color, n2);
    }

    public void paintButtonUpArrow(Graphics graphics, AbstractButton abstractButton) {
        Color color = abstractButton.isEnabled() ? Color.BLACK : CONTROL_SHADOW_COLOR;
        int n2 = 0;
        n2 = Math.min((abstractButton.getHeight() - 4) / 3, (abstractButton.getWidth() - 4) / 3);
        if (n2 < 2) {
            n2 = 2;
        }
        ArrowDrawer.drawBasicDownArrow(graphics, abstractButton, color, n2);
    }

    public void paintComboButtonArrow(Graphics graphics, AbstractButton abstractButton) {
        Color color = abstractButton.isEnabled() ? Color.BLACK : CONTROL_SHADOW_COLOR;
        ArrowDrawer.drawBasicDownArrow(graphics, abstractButton, color, 5);
    }

    public void paintFocusRectangle(Graphics graphics, AbstractArrowButton abstractArrowButton) {
        this.paintFocusRectangle(graphics, abstractArrowButton, 3, 2, 4, 4);
    }

    public void paintFocusRectangle(Graphics graphics, AbstractComboPopupPanel abstractComboPopupPanel) {
        AbstractArrowButton abstractArrowButton = (AbstractArrowButton)abstractComboPopupPanel.getPopupButton();
        int n2 = abstractArrowButton.getX();
        int n3 = abstractArrowButton.getY();
        graphics.translate(n2, n3);
        this.paintFocusRectangle(graphics, abstractArrowButton, 2, 0, 3, 3);
        graphics.translate(-n2, -n3);
    }

    public void paintFocusRectangle(Graphics graphics, JComponent jComponent, int n2, int n3, int n4, int n5) {
        graphics.setColor(this.FOCUS_COLOR);
        graphics.drawRect(n3, n2, jComponent.getWidth() - (n3 + n5), jComponent.getHeight() - (n2 + n4));
    }

    public void paintFocusRectangle(Graphics graphics, UneditableSpinner uneditableSpinner) {
        JComponent jComponent = uneditableSpinner.getEditor();
        this.paintFocusRectangle(graphics, uneditableSpinner, 3, 3, 4, uneditableSpinner.getWidth() - jComponent.getWidth());
    }

    public void prepareToPaint(Graphics graphics, AbstractComboPopupPanel abstractComboPopupPanel) {
    }

    public void prepareToPaint(Graphics graphics, UneditableSpinner uneditableSpinner) {
    }

    public void prepareToPrint(JTree jTree) {
        DefaultTreeCellRenderer defaultTreeCellRenderer = null;
        TreeCellRenderer treeCellRenderer = jTree.getCellRenderer();
        BasicTreeUI basicTreeUI = (BasicTreeUI)jTree.getUI();
        e e2 = null;
        e e3 = null;
        e e4 = null;
        n n2 = null;
        Icon icon = null;
        boolean bl = false;
        if (MetalPlafPainter.isUsingOceanTheme()) {
            return;
        }
        icon = basicTreeUI.getExpandedIcon();
        if (icon != null && icon.getClass() == (f == null ? (f = MetalPlafPainter.class$("javax.swing.plaf.metal.MetalIconFactory$TreeControlIcon")) : f)) {
            basicTreeUI.setExpandedIcon(new b());
        }
        if ((icon = basicTreeUI.getCollapsedIcon()) != null && icon.getClass() == (f == null ? (f = MetalPlafPainter.class$("javax.swing.plaf.metal.MetalIconFactory$TreeControlIcon")) : f)) {
            basicTreeUI.setCollapsedIcon(new g());
        }
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
            e2 = new e(null);
            icon = defaultTreeCellRenderer.getLeafIcon();
            if (icon != null && icon.getClass() == (c == null ? (c = MetalPlafPainter.class$("javax.swing.plaf.metal.MetalIconFactory$TreeLeafIcon")) : c)) {
                n2 = new n(null);
                bl = true;
            }
            if ((icon = defaultTreeCellRenderer.getOpenIcon()) != null && icon.getClass() == (b == null ? (b = MetalPlafPainter.class$("javax.swing.plaf.metal.MetalIconFactory$TreeFolderIcon")) : b)) {
                e3 = e2;
                bl = true;
            }
            if ((icon = defaultTreeCellRenderer.getClosedIcon()) != null && icon.getClass() == (b == null ? (b = MetalPlafPainter.class$("javax.swing.plaf.metal.MetalIconFactory$TreeFolderIcon")) : b)) {
                e4 = e2;
                bl = true;
            }
            if (bl) {
                jTree.setCellRenderer(new ReplaceIconsTreeCellRendererWrapper(defaultTreeCellRenderer, n2, e3, e4));
            }
        }
    }

    protected int computeArrowHeight(int n2, int n3) {
        int n4 = 0;
        n4 = (Math.min(n2, n3) - 4) / 3;
        if (n4 < 2) {
            n4 = 2;
        }
        return n4;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public static class StandardBorder
    extends AbstractBorder {
        private final Insets a = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            int n6 = n4 - 2;
            int n7 = n5 - 2;
            graphics.translate(n2, n3);
            if (component.isEnabled()) {
                graphics.setColor(PlafPainter.CONTROL_DARK_SHADOW_COLOR);
                graphics.drawRect(0, 0, n6, n7);
                graphics.setColor(PlafPainter.CONTROL_HIGHLIGHT_COLOR);
                graphics.drawRect(1, 1, n6, n7);
                graphics.setColor(PlafPainter.CONTROL_COLOR);
                graphics.drawLine(0, n5 - 1, 1, n7);
                graphics.drawLine(n4 - 1, 0, n6, 1);
            } else {
                graphics.setColor(PlafPainter.CONTROL_SHADOW_COLOR);
                graphics.drawRect(0, 0, n6, n7);
            }
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return this.a;
        }
    }
}

