/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;
import jpdf_common.gui.layout.ConstraintLayoutManager;

public class TripletLayout
implements ConstraintLayoutManager,
Serializable {
    public static final String LEFT = "Left";
    public static final String CENTER = "Center";
    public static final String RIGHT = "Right";
    private static final long serialVersionUID = 120L;
    private Component d = null;
    private Component a = null;
    private Component c = null;
    private int b = 0;

    public TripletLayout() {
        this(0);
    }

    public TripletLayout(int n2) {
        this.setHorizontalGap(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(String string, Component component) {
        String string2 = null;
        Object object = component.getTreeLock();
        synchronized (object) {
            if (string == null) {
                string = CENTER;
            }
            if (string.equals(CENTER)) {
                this.a = component;
            } else if (string.equals(LEFT)) {
                this.d = component;
            } else if (string.equals(RIGHT)) {
                this.c = component;
            } else {
                string2 = "Cannot add to layout - Unknown Constraint: " + string;
                throw new IllegalArgumentException(string2);
            }
        }
    }

    public Object getConstraints(Component component) {
        if (component == this.d) {
            return LEFT;
        }
        if (component == this.a) {
            return CENTER;
        }
        if (component == this.c) {
            return RIGHT;
        }
        return null;
    }

    public int getHorizontalGap() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = container.getSize();
            Dimension dimension2 = null;
            Component component = null;
            Insets insets = container.getInsets();
            int n2 = insets.top;
            int n3 = dimension.height - insets.bottom;
            int n4 = insets.left;
            int n5 = dimension.width - insets.right;
            int n6 = this.getHorizontalGap();
            int n7 = 0;
            int n8 = n3 - n2;
            component = this.a(RIGHT);
            if (component != null) {
                dimension2 = component.getPreferredSize();
                n7 = (n8 - dimension2.height) / 2;
                component.setBounds(n5 - dimension2.width, n2 + n7, dimension2.width, dimension2.height);
                n5 -= dimension2.width + n6;
            }
            if ((component = this.a(LEFT)) != null) {
                dimension2 = component.getPreferredSize();
                n7 = (n8 - dimension2.height) / 2;
                component.setBounds(n4, n2 + n7, dimension2.width, dimension2.height);
                n4 += dimension2.width + n6;
            }
            if ((component = this.a(CENTER)) != null) {
                dimension2 = component.getPreferredSize();
                n7 = (n8 - dimension2.height) / 2;
                component.setBounds(n4, n2 + n7, n5 - n4, dimension2.height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            Dimension dimension2 = null;
            Component component = null;
            Insets insets = container.getInsets();
            int n2 = this.getHorizontalGap();
            component = this.a(RIGHT);
            if (component != null) {
                dimension2 = component.getMinimumSize();
                dimension.width += dimension2.width + n2;
                dimension.height = Math.max(dimension2.height, dimension.height);
            }
            if ((component = this.a(LEFT)) != null) {
                dimension2 = component.getMinimumSize();
                dimension.width += dimension2.width + n2;
                dimension.height = Math.max(dimension2.height, dimension.height);
            }
            if ((component = this.a(CENTER)) != null) {
                dimension2 = component.getMinimumSize();
                dimension.width += dimension2.width;
                dimension.height = Math.max(dimension2.height, dimension.height);
            }
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            Dimension dimension2 = null;
            Component component = null;
            Insets insets = container.getInsets();
            int n2 = this.getHorizontalGap();
            component = this.a(RIGHT);
            if (component != null) {
                dimension2 = component.getPreferredSize();
                dimension.width += dimension2.width + n2;
                dimension.height = Math.max(dimension2.height, dimension.height);
            }
            if ((component = this.a(LEFT)) != null) {
                dimension2 = component.getPreferredSize();
                dimension.width += dimension2.width + n2;
                dimension.height = Math.max(dimension2.height, dimension.height);
            }
            if ((component = this.a(CENTER)) != null) {
                dimension2 = component.getPreferredSize();
                dimension.width += dimension2.width;
                dimension.height = Math.max(dimension2.height, dimension.height);
            }
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (component == this.a) {
                this.a = null;
            } else if (component == this.d) {
                this.d = null;
            } else if (component == this.c) {
                this.c = null;
            }
        }
    }

    public void setHorizontalGap(int n2) {
        this.b = n2;
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.b + "]";
    }

    private Component a(String string) {
        Component component = null;
        if (string == LEFT) {
            component = this.d;
        } else if (string == CENTER) {
            component = this.a;
        } else if (string == RIGHT) {
            component = this.c;
        }
        if (component != null && !component.isVisible()) {
            component = null;
        }
        return component;
    }
}

