/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import jpdf_common.gui.layout.AbstractLayoutManager;

public class RowLayout
extends AbstractLayoutManager {
    private int a = 0;
    private int c = 0;
    private int b = 0;

    public RowLayout() {
        this(0, 0, 0);
    }

    public RowLayout(int n2) {
        this(n2, 0, 0);
    }

    public RowLayout(int n2, int n3) {
        this(n2, 0, n3);
    }

    public RowLayout(int n2, int n3, int n4) {
        this.setHorizontalGap(n4);
        this.setHorizontalAlignment(n2);
        this.setVerticalAlignment(n3);
    }

    public int getHorizontalAlignment() {
        return this.a;
    }

    public int getHorizontalGap() {
        return this.b;
    }

    public int getVerticalAlignment() {
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] componentArray = container.getComponents();
            Dimension dimension = null;
            Insets insets = container.getInsets();
            int n2 = container.getHeight() - (insets.top + insets.bottom);
            int n3 = container.getWidth() - (insets.left + insets.right);
            int n4 = 0;
            int n5 = 0;
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (!componentArray[i2].isVisible()) continue;
                dimension = componentArray[i2].getPreferredSize();
                if (dimension.height == 0) {
                    componentArray[i2].setSize(dimension.width, n2);
                } else {
                    componentArray[i2].setSize(dimension.width, dimension.height);
                }
                if (n4 > 0) {
                    n4 += this.b;
                }
                n4 += dimension.width;
                n5 = Math.max(n5, dimension.height);
            }
            this.moveComponents(componentArray, insets, n3, n3 - n4, n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] componentArray = container.getComponents();
            Dimension dimension = new Dimension(0, 0);
            Dimension dimension2 = null;
            Insets insets = container.getInsets();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (!componentArray[i2].isVisible()) continue;
                dimension2 = componentArray[i2].getMinimumSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                if (dimension.width > 0) {
                    dimension.width += this.b;
                }
                dimension.width += dimension2.width;
            }
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] componentArray = container.getComponents();
            Dimension dimension = new Dimension(0, 0);
            Dimension dimension2 = null;
            Insets insets = container.getInsets();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (!componentArray[i2].isVisible()) continue;
                dimension2 = componentArray[i2].getPreferredSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                if (dimension.width > 0) {
                    dimension.width += this.b;
                }
                dimension.width += dimension2.width;
            }
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
    }

    public void setHorizontalAlignment(int n2) {
        this.a = n2;
    }

    public void setHorizontalGap(int n2) {
        this.b = n2;
    }

    public void setVerticalAlignment(int n2) {
        this.c = n2;
    }

    public String toString() {
        String string = null;
        switch (this.getHorizontalAlignment()) {
            case 2: {
                string = ",halign=left";
                break;
            }
            case 0: {
                string = ",halign=center";
                break;
            }
            case 4: {
                string = ",halign=right";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.getHorizontalGap() + string + "]";
    }

    protected void moveComponents(Component[] componentArray, Insets insets, int n2, int n3, int n4) {
        Object var6_6 = null;
        Dimension dimension = new Dimension();
        int n5 = this.getVerticalAlignment();
        int n6 = insets.left;
        int n7 = insets.top;
        int n8 = 0;
        int n9 = 0;
        switch (this.getHorizontalAlignment()) {
            case 2: {
                n8 = n6;
                break;
            }
            case 0: {
                n8 = n6 + n3 / 2;
                break;
            }
            case 4: {
                n8 = n6 + n3;
            }
        }
        if (n5 == 1) {
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (!componentArray[i2].isVisible()) continue;
                componentArray[i2].getSize(dimension);
                componentArray[i2].setLocation(n8, n7);
                n8 += dimension.width + this.b;
            }
        } else if (n5 == 3) {
            for (int i3 = 0; i3 < componentArray.length; ++i3) {
                if (!componentArray[i3].isVisible()) continue;
                componentArray[i3].getSize(dimension);
                n9 = n7 + (n4 - dimension.height);
                componentArray[i3].setLocation(n8, n9);
                n8 += dimension.width + this.b;
            }
        } else {
            for (int i4 = 0; i4 < componentArray.length; ++i4) {
                if (!componentArray[i4].isVisible()) continue;
                componentArray[i4].getSize(dimension);
                n9 = n7 + (n4 - dimension.height) / 2;
                componentArray[i4].setLocation(n8, n9);
                n8 += dimension.width + this.b;
            }
        }
    }
}

