/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;
import jpdf_common.gui.layout.ConstraintLayoutManager;

public class QuadrantLayout
implements ConstraintLayoutManager,
Serializable {
    public static final String NORTH_EAST = "NE";
    public static final String NORTH_WEST = "NW";
    public static final String SOUTH_EAST = "SE";
    public static final String SOUTH_WEST = "SW";
    private static final long serialVersionUID = 120L;
    private Component f = null;
    private Component d = null;
    private Component c = null;
    private Component a = null;
    private int e = 0;
    private int b = 0;

    public QuadrantLayout() {
        this(0, 0);
    }

    public QuadrantLayout(int n2, int n3) {
        this.setHorizontalGap(n2);
        this.setVerticalGap(n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(String string, Component component) {
        String string2 = null;
        Object object = component.getTreeLock();
        synchronized (object) {
            if (string.equals(NORTH_EAST)) {
                this.f = component;
            } else if (string.equals(NORTH_WEST)) {
                this.d = component;
            } else if (string.equals(SOUTH_EAST)) {
                this.c = component;
            } else if (string.equals(SOUTH_WEST)) {
                this.a = component;
            } else {
                string2 = "Cannot add to layout - Unknown Constraint: " + string;
                throw new IllegalArgumentException(string2);
            }
        }
    }

    public Object getConstraints(Component component) {
        if (component == this.f) {
            return NORTH_EAST;
        }
        if (component == this.d) {
            return NORTH_WEST;
        }
        if (component == this.c) {
            return SOUTH_EAST;
        }
        if (component == this.a) {
            return SOUTH_WEST;
        }
        return null;
    }

    public int getHorizontalGap() {
        return this.e;
    }

    public int getVerticalGap() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = container.getSize();
            Dimension dimension2 = null;
            Component component = null;
            Insets insets = container.getInsets();
            int n2 = insets.top;
            int n3 = dimension.height - insets.bottom;
            int n4 = insets.left;
            int n5 = dimension.width - insets.right;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            component = this.a(NORTH_WEST);
            if (component != null) {
                dimension2 = component.getPreferredSize();
                n6 = dimension2.height;
                n7 = dimension2.width;
            }
            if ((component = this.a(NORTH_EAST)) != null) {
                dimension2 = component.getPreferredSize();
                if (dimension2.height > n6) {
                    n6 = dimension2.height;
                }
            }
            if ((component = this.a(SOUTH_WEST)) != null) {
                dimension2 = component.getPreferredSize();
                if (dimension2.width > n7) {
                    n7 = dimension2.width;
                }
            }
            n8 = n4 + n7;
            if (n7 > 0) {
                n8 += this.getHorizontalGap();
            }
            n9 = n2 + n6;
            if (n6 > 0) {
                n9 += this.getVerticalGap();
            }
            if ((component = this.a(NORTH_WEST)) != null) {
                component.setBounds(n4, n2, n7, n6);
            }
            if ((component = this.a(NORTH_EAST)) != null) {
                component.setBounds(n8, n2, n5 - n8, n6);
            }
            if ((component = this.a(SOUTH_WEST)) != null) {
                component.setBounds(n4, n9, n7, n3 - n9);
            }
            if ((component = this.a(SOUTH_EAST)) != null) {
                component.setBounds(n8, n9, n5 - n8, n3 - n9);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = null;
            Component component = null;
            Insets insets = container.getInsets();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            component = this.a(NORTH_WEST);
            if (component != null) {
                dimension = component.getMinimumSize();
                n2 = dimension.height;
                n4 = dimension.width;
            }
            if ((component = this.a(NORTH_EAST)) != null) {
                dimension = component.getMinimumSize();
                if (dimension.height > n2) {
                    n2 = dimension.height;
                }
                n5 = dimension.width;
            }
            if ((component = this.a(SOUTH_WEST)) != null) {
                dimension = component.getMinimumSize();
                n3 = dimension.height;
                if (dimension.width > n4) {
                    n4 = dimension.width;
                }
            }
            if ((component = this.a(SOUTH_EAST)) != null) {
                dimension = component.getMinimumSize();
                if (dimension.height > n3) {
                    n3 = dimension.height;
                }
                if (dimension.width > n5) {
                    n5 = dimension.width;
                }
            }
            n6 = n4 + n5;
            n7 = n2 + n3;
            if (n2 > 0 && n3 > 0) {
                n7 += this.getVerticalGap();
            }
            if (n4 > 0 && n5 > 0) {
                n6 += this.getHorizontalGap();
            }
            return new Dimension(n6 += insets.left + insets.right, n7 += insets.top + insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = null;
            Component component = null;
            Insets insets = container.getInsets();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            component = this.a(NORTH_WEST);
            if (component != null) {
                dimension = component.getPreferredSize();
                n2 = dimension.height;
                n4 = dimension.width;
            }
            if ((component = this.a(NORTH_EAST)) != null) {
                dimension = component.getPreferredSize();
                if (dimension.height > n2) {
                    n2 = dimension.height;
                }
                n5 = dimension.width;
            }
            if ((component = this.a(SOUTH_WEST)) != null) {
                dimension = component.getPreferredSize();
                n3 = dimension.height;
                if (dimension.width > n4) {
                    n4 = dimension.width;
                }
            }
            if ((component = this.a(SOUTH_EAST)) != null) {
                dimension = component.getPreferredSize();
                if (dimension.height > n3) {
                    n3 = dimension.height;
                }
                if (dimension.width > n5) {
                    n5 = dimension.width;
                }
            }
            n6 = n4 + n5;
            n7 = n2 + n3;
            if (n2 > 0 && n3 > 0) {
                n7 += this.getVerticalGap();
            }
            if (n4 > 0 && n5 > 0) {
                n6 += this.getHorizontalGap();
            }
            return new Dimension(n6 += insets.left + insets.right, n7 += insets.top + insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (component == this.f) {
                this.f = null;
            } else if (component == this.d) {
                this.d = null;
            } else if (component == this.c) {
                this.c = null;
            } else if (component == this.a) {
                this.a = null;
            }
        }
    }

    public void setHorizontalGap(int n2) {
        this.e = n2;
    }

    public void setVerticalGap(int n2) {
        this.b = n2;
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.e + ", vgap=" + this.b + "]";
    }

    private Component a(String string) {
        Component component = null;
        if (string == NORTH_EAST) {
            component = this.f;
        } else if (string == NORTH_WEST) {
            component = this.d;
        } else if (string == SOUTH_EAST) {
            component = this.c;
        } else if (string == SOUTH_WEST) {
            component = this.a;
        }
        if (component != null && !component.isVisible()) {
            component = null;
        }
        return component;
    }
}

