/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.component.text;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import jpdf_common.system.manage.BasicResourceManager;

public class UndoAdministrator
extends UndoManager {
    protected final UndoAction UNDO_ACTION;
    protected final RedoAction REDO_ACTION;
    private final UndoRedoObserver b;
    private final boolean c;
    private boolean a = false;

    public UndoAdministrator(JTextComponent jTextComponent, boolean bl) {
        this(jTextComponent, null, bl);
    }

    public UndoAdministrator(JTextComponent jTextComponent, UndoRedoObserver undoRedoObserver, boolean bl) {
        this.b = undoRedoObserver;
        this.c = bl;
        this.UNDO_ACTION = new UndoAction(this, !bl);
        this.REDO_ACTION = new RedoAction(this, !bl);
        this.a(jTextComponent);
        jTextComponent.getDocument().addUndoableEditListener(this);
    }

    public boolean isEditedFlagSet() {
        return this.a;
    }

    public void resetEditedFlag() {
        this.a = false;
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        super.undoableEditHappened(undoableEditEvent);
        if (this.c) {
            this.c();
        }
        this.d();
    }

    private void a(JTextComponent jTextComponent) {
        InputMap inputMap = jTextComponent.getInputMap(0);
        ActionMap actionMap = jTextComponent.getActionMap();
        String string = null;
        string = "Undo";
        inputMap.put(KeyStroke.getKeyStroke(90, 2), string);
        actionMap.put(string, this.UNDO_ACTION);
        string = "Redo";
        inputMap.put(KeyStroke.getKeyStroke(89, 2), string);
        actionMap.put(string, this.REDO_ACTION);
    }

    private void a() {
        if (this.b != null) {
            this.b.redone();
        }
    }

    private void b() {
        if (this.b != null) {
            this.b.undone();
        }
    }

    private void d() {
        this.a = true;
    }

    private void c() {
        this.UNDO_ACTION.updateUndoState();
        this.REDO_ACTION.updateRedoState();
    }

    static void c(UndoAdministrator undoAdministrator) {
        undoAdministrator.b();
    }

    static boolean d(UndoAdministrator undoAdministrator) {
        return undoAdministrator.c;
    }

    static void b(UndoAdministrator undoAdministrator) {
        undoAdministrator.c();
    }

    static void a(UndoAdministrator undoAdministrator) {
        undoAdministrator.a();
    }

    protected class RedoAction
    extends AbstractAction {
        private final UndoAdministrator a;

        public RedoAction(UndoAdministrator undoAdministrator, boolean bl) {
            this.a = undoAdministrator;
            super("Redo");
            this.setEnabled(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.a.redo();
                UndoAdministrator.a(this.a);
            }
            catch (CannotRedoException cannotRedoException) {
                BasicResourceManager.beep();
            }
            if (UndoAdministrator.d(this.a)) {
                UndoAdministrator.b(this.a);
            }
        }

        protected void updateRedoState() {
            if (this.a.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", this.a.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    protected class UndoAction
    extends AbstractAction {
        private final UndoAdministrator a;

        public UndoAction(UndoAdministrator undoAdministrator, boolean bl) {
            this.a = undoAdministrator;
            super("Undo");
            this.setEnabled(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.a.undo();
                UndoAdministrator.c(this.a);
            }
            catch (CannotUndoException cannotUndoException) {
                BasicResourceManager.beep();
            }
            if (UndoAdministrator.d(this.a)) {
                UndoAdministrator.b(this.a);
            }
        }

        protected void updateUndoState() {
            if (this.a.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", this.a.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    public static interface UndoRedoObserver {
        public void redone();

        public void undone();
    }
}

